/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "sphere.h"
#include "cylinder.h"
#include "box.h"
#include "primitive.h"
#include "exit.h"
#include "data.h"
#include "group.h"
#include "node.h"
#include "text.h"
#include "hash.h"
#include "light.h"
#include "symbol.h"
#include "message.h"
#include "gorth.h"
#include "boolean.h"

#ifdef _DISABLE_GL_
#include <string.h>
#include "../prtalk/method.h"
#include "../prtalk/atom.h"
#include "../prtalk/prtalk.h"
#include "../prtalk/bond.h"
#include "../prtalk/helix.h"
#include "../prtalk/sheet.h"
#endif

#define GROUP_STACK_SIZE 96

extern int line_number;
extern graphic_orth* orth_obj;
extern group* root_obj;
extern group* current_ref_group;
extern void make_name(char* str,node* np);
extern header* insert_list(header* top,header* tail);
extern header*  append_list(header* last,header* list);
extern char line_buffer[BUFSIZ];
extern int is_sync;

#ifdef _DISABLE_GL_
extern void DisplayRibbonAll(char*);
extern int  DisplayRibbonHelix(char*);
extern int  DisplayRibbonSheet(char*);
extern int  DisplayRibbonTurn(char*);
extern void DisplayOnlyCA(void);
extern void DisplayLineResidue(char*);
extern void ResidueSeqNo(void);
extern void GravityPoint(double*, double*, double*);
extern void ChangeBondDivide(char* , int , int);
extern void SpherePrint(char*, int,int);
extern int is_only_pr_talk;
#endif

group* group_stack[GROUP_STACK_SIZE];
int group_sp;

void bcopy(char* src,char* obj,unsigned int size)
{
  for (unsigned int count = 0;count < size;count++) {
    *obj = *src;
    obj++;
    src++;
  }
}

header* copy_object(header* object)
//{}
// header* copy_object(header* object)
// $@%*%V%8%'%/%H(Jobject$@$N%3%T!<$r:n$k!#(J
// $@C"$7!"(Jmaterial,light$@%*%V%8%'%/%H$O%3%T!<$G$-$J$$!"(J
//{}
{
#ifdef DEBUG
  fprintf(stderr,"header* copy_object(header* %x)\n",(unsigned int)object);
#endif
  if (object == (header*)0) return (header*)0;
#ifdef DEBUG
  fprintf(stderr,"object is");
  object->Print();
  fprintf(stderr,"\n");
#endif
    header* ret;
  switch(object->Type()) {
  case POL_SPHERE:
    sphere *sp_ret;
    sp_ret = new sphere[1];
    bcopy((char*)object,(char*)sp_ret,sizeof(sphere));
    sp_ret->CopySplitMember();
    ret = (header*)sp_ret;
    ret->Ref(1);
    break;
#ifdef _DISABLE_GL_
  case POL_ATOM:
    globe *gb_ret;
    gb_ret = new globe[1];
    bcopy((char*)object,(char*)gb_ret,sizeof(globe));
    gb_ret->CopySplitMember();
    ret = (header*)gb_ret;
    ret->Ref(1);
    break;
#endif
  case POL_PIPE0: case POL_PIPE1: case POL_CONE: case POL_CONIC:
  case POL_CYLINDER0: case POL_CYLINDER1: case POL_PYRAMID:
  case POL_PILLAR0: case POL_PILLAR1:
    cylinder *cy_ret;
    cy_ret = new cylinder[1];
    bcopy((char*)object,(char*)cy_ret,sizeof(cylinder));
    cy_ret->CopySplitMember();
    ret = (header*)cy_ret;
    ret->Ref(1);
    break;
  case PR_SEGMENT:
    segment* li_ret;
    li_ret = new segment[1];
    bcopy((char*)object,(char*)li_ret,sizeof(segment));
    ret = (header*)li_ret;
    li_ret->CopySplitMember();
    ret->Ref(1);
    break;
  case PR_TEXT:
    text* tx_ret;
    tx_ret = new text[1];
    bcopy((char*)object,(char*)tx_ret,sizeof(text));
    tx_ret->CopySplitMember();
    ret = (header*)tx_ret;
    ret->Ref(1);
    break;
  case PR_LINE:
    line* re_ret;
    re_ret = new line[1];
    bcopy((char*)object,(char*)re_ret,sizeof(line));
    re_ret->CopySplitMember();
    ret = (header*)re_ret;
    ret->Ref(1);
    break;
  case POL_MESH:
    mesh* po_ret;
    po_ret = new mesh[1];
    bcopy((char*)object,(char*)po_ret,sizeof(mesh));
    po_ret->CopySplitMember();
    ret = (header*)po_ret;
    ret->Ref(1);
    break;
  case PR_DOT:
    dot* dot_ret;
    dot_ret = new dot[1];
    bcopy((char*)object,(char*)dot_ret,sizeof(dot));
    dot_ret->CopySplitMember();
    ret = (header*)dot_ret;
    ret->Ref(1);
    break;
  case DAT_LOCATION:
    location* loc_ret;
    loc_ret = new location[1];
    bcopy((char*)object,(char*)loc_ret,sizeof(location));
    ret = (header*)loc_ret;
    ret->Ref(1);
    break;
  case DAT_INTEGER:
    fixed_number* fi_ret ;
    fi_ret = new fixed_number[1];
    bcopy((char*)object,(char*)fi_ret,sizeof(fixed_number));
    ret = (header*)fi_ret;
    ret->Ref(1);
    break;
  case DAT_FLOAT:
    float_number* fl_ret ;
    fl_ret = new float_number[1];
    bcopy((char*)object,(char*)fl_ret,sizeof(float_number));
    ret = (header*)fl_ret;
    ret->Ref(1);
    break;
  case DAT_LIST:
    cons* list_ret ;
    cons* source = (cons*)object;
    list_ret = new cons [1];
    list_ret->Car(copy_object(source->Car()));
    if ((source->Cdr()) != (header*)0) {
      list_ret->Cdr(copy_object(source->Cdr()));
    }
    ret = (header*)list_ret;
    ret->Ref(1);
    break;
  case GROUP_OBJ:
    group* gr_ret;
    gr_ret = new group[1];
    bcopy((char*)object,(char*)gr_ret,sizeof(group));
    gr_ret->Copy(object);
    ret = (header*)gr_ret;
    ret->Ref(1);
    break;
  case POL_BOX:
    box* box_ret;
    box_ret = new box[1];
    bcopy((char*)object,(char*)box_ret,sizeof(box));
    box_ret->CopySplitMember();
    ret = (header*)box_ret;
    ret->Ref(1);
    break;
  case NODE_OBJ:
    node* no_ret;
    header* node_value;
    no_ret = new node[1];
    bcopy((char*)object,(char*)no_ret,sizeof(node));
    node_value = copy_object((header*)(((node*)object)->Value()));
    no_ret->Value(node_value);
    if (node_value->Type() == GROUP_OBJ) {
      ((group*)node_value)->Parent(no_ret);
    }
    ret = (header*)no_ret;
    ret->Ref(1);
    break;
  default:
    fprintf(stderr,"Fatal : \nunable to copy %d\n",line_number);
    error_exit();
    ret = (header*)0;
    break;
  }
  return ret;
}

void method_to_set_object(header* obj,header* marg)
//{}
// $@%a%C%;!<%8(Jto xx $@$N<B9T%3!<%I(J
// $@0z?t(Jxx$@$O(Jlocation$@7?$N:BI8CM(J{x,y,z}$@$G$"$k!#(J
//{}
{
  if ((marg->Type()) != DAT_LOCATION) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : Illiegal argment %d\n",line_number);
    error_exit();
  }

  ((object*)obj)->To((location*)marg);
}

void method_from_set_object(header* obj,header* marg)
//{}
//$@%a%C%;!<%8(Jfrom xx $@$N<B9T%3!<%I(J
// $@0z?t(Jxx$@$O(Jlocation$@7?$N:BI8CM(J{x,y,z}$@$G$"$k!#(J
//{}
{
#ifdef _DISABLE_GL_
  if ((marg->Type()) != DAT_LOCATION && (marg->Type()) != POL_SPHERE) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : Illiegal argment %d\n",line_number);
    error_exit();
  }
#else
  if ((marg->Type()) != DAT_LOCATION) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : Illiegal argment %d\n",line_number);
    error_exit();
  }
#endif

  ((object*)obj)->From((location*)marg);
}

void method_scale(header*obj,header* marg)
//{}
// magnify$@$N<B9T%3!<%I(J
// $@0z?t(Jxx$@$O!V?t!W$G$"$k!#(J
//{}
{
  float s;
  if ((marg->Type()) == DAT_INTEGER) {
    s =(float)(((fixed_number*)marg)->Value());
  }else{
    s = ((float_number*)marg)->Value();
  }

  ((object*)obj)->Scale((double)s);
}

void method_is(node* np,header* marg)
//{}
// $@%a%C%;!<%8(Jis$@$N<B9T%3!<%I(J
// $@0z?t$O(Jnode*$@$GJQ?t$NHVCM!"$=$l$KBeF~$9$k%*%V%8%'%/%H(J
//{}
{

  // $@$3$3$G$O!";2>H%+%&%s%H$r(JSplit(1)$@$9$kI,MW$,$"$k!#(J
  header* val;
  val = (header*)0;
  val = np->Value();
  if (val  != NULL) val->Close();
  if (marg != NULL) {
    marg->Split();
    if ((marg->Type() == GROUP_OBJ)&&(((group*)marg)->Parent() == NULL))
      {
	((group*)marg)->Parent((object*)np);
      }
    np->Value(marg);
  }else {
    np->Value((header*)0);
  }
}

void method_hideall(header* obj)
// {}
// hideall$@$N<B9T%3!<%I(J
// {}
{
  ((group*)obj)->DrawStateAll(ObjectHidding);
}

void method_hide(header* obj)
// {}
// hide$@$N<B9T%3!<%I(J
// {}
{
  ((object*)obj)->DrawState(ObjectHidding);
}

void method_wireall(header* obj)
// {}
// $@%a%C%;!<%8(Jwireall$@$N<B9T%3!<%I(J
// {}
{
  ((group*)obj)->DrawStateAll(DrawingWireFrame);
}

void method_wire(header* obj)
// {}
// $@%a%C%;!<%8(Jwire$@$N<B9T%3!<%I(J
// {}
{
  ((object*)obj)->DrawState(DrawingWireFrame);
}

void method_drawall(header* obj)
//{}
// drawall$@$N<B9T%3!<%I(J
// {}
{
  ((group*)obj)->DrawStateAll(ObjectDrawing);
}
#ifdef _DISABLE_GL_
void method_ribbonall(header* obj,const char* groupName)
//{}
// ribbonAll$@$N<B9T%3!<%I(J
// {}
{
  double gx = 0.0, gy = 0.0, gz = 0.0;
  MakeGroupObject("Root");
  DisplayRibbonAll((char*)groupName);
  GravityPoint(&gx, &gy, &gz);
  MoveObject("Root",gx,gy,gz);
  PushGroup("Root");
  if(strncmp(groupName,"Root",4) != 0){
    DrawObject("Ribbon");
    PushGroup("Ribbon");
    DrawAll((char*)groupName);
    PopGroup();
  }
  else  DrawAll("Ribbon");
  PopGroup();
  is_only_pr_talk = TRUE;
}

/*
void method_ribbonhelix(header* obj, header* arg, const char* groupName)
//{}
// ribbonHelix$@$N<B9T%3!<%I(J
// {}
{
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    int i = DisplayRibbonHelix((char*)groupName);
    if(i<0){
      fprintf(stderr, "ProteinTalk Error: Helix is not exist.\n");
      return;
    }
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("Helix");
      PushGroup("Helix");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("Helix");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("Helix");
    PopGroup();
  }
}

void method_sheet(header* obj,header* arg, const char* groupName)
//{}
// sheet$@$N<B9T%3!<%I(J
// {}
{
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    int i = DisplayRibbonSheet((char*)groupName);
    if(i<0){
      fprintf(stderr, "ProteinTalk Error: Sheet is not exist.\n");
      return;
    }
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("Sheet");
      PushGroup("Sheet");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("Sheet");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("Sheet");
    PopGroup();
  }
}
*/

void method_turn(header* obj,header* arg, const char* groupName)
//{}
// turn$@$N<B9T%3!<%I(J
// {}
{
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    int i = DisplayRibbonTurn((char*)groupName);
    if(i<0){
      fprintf(stderr, "ProteinTalk Error: Turn is not exist.\n");
      return;
    }
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("Turn");
      PushGroup("Turn");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("Turn");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("Turn");
    PopGroup();
  }
}

void method_calpha(header* obj,header* arg, const char* groupName)
//{}
// calpha$@$N<B9T%3!<%I(J
// {}
{
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    DisplayOnlyCA();
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    HideAll("Residue");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("CA");
      PushGroup("CA");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("CA");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("CA");
    DrawAll("Residue");
    PopGroup();
  }
}

void method_wired(header* obj,header* arg, const char* groupName)
//{}
// wired execution code
// {}
{
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    DisplayLineResidue((char*)groupName);
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    HideAll("Residue");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("Line");
      PushGroup("Line");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("Line");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("Line");
    DrawAll("Residue");
    PopGroup();
  }
}

void method_seqno(header* obj,header* arg, const char* groupName)
//{}
// sequence number execution code
// {}
{
//void method_draw(header* obj)
//{}
// draw$@$N<B9T%3!<%I(J
// {}
//{
//  ((object*)obj)->DrawState(ObjectDrawing);
//}
  is_only_pr_talk = TRUE;
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    double gx = 0.0, gy = 0.0, gz = 0.0;
    MakeGroupObject("Root");
    ResidueSeqNo();
    GravityPoint(&gx, &gy, &gz);
    MoveObject("Root",gx,gy,gz);
    PushGroup("Root");
    if(strncmp(groupName,"Root",4) != 0){
      DrawObject("SeqNo");
      PushGroup("SeqNo");
      DrawAll((char*)groupName);
      PopGroup();
    }
    else  DrawAll("SeqNo");
    PopGroup();
  }
  else if(id == sym_param_off){
    PushGroup("Root");
    HideAll("SeqNo");
    PopGroup();
  }
}

void method_divide(header* obj, header* marg, const char* groupName)
//{}
// $@%a%C%;!<%8(Jdivide$@$N<B9T%k!<%A%s(J
// $@0z?t$O%0%k!<%W%*%V%8%'%/%H(J
//{}
{
  float s;
  if ((marg->Type()) == DAT_INTEGER) {
    s =(float)(((fixed_number*)marg)->Value());
  }else{
    s = ((float_number*)marg)->Value();
  }
  switch (obj->Type()) {
  case POL_PIPE0: case POL_PIPE1: case POL_CYLINDER0: case POL_CYLINDER1:
  case GROUP_OBJ:
    ChangeBondDivide((char*)groupName, 0, (int)s);
    break;
  default:
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : Illiegal mesage %d\n",line_number);
    error_exit();
    break;
  }
  is_only_pr_talk = TRUE;
}

void globe_object(header* obj,header* arg, const char* groupName)
//{}
// globe xx $@%a%C%;!<%8$N<B9T%k!<%A%s(J
// $@0z?t$O!"%*%V%8%'%/%H$H!"(Jxx$@$O(Jstring$@7?$G(JValue$@$O(Jsym_param_on,sym_param_off
//{}
{
  char* str;
  str = ((string*)arg)->Value();

  int id;
  id = hash_table.wordId(str);
  if(id == sym_param_on){
    SpherePrint( (char*)groupName, 0, 0);
  }
  if(id == sym_param_off){
    SpherePrint( (char*)groupName, 0, 1);
  }

  is_only_pr_talk = TRUE;
}
#endif

void method_draw(header* obj)
//{}
// draw$@$N<B9T%3!<%I(J
// {}
{
#ifdef _DISABLE_GL_
  switch(obj->Type())
    {
    case POL_BOND:
    case POL_HELIX:
    case POL_SHEET:
      is_only_pr_talk = TRUE;
      obj->Draw();
    }
#endif
  ((object*)obj)->DrawState(ObjectDrawing);
}

void nurbs_object(header* obj,header* marg)
// {}
// $@%a%C%;!<%8(Jnurbs xx$@$N<B9T%k!<%A%s(J
// $@0z?t$O!"%*%V%8%'%/%H$H!"(Jxx$@$O(Jstring$@7?$G(JValue$@$O(Jsym_param_on,sym_param_off
// {}
{
  char* str;
  str = ((string*)marg)->Value();
  ((object*)obj)->Nurbs(str);
}

void smooth_object(header* obj,header* arg)
//{}
// smooth xx $@%a%C%;!<%8$N<B9T%k!<%A%s(J
// $@0z?t$O!"%*%V%8%'%/%H$H!"(Jxx$@$O(Jstring$@7?$G(JValue$@$O(Jsym_param_on,sym_param_off
//{}
{
  char* str;
  str = ((string*)arg)->Value();
  switch(obj->Type()) {
  case PR_LINE:
    line* pr_rect;
    pr_rect = (line*)obj;
    pr_rect->SmoothState(str);
    break;
  case PR_SEGMENT:
    segment* pr_segment;
    pr_segment = (segment*)obj;
    pr_segment->SmoothState(str);
    break;
  case PR_DOT:
    dot* dt_point;
    dt_point = (dot*)obj;
    dt_point->SmoothState(str);
    break;
  case POL_MESH:
    mesh* pol_mesh;
    pol_mesh = (mesh*)obj;
    pol_mesh->AliasState(str);
    break;
  default:
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : Illiegal mesage %d\n",line_number);
    error_exit();
    break;
  }
}

void method_rotate_object(header* obj,header* marg)
//{}
// rotate xx $@%a%C%;!<%8$N<B9T%k!<%A%s(J
// $@0z?t(Jxx$@$O(Jlocation$@7?$N:BI8CM(J{x,y,z}$@$G$"$k!#(J
//{}
{
  ((object*)obj)->Rotate(marg);
}

void method_move_object(header* obj,header* marg)
//{}
// moves xx $@%a%C%;!<%8$N<B9T%k!<%A%s(J
// $@0z?t(Jxx$@$O(Jlocation$@7?$N:BI8CM(J{x,y,z}$@$G$"$k!#(J
//{}
{
  ((object*)obj)->Move(marg);
}
header* mathod_location(header* obj)
//{}
// $@%a%C%;!<%8(Jlocation$@$N<B9T%3!<%I(J
// $@0z?t$O!"%*%V%8%'%/%H(J
//{}
{
  return (header*)((location*)(((object*)obj)->Location()));
}

header* mathod_rotation(header* obj)
//{}
// $@%a%C%;!<%8(Jrotation$@$N<B9T%3!<%I(J
// $@0z?t$O!"%*%V%8%'%/%H(J
//{}
{
  return (header*)(((object*)obj)->Rotate());
}

void antialiases_object(header* obj,header* arg)
//{}
// antialiases xx $@%a%C%;!<%8$N<B9T%k!<%A%s(J
// $@0z?t$O!"%*%V%8%'%/%H$H!"(Jxx$@$O(Jstring$@7?$G(JValue$@$O(Jsym_param_on,sym_param_off
//{}
{
  char* str;
  str = ((string*)arg)->Value();
  ((object*)obj)->AliasState(str);
}

header* object_member(header* obj,int id)
// {}
// $@%*%V%8%'%/%H$N%a%s%P$r8!:w$7!"(Jnode$@$N%"%I%l%9$rJV$9!#(J
// {}
{
  return (header*)(((object*)obj)->Reference(id));
}

void method_up()
// {}
// $@%a%C%;!<%8(J up$@$N<B9T%k!<%A%s(J
// {}
{
  if (current_ref_group != root_obj) {
    node* work;
    work = (node*)(current_ref_group->Parent());
    current_ref_group = (group*)(work->Parent());
  }
}
void method_into(header* marg)
//{}
// $@%a%C%;!<%8(Jinto$@$N<B9T%k!<%A%s(J
// $@0z?t$O%0%k!<%W%*%V%8%'%/%H(J
//{}
{
  if (marg == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nargmemt is not object %d\n",line_number);
    error_exit();
  }else if (marg->Type() == GROUP_OBJ) {
    current_ref_group = (group*)marg;
  }else{
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nargmemt is not group object %d\n",line_number);
    error_exit();
  }
}
void method_pop()
//{}
// $@%a%C%;!<%8(Jpop$@$N<B9T%k!<%A%s(J
//{}
{
  if (group_sp > 0) {
    group_sp--;
    current_ref_group =  group_stack[group_sp];
  }else{
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \ngroup stack is empty %d\n",line_number);
    error_exit();
  }
}
void method_push(header* marg)
//{}
// $@%a%C%;!<%8(Jpush$@$N<B9T%k!<%A%s(J
// $@0z?t$O%0%k!<%W%*%V%8%'%/%H(J
//{}
{
  if (marg == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nargmemt is not object %d\n",line_number);
    error_exit();
  }else if (marg->Type() == GROUP_OBJ) {
    if (group_sp < GROUP_STACK_SIZE) {
      group_stack[group_sp] = current_ref_group;
      group_sp++;
    }
    current_ref_group = (group*)marg;
  }else{
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nargmemt is not group object %d\n",line_number);
    error_exit();
  }
}

header* method_value(header* obj,header* marg) 
//[}
//value$@%a%C%;!<%8$N<B9T%3!<%I(J
// $@$b$70z?t$,@0?t$N$_$J$i$P!"CM$rJV$9!#(J
// $@$b$7@0?t$H!"CM$,$"$l$PCM$r%;%C%H$9$k!#(J
//[}
{
  location* loc = (location*)obj;
  int id = ((fixed_number*)marg)->Value();
  header* arg_next;
  double value = 0;
  if ((arg_next = marg->Next()) == NULL) {
    //$@0z?t$,(J1$@8D$J$iCM$rJV$9(J
    if (id == 0)      value = loc->X();
    else if (id == 1) value = loc->Y();
    else if (id == 2) value = loc->Z();
    float_number* ret_fn = new float_number[1];
    ret_fn->Split();
    ret_fn->Value(value);
    return (header*)ret_fn;
  }
  // $@0z?t$,(J2$@8D$J$iCM$r%;%C%H(J
  if (arg_next->Type() == DAT_INTEGER) {
    value = (double)(((fixed_number*)arg_next)->Value());
  }else{
    value = (double)(((float_number*)arg_next)->Value());
  }
  if (id == 0) {
    loc->X(value);
  }else if (id == 1) {
    loc->Y(value);
  }else if (id == 2) {
    loc->Z(value);
  }
  return (header*)0;
}

header* method_append_list(header* obj,header* marg)
// {}
// append$@%a%C%;!<%8$N<B9T%3!<%I(J
// $@0z?t$O!"%*%V%8%'%/%H$H!"(Jappend$@$9$k%*%V%8%'%/%H(Jmarg
// {}
{
#ifdef DEBUG
  fprintf(stderr,"header* method_append_list(header* %x,header* %x)\n",(unsigned int)obj,(unsigned int)marg);
#endif
  return append_list(marg,(header*)obj);
}

header* method_car(header* obj)
// {}
// car$@%a%C%;!<%8$N<B9T%3!<%I(J
// {}
{
#ifdef DEBUG
  fprintf(stderr,"header* method_car(header* %x)\n",(unsigned int)obj);
#endif
  cons* cellp = (cons*)obj;
  return (header*)(cellp->Car());
}

header* method_cdr(header* obj)
// {}
// cdr$@%a%C%;!<%8$N<B9T%3!<%I(J
// {}
{
#ifdef DEBUG
  fprintf(stderr,"header* method_cdr(header* %x)\n",(unsigned int)obj);
#endif
  cons* cellp = (cons*)obj;
  return (header*)(cellp->Cdr());
}

header* method_insert(header* obj,header* marg)
// {}
// insert$@%a%C%;!<%8$N<B9T%3!<%I(J
// {}
{
#ifdef DEBUG
  fprintf(stderr,"header* method_insert(header* %x,header* %x)\n",(unsigned int)obj,(unsigned int)marg);
#endif
  if (obj == (object*)0) { 
    return insert_list(marg,(header*)obj);
  }
  if (obj->Type() == DAT_LIST) {
    return insert_list(marg,(header*)obj);
  }
  fprintf(stderr,"%s\n",line_buffer);
  fprintf(stderr,"Fatal (cdr): \nIs not list object\n");
  error_exit();
  return NULL;
}

header* method_element(header* obj,header* marg)
//{}
// element $@%a%C%;!<%8$N<B9T%3!<%I(J
//{}
{
#ifdef DEBUG
  fprintf(stderr,"header* method_element(header* %x,header* %x)\n",(unsigned int)obj,(unsigned int)marg);
#endif
  header* ret = (header*)0;
  int index;
  index = ((fixed_number*)marg)->Value();
  cons* wp = (cons*)obj;
  for (int count = 0;count<index;count++) {
    if (wp == (cons*)0) break;
    wp = (cons*)wp->Cdr();
  }
  if (marg->Next()!= NULL) {
    header* argment;
    argment = marg->Next();
    header* car;
    car = wp->Car();
    if (car != NULL) car->Close();
    argment->Split();
    wp->Car(argment);
  } else {
    if (wp != (cons*)0) {
      ret = wp->Car();
    }
  }
  return ret;
}

void null_object_check(node* np)
// {}
// $@%*%V%8%'%/%H$NCf?H$,6u$J$i%(%i!<%a%C%;!<%8$rI=<(!"=*N;(J
// {}
{
  if ((np->Value()) == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : var(%s)\nIs not object %d\n",
	    (np->Name()),line_number);
    error_exit();
  }
}
void error_msg_is_not_x_object(node* np,char* str)
{
  fprintf(stderr,"%s\n",line_buffer);
  fprintf(stderr,"Fatal : var(%s)\nIs not %s object %d\n",
	  (np->Name()),str,line_number);
  error_exit();
}
header* execute(header* exector,message* mp)
// {}
// $@%a%C%;!<%8$r<B9T$5$;$k!#(J
// {}
{
#ifdef DEBUG
  fprintf(stderr,"header* execute(header* %x,message* %x)\n",
	  (unsigned int)exector, (unsigned int)mp);
#endif
  if ((exector == NULL)||(exector == (header*)0)){
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nIs not object %d\n",line_number);
    error_exit();
  }
  if (exector->Type() == NOT_INITIALIZE) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,"Fatal : \nIs not object %d\n",line_number);
    error_exit();
  }
  header* ret;
  header* marg;
  header* obj;
  obj = (header*)0;
  ret = exector;
  node* np;
  np = (node*)exector;
  marg = mp->Arg();
  obj = np->Value();
  float r,g,b;
  switch(mp->Type()) {
  case METHOD_APPEND:
    if (obj == (header*)0) {
      return method_append_list(obj,marg);
    }
    if (obj->Type() != DAT_LIST) {
      error_msg_is_not_x_object(np,"list");
    }
    return method_append_list(obj,marg);
  case METHOD_VALUE:
    header* rt_val ;
    rt_val = (header*)0;
    null_object_check(np);
    if (obj->Type() != DAT_LOCATION) {
      error_msg_is_not_x_object(np,"location");
    }
    if (marg->Type() != DAT_INTEGER) {
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : argment\nIs not integer object %d\n",line_number);
      error_exit();
    }
    rt_val = method_value(obj,marg) ;
    if (rt_val != (header*)0) return rt_val;
    break;
  case METHOD_ELEMENT:
    header* rt_value;
    if (marg->Type() != DAT_INTEGER) {
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : method element first argment\nIs not integer %d\n",line_number);
      error_exit();
    }
    rt_value =  method_element(obj,marg);
    if (rt_value != (header*)0) {
      return rt_value;
    }
    break;
  case METHOD_CAR:
    null_object_check(np);
    if (obj->Type() == DAT_LIST) {
      return method_car(obj);
    } else {
      error_msg_is_not_x_object(np,"list");
    }
    break;
  case METHOD_CDR:
    null_object_check(np);
    if (obj->Type() == DAT_LIST) {
      return method_cdr(obj);
    } else {
      error_msg_is_not_x_object(np,"list");
    }
    break;
  case METHOD_INSERT:
    return method_insert(obj,marg);
  case METHOD_QUIT:
#ifdef _DISABLE_GL_
    printf("quit;\n");
#endif
    normal_exit();
    break;
  case METHOD_SYNC:
    is_sync = TRUE;
    break;
  case METHOD_PUSH:
    method_push(marg);
    break;
  case METHOD_POP:
    method_pop();
    break;
  case METHOD_INTO:
    method_into(marg);
    break;
  case METHOD_UP:
    method_up();
    break;
  case METHOD_DELETE:
    null_object_check(np);
    obj->Close();
    np->Value((header*)0);
    break;
  case METHOD_LOCATION:
    null_object_check(np);
    return mathod_location(obj);
  case METHOD_ANTIALIASES:
    null_object_check(np);
    antialiases_object(obj,marg);
    break;
  case METHOD_NURBS:
    null_object_check(np);
    nurbs_object(obj,marg);
    return ret;
  case METHOD_SMOOTHS:
    null_object_check(np);
    smooth_object(obj,marg);
    break;
  case METHOD_MOVE:
    null_object_check(np);
    method_move_object(obj, marg);
    break;
  case METHOD_ROTATION:
    null_object_check(np);
    return  mathod_rotation(obj);
  case METHOD_ROTATE:
    null_object_check(np);
    method_rotate_object(obj,marg);
    break;
  case METHOD_SHINES:
    null_object_check(np);
    float shines;
    if ((marg->Type()) == DAT_INTEGER) {
      shines = (float)(((fixed_number*)marg)->Value());
      ((material*)obj)->Shiness(shines);
    }else if ((marg->Type()) == DAT_FLOAT) {
      shines = ((float_number*)marg)->Value();
      ((material*)obj)->Shiness(shines);
    }else{
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : argment\nIs not numeric object %d\n",(np->Name()),line_number);
      error_exit();
    }
    break;
  case METHOD_SPECULER:
    null_object_check(np);
    if ((marg->Type()) == DAT_LOCATION) {
      r = ((location*)marg)->X();
      g = ((location*)marg)->Y();
      b = ((location*)marg)->Z();
      ((material*)obj)->Speculer(r,g,b);
    }else{
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : argmenmt\nIs not location object %d\n",(np->Name()),line_number);
      error_exit();
    }
    break;
  case METHOD_ALPHA:
    null_object_check(np);
    float alpha;
    if ((marg->Type())== DAT_FLOAT) {
      alpha = ((float_number*)marg)->Value();
      ((material*)obj)->Alpha(alpha);
    } else if ((marg->Type())== DAT_INTEGER) {
      alpha = ((fixed_number*)marg)->Value();
      ((material*)obj)->Alpha(alpha);
    }else{
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : argment\nIs not numeric object %d\n",line_number);
      error_exit();
    }
    break;
  case METHOD_COLOR:
    null_object_check(np);
    if ((marg->Type()) == DAT_LOCATION) {
      r = ((location*)marg)->X();
      g = ((location*)marg)->Y();
      b = ((location*)marg)->Z();
      if (obj->Type() == MATERIAL_OBJ) { 
	((material*)obj)->RgbSet(r,g,b);
      }else if (obj->Type() == LIGHT_OBJ) { 
	((light*)obj)->RgbSet(r,g,b);
      }
    }else{
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,"Fatal : var(%s)\nIs not location object %d\n",(np->Name()),line_number);
      error_exit();
    }
    break;
  case METHOD_BIND:
    null_object_check(np);
    if (obj->Type() == MATERIAL_OBJ) { 
      ((material*)obj)->Bind();
    }else if (obj->Type() == LIGHT_OBJ) { 
      ((light*)obj)->Bind();
    }else{
      error_msg_is_not_x_object(np,"light or material");
    }
    break;
  case METHOD_HIDE:
    null_object_check(np);
    method_hide(obj);
    break;
  case METHOD_HIDE_ALL:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_hideall(obj);
    break;
  case METHOD_WIRE:
    null_object_check(np);
    method_wire(obj);
    break;
  case METHOD_WIRE_ALL:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_wireall(obj);
    break;
  case METHOD_DRAW_ALL:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_drawall(obj);
    break;
#ifdef _DISABLE_GL_
  case METHOD_RIBBON_ALL:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_ribbonall(obj,np->Name());
    break;
/*
  case METHOD_RIBBON_HELIX:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_ribbonhelix(obj,marg,np->Name());
    break;
  case METHOD_RIBBON_SHEET:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_sheet(obj,marg,np->Name());
    break;
*/
  case METHOD_RIBBON_TURN:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_turn(obj,marg,np->Name());
    break;
  case METHOD_C_ALPHA:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_calpha(obj,marg,np->Name());
    break;
  case METHOD_WIRED:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_wired(obj,marg,np->Name());
    break;
  case METHOD_SEQ_NO:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_seqno(obj,marg,np->Name());
    break;
  case METHOD_DIVIDE:
    null_object_check(np);
    if (obj->Type() != GROUP_OBJ) {
      error_msg_is_not_x_object(np,"group");
    }
    method_divide(obj, marg,np->Name());
    break;
  case METHOD_GLOBE:
    null_object_check(np);
    fprintf(stderr,"np:[%s]\n", np->Name());
    globe_object(obj,marg,np->Name());
    break;
#endif
  case METHOD_DRAW:
    null_object_check(np);
    method_draw(obj);
    break;
  case METHOD_FROM:
    null_object_check(np);
    method_from_set_object(obj,marg);
    break;
  case METHOD_TO:
    null_object_check(np);
    method_to_set_object(obj,marg);
    break;
  case METHOD_COPY:
    // $@$3$3$G$OI,$:%3%T!<$5$l$?%*%V%8%'%/%H$N;2>H%+%&%s%H$r(J
    // 1$@$H$9$k$?$a(JSplit$@$O9T$J$o$J$$!#(J
    if (obj != (header*)0) {
      obj->Close();
    }
    obj = copy_object(marg);
    if (obj->Type() == GROUP_OBJ) {
      ((group*)obj)->Parent(np);
    }
    np->Value(obj);
    break;
  case METHOD_IS:
    method_is(np,marg);
    break;
  case METHOD_TRANSFORM:
    {
      float var_arg[6];
      header* wp;
      int arg_c;
      null_object_check(np);
      wp = marg;
      for (arg_c = 0;arg_c<6;arg_c++) {
	if (wp->Type() == DAT_INTEGER) {
	  var_arg[arg_c] = (float)(((fixed_number*)wp)->Value());
	}else if(wp->Type() == DAT_FLOAT) {
	  var_arg[arg_c] = ((float_number*)wp)->Value();
	}
	wp = wp->Next();
      }
      orth_obj->Transform(var_arg[0],var_arg[1],var_arg[2],var_arg[3],var_arg[4],var_arg[5]);
    }
    break;
  case METHOD_SCALE:
    null_object_check(np);
    method_scale(obj,marg);
    break;
  default:
    //fprintf(stderr,"Sorry,Not implement message\n");
    /* Error */
    return ret;
  }
  delete mp;
  return ret;
}

header* make_instance(int id)
// {}
// is a X$@$N7A<0$G;XDj$5$l$?%*%V%8%'%/%H$N@8@.$r9T$&!#(J
// {}
{
  return new_instance[id]();
}
