/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include "header.h"
#include "hash.h"
#include "symbol.h"
extern "C" {
#include <malloc.h>
};

header::header()
{
  type = NOT_INITIALIZE;
  sym_id = sym_notinit;
  next = (header*)0;
  ref_c = 0;
}
void header::Close()
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void header::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
  if (ref_c == 0) {
    free(this);
  }
}

void header::Split(int r)
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void header::Split(%d)\n",(unsigned int)this,ref_c,r);
#endif
  ref_c += r;
}

void header::Print()
{
  fprintf(stderr,"object (%s)",hash_table.idWord(sym_id));
}

/* Return reserved word on hash table */
char* header::Name()
{
  return hash_table.idWord(sym_id);
}

void header::Next(header* n)
{
  next = n;
}
header* header::Next()
{
  return next;
}
void header::Previous(header* n)
{
  prev = n;
}
header* header::Previous()
{
  return prev;
}

void header::Draw()
{
}

void header::DrawState(DrawStatus t)
{
}
