/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <math.h>
#include "function.h"
#include "data.h"

inline header* func_sqrt(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(sqrt(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(sqrt(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_sin(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(sin(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(sin(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_cos(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(cos(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(cos(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_tan(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(tan(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(tan(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_atan(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(atan(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(atan(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_asin(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(asin(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(asin(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_acos(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(acos(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(acos(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_exp(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(exp(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(exp(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_log(header* arg)
{
  header* ret;
  float val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new float_number[1]);
    val = (float)(((fixed_number*)arg)->Value());
    ((float_number*)ret)->Value(log(val));
    ((float_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new float_number[1]);
    val = ((float_number*)arg)->Value();
    ((float_number*)ret)->Value(log(val));
    ((float_number*)ret)->Split();
  }
  return ret;
}

inline header* func_int(header* arg)
{
  header* ret;
  int val;
  ret = (header*)0;
  if ((arg->Type()) == DAT_INTEGER) {
    ret = (header*)(new fixed_number[1]);
    val = ((fixed_number*)arg)->Value();
    ((fixed_number*)ret)->Value(val);
    ((fixed_number*)ret)->Split();
  }else if ((arg->Type()) == DAT_FLOAT) {
    ret = (header*)(new fixed_number[1]);
    val = (int)(((float_number*)arg)->Value());
    ((fixed_number*)ret)->Value(val);
    ((fixed_number*)ret)->Split();
  }
  return ret;
}

header* builtin_function(FunctionID fid,header* arg)
{
  header* ret;
  ret = (header*)0;
  switch(fid) {
  case FUNCTION_SQRT:
    ret = func_sqrt(arg);
    break;
  case FUNCTION_INT:
    ret = func_int(arg);
    break;
  case FUNCTION_SIN:
    ret = func_sin(arg);
    break;
  case FUNCTION_TAN:
    ret = func_tan(arg);
    break;
  case FUNCTION_COS:
    ret = func_cos(arg);
    break;
  case FUNCTION_ASIN:
    ret = func_asin(arg);
    break;
  case FUNCTION_ATAN:
    ret = func_atan(arg);
    break;
  case FUNCTION_ACOS:
    ret = func_acos(arg);
    break;
  case FUNCTION_EXP:
    ret = func_exp(arg);
    break;
  case FUNCTION_LOG:
    ret = func_log(arg);
    break;
  default:
    break;
  }
  return ret;
}

header* minus (header* a)
{
  header* ret;
  ret = (header*)0;
  switch (a->Type()) {
  case DAT_INTEGER:
    fixed_number* vi;
    vi = new fixed_number [1];
    vi->Value(-(((fixed_number*)a)->Value()));
    ret = (header*)vi;
    break;
  case DAT_FLOAT:
    float_number* vf;
    vf = new float_number [1];
    vf->Value(-(((float_number*)a)->Value()));
    ret = (header*)vf;
    break;
  default:
    break;
  }
  return ret;
}

header* add (header* a,header* b)  
{
  if ((a == (header*)0)||(b == (header*)0)) {
    return (header*)0;
  }
  float_number* ret_float;
  float rvf;
  int rvi;
  switch (a->Type()) {
  case DAT_INTEGER:
    switch(b->Type()) {
    case DAT_INTEGER:
      fixed_number* ret_fixed;
      ret_fixed = new fixed_number[1];
      rvi = (((fixed_number*)a)->Value())+(((fixed_number*)b)->Value());
      ret_fixed->Value(rvi);
      return ret_fixed;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((fixed_number*)a)->Value())+(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  case DAT_FLOAT:
    switch(b->Type()) {
    case DAT_INTEGER:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())+(((fixed_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    case DAT_FLOAT:
      float rvf;
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())+(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  default:
    //error
      break;
  }
  return (header*)0;
}
header* dev (header* a,header* b)  
{
  if ((a == (header*)0)||(b == (header*)0)) {
    return (header*)0;
  }
  float_number* ret_float;
  int rvi;
  float rvf;
  switch (a->Type()) {
  case DAT_INTEGER:
    switch(b->Type()) {
    case DAT_INTEGER:
      fixed_number* ret_fixed;
      ret_fixed = new fixed_number[1];
      rvi = (((fixed_number*)a)->Value())/(((fixed_number*)b)->Value());
      ret_fixed->Value(rvi);
      return ret_fixed;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((fixed_number*)a)->Value())/(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  case DAT_FLOAT:
    switch(b->Type()) {
    case DAT_INTEGER:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())/(((fixed_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())/(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  default:
    //error
      break;
  }
  return (header*)0;
}

header* sub (header* a,header* b)  
{
  if ((a == (header*)0)||(b == (header*)0)) {
    return (header*)0;
  }
  float_number* ret_float;
  int rvi;
  float rvf;
  switch (a->Type()) {
  case DAT_INTEGER:
    switch(b->Type()) {
    case DAT_INTEGER:
      fixed_number* ret_fixed;
      ret_fixed = new fixed_number[1];
      rvi = (((fixed_number*)a)->Value())-(((fixed_number*)b)->Value());
      ret_fixed->Value(rvi);
      return ret_fixed;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((fixed_number*)a)->Value())-(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  case DAT_FLOAT:
    switch(b->Type()) {
    case DAT_INTEGER:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())-(((fixed_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())-(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  default:
    //error
      break;
  }
  return (header*)0;
}

header* mul (header* a,header* b)  
{
  if ((a == (header*)0)||(b == (header*)0)) {
    return (header*)0;
  }
  float_number* ret_float;
  int rvi;
  float rvf;
  switch (a->Type()) {
  case DAT_INTEGER:
    switch(b->Type()) {
    case DAT_INTEGER:
      fixed_number* ret_fixed;
      ret_fixed = new fixed_number[1];
      rvi = (((fixed_number*)a)->Value())*(((fixed_number*)b)->Value());
      ret_fixed->Value(rvi);
      return ret_fixed;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((fixed_number*)a)->Value())*(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  case DAT_FLOAT:
    switch(b->Type()) {
    case DAT_INTEGER:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())*(((fixed_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    case DAT_FLOAT:
      ret_float = new float_number[1];
      rvf = (((float_number*)a)->Value())*(((float_number*)b)->Value());
      ret_float->Value(rvf);
      return ret_float;
    default:
      break;
    }
    break;
  default:
    //error
      break;
  }
  return (header*)0;
}

#ifdef  _DEBUG_TEST_
#include <stdio.h>
main()
{
  int s_i = 2;
  float s_f = 3;
  fixed_number* aip;
  float_number* afp;
  fixed_number* ip;
  float_number* fp;
  ip = new fixed_number[1];
  fp = new float_number[1];
  ip->Value(s_i);
  fp->Value(s_f);
  aip = (fixed_number*)add (((header*)(ip)) , ((header*)(ip)));
  printf("i+i%d\n",(aip->Value()));
  aip = (fixed_number*)sub (((header*)(ip)) , ((header*)(ip)));
  printf("i-i%d\n",(aip->Value()));
  aip = (fixed_number*)mul (((header*)(ip)) , ((header*)(ip)));
  printf("i*i%d\n",(aip->Value()));
  aip = (fixed_number*)dev (((header*)(ip)) , ((header*)(ip)));
  printf("i/i%d\n",(aip->Value()));

  afp = (float_number*)add (((header*)(fp)) , ((header*)(ip)));
  printf("f+i%f\n",(afp->Value()));
  afp = (float_number*)sub (((header*)(fp)) , ((header*)(ip)));
  printf("f-i%f\n",(afp->Value()));
  afp = (float_number*)mul (((header*)(fp)) , ((header*)(ip)));
  printf("f*i%f\n",(afp->Value()));
  afp = (float_number*)dev (((header*)(fp)) , ((header*)(ip)));
  printf("f/i%f\n",(afp->Value()));

  afp = (float_number*)add (((header*)(ip)) , ((header*)(fp)));
  printf("i+f%f\n",(afp->Value()));
  afp = (float_number*)sub (((header*)(ip)) , ((header*)(fp)));
  printf("i-f%f\n",(afp->Value()));
  afp = (float_number*)mul (((header*)(ip)) , ((header*)(fp)));
  printf("i*f%f\n",(afp->Value()));
  afp = (float_number*)dev (((header*)(ip)) , ((header*)(fp)));
  printf("i/f%f\n",(afp->Value()));

  afp = (float_number*)add (((header*)(fp)) , ((header*)(fp)));
  printf("f+f%f\n",(afp->Value()));
  afp = (float_number*)sub (((header*)(fp)) , ((header*)(fp)));
  printf("f-if%f\n",(afp->Value()));
  afp = (float_number*)mul (((header*)(fp)) , ((header*)(fp)));
  printf("f*f%f\n",(afp->Value()));
  afp = (float_number*)dev (((header*)(fp)) , ((header*)(fp)));
  printf("f/f%f\n",(afp->Value()));
}
#endif
