/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <stdio.h>

#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <device.h>
#endif

#include "event.h"

typedef struct event_s
{
    int		window, device, state;
    void (*func)(void *, int);
    void *arg;
} event_t;

typedef struct update_s
{
    int *flag;
    void (*ufunc)();
    void *arg;
} update_t;

int context, state, device;

#define SIZE_OF_UPDATE_TABLE 10
#define SIZE_OF_EVENT_TABLE 40

event_t event_table[SIZE_OF_EVENT_TABLE];
update_t update_table[SIZE_OF_UPDATE_TABLE];

int no_of_events = 0, no_of_update = 0;

void add_event(int window, int device, int state, void (*func)(void *, int), void *arg)
{
  event_t* new_guy;
  if (no_of_events == SIZE_OF_EVENT_TABLE) {
    fprintf(stderr,"Fatal:\nSorry, Please update SIZE_OF_EVENT_TABLE event.c\n");
#ifndef _DISABLE_GL_
    gexit();
#endif
    exit(-1);
  }
  new_guy = (event_table+no_of_events);
  new_guy->window = window;
  new_guy->device = device;
  new_guy->state  = state;
  new_guy->func   = func;
  new_guy->arg    = arg;
  no_of_events++;
}

void add_update(int *flag, void (*ufunc)(void), void *arg)
{
  update_t* new_guy;
  if (no_of_update == SIZE_OF_UPDATE_TABLE) {
    fprintf(stderr,"Fatal:\nSorry, Please update SIZE_OF_UPDATE_TABLE event.c\n");
#ifndef _DISABLE_GL_
    gexit();
#endif
    exit(-1);
  }
  new_guy = (update_table+no_of_update);
  new_guy->flag = flag;
  new_guy->ufunc = ufunc;
  new_guy->arg  = arg;
  no_of_update++;
}

static int find_update(void)
{
  update_t* scan;
  int updated = 0;
  int count;
  count = no_of_update-1;
  scan = (update_table+count);
  for (;count >= 0; scan--,count--) {
    if (*scan->flag) {
      (*scan->ufunc)();
      updated = 1;
    }
  }
  return(updated);
}

void event_inputchange(long event,short val)
{
  context = state;
}

static void find_event(void)
{
  int flag;
  event_t* scan;
  short	s;
  int count ;
  device = qread(&s);
#ifdef DEBUG
  printf(" event device %d state %d \n",device,s);
#endif
  state = s;
  count = no_of_events-1;
  scan = (event_table+count);
  for (flag = 0;count >= 0; scan--,count--) {
    if (((scan->window == ANY) || (context == scan->window))&&((scan->device == ANY) ||(device == scan->device)) && ((scan->state == ANY) || (state == scan->state))) {
      (*scan->func)(scan->arg, state);
      flag = 1;
    }
  }
}

void event(void)
{
  static int initialized = 0;
  if (initialized == 0) {
    add_event(ANY, INPUTCHANGE, ANY,(void(*)(void*,int))event_inputchange, 0);
    qdevice(INPUTCHANGE);
    initialized = 1;
  }
  if (qtest()) {
    find_event();
  } else if (find_update() == 0) {
    find_event();
  }
}




