/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* */
/* -*-C++-*- */
#include <math.h>
#include "group.h"
#include "cylinder.h"
#include "data.h"
#include "hash.h"
#include "symbol.h"
#include "exit.h"

extern group *root_obj;
extern void nvector(float *A,float *B,float *C,float *n);
extern char line_buffer[BUFSIZ];


char* errmsg_height_invalid = "Fatal : \ncylinder,pipe,conic,pillar or cone member height invalid object\n";
char* errmsg_top_invalid = "Fatal : \ncylinder,pipe,conic,pillar or cone member top invalid object\n";
char* errmsg_bottom_invalid = "Fatal : \ncylinder,pipe,conic,pillar or cone member bottom invalid object\n";
char* errmsg_division_invalid = "Fatal : \ncylinder,pipe,conic,pillar or cone member division invalid object\n";
char* errmsg_cylinder_material_invalid = "Fatal : \ncylinder,pipe,conic,pillar or cone member material invalid object\n";

node *default_node_radius_top;
node *default_node_radius_bottom;
node *default_node_height;
node *default_node_division;
const double rad2theta = (180.0/M_PI);
const double halfpie = (M_PI/2.0);

void initialize_cylinder()
{
  float_number* default_tradius;
  float_number* default_bradius;
  float_number* default_height;
  fixed_number* default_division;
  default_tradius = new float_number[1];
  default_bradius = new float_number[1];
  default_height = new float_number[1];
  default_division = new fixed_number[1];
  default_tradius->Split();
  default_bradius->Split();
  default_height->Split();
  default_division->Split();
  default_tradius->Value(1);
  default_bradius->Value(1);
  default_height->Value(1);
  default_division->Value(20);
  default_node_radius_top = (node*)(root_obj->Search_and_Create("DefaultRadiusTop"));
  default_node_radius_top->Value(default_tradius);
  default_node_radius_bottom = (node*)(root_obj->Search_and_Create("DefaultRadiusBottom"));
  default_node_radius_bottom->Value(default_bradius);
  default_node_height = (node*)(root_obj->Search_and_Create("DefaultHeight"));
  default_node_height->Value(default_height);
  default_node_division = (node*)(root_obj->Search_and_Create("DefaultDivide"));
  default_node_division->Value(default_division);
}

 cylinder::cylinder()
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::cylinder()\n");
#endif
  sym_id = sym_cylinder0;
  dx = 0;dy = 0;dz = 0;
  cx = 0;cy = 0;cz = 0;
  xtheta = 0; ytheta = 0;
  type = POL_CYLINDER0;
  header*  value;

  value = default_node_radius_top->Value();
  value->Split();
  obj[0].Id(sym_om_top);
  obj[0].Value(value);
  obj[0].Split();

  value = default_node_radius_bottom->Value();
  value->Split();
  obj[1].Id(sym_om_bottom);
  obj[1].Value(value);
  obj[1].Split();
  value = default_node_height->Value();
  value->Split();
  obj[2].Id(sym_om_height);
  obj[2].Value(value);
  obj[2].Split();

  value = default_node_division->Value();
  value->Split();
  obj[3].Id(sym_om_division);
  obj[3].Value(value);
  obj[3].Split();
}

/********** subclass constructers ***********/
 cylinder1::cylinder1(void) : cylinder()
{
  sym_id = sym_cylinder1;
  type = POL_CYLINDER1;
}

 pipe0::pipe0(void) : cylinder()
{
  sym_id = sym_pipe0;
  type = POL_PIPE0;
}

 pipe1::pipe1(void) : pipe0()
{
  sym_id = sym_pipe1;
  type = POL_PIPE1;
}

 pillar0::pillar0(void) : cylinder()
{
  sym_id = sym_pillar0;
  type = POL_PILLAR0;
}

 pillar1::pillar1(void) : pillar0()
{
  sym_id = sym_pillar1;
  type = POL_PILLAR1;
}

 conic::conic(void) : cylinder()
{
  sym_id = sym_conic;
  type = POL_CONIC;
}

 cone::cone(void) : cylinder()
{
  sym_id = sym_cone;
  type = POL_CONE;
}
/*******************************************/

 void cylinder::CopySplitMember()
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::CopySplitMember()\n");
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
  header* value;
  int c ;
  for (c = 0;c<CYLINDER_WORD_SIZE;c++) {
    value = obj[c].Value();
    value->Split();
  }
}
void cylinder::From(location* l)
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::From{%g %g %g}\n",l->X(),l->Y(),l->Z());
#endif
  //printf("(%g %g %g)(%g %g %g) From(%f %f %f)\n",object_location->X(),object_location->Y(),object_location->Z(),dx,dy,dz,l->X(),l->Y(),l->Z());
  dx = (object_location->X())+dx - (l->X());
  dy = (object_location->Y())+dy - (l->Y());
  dz = (object_location->Z())+dz - (l->Z());
  cx = dx/2; cy = dy/2; cz = dz/2;
  Move(l);
  double height;
  height = sqrt(dx*dx+dy*dy+dz*dz);
  double work = 0;
  if (dz != 0.0) {
    work = atan(dy/dz);
  }
  xtheta = (dz == 0.0) ? halfpie:((dz < 0) ? (M_PI-work):(-work));
  work = dx/height;
  if (dz == 0.0) {
    if ((dx < 0)&&(dy <0)) {
      work = fabs(work);
    }
  }
  ytheta = (dz < 0) ? (3*M_PI/2 - acos(work)):
    ((dz == 0) ? ( (((dx <0)&&(dy <0))||(dx > 0)&&(dy >0)) ? (halfpie + acos(work)): (halfpie - acos(work))) :(halfpie - acos(work)));
  xtheta *= rad2theta;
  ytheta *= rad2theta;
  header* dp;
  dp = obj[2].Value();
  float_number* new_height;
  new_height = new float_number[1];
  new_height->Value(height);
  new_height->Split();
  obj[2].Value(new_height);
  dp->Close();
}

void cylinder::To(location* l)
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::To{%g %g %g}\n",l->X(),l->Y(),l->Z());
#endif
  //printf("To(%f %f %f)\n",l->X(),l->Y(),l->Z());
  dx = (l->X())-(object_location->X());
  dy = (l->Y())-(object_location->Y());
  dz = (l->Z())-(object_location->Z());
  cx = dx/2;  cy = dy/2;  cz = dz/2;
  double height;
  height = sqrt(dx*dx+dy*dy+dz*dz);
  double work = 0;
  if (dz != 0.0) {
    work = atan(dy/dz);
  }
  xtheta = (dz == 0.0) ? halfpie:((dz < 0) ? (M_PI-work):(-work));
  work = dx/height;
  if (dz == 0.0) {
    if ((dx < 0)&&(dy <0)) {
      work = fabs(work);
    }
  }
  ytheta = (dz < 0) ? (3*M_PI/2 - acos(work)):
    ((dz == 0) ? ( (((dx <0)&&(dy <0))||(dx > 0)&&(dy >0)) ? (halfpie + acos(work)): (halfpie - acos(work))) :(halfpie - acos(work)));
  xtheta *= rad2theta;
  ytheta *= rad2theta;
  header* dp;
  dp = obj[2].Value();
  float_number* new_height;
  new_height = new float_number[1];
  new_height->Value(height);
  new_height->Split();
  dp->Close();
  obj[2].Value(new_height);
}

 void cylinder::Close()
//{}
// ¾ΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::Close()\n");
#endif
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    header* value;
    for (int cc = 0;cc < CYLINDER_WORD_SIZE;cc++) {
      value = obj[cc].Value();
      value->Close();
    }
    free(this);
  }
}
 void cylinder::PushTranslation()
{
#ifdef DEBUG
  fprintf(stderr," void cylinder::PushTranslation()\n");
#endif
#ifndef _DISABLE_GL_
  double ex = (object_location->X()),ey = (object_location->Y()),ez = (object_location->Z());
  ex += cx; ey += cy; ez += cz;
  translate(ex,ey,ez);
#endif
}
 void cylinder::PopTranslation()
{
#ifdef DEBUG
  fprintf(stderr," void cylinder::PopTranslation()\n");
#endif
#ifndef _DISABLE_GL_
  double ex = (object_location->X()),ey = (object_location->Y()),ez = (object_location->Z());
  ex += cx; ey += cy; ez += cz;
  translate(-ex,-ey,-ez);
#endif
}
 void cylinder::PushRotation()
{
#ifdef DEBUG
  fprintf(stderr," void cylinder::PushRotation()\n");
#endif
#ifndef _DISABLE_GL_
  double rx,ry,rz;
  rx = object_rotation->X();
  ry = object_rotation->Y();
  rz = object_rotation->Z();
  rx += xtheta; ry += ytheta;
  rot(rx,'x');
  rot(ry,'y');
  rot(rz,'z');
#endif
}

 void cylinder::PopRotation()
{
#ifdef DEBUG
  fprintf(stderr," void cylinder::PopRotation()\n");
#endif
#ifndef _DISABLE_GL_
  double rx,ry,rz;
  rx = object_rotation->X();
  ry = object_rotation->Y();
  rz = object_rotation->Z();
  rx += xtheta; ry += ytheta;
  rot(-rz,'z');
  rot(-ry,'y');
  rot(-rx,'x');
#endif
}

header* cylinder::Reference(int id)
//{}
//¾Ρ֥ȤΥл
//ϥåidĥ̾ΥФ¸ߤС
//ФΥΡɤΥɥ쥹֤ǤʤС
//0֤
//{}
{
  if ((color->Id()) == id){
    return (header*)color;
  }
  for (int cc = 0;cc<CYLINDER_WORD_SIZE;cc++) {
    if ((obj[cc].Id()) == id) {
      return (header*)(obj+cc);
    }
  }
  return (header*)0;
}

void cylinder::Draw()
//{}
//¾ΡԤʤ
//{}
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::Draw()\n");
#endif
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return; 
  if (scale == 0) return; 
  float top,bottom;
  top = numerical2float(obj[0].Value(),errmsg_top_invalid);
  bottom = numerical2float(obj[1].Value(),errmsg_bottom_invalid);
  division = numerical2int(obj[3].Value(),errmsg_division_invalid);
  if (division == 0) return;
  check_material_and_bind(color->Value(),errmsg_cylinder_material_invalid);
  full_height = numerical2float(obj[2].Value(),errmsg_height_invalid);
  if (full_height < 0.000001) return;
  float Z;
  Z = full_height/2;
  PushScale();
  PushTranslation();
  PushRotation();
  backface(TRUE);

  float DTheta,Theta = 0.0;
  DTheta = 2.0*M_PI/division;
  float A[3],B[3];
  float n[3];

  float norm_l = sqrt(((bottom-top)/full_height)*((bottom-top)/full_height)+1);
  n[0] = 1.0/norm_l; n[1] = 0; n[2] = (bottom-top)/full_height/norm_l;

  A[0] = top;    A[1] = 0;
  B[0] = bottom; B[1] = 0;
  A[2] = Z;  B[2] = -Z;
  
  if (dstate != ObjectDrawing)
    {
      bgnline();
      v3f(A);v3f(B);
      endline();
      for (int J = 0;  J < division;  J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top;    A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(A);v3f(B);
	  endline();
	}
    }
  else
    {
      bgntmesh();
      n3f(n);v3f(A);v3f(B);
      for (int J = 0;  J <= division;  J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top;    A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  n[0] = cos(Theta)/norm_l; n[1] = sin(Theta)/norm_l;
	  n3f(n);v3f(A);v3f(B);
	}
      endtmesh();
    }

  Theta = 0.0;
  if (dstate == DrawingWireFrame)
    {
      float tc[3],bc[3];
      A[0]  = top;    A[1] = 0;
      B[0]  = bottom; B[1] = 0;
      tc[0] = tc[1] = bc[0] = bc[1] = 0;

      A[2] = Z; B[2] = -Z;
      tc[2] =Z;bc[2] = -Z;

      for (int J = 0;  J < division; J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top   ; A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(tc); v3f(A);
	  endline();
	  bgnline();
	  v3f(bc); v3f(B);
	  endline();
	}
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top   ; A[1] = sin(Theta)*top;
	  v3f(A);
	}
      endline();
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  v3f(B);
	}
      endline();
    }
  else 
    {
      Theta = 0;
      bgnpolygon();
      float v[3];
      v[2] = Z;
      n[0] = 0; n[1] = 0; n[2] = 1;
      for (int J = 0;  J <= division; J++,Theta += DTheta)
	{
	  v[0] = cos(Theta)*top;  v[1] = sin(Theta)*top;
	  n3f(n); v3f(v);
	}
      endpolygon();
      Theta = M_PI*2.0;
      bgnpolygon();
      v[2] = -Z;
      n[0] = 0; n[1] = 0; n[2] = -1;
      for (J = 0;  J <= division;  J++, Theta -= DTheta)
	{
	  v[0] = cos(Theta)*bottom;  v[1] = sin(Theta)*bottom;
	  n3f(n); v3f(v);
	}
      endpolygon();
    }
  backface(TRUE);
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

void cylinder::Scale(double s)
{
  scale = s;
}

void pipe0::Draw()
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return; 
  if (scale == 0) return; 
  float top,bottom;
  top = numerical2float(obj[0].Value(),errmsg_top_invalid);
  bottom = numerical2float(obj[1].Value(),errmsg_bottom_invalid);
  division = numerical2int(obj[3].Value(),errmsg_division_invalid);
  if (division == 0) return;
  check_material_and_bind(color->Value(),errmsg_cylinder_material_invalid);
  float n[3],v[3];
  float DTheta,Theta = 0.0;
  full_height = numerical2float(obj[2].Value(),errmsg_height_invalid);
  if (full_height < 0.000001) return;
  float Z;
  Z = full_height/2;
  PushScale();
  PushTranslation();
  PushRotation();
  backface(FALSE);
  DTheta = 2.0*M_PI/division;
  float A[3],B[3];

  float norm_l = sqrt(((bottom-top)/full_height)*((bottom-top)/full_height)+1);
  n[0] = 1.0/norm_l; n[1] = 0; n[2] = (bottom-top)/full_height/norm_l;

  A[0] = top;    A[1] = 0;
  B[0] = bottom; B[1] = 0;
  A[2] = Z;  B[2] = -Z;

  if (dstate != ObjectDrawing)
    {
      bgnline();
      v3f(A);v3f(B);
      endline();
      for (int J = 0;  J < division;  J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top;    A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(A);v3f(B);
	  endline();
	}
    }
  else
    {
      bgntmesh();
      n3f(n);v3f(A);v3f(B);
      for (int J = 0;  J <= division;  J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top;    A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  n[0] = cos(Theta)/norm_l; n[1] = sin(Theta)/norm_l;
	  n3f(n);v3f(A);v3f(B);
	}
      endtmesh();
    }

  backface(FALSE);
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

void pillar0::Draw()
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return; 
  if (scale == 0) return; 
  float top,bottom;
  top = numerical2float(obj[0].Value(),errmsg_top_invalid);
  bottom = numerical2float(obj[1].Value(),errmsg_bottom_invalid);
  division = numerical2int(obj[3].Value(),errmsg_division_invalid);
  if (division == 0) return;
  check_material_and_bind(color->Value(),errmsg_cylinder_material_invalid);
  full_height = numerical2float(obj[2].Value(),errmsg_height_invalid);
  if (full_height < 0.000001) return;
  float Z;
  Z = full_height/2;
  PushScale();
  PushTranslation();
  PushRotation();
  backface(TRUE);
  float DTheta,Theta;
  Theta = 0;
  DTheta = 2.0*M_PI/division;


  float n[3];
  float A[3],B[3];

  float bottomNew = bottom*cos(DTheta/2.0);
  float topNew    = top   *cos(DTheta/2.0);
  float norm_l = sqrt(((bottomNew-topNew)/full_height)
		      *((bottomNew-topNew)/full_height)+1);
  n[0] = 1.0/norm_l; n[1] = 0; n[2] = (bottomNew-topNew)/full_height/norm_l;

  A[0] = top;    A[1] = 0;
  B[0] = bottom; B[1] = 0;
  A[2] = Z;  B[2] = -Z;

  if(dstate ==  DrawingWireFrame)
    {
      A[0] = top;    A[1] = 0;
      B[0] = bottom; B[1] = 0;
      bgnline();
      v3f(A);v3f(B);
      endline();
      for (int J = 0;  J < division;  J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top;    A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(A);v3f(B);
	  endline();
	}
    }
  else
    {
      A[0] = top;    A[1] = 0;
      B[0] = bottom; B[1] = 0;
      for (int J = 0;  J < division;  J++, Theta += DTheta) 
	{
	  n[0] = cos(Theta+DTheta/2.0)/norm_l;
	  n[1] = sin(Theta+DTheta/2.0)/norm_l;
	  bgntmesh();
	  n3f(n);
	  v3f(A);v3f(B);
	  A[0] = cos(Theta+DTheta)*top;
	  A[1] = sin(Theta+DTheta)*top;
	  B[0] = cos(Theta+DTheta)*bottom;
	  B[1] = sin(Theta+DTheta)*bottom;
	  v3f(A);v3f(B);
	  endtmesh();
	}
    }
  Theta = 0;
  if (dstate == DrawingWireFrame)
    {
      float tc[3],bc[3];
      A[0]  = top;    A[1] = 0;
      B[0]  = bottom; B[1] = 0;
      tc[0] = tc[1] = bc[0] = bc[1] = 0;

      A[2] = Z; B[2] = -Z;
      tc[2] =Z;bc[2] = -Z;

      for (int J = 0;  J < division; J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top   ; A[1] = sin(Theta)*top;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(tc); v3f(A);
	  endline();
	  bgnline();
	  v3f(bc); v3f(B);
	  endline();
	}
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  A[0] = cos(Theta)*top   ; A[1] = sin(Theta)*top;
	  v3f(A);
	}
      endline();
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  v3f(B);
	}
      endline();
    }
  else
    {
      bgnpolygon();
      float v[3];
      v[2] = Z;
      n[0] = 0; n[1] = 0; n[2] = 1;
      for (int J = 0;  J <= division; J++,Theta += DTheta)
	{
	  v[0] = cos(Theta)*top;  v[1] = sin(Theta)*top;
	  n3f(n); v3f(v);
	}
      endpolygon();
      Theta = M_PI*2.0;
      bgnpolygon();
      v[2] = -Z;
      n[0] = 0; n[1] = 0; n[2] = -1;
      for (J = 0;  J <= division;  J++, Theta -= DTheta)
	{
	  v[0] = cos(Theta)*bottom;  v[1] = sin(Theta)*bottom;
	  n3f(n); v3f(v);
	}
      endpolygon();
    }
  
  backface(TRUE);

  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

void cone::Draw()
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return; 
  if (scale == 0) return; 
  float top,bottom;
  top = numerical2float(obj[0].Value(),errmsg_top_invalid);
  bottom = numerical2float(obj[1].Value(),errmsg_bottom_invalid);
  division = numerical2int(obj[3].Value(),errmsg_division_invalid);
  if (division == 0) return;
  check_material_and_bind(color->Value(),errmsg_cylinder_material_invalid);
  float n[3],v[3];
  float DTheta,Theta;
  full_height = numerical2float(obj[2].Value(),errmsg_height_invalid);
  if (full_height < 0.000001) return;
  float Z;
  Z = full_height/2;
  PushScale();
  PushTranslation();
  PushRotation();
  backface(TRUE);

  DTheta = 2.0*M_PI/division;
  Theta = 0;

  float A[3],B[3];

  float norm_l = sqrt(((bottom)/full_height)
		      *((bottom)/full_height)+1);
  n[0] = 1.0/norm_l; n[1] = 0; n[2] = (bottom)/full_height/norm_l;

  A[0] = 0;      A[1] = 0;
  B[0] = bottom; B[1] = 0;
  A[2] = Z;  B[2] = -Z;

  if(dstate ==  DrawingWireFrame)
    {
      A[0] = 0;    A[1] = 0;
      B[0] = bottom; B[1] = 0;
      bgnline();
      v3f(A);v3f(B);
      endline();
      for (int J = 0;  J < division;  J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(A);v3f(B);
	  endline();
	}
    }
  else
    {
      A[0] = 0;      A[1] = 0;
      B[0] = bottom; B[1] = 0;
      bgntmesh();
      n3f(n);v3f(A);v3f(B);
      for (int J = 0;  J <= division;  J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  n[0] = cos(Theta)/norm_l; n[1] = sin(Theta)/norm_l;
	  n3f(n);v3f(A);v3f(B);
	}
      endtmesh();

    }
  Theta = 0;
  if (dstate == DrawingWireFrame)
    {
      float tc[3],bc[3];
      A[0]  = 0;      A[1] = 0;
      B[0]  = bottom; B[1] = 0;
      tc[0] = tc[1] = bc[0] = bc[1] = 0;

      A[2] = Z; B[2] = -Z;
      tc[2] =Z;bc[2] = -Z;

      for (int J = 0;  J < division; J++, Theta += DTheta)
	{
	  A[0] = 0.0              ; A[1] = 0.0;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(tc); v3f(A);
	  endline();
	  bgnline();
	  v3f(bc); v3f(B);
	  endline();
	}
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  v3f(B);
	}
      endline();
    }
  else
    {
      Theta = M_PI*2.0;
      bgnpolygon();
      v[2] = -Z;
      n[0] = 0; n[1] = 0; n[2] = -1;
      for (int J = 0;  J <= division;  J++, Theta -= DTheta)
	{
	  v[0] = cos(Theta)*bottom;  v[1] = sin(Theta)*bottom;
	  n3f(n); v3f(v);
	}
      endpolygon();
    }
  
  backface(TRUE);
  PopRotation();
  PopTranslation();
  PopScale();


#endif
}

void conic::Draw()
{
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return; 
  if (scale == 0) return; 
  float top,bottom;
  top = numerical2float(obj[0].Value(),errmsg_top_invalid);
  bottom = numerical2float(obj[1].Value(),errmsg_bottom_invalid);
  division = numerical2int(obj[3].Value(),errmsg_division_invalid);
  if (division == 0) return;
  check_material_and_bind(color->Value(),errmsg_cylinder_material_invalid);
  float n[3],v[3];
  float DTheta,Theta;
  full_height = numerical2float(obj[2].Value(),errmsg_height_invalid);
  if (full_height < 0.000001) return;
  float Z;
  Z = full_height/2;
  PushScale();
  PushTranslation();
  PushRotation();
  backface(TRUE);

  DTheta = 2.0*M_PI/division;
  Theta = 0;

  float A[3],B[3];

  float bottomNew = bottom*cos(DTheta/2.0);
  float norm_l = sqrt(((bottomNew)/full_height)
		      *((bottomNew)/full_height)+1);
  n[0] = 1.0/norm_l; n[1] = 0; n[2] = (bottomNew)/full_height/norm_l;

  A[0] = 0;      A[1] = 0;
  B[0] = bottom; B[1] = 0;
  A[2] = Z;  B[2] = -Z;

  if(dstate ==  DrawingWireFrame)
    {
      A[0] = 0;    A[1] = 0;
      B[0] = bottom; B[1] = 0;
      bgnline();
      v3f(A);v3f(B);
      endline();
      for (int J = 0;  J < division;  J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(A);v3f(B);
	  endline();
	}
    }
  else
    {
      A[0] = 0;      A[1] = 0;
      B[0] = bottom; B[1] = 0;
      for (int J = 0;  J < division;  J++, Theta += DTheta) 
	{
	  n[0] = cos(Theta+DTheta/2.0)/norm_l;
	  n[1] = sin(Theta+DTheta/2.0)/norm_l;
	  bgntmesh();
	  n3f(n);
	  v3f(A);v3f(B);
	  B[0] = cos(Theta+DTheta)*bottom;
	  B[1] = sin(Theta+DTheta)*bottom;
	  v3f(A);v3f(B);
	  endtmesh();
	}
    }
  Theta = 0;
  if (dstate == DrawingWireFrame)
    {
      float tc[3],bc[3];
      A[0]  = 0;      A[1] = 0;
      B[0]  = bottom; B[1] = 0;
      tc[0] = tc[1] = bc[0] = bc[1] = 0;

      A[2] = Z; B[2] = -Z;
      tc[2] =Z;bc[2] = -Z;

      for (int J = 0;  J < division; J++, Theta += DTheta)
	{
	  A[0] = 0.0              ; A[1] = 0.0;
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  bgnline();
	  v3f(tc); v3f(A);
	  endline();
	  bgnline();
	  v3f(bc); v3f(B);
	  endline();
	}
      bgnline();
      for (J = 0;  J <= division; J++, Theta += DTheta)
	{
	  B[0] = cos(Theta)*bottom; B[1] = sin(Theta)*bottom;
	  v3f(B);
	}
      endline();
    }
  else
    {
      Theta = M_PI*2.0;
      bgnpolygon();
      v[2] = -Z;
      n[0] = 0; n[1] = 0; n[2] = -1;
      for (int J = 0;  J <= division;  J++, Theta -= DTheta)
	{
	  v[0] = cos(Theta)*bottom;  v[1] = sin(Theta)*bottom;
	  n3f(n); v3f(v);
	}
      endpolygon();
    }
  
  backface(TRUE);

  PopRotation();
  PopTranslation();
  PopScale();


#endif
}

