%*****************************************************************************
%
%       Metis WINDOW Utility
%               Multi-PSI version
%
%               created by      : ???
%               version         : 1.0
%               revision        : 0.0
%               date created    : 8-30-91
%               date changed    : 03-Feb-92
%               comments
%               : create  "graph windows" ;
%               : changed standard_io_window options ;
%                                "permission" is "out"  03-Feb-92
%               : create  "graph work windows" ;        12-Feb-92
%*****************************************************************************

class metis_window with_macro metis_display_device has

    attribute
            superior,
            equations,
            rules,
            process,
            graph,
            graphCtrl,
            graphWrk,
            ( font7 :=  Font7 :- ( :create(#font,"font:tiny_7.font",Font7) )),
            ( font10 := Font10 :- ( :create(#font,"font:test_10.font",Font10) )),
            ( font11 := Font11 :- ( :create(#font,"font:test_11.font",Font11) )),
            ( font16 := Font16 :- ( :create(#font,"font:kanji_16.font",Font16) ));

    :window_control(Class,Mode) :- !,
            window_control(Mode,Class);
    :startup_window(Class) :- !,
            startup_window ;
    :message_window(Class,Message) :- !,
            message_window(Class,Message);
    :set_window_title(Class,Wname,Title) :- !,
            set_window_title(Class,Wname,Title);
    :get_window_object(Class,Wname,Wobj) :- !,
            get_window_object(Wname,Class,Wobj);
    :set_superior_window(_,Title,Font,Size,SW) :- !,
            set_superior_window(Title,Font,Size,SW);
    :set_pmacs_window(_,Posi,Size,Title,FontL,FontC,SW,PW) :- !,
            set_pmacs_window(Posi,Size,Title,FontL,FontC,SW,PW);
    :set_standard_io_window(_,Posi,Size,Title,FontL,FontC,SW,SIW) :- !,
            set_standard_io_window(Posi,Size,Title,FontL,FontC,SW,SIW);


local

%--------------------------------------------------%
%       window control                             %
%--------------------------------------------------%

    window_control(open,Class) :- !,
            metis_window_open(Class);
    window_control(quit,Class) :- !,
            metis_window_close(Class);
    window_control(hide,Class) :- !,
            :hide(Class!superior);
    window_control(close,Class) :- !,
            :close(Class!superior);

%-----< window open >--------------------------------------------------

    metis_window_open(Class) :- !,
            set_superior_window(
                "METIS/MPSI ver1.0 (20.Aug.1991), Institute for New Generation Computer Technology",
                    Class!font11,(Sw,Sh),SW),
            set_graphic_window((0,0),((Sw/2),(Sh/2)),"GRAPH",all,Class!font11,Class!font7,SW,GW,Ctrl),
            set_standard_io_window((0,0),((Sw/2),(Sh/2)),"GRAPH",Class!font11,Class!font7,SW,GWW),
            set_pmacs_window((0,0),((Sw/2),(Sh/2)),"EQUATIONS",Class!font11,Class!font11,SW,EW),
            set_pmacs_window((0,(Sh/2)),((Sw/2),(Sh/2)),"RULES",Class!font11,Class!font11,SW,RW),
            set_pmacs_window(((Sw/2),0),((Sw/2),Sh),"PROCESS",Class!font11,Class!font11,SW,PW),
            set_window_slot(Class,SW,EW,RW,PW,GW,Ctrl,GWW),
            set_window_active(EW,RW,GW,PW,SW),
            set_editor_process;

%-----< set_window_slot >--------------------------------------------------

    set_window_slot(Class,SW,EW,RW,PW,GW,Ctrl,GWW) :- !,
            Class!superior  := SW,
            Class!equations := EW,
            Class!rules     := RW,
            Class!process   := PW,
            Class!graph     := GW,
            Class!graphCtrl := Ctrl,
            Class!graphWrk  := GWW ;

%-----< set_window_activate >--------------------------------------------------

    set_window_active(EW,RW,GW,PW,SW) :- !,
            :activate(EW),
            :activate(RW),
            :activate(GW),
            :activate(PW),
            :activate(SW);

%--------------------------------------------------%
%       set / reset editor process                 %
%--------------------------------------------------%

%-----< set_editor_process >--------------------------------------------------

    set_editor_process :- !,
            set_editor_process([equations,rules,graph]);

    set_editor_process([]) :- !;
    set_editor_process([Wname|Wrem]) :- !,
            get_window_class(Wname,WC),
            :create(WC,WP),
            :create(#process,PR),
            WC!edit_process := PR,
            :activate(PR,WP),!,
            set_editor_process(Wrem);

%-----< reset_editor_process >--------------------------------------------------

    reset_editor_process :- !,
            reset_editor_process([equations,rules,graph]);

    reset_editor_process([]) :- !;
    reset_editor_process([Wname|Wrem]) :- !,
            get_window_class(Wname,WC),
            :exterminate(WC!edit_process),!,
            reset_editor_process(Wrem);

    get_window_class(equations,#metis_equations_window) :- !;
    get_window_class(rules,#metis_rules_window) :- !;
    get_window_class(graph,#metis_graph_window) :- !;


%--------------------------------------------------%
%       window close                               %
%--------------------------------------------------%

    metis_window_close(Class) :- !,
            reset_editor_process,
            :deactivate(Class!superior),
            :kill(Class!superior);

%--------------------------------------------------%
%       set title                                  %
%--------------------------------------------------%

    set_window_title(Class,Wname,Title) :-
            get_window_object(Wname,Class,Wobj),
            :term_to_string(#metis_mpsi,unquote,Title,Title_),!,
            :set_title(Wobj,Title_);

%--------------------------------------------------%
%       get window object                          %
%--------------------------------------------------%

    get_window_object(equations,Class,Class!equations) :- !;
    get_window_object(rules,Class,Class!rules) :- !;
    get_window_object(process,Class,Class!process) :- !;
    get_window_object(graph,Class,Class!graph) :- !;


%--------------------------------------------------%
%       message window                             %
%--------------------------------------------------%

%-----< startup >--------------------------------------------------

    startup_window :- !,
            :create(#font,"font:test_11.font",Font),
            :show(#messenger,
                    "\n\15bMetis\15b\n\8bjust a few minute.\n",
                    [font(Font),beep]);

%-----< normal message >--------------------------------------------------

    message_window(Class,Message) :- !,
            :show(#messenger,
                    {"\n\5b\s\5b\n",[Message]},
                    [font(Class!font11),beep]);


%--------------------------------------------------%
%       window utility                             %
%--------------------------------------------------%

%-----< set_superior_window >--------------------------------------------------

    set_superior_window(Title,Font,(Sx,Sy),SW) :- !,
            :create(#standard_superior_window,
                        [
                            nature([with_key_select,with_icon]),
                            label_font(Font),
                            title(Title),
                            color_pairs_list(colors),
                            label_color((purple-1))
                        ],SW),
            :get_inside_size(SW,Sx,Sy);

%-----< set_pmacs_window >--------------------------------------------------

    set_pmacs_window((Px,Py),(Sx,Sy),Title,FontL,FontC,SW,PW) :- !,
            :create(#metis_pmacs,
                        [
                            nature([with_shared_window]),
                            superior(SW),
                            size(Sx,Sy),
                            position(Px,Py)
                        ],PW),
            :unquote_atom(PW),
            ( FontC = font13 ; :set_font(PW,FontC) ),
            ( FontL = font13 ; :set_label_font(PW,FontL) ),
            :set_title(PW,Title);

%-----< set_standard_io_window >--------------------------------------------------

    set_standard_io_window((Px,Py),(Sx,Sy),Title,FontL,FontC,SW,SIW) :- !,
            :create(#standard_io_window,
                        [
                            superior(SW),
                            permission(out),
                            margin_flag(off),
                            size(Sx,Sy),
                            position(Px,Py),
                            font(FontC),
                            label_font(FontL),
                            title(Title),
                            color_pairs_list(superior)
                        ],SIW);

%-----< set_graphic_window >--------------------------------------------------

    set_graphic_window(Position,Size,Title,Option,FontL,FontC,SW,GW,CO) :- !,
            :set_graphic_window(#metis_control_box,
                        Position,Size,Title,Option,FontL,FontC,SW,GW,CO);

end.


%--------------------------------------------------%
%   customize pmacs for metis system window        %
%--------------------------------------------------%

class metis_pmacs has

    nature
        pmacs_window ;

instance

    attribute 
        editor := #metis_editor,
        interpreter := #metis_interpreter,
        current_position0 := no,
        control_type := transparence;

%-----< putt >--------------------------------------------------

    :putt(Ins,Control) :-
            control_(Control,Ins),!;

    :putt(Ins,Control,V,V) :-
            control_(Control,Ins),!;

local

%-----< control >--------------------------------------------------

    control_(Var,_) :-
            unbound(Var),!,
            fail;
    control_('$normal',Ins) :- !,
            control_execute(Ins);
    control_('$bold',_) :- !;
    control_('$underline',Ins) :- !,
            set_current_position0(Ins),
            Ins!control_type := 'underline' ;
    control_('$blink',_) :- !;
    control_('$secret',_) :- !;
    control_('$reverse',Ins) :- !,
            set_current_position0(Ins),
            Ins!control_type := 'reverse' ;
    control_('$dotted',Ins) :- !,
            set_current_position0(Ins),
            Ins!control_type := 'dotted' ;
    control_('$rough_dotted',Ins) :- !,
            set_current_position0(Ins),
            Ins!control_type := 'rough_dotted' ;
    control_('$box',Ins) :- !,
            set_current_position0(Ins),
            Ins!control_type := 'box' ;
    control_('$graphic',_) :- !;
    control_('$ascii',_) :- !;
    control_('$big'(X),_) :- !;
    control_('$beep',Ins) :- !,
            :beep(Ins);
    control_('$background_bell',_) :- !;
    control_('$tab',Ins) :- !,
            :current_buffer(Ins,Buff),
            :current_column(Buff,Col),
            Tab is 7 - (Col mod 8),
            (   Tab == 0,!,
                tab(8,Ins)
            ;
                tab(Tab,Ins) );
    control_('$clear_screen',Ins) :- !,
            :get_editor(Ins,Edit),
            :current_buffer(Edit,Buff),
            :clear_buffer(Edit,Buff,0);
    control_('$clear_screenA',_) :- !;
    control_('$clear_screenE',_) :- !;
    control_('$clear_line',Ins) :- !,
            :get_editor(Ins,Edit),
            :beginning_of_line(Edit),
            (   :kill_line_forward(Edit,_) ; true ),!;
    control_('$clear_lineA',_) :- ! ;
    control_('$clear_lineE',Ins) :- !,
            :get_editor(Ins,Edit),
            (   :kill_line_forward(Edit,_) ; true ),!;
    control_('$position_nl',Ins) :- !,
            :get_editor(Ins,Edit),
            :next_line(Edit),
            :beginning_of_line(Edit);
    control_('$position_up',Ins) :- !,
            :get_editor(Ins,Edit),
            :previous_line(Edit);
    control_('$position_down',Ins) :- !,
            :get_editor(Ins,Edit),
            :next_line(Edit);
    control_('$position_right',Ins) :- !,
            :get_editor(Ins,Edit),
            :forward_character(Edit);
    control_('$position_left',Ins) :- !,
            :get_editor(Ins,Edit),
            :backward_character(Edit);
    control_('$position_lineA',Ins) :- !,
            :get_editor(Ins,Edit),
            :beginning_of_line(Edit);
    control_('$position'(1,1),_) :- !;
    control_('$position'(L,C),_) :- !;
    control_('$current_position'(L+1,C+1),_) :- !;
    control_('$cursor_visible',_) :- !;
    control_('$cursor_invisible',_) :- !;
    control_('$cursor_underline',_) :- !;
    control_('$cursor_block',_) :- !;
    control_('$scroll'(T,B),_) :- !;
    control_('$scroll_move'(T,B,O),_) :- !;
    control_('$ttyflush',Ins) :- !,
            :flash(Ins);


%-----< control_execution >--------------------------------------------------

    control_execute(Ins) :- !,
            control_execute_case(Ins!current_position0,Ins);

    control_execute_case(no,_) :- !;
    control_execute_case(P0,Ins) :- !,
            :current_buffer(Ins,Buff),
            :current_position(Buff,P),
            :set_region(Buff,P0,P,Ins!control_type,_),
            Ins!current_position0 := no,
            Ins!control_type := transparence;

%-----< set_current_position0 >--------------------------------------------------

    set_current_position0(Ins) :- !,
            :current_buffer(Ins,Buff),
            :current_position(Buff,P0),
            Ins!current_position0 := P0;

%-----< tab >--------------------------------------------------

    tab(0,_) :- !;
    tab(N,Ins) :- !,
            :putf(Ins," "),
            NewN is N - 1,!,
            tab(NewN,Ins);

end.


%--------------------------------------------------%
%   customize pmacs editor                         %
%--------------------------------------------------%

class metis_editor has

    nature 
        standard_editor;

instance

    :command(Edit,'mouse#ll',command_menu);

%-----< call command menu >--------------------------------------------------

    :command_menu(_) :- !,
            :message_window(#metis_window,"Sorry, unusable command menu.");

end.

%--------------------------------------------------%
%   customize pmacs interpretor                    %
%--------------------------------------------------%

class metis_interpreter has

    nature
        editor_command_interpreter;

instance

        :continue(Obj,command_menu,_):-!,fail;

end.


%--------------------------------------------------%
% equations/rules/graph windows editor process     %
%--------------------------------------------------%

%-----< for equations window >--------------------------------------------------

class metis_equations_window has

    nature
        as_program ;

    attribute
        edit_process ;
instance

    :goal(_) :- !,
            :assign_window(#metis_window!equations),
            :get_interpreter(#metis_window!equations,IP),
            :command_interpret(IP);

end.


%-----< for rules window >--------------------------------------------------

class metis_rules_window has

    nature
        as_program ;

    attribute
        edit_process ;

instance

    :goal(_) :- !,
            :assign_window(#metis_window!rules),
            :get_interpreter(#metis_window!rules,IP),
            :command_interpret(IP);

end.


%-----< for graph window >--------------------------------------------------

class metis_graph_window has

    nature
        as_program ;

    attribute
        edit_process ;

instance

    :goal(_) :- !,
            execute_graph_code;

local

    execute_graph_code :- !,
            repeat,
                :read_control_box_code(#metis_window!graphCtrl,Code),
                control_box_code_case(Code),
            fail ;

    control_box_code_case(abnormal) :- !;
    control_box_code_case('$close'(Mcode)) :- !,
            close_window(Mcode),!;
    control_box_code_case('$reshape'(Mcode)) :- !,
            resize_window(Mcode),!;
    control_box_code_case(Code) :- !,
            :control_for_external(#metis_graph,Code),!;

%-----< close window >--------------------------------------------------

    close_window(mouse#r) :- !,
            :message_window(#metis_window,"close the window"),!;
    close_window(_) :- !,
            :close(#metis_window!graph),!;

%-----< resize window  >--------------------------------------------------
    
    resize_window(mouse#r) :- !,
            :message_window(#metis_window,"move or reshape the window"),!;
    resize_window(mouse#m) :- !,
            :set_position(#metis_window!graph,manipulator,_),!;
    resize_window(_) :- !,
            :get_size(#metis_window!graph,W0,H0),
            :reshape(#metis_window!graph,manipulator,_,_,_),
            :get_size(#metis_window!graph,W,H),
            resize_window_case(W,H,W0,H0),!;

    resize_window_case(W,H,W0,H0) :-
            ( W =< 200 ; H =< 200 ) ,!,
            :message_window(#metis_window,"<W> illegal window size"),
            resize_window_set(W0,H0),!;
    resize_window_case(W,H,_,_) :- !,
            resize_window_set(W,H),!;

    resize_window_set(W,H) :- !,
            :set_size(#metis_window!graphWrk,W,H),
            :get_position(#metis_window!graph,PX,PY),
            :set_graphic_window(#metis_control_box,(PX,PY),(W,H),"GRAPH",all,
                                #metis_window!font11,#metis_window!font7,#metis_window!superior,GW,Ctrl),
            GW0 = #metis_window!graph,
            #metis_window!graph := GW,
            #metis_window!graphCtrl := Ctrl,
            :monitor_graph_set(#metis_graph,repeat),
            :activate(GW),
            :kill(GW0) ,!;

end.


%--------------------------------------------------%
%       control_box window                         %
%--------------------------------------------------%

class metis_control_box  has

    :set_graphic_window(Class,Posi,Size,Title,Option,FontL,FontC,SW,GW,Ins) :- !,
            :new(Class,Ins),
            :set_graphic_window(Ins,Posi,Size,Title,Option,FontL,FontC,SW,GW);
    :set_graphic_option(Class,GW,Option) :- !,
            :new(Class,Ins),
            set_graphic_option(Ins,GW,Option);

instance

    attribute
        graphic_window,
        width,
        height,
        '$up',
        '$down',
        '$left',
        '$right',
        '$close',
        '$sizeUp',
        '$sizeDown',
        '$reshape',
        '$menu'  ;

    :set_graphic_window(Ins,Posi,Size,Title,Option,FontL,FontC,SW,GW) :- !,
            set_graphic_window(Ins,Posi,Size,Title,Option,FontL,FontC,SW,GW);
    :set_graphic_option(Ins,GW,Option) :- !,
            set_graphic_option(Ins,GW,Option);
    :read_control_box_code(Ins,Code) :- !,
            read_control_box_code(Ins,Code);

local

    set_graphic_window(Ins,(Px,Py),(Sx,Sy),Title,Option,FontL,FontC,SW,GW) :- !,
            :create(#standard_io_window,
                        [
                            superior(SW),
                            permission(out),
                            margin_flag(off),
                            size(Sx,Sy),
                            position(Px,Py),
                            font(FontC),
                            label_font(FontL),
                            title(Title),
                            color_pairs_list(superior)
                        ],GW),
            set_graphic_option(Ins,GW,Option),
            Ins!graphic_window := GW;

%-----< set_graphic_option >--------------------------------------------------

    set_graphic_option(Ins,GW,Option) :- !,
            :clear(GW),
            get_graphic_option(Option,O),
            get_window_inside_size(GW,Ins,W,H),
            set_graphic_option_(O,Ins,GW,W,H);

    get_graphic_option(all,O) :- !,
            O = ['$close','$size','$vertical','$horizontal','$reshape','$menu'("option")];
    get_graphic_option(Option,Option) :- !;

    get_window_inside_size(GW,Ins,W,H) :- !,
            :get_inside_size(GW,Cw,Ch),        %%windows charactor size
            :get_inside_units(GW,Uw,Uh),       %%windows unit size
            W = Cw * Uw,                       %%windows width : 634
            H = Ch * Uh,                       %%windows height : 436
            Ins!width  := W,
            Ins!height := H;

    set_graphic_option_([],_,_,_,_) :- !;
    set_graphic_option_([Oone|Orem],Ins,GW,W,H) :- !,
            set_graphic_option_one(Oone,Ins,GW,W,H),!,
            set_graphic_option_(Orem,Ins,GW,W,H);

    set_graphic_option_one('$close',Ins,GW,W,H) :- !,
            set_frame('$left_vertical',GW,W,H),
            set_button('$close',Ins,GW,0,0);
    set_graphic_option_one('$size',Ins,GW,W,_) :- !,
            set_frame('$top_horizontal',GW,W,H),
            set_button('$sizeUp',Ins,GW,(W-45),0),
            set_button('$sizeDown',Ins,GW,(W-30),0);
    set_graphic_option_one('$vertical',Ins,GW,W,H) :- !,
            set_frame('$right_vertical',GW,W,H),
            set_button('$up',Ins,GW,(W-15),15),
            set_button('$down',Ins,GW,(W-15),(H-30));
    set_graphic_option_one('$horizontal',Ins,GW,W,H) :- !,
            set_frame('$bottom_horizontal',GW,W,H),
            set_button('$right',Ins,GW,(W-30),(H-15)),
            set_button('$left',Ins,GW,65,(H-15));
    set_graphic_option_one('$reshape',Ins,GW,W,H) :- !,
            set_button('$reshape',Ins,GW,(W-15),(H-15));
    set_graphic_option_one('$menu'(Mname),Ins,GW,W,H) :- !,
            set_frame('$bottom_horizontal',GW,W,H),
            set_button('$menu'(Mname),Ins,GW,15,(H-15));

%-----< set button >--------------------------------------------------

    set_button('$up',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$up',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+7,Sy+3),(Sx+3,Sy+7),(Sx+5,Sy+7),(Sx+5,Sy+11),
                                (Sx+9,Sy+11),(Sx+9,Sy+7),(Sx+11,Sy+7),(Sx+7,Sy+3)],1,solid,set);
    set_button('$down',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$down',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+5,Sy+3),(Sx+5,Sy+7),(Sx+3,Sy+7),(Sx+7,Sy+11),
                                (Sx+11,Sy+7),(Sx+9,Sy+7),(Sx+9,Sy+3),(Sx+5,Sy+3)],1,solid,set);
    set_button('$right',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$right',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+3,Sy+5),(Sx+3,Sy+9),(Sx+7,Sy+9),(Sx+7,Sy+11),
                                (Sx+11,Sy+7),(Sx+7,Sy+3),(Sx+7,Sy+5),(Sx+3,Sy+5)],1,solid,set);
    set_button('$left',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$left',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+3,Sy+7),(Sx+7,Sy+11),(Sx+7,Sy+9),(Sx+11,Sy+9),
                                (Sx+11,Sy+5),(Sx+7,Sy+5),(Sx+7,Sy+3),(Sx+3,Sy+7)],1,solid,set);
    set_button('$close',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$close',Ins,GW,Sx,Sy),
            :draw_rectangle(GW,Sx+3,Sy+6,9,3,1,solid,set);
    set_button('$sizeUp',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$sizeUp',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+7,Sy+5),(Sx+3,Sy+9),(Sx+11,Sy+9)],1,solid,set);
    set_button('$sizeDown',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$sizeDown',Ins,GW,Sx,Sy),
            :draw_polygon(GW,[(Sx+3,Sy+5),(Sx+7,Sy+9),(Sx+11,Sy+5)],1,solid,set);
    set_button('$reshape',Ins,GW,Sx,Sy) :- !,
            set_button_frame('$reshape',Ins,GW,Sx,Sy),
            :draw_rectangle(GW,Sx+3,Sy+3,5,5,1,solid,set),
            :draw_polygon(GW,[(Sx+8,Sy+5),(Sx+11,Sy+5),(Sx+11,Sy+11),(Sx+5,Sy+11),(Sx+5,Sy+8)],1,solid,set);
    set_button('$menu'(Mname),Ins,GW,Sx,Sy) :- !,
            set_button_frame('$menu',Ins,GW,Sx,Sy),
            :draw_string(GW,Sx+3,Sy,Mname,#metis_window!font7);

    set_button_frame('$menu',Ins,GW,Sx,Sy) :- !,
            freeze((Sx,Sy,(Sx+50),(Sy+15)),Posi),
            Ins!'$menu' := Posi ,
            :draw_rectangle(GW,Sx,Sy,50,15,1,solid,set);
    set_button_frame(Oname,Ins,GW,Sx,Sy) :- !,
            freeze((Sx,Sy,(Sx+15),(Sy+15)),Posi),
            Ins!Oname := Posi ,            
            :draw_rectangle(GW,Sx,Sy,15,15,1,solid,set);

%-----< set_frame >--------------------------------------------------

    set_frame('$right_vertical',GW,W,H) :-
            :draw_rectangle(GW,(W-15),0,15,H,1,solid,set);
    set_frame('$left_vertical',GW,W,H) :-
            :draw_rectangle(GW,0,0,15,H,1,solid,set);
    set_frame('$top_horizontal',GW,W,H) :-
            :draw_rectangle(GW,0,0,W,15,1,solid,set);
    set_frame('$bottom_horizontal',GW,W,H) :-
            :draw_rectangle(GW,0,(H-15),W,15,1,solid,set);

%--------------------------------------------------%
%       read_control_box_code                      %
%--------------------------------------------------%

    read_control_box_code(Ins,Code) :- !,
            :read_click_with_position(Ins!graphic_window,Mcode,X,Y),
            read_control_box_code_(Ins,Mcode,X,Y,Code);

    read_control_box_code_(Ins,Mcode,X,Y,Code) :-
            control_box_code_and_range(Ins,Mode,Range),
            control_box_range_match(Range,X,Y),
            control_box_code_match(Mode,Mcode,Code),!;
    read_control_box_code_(_,_,_,_,abnormal) :- !;

%-----< control_box_range_match >--------------------------------------------------

    control_box_range_match((X0,Y0,X1,Y1),X,Y) :- !,
            X0 =< X , X =< X1,
            Y0 =< Y , Y =< Y1;

%-----< control_box_code_and_range >--------------------------------------------------

    control_box_code_and_range(Ins,left,Range) :-
            melt(Ins!'$left',Range);
    control_box_code_and_range(Ins,right,Range) :-
            melt(Ins!'$right',Range);
    control_box_code_and_range(Ins,up,Range) :-
            melt(Ins!'$up',Range);
    control_box_code_and_range(Ins,down,Range) :-
            melt(Ins!'$down',Range);
    control_box_code_and_range(Ins,close,Range) :-
            melt(Ins!'$close',Range);
    control_box_code_and_range(Ins,sizeUp,Range) :-
            melt(Ins!'$sizeUp',Range);
    control_box_code_and_range(Ins,sizeDown,Range) :-
            melt(Ins!'$sizeDown',Range);
    control_box_code_and_range(Ins,reshape,Range) :-
            melt(Ins!'$reshape',Range);
    control_box_code_and_range(Ins,menu,Range) :-
            melt(Ins!'$menu',Range);


%-----< control_box_code_match >--------------------------------------------------

    control_box_code_match(left,Mcode,'$left'(Mcode)) :- !;
    control_box_code_match(right,Mcode,'$right'(Mcode)) :- !;
    control_box_code_match(up,Mcode,'$up'(Mcode)) :- !;
    control_box_code_match(down,Mcode,'$down'(Mcode)) :- !;
    control_box_code_match(sizeUp,Mcode,'$sizeUp'(Mcode)) :- !;
    control_box_code_match(sizeDown,Mcode,'$sizeDown'(Mcode)) :- !;
    control_box_code_match(close,Mcode,'$close'(Mcode)) :- !;
    control_box_code_match(reshape,Mcode,'$reshape'(Mcode)) :- !;
    control_box_code_match(menu,Mcode,'$menu'(Mcode)) :- !;    

end.