%*****************************************************************************
%
%       Metis MACRO
%               Multi - PSI version
%
%               created by      : ???
%               version         : 1.0
%               revision        : 0.0
%               date created    : 8-30-91
%               date changed    : 08-Jan-92
%               comments
%*****************************************************************************


%--------------------------------------------------%
%   metis_main_methods                             %
%--------------------------------------------------%    

macro_bank metis_main_methods has

%%interface(metis) => :metis_metis(#metis_main);
%%interface(c) => :metis_c(#metis_main);
%%interface(continue) => :metis_continue(#metis_main);
interface(command_select(A,B,C,D,E) ) => :metis_command_select(#metis_main,A,B,C,D,E);
interface(portray(A) ) => :metis_portray(#metis_main,A);
interface(orient(A,B,C) ) => :metis_orient(#metis_main,A,B,C);
%%interface(i) => :metis_i(#metis_main);
%%interface(interactive) => :metis_interactive(#metis_main);
interface(less(A,B) ) => :metis_less(#metis_main,A,B);
interface(can_less(A,B,C,D,E,F) ) => :metis_can_less(#metis_main,A,B,C,D,E,F);
interface(reduce_one(A,B,C) ) => :metis_reduce_one(#metis_main,A,B,C);
interface(reduce_ass ) => :metis_reduce_ass(#metis_main);
interface(refer(A,B,C,D) ) => :metis_refer(#metis_main,A,B,C,D);
interface(refer_match(A,B,C,D) ) => :metis_refer_match(#metis_main,A,B,C,D);
interface(set(A) ) => :metis_set(#metis_main,A);
interface(ref(A) ) => :metis_ref(#metis_main,A);
interface(new_port(A,B) ) => :metis_new_port(#metis_main,A,B);

end.


%--------------------------------------------------%
%   metis_command_methods                          %
%--------------------------------------------------%

macro_bank metis_command_methods has

interface(command(A,B,C,D,E,F) ) => :metis_command(#metis_command,A,B,C,D,E,F);
interface(default_command(A,B) ) => :metis_default_command(#metis_command,A,B);
interface(cpc_mode_and_id(B,C) ) => :metis_cpc_mode_and_id(#metis_command,B,C);

end.


%--------------------------------------------------%
%   metis_buildin_methods                          %
%--------------------------------------------------%

macro_bank metis_buildin_methods has

interface(abolish(Clause,Arity) ) =>
        :abolish(#metis_assert,``(Clause),Arity);
interface(assert(Clause) ) =>
        :assert(#metis_assert,``(Clause));
interface(assert(Clause,Ref) ) => 
        :assert(#metis_assert,``(Clause),Ref);
interface(asserta(Clause) ) =>
        :asserta(#metis_assert,``(Clause));             
interface(asserta(Clause,Ref) ) =>
        :asserta(#metis_assert,``(Clause),Ref);
interface(assertz(Clause) ) =>
        :assertz(#metis_assert,``(Clause));
interface(assertz(Clause,Ref) ) =>
        :assertz(#metis_assert,``(Clause),Ref);
interface(bagof(Data,Pred,List) ) =>
        :prolog_bagof(#metis_buildin,Data,Pred,List);
interface(call(Clause) ) =>
        :prolog_call(#metis_buildin,Clause);
interface(notcall(Clause) ) =>
        :prolog_notcall(#metis_buildin,Clause);
interface(clause(Hed,Body,Ref) ) =>
        :clause(#metis_assert,``(Hed),Body,Ref);
interface(clause(Hed,Body) ) =>
        :clause(#metis_assert,``(Hed),Body);
interface(compare(OP,L,R) ) =>
        :prolog_compare(#metis_buildin,OP,L,R);
interface(erase(Ref) ) =>
        :erase(#metis_assert,Ref);
interface(trimcore) =>
        true;
interface(terminal_open) =>
        :prolog_terminal_open(#metis_buildin);
interface(terminal_close) =>
        :prolog_terminal_close(#metis_buildin);
interface(get0(X) ) =>
        :prolog_get0(#metis_buildin,X);   
interface(length(List,L) ) =>
        :prolog_length(#metis_buildin,List,L);
interface(name(X,List) ) =>
        :prolog_name(#metis_buildin,X,List);
interface(numbervars(Term,Cin,Cout) ) => 
        :prolog_numbervars(#metis_buildin,Term,Cin,Cout);
interface(nl) =>
        :prolog_nl(#metis_buildin);
interface(op(P,F,O) ) =>
        :prolog_op(#metis_buildin,P,F,O);
interface(print(Format,Arg_list) ) =>
        :prolog_print(#metis_buildin,Format,Arg_list);
interface(put(X) ) =>
        :prolog_put(#metis_buildin,X);
interface(read(X) ) =>
        :prolog_read(#metis_buildin,X);
interface(retract(Clause) ) =>
        :retract(#metis_assert,``(Clause));
interface(rename(Old_file,New_file) ) =>
        :prolog_rename(#metis_buildin,Old_file,New_file);
interface(see(Fanam) ) =>
        :prolog_see(#metis_buildin,Fanam);
interface(seeing(Fnam) ) =>
        :prolog_seeing(#metis_buildin,Fnam);
interface(seen) =>
        :prolog_seen(#metis_buildin);
interface(sort(X,List) ) =>
        :prolog_sort(#metis_buildin,X,List);
interface(tell(Fanam) ) =>
        :prolog_tell(#metis_buildin,Fanam);
interface(told) =>
        :prolog_told(#metis_buildin);
interface(telling(Fnam) ) =>
        :prolog_telling(#metis_buildin,Fnam);
interface(write(X) ) =>
        :prolog_write(#metis_buildin,X);
interface(write(X,Y,Z) ) =>
        :prolog_write(#metis_buildin,X,Y,Z);
interface('=..'(Term,List) ) =>
        :'prolog_=..'(#metis_buildin,Term,List);
interface(functor(Term,A,B) ) =>
        :prolog_functor(#metis_buildin,Term,A,B);
interface(tab(A) ) =>
        :prolog_tab(#metis_buildin,A);
interface(prompt(A,B) ) =>
        :prolog_prompt(#metis_buildin,A,B); 
interface(print(A) ) =>
        :prolog_print(#metis_buildin,A);
interface(ttyflush) =>
        :prolog_ttyflush(#metis_buildin);
interface(log) =>
        :prolog_log(#metis_buildin);
interface(nolog) =>
        :prolog_nolog(#metis_buildin);
interface(plsys(A) ) =>
        :prolog_plsys(#metis_buildin,A);
interface(nofileerrors) =>
        :prolog_nofileerrors(#metis_buildin);
interface(writeq(A) ) =>
        :prolog_writeq(#metis_buildin,A);
interface(writeq(A,B,C) ) =>
        :prolog_writeq(#metis_buildin,A,B,C);
interface(nonvar(A) ) =>
        :prolog_nonvar(#metis_buildin,A);
interface(var(A) ) =>
        :prolog_var(#metis_buildin,A);
interface(statistics(A,B) ) =>
        :prolog_statistics(#metis_buildin,A,B);
interface(compile(A) ) =>
        true;
interface(reconsult(A) ) =>
        true;
interface(incore(A) ) =>
        true;
%%interface(halt) =>
%%        true;
interface(halt) =>
        :prolog_halt(#metis_buildin);
interface(abort) =>
        true;

'\+'(A) => not(A);
(X)'@>'(Y) => (X)'>'(Y);
(X)'@>='(Y) => (X)'>='(Y);
(X)'@<'(Y) => (X)'<'(Y);
(X)'@=<'(Y) => (X)'=<'(Y);
 
end.


%--------------------------------------------------%
%       metis_db_methods                           %
%--------------------------------------------------%

macro_bank metis_db_methods has

%% change metis_db

interface('{DB}title'(A)) => :call(#metis_assert,'{DB}title'(A));
interface('{DB-op}inf'(A,B,C,D)) => :call(#metis_assert,'{DB-op}inf'(A,B,C,D));
interface('{DB-op}cons'(A)) => :call(#metis_assert,'{DB-op}cons'(A));
interface('{DB-op}less'(A,B)) => :call(#metis_assert,'{DB-op}less'(A,B));
interface('{DB-eq}###'(A,B,C,D,E,F,G,H,I,J)) => :call(#metis_assert,'{DB-eq}###'(A,B,C,D,E,F,G,H,I,J));
interface('{DB-eq}#/#'(A,B,C,D,E,F,G,H,I,J,K)) => :call(#metis_assert,'{DB-eq}#/#'(A,B,C,D,E,F,G,H,I,J,K));
interface('{CPC}current'(A)) => :call(#metis_assert,'{CPC}current'(A));
interface('{CPC}evaluated'(A)) => :call(#metis_assert,'{CPC}evaluated'(A));
interface('{DB-rl}>>>'(A,B,C,D,E,F)) => :call(#metis_assert,'{DB-rl}>>>'(A,B,C,D,E,F));
interface('{DB-rl}#>>'(A,B,C,D,E,F,G)) => :call(#metis_assert,'{DB-rl}#>>'(A,B,C,D,E,F,G));
interface('{DB-rl}##>'(A,B,C,D,E,F)) => :call(#metis_assert,'{DB-rl}##>'(A,B,C,D,E,F));
interface('{DB-rl}#<<'(A,B,C,D,E,F,G)) => :call(#metis_assert,'{DB-rl}#<<'(A,B,C,D,E,F,G));
interface('{DB-rl}##<'(A,B,C,D,E,F)) => :call(#metis_assert,'{DB-rl}##<'(A,B,C,D,E,F));
interface('{DB-rl}</>'(A,B,C,D,E,F,G)) => :call(#metis_assert,'{DB-rl}</>'(A,B,C,D,E,F,G));
interface('{CPC}>>>'(A,B,C,D,E)) => :call(#metis_assert,'{CPC}>>>'(A,B,C,D,E));
interface('{CPC}#>>'(A,B,C,D,E)) => :call(#metis_assert,'{CPC}#>>'(A,B,C,D,E));
interface('{CPC}##>'(A,B,C,D)) => :call(#metis_assert,'{CPC}##>'(A,B,C,D));
interface('{CPC}#<<'(A,B,C,D,E)) => :call(#metis_assert,'{CPC}#<<'(A,B,C,D,E));
interface('{CPC}##<'(A,B,C,D)) => :call(#metis_assert,'{CPC}##<'(A,B,C,D));
interface('{HIS}'(A)) => :call(#metis_assert,'{HIS}'(A));
interface('{CNT}'(A,B)) => :call(#metis_assert,'{CNT}'(A,B));
interface('{CNT}id'(A,B)) => :call(#metis_assert,'{CNT}id'(A,B));
interface('{FLG}bell' ) => :call(#metis_assert,'{FLG}bell');
interface('{FLG}trace'(A)) => :call(#metis_assert,'{FLG}trace'(A));
interface('{FLG}completion') => :call(#metis_assert,'{FLG}completion');
interface('{FLG}monitor'(A,B)) => :call(#metis_assert,'{FLG}monitor'(A,B));
interface('{FLG}history') => :call(#metis_assert,'{FLG}history');  % save delted data
interface('{FLG}comlog') => :call(#metis_assert,'{FLG}comlog');  % make command log file
interface('{SYS}ttycopy') => :call(#metis_assert,'{SYS}ttycopy');
interface('{FLG}log') => :call(#metis_assert,'{FLG}log');  % make prolog.log
interface('{FLG}to_interactive') => :call(#metis_assert,'{FLG}to_interactive');
interface('{DFT}monitor'(A,B)) => :call(#metis_assert,'{DFT}monitor'(A,B)); 
interface('{DFT}trace'(A)) => :call(#metis_assert,'{DFT}trace'(A)); 
interface('{DB-op}form'(A,B,C)) => :call(#metis_assert,'{DB-op}form'(A,B,C));
interface('{SYS}com_mode'(A)) => :call(#metis_assert,'{SYS}com_mode'(A));
interface('{SYS}version'(A)) => :call(#metis_assert,'{SYS}version'(A));
interface('{SYS}compiled'(A,B,C)) => :call(#metis_assert,'{SYS}compiled'(A,B,C));
interface('{SYS}jobno'(A,B)) => :call(#metis_assert,'{SYS}jobno'(A,B));
interface('{SYS}ttylength'(A)) => :call(#metis_assert,'{SYS}ttylength'(A));
interface('{SYS}ttylevel'(A)) => :call(#metis_assert,'{SYS}ttylevel'(A));
interface('{SYS}print'(A)) => :call(#metis_assert,'{SYS}print'(A));
interface('{SYS}ttytype'(A)) => :call(#metis_assert,'{SYS}ttytype'(A));
interface('{DFT}ttytype'(A)) => :call(#metis_assert,'{DFT}ttytype'(A));
interface('{CPC}terminate') => :call(#metis_assert,'{CPC}terminate');
interface('{SYS}command_file'(A,B)) => :call(#metis_assert,'{SYS}command_file'(A,B));
interface('{SYS}compiled_date'(A,B,C)) => :call(#metis_assert,'{SYS}compiled_date'(A,B,C));
interface('{SYS}current_file'(A,B)) => :call(#metis_assert,'{SYS}current_file'(A,B));
interface('{SYS}executable_file'(A)) => :call(#metis_assert,'{SYS}executable_file'(A));
interface('{DFT}'(A)) => :call(#metis_assert,'{DFT}'(A));
interface('{CPC}induction'(A)) => :call(#metis_assert,'{CPC}induction'(A));

end.


%--------------------------------------------------%
%       metis_biiiildin_methods                    %
%--------------------------------------------------%

macro_bank metis_device_methods has

interface(terminal_type_data(A,B,C,D,E))=>
         :metis_terminal_type_data(#metis_device,A,B,C,D,E);
interface(terminal_level_data(A,B))=>
         :metis_terminal_level_data(#metis_device,A,B);
interface(read(Prompt,Inp))=>
         :metis_read(#metis_device,Prompt,Inp);
interface(read_file(A,Ext,Out))=>
         :metis_read_file(#metis_device,A,Ext,Out);
interface(lininp(Prompt,Buff))=>
         :metis_lininp(#metis_device,Prompt,Buff);
interface(lininp(Prompt,Buff,Trm))=>
         :metis_lininp(#metis_device,Prompt,Buff,Trm);
interface(lininpTop(Prompt,Top))=>
         :metis_lininpTop(#metis_device,Prompt,Top);
interface(lininpCase(Prompt,Cases,Num))=>
         :metis_lininpCase(#metis_device,Prompt,Cases,Num);
interface(set_prompt(Atom))=>
         :metis_set_prompt(#metis_device,Atom);
interface(printf(Item))=>
         :metis_printf(#metis_device,Item);
interface(printf_nomore)=>
         :metis_printf_nomore(#metis_device);
interface(set_terminal_type(A))=>
         :metis_set_terminal_type(#metis_device,A);
interface(get_terminal_type(Type))=>
         :metis_get_terminal_type(#metis_device,Type);
interface(get_terminal_level(Level))=>
         :metis_get_terminal_level(#metis_device,Level);
interface(get_terminal_length(Size))=>
         :metis_get_terminal_length(#metis_device,Size);
interface(get_terminal_range(Top,Bottom))=>
         :metis_get_terminal_range(#metis_device,Top,Bottom);
interface(get_control_sequence(Type,Level,Ctrl,Char))=>
         :metis_get_control_sequence(#metis_device,Type,Level,Ctrl,Char);
interface(can_file_open(Read,File)) =>
         :metis_can_file_open(#metis_device,Read,File);
interface(can_file_open(Flg,A,Key,Ext,File)) =>
         :metis_can_file_open(#metis_device,Flg,A,Key,Ext,File);
interface(file_open(Read,Key,File)) =>
         :metis_file_open(#metis_device,Read,Key,File);
interface(file_close(Read)) =>
         :metis_file_close(#metis_device,Read);
interface(is_end_of_file(End)) =>
         :metis_is_end_of_file(#metis_device,End);
interface(is_end_of_file(A,B,C,D)) =>
         :metis_is_end_of_file(#metis_device,A,B,C,D);
interface(create_tmpfile(Name,File)) =>
         :metis_create_tmpfile(#metis_device,Name,File);
interface(rename_tmpfile(Name,NewFile)) =>
         :metis_rename_tmpfile(#metis_device,Name,NewFile);
interface(delete_tmpfile(Name)) =>
         :metis_delete_tmpfile(#metis_device,Name);
interface(clock(T)) =>
         :metis_clock(#metis_device,T);
end.


%--------------------------------------------------%
%       metis_utility_methods                      %
%--------------------------------------------------%

macro_bank metis_utility_methods has

interface(get_one_list(A,B) ) =>
         :metis_get_one_list(#metis_utility,A,B);
interface(get_one_list(A,B,C) ) =>
         :metis_get_one_list(#metis_utility,A,B,C);
interface(to_skolem(A) ) =>
         :metis_to_skolem(#metis_utility,A);
interface(operator_infix(A) ) => 
         :metis_operator_infix(#metis_utility,A);
interface(operator_prefix(A) ) => 
         :metis_operator_prefix(#metis_utility,A);
interface(operator_postfix(A) ) => 
         :metis_operator_postfix(#metis_utility,A);
interface(to_skolem(A,B,C) ) =>
         :metis_to_skolem(#metis_utility,A,B,C);
interface(to_skolem_list(A) ) =>
         :metis_to_skolem_list(#metis_utility,A);
interface(to_skolem_list(A,B,C) ) =>
         :metis_to_skolem_list(#metis_utility,A,B,C);
interface(from_skolem(A,B) ) =>
         :metis_from_skolem(#metis_utility,A,B);
interface(from_skolem_list(A,B) ) => 
         :metis_from_skolem_list(#metis_utility,A,B);
interface(to_successor_one(A,B) ) =>
         :metis_to_successor_one(#metis_utility,A,B);
interface(from_Sexpression_and_successor(A,B) ) =>
         :metis_from_Sexpression_and_successor(#metis_utility,A,B);
interface(from_successor_one(A,B) ) =>
         :metis_from_successor_one(#metis_utility,A,B);
interface(to_linear(A,B,C) ) =>
         :metis_to_linear(#metis_utility,A,B,C);
interface(get_top_operator(A,B) ) =>
         :metis_get_top_operator(#metis_utility,A,B);
interface(get_top_operator_list(A,B) ) =>
         :metis_get_top_operator_list(#metis_utility,A,B);
interface(get_top_sub_operator(A,B,C) ) =>
         :metis_get_top_sub_operator(#metis_utility,A,B,C);
interface(get_top_sub_operator_list(A,B,C) ) =>
         :metis_get_top_sub_operator_list(#metis_utility,A,B,C);
interface(get_first_operator(A,B) ) =>
         :metis_get_first_operator(#metis_utility,A,B);
interface(get_operators_sweep(A,B) ) =>
         :metis_get_operators_sweep(#metis_utility,A,B);
interface(get_operators(A,B) ) =>
         :metis_get_operators(#metis_utility,A,B);
interface(get_variables_sweep(A,B) ) =>
         :metis_get_variables_sweep(#metis_utility,A,B);
interface(get_variables(A,B) ) =>
         :metis_get_variables(#metis_utility,A,B);
interface(list_to_atom(A,B) ) =>
         :metis_list_to_atom(#metis_utility,A,B);
interface(list_to_dlist(A,B,C) ) =>
         :metis_list_to_dlist(#metis_utility,A,B,C);
interface(list_from_dlist(A,B,C) ) =>
         :metis_list_from_dlist(#metis_utility,A,B,C);
interface(lower_and_upper_string(A,B) ) =>
         :metis_lower_and_upper_string(#metis_utility,A,B);
interface(lower_and_upper(A,B) ) =>
         :metis_lower_and_upper(#metis_utility,A,B);
interface(unify_occ(A,B) ) => 
         :metis_unify_occ(#metis_utility,A,B);
interface(dname(A,B,C) ) =>
         :metis_dname(#metis_utility,A,B,C);
interface(member_of_list(A,B,C) ) =>
         :metis_member_of_list(#metis_utility,A,B,C);
interface(compareSet(A,B,C) ) =>
         :metis_compareSet(#metis_utility,A,B,C);
interface(delete_list(A,B,C,D) ) =>
         :metis_delete_list(#metis_utility,A,B,C,D);
interface(delete_one_list(A,B,C,D) ) =>
         :metis_delete_one_list(#metis_utility,A,B,C,D);
interface(can_delete_list(A,B,C,D) ) =>
         :metis_can_delete_list(#metis_utility,A,B,C,D);
interface(sweep_list(A,B,C) ) =>
         :metis_sweep_list(#metis_utility,A,B,C);
interface(union_list(A,B,C,D) ) =>
         :metis_union_list(#metis_utility,A,B,C,D);
interface(intersect_list(A,B,C,D) ) =>
         :metis_intersect_list(#metis_utility,A,B,C,D);
interface(intersect_list(A,B,C,D,E,F) ) =>
         :metis_intersect_list(#metis_utility,A,B,C,D,E,F);
interface( is_var(V) ) =>
         :metis_is_var(#metis_utility,V);
interface(app_list(A,B,C) ) =>
         :metis_app_list(#metis_utility,A,B,C);
interface(rev_list(A,B) ) =>
         :metis_rev_list(#metis_utility,A,B);
interface(front_ulmatch(A,B) ) =>
         :metis_front_ulmatch(#metis_utility,A,B);
interface(front_ulmatch(A,B,C) ) =>
         :metis_front_ulmatch(#metis_utility,A,B,C);
interface(middle_ulmatch(A,B) ) =>
         :metis_middle_ulmatch(#metis_utility,A,B);
interface(is_list(A) ) =>
         :metis_is_list(#metis_utility,A);
interface(is_string(A) ) =>
         :metis_is_string(#metis_utility,A);
interface(counter(A,B) ) =>
         :metis_counter(#metis_utility,A,B);
interface(counter(A,B,C) ) =>
         :metis_counter(#metis_utility,A,B,C);
interface(counter(A,B,C,D) ) =>
         :metis_counter(#metis_utility,A,B,C,D);
interface(trace_on(A) ) =>
         :metis_trace_on(#metis_utility,A);
interface(traceoff ) =>
         :metis_traceoff(#metis_utility);
interface(trace(A) ) =>
         :metis_trace(#metis_utility,A);
interface(trace(A,B) ) =>
         :metis_trace(#metis_utility,A,B);
interface(is_trace(A) ) =>
         :metis_is_trace(#metis_utility,A);
interface(notrace(A) ) =>
         :metis_notrace(#metis_utility,A);
interface(notrace(A,B) ) =>
         :metis_notrace(#metis_utility,A,B);
interface(not_flag_trace(A) ) =>
         :metis_not_flag_trace(#metis_utility,A);
interface(retract_all(A) ) =>
         :metis_retract_all(#metis_utility,``(A));
interface(bagoft(A,B,C) ) =>
         :metis_bagoft(#metis_utility,A,B,C);
interface(operator_prefix(A) ) =>
         :metis_operator_prefix(#metis_utility,A);
interface(operator_postfix(A) ) =>
         :metis_operator_postfix(#metis_utility,A);
interface(not_seeing(File) ) =>
         :metis_not_seeing(#metis_utility,File);
interface(not_unify(L,R) ) =>
         :metis_not_unify(#metis_utility,L,R);
interface(not_not_unify(L,R) ) =>
         :metis_not_not_unify(#metis_utility,L,R);
end.


%--------------------------------------------------%
%       metis_common_methods                       %
%--------------------------------------------------%

macro_bank metis_common_methods has

prolog_string(Str) => List :-
        :string_to_list(#symbolizer,LL,Str),
        jis_to_ascii(LL,List);

local

jis_to_ascii([],[]):-!;
jis_to_ascii([H_List|T_List],[H_LL|T_LL]) :-!,
        :from_kanji(#ascii_coder,H_List,H_LL),
        jis_to_ascii(T_List,T_LL);

end.


%--------------------------------------------------%
%       metis_color_display_macro                  %
%--------------------------------------------------%
macro_bank metis_display_device has

    system          =>  0 ;
    white           =>  3 ;
    black           =>  5 ;
    light_green     =>  7 ;
    blue            =>  9 ;
    red             =>  11 ;
    cyan            =>  13 ;
    green           =>  15 ;
    purple          =>  17 ;
    yellow          =>  19 ;
    pink            =>  21 ;
    colors          =>  [ 
                            { 0,{{65535,65535,51200},{    0,    0,    0}}},     %   system
                            { 2,{{65535,65535,51200},{65535,65535,51200}}},     %   White
                            { 4,{{65535,65535,51200},{    0,    0,    0}}},     %   Black
                            { 6,{{65535,65535,51200},{    0,65535,    0}}},     %   Light Green
                            { 8,{{65535,65535,51200},{    0,    0,65535}}},     %   Blue
                            {10,{{65535,65535,51200},{55535,    0,    0}}},     %   Red
                            {12,{{65535,65535,51200},{    0,65535,65535}}},     %   Cyan
                            {14,{{65535,65535,51200},{    0,32768,    0}}},     %   Green
                            {16,{{65535,65535,51200},{65535,    0,65535}}},     %   Purple
                            {18,{{65535,65535,51200},{65535,65535,    0}}},     %   Yellow
                            {20,{{65535,65535,51200},{65535,32768,32768}}}      %   Pink
                        ];

end.