%*****************************************************************************
%
%       Metis Graph Utility
%               Multi-PSI version
%
%               created by      : ???
%               version         : 1.0
%               revision        : 0.0
%               date created    : 18-Jan-92
%               date changed    : 23-Jan-92
%               comments
%               : changed graph out methode to "copy"   12-Feb-92
%*****************************************************************************

class metis_graph with_macro metis_display_device has

    attribute

        windows_width,      %%graph windows inside width
        windows_height,     %%graph windows inside height
        scale_Xratio,      %%X-coordinate scale ratio
        scale_Yratio,      %%Y-coordinate scale ratio
        scale_0pointX,      %%point"0" X-coordinate
        scale_0pointY,      %%point"0" Y-coordinate
        scale_XpointX,      %%point"Xmax" X-coordinate
        scale_XpointY,      %%point"Xmax" Y-coordinate
        scale_YpointX,      %%point"Ymax" X-coordinate
        scale_YpointY,      %%point"Ymax" X-coordinate
        ( point := Pobj :- :create(#monogyny_list_index,Pobj) );        %%point list

    :monitor_graph_set(Class,Mode) :- !,
            monitor_graph_set(Mode,Class);
    :monitor_graph_reset(_) :- !,
            monitor_graph_reset;
    :monitor_graph_scale(Class,Margin,Xmin,Xmax,Xinterval,Ymin,Ymax,Yinterval,GW,Font) :- !,
            monitor_graph_scale(Class,Margin,Xmin,Xmax,Xinterval,Ymin,Ymax,Yinterval,GW,Font);
    :monitor_graph_draw(Class,Point) :- !,
            monitor_graph_draw(Point,Class);
    :monitor_graph_draw_repeat(Class) :- !,
            monitor_graph_draw_repeat(Class);
    :monitor_graph_draw_line(Class,GW,Point) :- !,
            monitor_graph_draw_line(GW,Point,Class);
    :monitor_graph_init(Class,Mode) :- !,
            monitor_graph_init(Mode,Class);
    :monitor_graph_count_set(Class,P) :- !,
            monitor_graph_count_set(P,Class);
    :monitor_graph_option_set(_,Op) :- !,
            monitor_graph_option_set(Op);
    :clipping_point(Class,Mode,Kind,P) :- !,
            clipping_point(Mode,Class,Kind,P);
    :control_for_external(Class,Code) :- !,
            control_for_external(Code,Class);


local
    
%--------------------------------------------------%
%       monitor graph                              %
%--------------------------------------------------%

%-----< set / reset monitor graph >--------------------------------------------------

    monitor_graph_set(initialize,Class) :- !,
            monitor_graph_init(all,Class),
            monitor_graph_scale(Class),
            monitor_graph_flush(Class);
    monitor_graph_set(clear,Class) :- !,
            monitor_graph_init(clipping_point,Class),
            monitor_graph_scale(Class),
            monitor_graph_flush(Class);
    monitor_graph_set(repeat,Class) :- !,
            monitor_graph_scale(Class),
            monitor_graph_draw_repeat(Class),
            monitor_graph_flush(Class);

    monitor_graph_reset :- !;

%-----< set scale >--------------------------------------------------

    monitor_graph_scale(Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(Margin,axis(Xmin,Xmax,Xi,_),axis(Ymin,Ymax,Yi,_),_),true),
            monitor_graph_scale(Class,Margin,Xmin,Xmax,Xi,Ymin,Ymax,Yi,#metis_window!graphWrk,#metis_window!font10);

    monitor_graph_scale(Class,Margin,Xmin,Xmax,Xinterval,Ymin,Ymax,Yinterval,GW,Font) :- !,
            get_window_inside_size(GW,Class,W,H),
            get_scale_position(Class,W,H,Margin,P0,XP,YP),
            get_scale_length(P0,XP,YP,XL,YL),
            get_scale_ratio(Class,XL,YL,Xmin,Xmax,Ymin,Ymax,Xsf,Ysf),
            get_scale_interval(Xinterval,Yinterval,Xsf,Ysf,Xsi,Ysi),
            :clear(GW),
            set_scale_axis(GW,P0,XP,YP,Xsi,Ysi,Xmin,Ymin,Xinterval,Yinterval),
            set_scale_axis_name(GW,W,P0,YP,Margin,"step","number",Font),
            set_scale_view_mode(GW,P0,Margin,Font),
            set_scale_line_name(GW,Class,W,YP,Font);

%--------------------------------------------------%
%       get scale option value                     %
%--------------------------------------------------%

    get_window_inside_size(GW,Class,W,H) :- !,
%%            :get_inside_size(GW,Cw,Ch),        %%graph windiw's charactor size
%%            :get_inside_units(GW,Uw,Uh),       %%graph windiw's unit size
%%            W = Cw * Uw,                       %%graph windiw's width : 634
%%            H = Ch * Uh,                       %%graph window's height : 436
            #metis_window!graphCtrl = GC,
            W = GC!width,
            H = GC!height,
            Class!windows_width := W,
            Class!windows_height := H;

    get_scale_position(Class,W,H,Margin,(P0x,P0y),(XPx,XPy),(YPx,YPy)) :- !,
            P0x = Margin,     P0y = H - Margin,
            XPx = W - Margin, XPy = H - Margin,
            YPx = Margin,     YPy = Margin,
            Class!scale_0pointX := P0x,
            Class!scale_0pointY := P0y,
            Class!scale_XpointX := XPx,
            Class!scale_XpointY := XPy,
            Class!scale_YpointX := YPx,
            Class!scale_YpointY := YPy;

    get_scale_length((P0x,P0y),(XPx,_),(_,YPy),XL,YL) :- !,
            XL = XPx - P0x,
            YL = P0y - YPy;

    get_scale_ratio(Class,XL,YL,Xmin,Xmax,Ymin,Ymax,Xsf,Ysf) :- !,
            divide_floating(XL,Xmax-Xmin,Xsf),
            divide_floating(YL,Ymax-Ymin,Ysf),
            Class!scale_Xratio := Xsf,
            Class!scale_Yratio := Ysf;

    get_scale_interval(Xsf,Ysf,Xinterval,Yinterval,Xsi_,Ysi_) :- !,
            multiply_floating(Xinterval,Xsf,Xsi),
            floating_point_to_integer(Xsi,Xsi_),
            multiply_floating(Yinterval,Ysf,Ysi),
            floating_point_to_integer(Ysi,Ysi_);

%--------------------------------------------------%
%       set scale line                             %
%--------------------------------------------------%

%-----< set axis line >--------------------------------------------------

    set_scale_axis(GW,(P0x,P0y),(XPx,XPy),(YPx,YPy),Xsi,Ysi,Xnum,Ynum,Xinterval,Yinterval) :- !,
            :draw_filled_rectangle(GW,YPx,YPy,(XPx-P0x),(XPy-YPy),1,mesh,light_green),
            set_scale_axis(GW,(P0x+4,P0y+4),(XPx+4,XPy+4),(YPx+4,YPy+4),Xsi,Ysi,Xnum,Ynum,Xinterval,Yinterval,black),
            set_scale_axis(GW,(P0x,P0y),(XPx,XPy),(YPx,YPy),Xsi,Ysi,Xnum,Ynum,Xinterval,Yinterval,purple);

    set_scale_axis(GW,(P0x,P0y),(XPx,XPy),(YPx,YPy),Xsi,Ysi,Xnum,Ynum,Xinterval,Yinterval,Color) :- !,
    
            :draw_line(GW,XPx,XPy,P0x,P0y,4,solid,Color),
            :draw_line(GW,YPx,YPy,P0x,P0y,4,solid,Color),
            set_scale_axis_Xinterval(GW,P0x,XPx,XPy,Xsi,Xnum,Xinterval,Color),
            set_scale_axis_Yinterval(GW,P0y,YPy,YPx,Ysi,Ynum,Yinterval,Color);

    set_scale_axis_Xinterval(_,X,Xmax,_,_,_,_,_) :-
            X > Xmax,!;
    set_scale_axis_Xinterval(GW,X,Xmax,Y,SI,Num,Interval,Color) :- !,
            :draw_line(GW,X,Y-10,X,Y,4,solid,Color),
            :get_number_string(#symbolizer,Num,Num_),
            :draw_string(GW,X-6,Y+8,Num_,#metis_window!font7,set),!,
            set_scale_axis_Xinterval(GW,X+SI,Xmax,Y,SI,Num+Interval,Interval,Color);

    set_scale_axis_Yinterval(_,Y,Ymax,_,_,_,_,_) :-
            Y < Ymax,!;
    set_scale_axis_Yinterval(GW,Y,Ymax,X,SI,Num,Interval,Color) :- !,
            :draw_line(GW,X+10,Y,X,Y,4,solid,Color),
            :get_number_string(#symbolizer,Num,Num_),
            :draw_string(GW,X-30,Y-6,Num_,#metis_window!font7,set),!,
            set_scale_axis_Yinterval(GW,Y-SI,Ymax,X,SI,Num+Interval,Interval,Color);

%-----< set_scale_axis_name >--------------------------------------------------

    set_scale_axis_name(GW,W,(_,P0y),(YPx,YPy),Margin,Xname,Yname,Font) :- !,
            :append(#string,[Xname,"  ","->"],XXname),
            :draw_string(GW,(W/2),(P0y+Margin/2),XXname,Font,set),
            :draw_string(GW,(YPx/2),(YPy/2),Yname,Font,set),
            :draw_string(GW,(YPx/2-20),(YPy/2),"^",Font,set),
            :draw_line(GW,(YPx/2-16),(YPy/2+10),(YPx/2-16),(YPy/2+20),2,solid,set);

%-----< set_scale_view_mode >--------------------------------------------------

    set_scale_view_mode(GW,(P0x,P0y),Margin,Font) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,_,_,Vmode),true),
            Px = ( P0x / 2 ) - 10,
            Py = P0y + ( Margin / 2 ) - 10,
            set_scale_view_mode_case(Vmode,GW,Px,Py,Margin,NewVmode),
            :draw_string(GW,Px,Py,NewVmode,Font,exclusive_or);

    set_scale_view_mode_case(normal,GW,Px,Py,Margin,"normal") :- !,
            :draw_filled_rectangle(GW,Px+6,Py+6,60,20,black),
            :draw_filled_rectangle(GW,Px,Py,60,20,green);
    set_scale_view_mode_case(scroll,GW,Px,Py,Margin,"scroll") :- !,
            :draw_filled_rectangle(GW,Px+6,Py+6,60,20,black),
            :draw_filled_rectangle(GW,Px,Py,60,20,blue);
    set_scale_view_mode_case(optimize,GW,Px,Py,Margin,"optimize") :- !,
            :draw_filled_rectangle(GW,Px+6,Py+6,80,20,black),
            :draw_filled_rectangle(GW,Px,Py,80,20,purple);

%-----< set_scale_line_name >--------------------------------------------------

    set_scale_line_name(GW,Class,W,(_,YPy),Font) :- !,
            :clause(#metis_assert,'{FLG}monitor'(_,Mode),true),
            set_scale_line_name_case(Mode,GW,Class,W,YPy,Font);

    set_scale_line_name_case(all,GW,Class,W,YPy,Font) :- !,
            set_scale_line_name_list([equations,rules,cp,cpAss],GW,Class,W,YPy,Font,0);
    set_scale_line_name_case(data,GW,Class,W,YPy,Font) :- !,
            set_scale_line_name_list([equations,rules],GW,Class,W,YPy,Font,0);
    set_scale_line_name_case(Mode,GW,Class,W,YPy,Font) :- !,
            set_scale_line_name_list([Mode],GW,Class,W,YPy,Font,0);

    set_scale_line_name_list([],_,_,_,_,_,_) :- !;
    set_scale_line_name_list([Mone|Mrem],GW,Class,W,YPy,Font,N) :- !,
            get_line_type(Mone,Lwidth,Ltype,Lcolor),
            :draw_line(GW,(W/2+54),(YPy/3+N+4),(W/2+100+4),(YPy/3+N+4),Lwidth,Ltype,black),
            :draw_line(GW,(W/2+50),(YPy/3+N),(W/2+100),(YPy/3+N),Lwidth,Ltype,Lcolor),
            :term_to_string(#metis_mpsi,Mone,Name),
            :draw_string(GW,(W/2+120),(YPy/3+N-10),Name,Font,set),!,
            set_scale_line_name_list(Mrem,GW,Class,W,YPy,Font,N+20);
            
%--------------------------------------------------%
%       monitor graph draw                         %
%--------------------------------------------------%
            
    monitor_graph_draw(P,Class) :-
            monitor_graph_draw_continue(P,Class,NewP),!,
            monitor_graph_draw_line(#metis_window!graph,NewP,Class),
            monitor_graph_renew_view(NewP,Class);
    monitor_graph_draw(P,Class) :- !,
            monitor_graph_draw_point_set(P,NewP),            
            monitor_graph_draw_line(#metis_window!graph,NewP,Class),
            monitor_graph_renew_view(NewP,Class);

    monitor_graph_draw_continue([],_,[]) :- !;
    monitor_graph_draw_continue([{Mode,P}|Prem],Class,[{Mode,[LP|P]}|NewPrem]) :- !,
            clipping_point(get,Class,Mode,LP),
            clipping_point(set,Class,Mode,P),!,
            monitor_graph_draw_continue(Prem,Class,NewPrem);

%-----< monitor_graph_point_set >--------------------------------------------------

    monitor_graph_draw_point_set([],_) :- !;
    monitor_graph_draw_point_set([{Mode,P}|Prem],Class) :- !,
            clipping_point(set,Class,Mode,P),!,
            monitor_graph_draw_point_set(Prem,Class);

%-----< monitor_graph_draw_repeat >--------------------------------------------------

    monitor_graph_draw_repeat(Class) :- !,
            :clause(#metis_assert,'{FLG}monitor'(_,Mode),true),
            monitor_graph_draw_repeat(Mode,Class);

    monitor_graph_draw_repeat(all,Class) :- !,
            clipping_point(get_all,Class,equations,E),
            clipping_point(get_all,Class,rules,R),
            clipping_point(get_all,Class,cp,Cp),
            clipping_point(get_all,Class,cpAss,CpAss),
            monitor_graph_draw_line(#metis_window!graphWrk,[equations(E),rules(R),cp(Cp),cpAss(CpAss)],Class);
    monitor_graph_draw_repeat(data,Class) :- !,
            clipping_point(get_all,Class,equations,E),
            clipping_point(get_all,Class,rules,R),
            monitor_graph_draw_line(#metis_window!graphWrk,[equations(E),rules(R)],Class);
    monitor_graph_draw_repeat(Mode,Class) :- !,
            clipping_point(get_all,Class,Mode,P),
            monitor_graph_draw_line(#metis_window!graphWrk,[{Mode,(P)}],Class);

%-----< monitor_graph_draw_line >--------------------------------------------------

    monitor_graph_draw_line(GW,Plist,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,axis(Xmin,_,_,_),axis(Ymin,_,_,_),_),true),
            monitor_graph_draw_line_list(Plist,GW,Class,Xmin,Ymin);

    monitor_graph_draw_line_list([],_,_,_,_) :- !;
    monitor_graph_draw_line_list([{_,abnormal}|Prem],GW,Class,Xmin,Ymin) :- !,
            monitor_graph_draw_line_list(Prem,GW,Class,Xmin,Ymin);
    monitor_graph_draw_line_list([{Mode,P}|Prem],GW,Class,Xmin,Ymin) :- !,
            monitor_graph_draw_convert(P,Class,Xmin,Ymin,CP),
            get_line_type(Mode,Lwidth,Ltype,Lcolor),
            :draw_graph(GW,CP,Class!scale_YpointX,Class!scale_YpointY,
                    (Class!scale_XpointX - Class!scale_YpointX), 
                        (Class!scale_XpointY - Class!scale_YpointY),
                            Lwidth,Ltype,Lcolor),!,
            monitor_graph_draw_line_list(Prem,GW,Class,Xmin,Ymin);

%-----<  monitor_graph_draw_convert >--------------------------------------------------

    monitor_graph_draw_convert([],_,_,_,[]) :- !;
    monitor_graph_draw_convert([(X,Y)|Prem],Class,Xmin,Ymin,[(XP,YP)|NewPrem]) :- !,
            Xp = X - Xmin,                              %%X-coordinate
            multiply_floating(Xp,Class!scale_Xratio,Xfp),
            floating_point_to_integer(Xfp,Xip),
            XP = Xip + Class!scale_0pointX,
            Yp = Y - Ymin,                              %%Y-coordinate
            multiply_floating(Yp,Class!scale_Yratio,Yfp),
            floating_point_to_integer(Yfp,Yip),
            YP = Class!scale_0pointY - Yip ,!,
            monitor_graph_draw_convert(Prem,Class,Xmin,Ymin,NewPrem);

%-----< graph line type >--------------------------------------------------

    get_line_type(equations,4,solid,blue) :- !;
    get_line_type(rules,4,solid,red) :- !;
    get_line_type(cp,4,solid,green) :- !;
    get_line_type(cpAss,4,solid,cyan) :- !;

%--------------------------------------------------%
%       windows flush                              %
%--------------------------------------------------%

    monitor_graph_flush(Class) :- !,
            :copy(#metis_window!graph,#metis_window!graphWrk,16,16,16,16,
                        Class!windows_width-32,Class!windows_height-32,copy);


%--------------------------------------------------%
%       scroll / optimize                          %
%--------------------------------------------------%

    monitor_graph_renew_view(_,_) :-
            :clause(#metis_assert,'{{FLG}graph'(_,_,_,normal),true),!;
    monitor_graph_renew_view(P,Class) :- !,
            get_max_point(P,(0,0),(X,Y)),
            renew_graph_view(X,Y,Class);

    renew_graph_view(X,Y,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode),true),
            renew_graph_view_case(X,Y,Xmin,Xmax,Xi,Xs,Ymin,Ymax,Yi,Ys,Vmode,Class);

    renew_graph_view_case(X,Y,_,_,_,_,Ymin,Ymax,Yi,Ys,Vmode,Class) :-
            Y < Ymin,!,
            view_mode(Vmode,down,changed,X,Y,'Y-axis',Ymin,Ymax,Yi,Ys,Class);
    renew_graph_view_case(X,Y,_,Xmax,_,_,_,Ymax,_,_,_,_) :-
            X =< Xmax, Y =< Ymax,!;
    renew_graph_view_case(X,Y,Xmin,Xmax,Xi,Xs,Ymin,Ymax,Yi,Ys,Vmode,Class) :-
            X > Xmax, Y > Ymax,!,
            view_mode(Vmode,up,nochanged,X,Y,'X-axis',Xmin,Xmax,Xi,Xs,Class),
            view_mode(Vmode,up,changed,X,Y,'Y-axis',Ymin,Ymax,Yi,Ys,Class);
    renew_graph_view_case(X,Y,Xmin,Xmax,Xi,Xs,_,Ymax,_,_,Vmode,Class) :-
            X > Xmax, Y =< Ymax,!,
            view_mode(Vmode,up,changed,X,Y,'X-axis',Xmin,Xmax,Xi,Xs,Class);
    renew_graph_view_case(X,Y,_,Xmax,_,_,Ymin,Ymax,Yi,Ys,Vmode,Class) :-
            X =< Xmax, Y > Ymax,!,
            view_mode(Vmode,up,changed,X,Y,'Y-axis',Ymin,Ymax,Yi,Ys,Class);

    view_mode(Vmode,Smode,Cmode,X,Y,Axis,Min,Max,Interval,Scroll,Class) :- !,
            get_Sinterval(Min,Max,Scroll,Sratio,Sinterval),
            view_mode_case(Vmode,Smode,Min,Max,Interval,Sratio,Sinterval,NewMin,NewMax,NewInterval),
            monitor_graph_option_set({Axis,(NewMin,NewMax,NewInterval,Scroll)}),
            ( Cmode = changed,!,
              monitor_graph_set(repeat,Class)
            ; true ),!,
            renew_graph_view(X,Y,Class);

    get_Sinterval(Min,Max,Scroll,Sratio,Sinterval) :- !,       %%Sinterval = (Max-Min)*(Scroll/100)
            divide_floating(Scroll,100,Sratio),
            multiply_floating(Max-Min,Sratio,Sinterval0),
            floating_point_to_integer(Sinterval0,SI),
            ( SI = 0, Sinterval = 1 ; Sinterval = SI );

    view_mode_case(scroll,up,Min,Max,Interval,_,Sinterval,NewMin,NewMax,Interval) :- !,
            NewMin = Min + Sinterval,
            NewMax = Max + Sinterval;
    view_mode_case(scroll,down,Min,Max,Interval,_,Sinterval,NewMin,NewMax,Interval) :- !,
            NewMin = Min - Sinterval,
            NewMax = Max - Sinterval;
    view_mode_case(optimize,_,Min,Max,Interval,Sratio,Sinterval,Min,NewMax,NewInterval) :- !,
            NewMax = Max + Sinterval,
            multiply_floating(Interval,Sratio,Interval0),  %%NewInterval=Interval+(Interval*(Scroll/100))
            floating_point_to_integer(Interval0,Interval1),
            NewInterval = Interval + Interval1;

%-----< get_max_point >--------------------------------------------------

%%    get_max_point([],P,P) :- !;
%%    get_max_point([{_,P}|Prem],P0,Pmax) :- !,
%%            get_max_Xpoint(P,P0,Pm),!,
%%            get_max_Xpoint(Prem,Pm,Pmax);

    get_max_point([],P,P) :- !;
    get_max_point([{_,P}|_],P0,Pmax) :- !,
            get_max_Xpoint(P,P0,Pmax);

    get_max_Xpoint([],P,P) :- !;
    get_max_Xpoint([(X0,Y0)|Prem],(X,_),Pmax) :-
            X0 > X,!,
            get_max_Xpoint(Prem,(X0,Y0),Pmax);
    get_max_Xpoint([_|Prem],P,Pmax) :- !,
            get_max_Xpoint(Prem,P,Pmax);

%--------------------------------------------------%
%       scale option                                %
%--------------------------------------------------%

%-----< initialize scale option >--------------------------------------------------

    monitor_graph_init(all,Class) :- !,
            monitor_graph_init(data,_),
            monitor_graph_init(clipping_point,Class);
    monitor_graph_init(data,_) :- !,
            :retract(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(0,(Xmax-Xmin),Xi,Xs),axis(0,(Ymax-Ymin),Yi,Ys),Vmode));
    monitor_graph_init(clipping_point,Class) :- !,
            clipping_point(init,Class,all,_);

%-----< set scale option >--------------------------------------------------

    monitor_graph_option_set(initialize) :- !,
            :clause(#metis_assert,'{DFT}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode),true),
            :abolish(#metis_assert,'{FLG}graph',4),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));
    monitor_graph_option_set(view(Vmode)) :- !,
            monitor_graph_view_mode(Vmode);
    monitor_graph_option_set(margin(M)) :- !,
            monitor_graph_margin_option(M);
    monitor_graph_option_set('X-axis'(Option)) :- !,
            monitor_graph_Xaxis_option(Option);
    monitor_graph_option_set('Y-axis'(Option)) :- !,
            monitor_graph_Yaxis_option(Option);

    monitor_graph_view_mode(Vmode) :-
            :clause(#metis_assert,'{FLG}graph'(_,_,_,Vmode),true),!;
    monitor_graph_view_mode(Vmode) :- !,
            :retract(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),_)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));

    monitor_graph_Xaxis_option([]) :- !,
            :clause(#metis_assert,'{DFT}graph'(_,axis(Xmin,Xmax,Xi,Xs),_,_),true),
            :retract(#metis_assert,'{FLG}graph'(M,_,axis(Ymin,Ymax,Yi,Ys),Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));
    monitor_graph_Xaxis_option((Min,Max,Interval,Scroll)) :- !,
            :retract(#metis_assert,'{FLG}graph'(M,_,axis(Ymin,Ymax,Yi,Ys),Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Min,Max,Interval,Scroll),axis(Ymin,Ymax,Yi,Ys),Vmode));

    monitor_graph_Yaxis_option([]) :- !,
            :clause(#metis_assert,'{DFT}graph'(_,_,axis(Ymin,Ymax,Yi,Ys),_),true),
            :retract(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),_,Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));
    monitor_graph_Yaxis_option((Min,Max,Interval,Scroll)) :- !,
            :retract(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),_,Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Min,Max,Interval,Scroll),Vmode));

    monitor_graph_margin_option([]) :- !,
            :clause(#metis_assert,'{DFT}graph'(M,_,_,_),true),
            :retract(#metis_assert,'{FLG}graph'(_,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));
    monitor_graph_margin_option(M) :- !,
            :retract(#metis_assert,'{FLG}graph'(_,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode)),
            :assert(#metis_assert,'{FLG}graph'(M,axis(Xmin,Xmax,Xi,Xs),axis(Ymin,Ymax,Yi,Ys),Vmode));

%--------------------------------------------------%
%       clipping point                             %
%--------------------------------------------------%

%-----< monitor_graph_count_set >--------------------------------------------------

    monitor_graph_count_set([],_) :- !;
    monitor_graph_count_set([{Mode,P}|Prem],Class) :- !,
            clipping_point(set,Class,Mode,P),!,
            monitor_graph_count_set(Prem,Class);

%-----< set / get >--------------------------------------------------

    clipping_point(init,Class,Mode,_) :- !,
            (   Mode = all,!,
                :get_keys(Class!point,Mlist),
                init_clipping_point_list(Mlist,Class)
            ;
                :remove_at(Class!point,_,Mode)  ),!;
    clipping_point(remove,Class,Mode,P) :- !,
            (   :get_at(Class!point,Pobj,Mode),!,
                :remove_last(Pobj,P)
            ;
                true    ),!;
    clipping_point(set,Class,Mode,P) :- !,
            (   :get_at(Class!point,Pobj,Mode),!,
                set_clipping_point(P,Pobj)
            ;
                :create(#list,Pobj),
                set_clipping_point(P,Pobj),
                :put_at(Class!point,Pobj,Mode)  ),!;
    clipping_point(get,Class,Mode,P) :- !,
            (   :get_at(Class!point,Pobj,Mode),!,
                :get_last(Pobj,P0),
                melt(P0,P)
            ;
                P = abnormal    ),!;
    clipping_point(get_all,Class,Mode,P) :- !,
            (   :get_at(Class!point,Pobj,Mode),!,
                :get_contents(Pobj,P0),
                get_all_clipping_point_list(P0,P)
            ;
                P = abnormal    ),!;

    init_clipping_point_list([],_) :- !;
    init_clipping_point_list([Mone|Mrem],Class) :- !,
            clipping_point(init,Class,Mone,_),!,
            init_clipping_point_list(Mrem,Class);

    set_clipping_point((X,Y),Pobj) :- !,
            freeze((X,Y),P),
            :add_last(Pobj,P);
    set_clipping_point([P|Prem],Pobj) :- !,
            set_clipping_point(P,Pobj),
            set_clipping_point_list(Prem,Pobj) ;

    set_clipping_point_list([],_) :- !;
    set_clipping_point_list([Pone|Prem],Pobj) :- !,
            set_clipping_point(Pone,Pobj),!,
            set_clipping_point_list(Prem,Pobj);

    get_all_clipping_point_list([],[]) :- !;
    get_all_clipping_point_list([P0one|P0rem],[Pone|Prem]) :- !,
            melt(P0one,Pone),!,
            get_all_clipping_point_list(P0rem,Prem);

%--------------------------------------------------%
%       floating                                   %
%--------------------------------------------------%

%-----< multiply >--------------------------------------------------

    multiply_floating(L,R,A) :- !,
            integer_to_floating_point(L,LL),
            integer_to_floating_point(R,RR),
            A = LL * RR;

%-----< divide >--------------------------------------------------

    divide_floating(L,R,A) :- !,
            integer_to_floating_point(L,LL),
            integer_to_floating_point(R,RR),
            A = LL / RR;

%--------------------------------------------------%
%       control_for_external                       %
%--------------------------------------------------%

    control_for_external('$up'(Mcode),Class) :- !,
            control_for_externalUP(Mcode,Class);
    control_for_external('$down'(Mcode),Class) :- !,
            control_for_externalDOWN(Mcode,Class);
    control_for_external('$right'(Mcode),Class) :- !,
            control_for_externalRIGHT(Mcode,Class);
    control_for_external('$left'(Mcode),Class) :- !,
            control_for_externalLEFT(Mcode,Class);
    control_for_external('$sizeUp'(Mcode),Class) :- !,
            control_for_externalSIZEUP(Mcode,Class);
    control_for_external('$sizeDown'(Mcode),Class) :- !,
            control_for_externalSIZEDOWN(Mcode,Class);
    control_for_external('$menu'(_),_) :- !,
            :message_window(#metis_window,"Sorry, now making !!");
    control_for_external(_,_) :- !;

    control_for_externalUP(mouse#r,_) :- !,
            :message_window(#metis_window,"move to up");
    control_for_externalUP(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,_,axis(Ymin,Ymax,Yi,Ys),Vmode),true),
            control_scroll(Ymin,Ymax,Yi,Ys,'Y-axis',up,Vmode,Class);

    control_for_externalDOWN(mouse#r,_) :- !,
            :message_window(#metis_window,"move to down");
    control_for_externalDOWN(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,_,axis(Ymin,Ymax,Yi,Ys),Vmode),true),
            control_scroll(Ymin,Ymax,Yi,Ys,'Y-axis',down,Vmode,Class);

    control_for_externalRIGHT(mouse#r,_) :- !,
            :message_window(#metis_window,"move to right");
    control_for_externalRIGHT(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,axis(Xmin,Xmax,Xi,Xs),_,Vmode),true),
            control_scroll(Xmin,Xmax,Xi,Xs,'X-axis',up,Vmode,Class);

    control_for_externalLEFT(mouse#r,_) :- !,
            :message_window(#metis_window,"move to left");
    control_for_externalLEFT(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(_,axis(Xmin,Xmax,Xi,Xs),_,Vmode),true),
            control_scroll(Xmin,Xmax,Xi,Xs,'X-axis',down,Vmode,Class);

    control_for_externalSIZEUP(mouse#r,_) :- !,
            :message_window(#metis_window,"size up");
    control_for_externalSIZEUP(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(M,_,_,_),true),
            control_size(up,M,Class);

    control_for_externalSIZEDOWN(mouse#r,_) :- !,
            :message_window(#metis_window,"size down");
    control_for_externalSIZEDOWN(_,Class) :- !,
            :clause(#metis_assert,'{FLG}graph'(M,_,_,_),true),
            control_size(down,M,Class);

%-----< scroll control >--------------------------------------------------

    control_scroll(Min,_,_,_,_,down,_,_) :-
            Min =< 0,!,
            :message_window(#metis_window,"can't move it !!");
    control_scroll(Min,Max,Interval,Scroll,Axis,Smode,Vmode,Class) :- !,
            get_Sinterval(Min,Max,Scroll,Sratio,Sinterval),
            view_mode_case(Vmode,Smode,Min,Max,Interval,Sratio,Sinterval,NewMin,NewMax,NewInterval),
            monitor_graph_option_set({Axis,(NewMin,NewMax,NewInterval,Scroll)}),
            monitor_graph_set(repeat,Class);

    control_size(up,M,Class) :-
            M >= 80,!,
            monitor_graph_option_set(margin(M-10)),
            monitor_graph_set(repeat,Class);
    control_size(down,M,Class) :-
            M =< 140 ,!,
            monitor_graph_option_set(margin(M+10)),
            monitor_graph_set(repeat,Class);
    control_size(_,_,_) :- !,
            :message_window(#metis_window,"can't move it !!");

end.