%*****************************************************************************
%
%       Metis DEVICE Utility
%               Multi - PSI version
%
%               created by      : ???
%               version         : 1.0
%               revision        : 0.0
%               date created    : 8-30-91
%               date changed    : 92-Jan-17
%               comments        :
%               : ???  "can_file_open_add_ext_lis([46|_],_,_) :- !,fail;"
%               : changed "clock"
%*****************************************************************************

%:- op(1000,fx,(@));
remove_operator((@),fx).
add_operator((@),fx,1000).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       metis device macro                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

macro_bank metis_device_macro has

    nature
        metis_buildin_methods,
        metis_db_methods,
        metis_main_methods,
        metis_utility_methods,
        metis_command_methods,
        metis_common_methods;
end.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       metis_device                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

class metis_device with_macro metis_device_macro has

    component
        ( watch := X :- :create(#stop_watch,X),:start(X) );

:metis_terminal_type_data(Class,A,B,C,D,E):- !,terminal_type_data(A,B,C,D,E);
:metis_terminal_level_data(Class,A,B):- !,terminal_level_data(A,B);
:metis_read(Class,Prompt,Inp):- !,read(Prompt,Inp);
:metis_read_file(Class,A,Ext,Out):- !,read_file(A,Ext,Out);
:metis_lininp(Class,Prompt,Buff):- !,lininp(Prompt,Buff);
:metis_lininp(Class,Prompt,Buff,Trm):- !,lininp(Prompt,Buff,Trm);
:metis_lininpTop(Class,Prompt,Top):- !,lininpTop(Prompt,Top);
:metis_lininpCase(Class,Prompt,Cases,Num):- !,lininpCase(Prompt,Cases,Num);
:metis_set_prompt(Class,Atom):- !,set_prompt(Atom);
:metis_printf(Class,Item):- !,printf(Item);
:metis_printf_nomore(Class):- !,printf_nomore;
:metis_set_terminal_type(Class,A):- !,set_terminal_type(A);
:metis_get_terminal_type(Class,Type):- !,get_terminal_type(Type);
:metis_get_terminal_level(Class,Level):- !,get_terminal_level(Level);
:metis_get_terminal_length(Class,Size):- !,get_terminal_length(Size);
:metis_get_terminal_range(Class,Top,Bottom):- !,get_terminal_range(Top,Bottom);
:metis_get_control_sequence(Class,Type,Level,Ctrl,Char):- !,get_control_sequence(Type,Level,Ctrl,Char);
:metis_can_file_open(Class,Read,File):- !,can_file_open(Read,File);
:metis_can_file_open(Class,Flg,A,Key,Ext,File):- !,can_file_open(Flg,A,Key,Ext,File);
:metis_file_open(Class,Read,Key,File):- !,file_open(Read,Key,File);
:metis_file_close(Class,Read):- !,file_close(Read);
:metis_is_end_of_file(Class,End):- !,is_end_of_file(End);
:metis_is_end_of_file(Class,A,B,C,D):- !,is_end_of_file(A,B,C,D);
:metis_create_tmpfile(Class,Name,File):- !,create_tmpfile(Name,File);
:metis_rename_tmpfile(Class,Name,NewFile):- !,rename_tmpfile(Name,NewFile);
:metis_delete_tmpfile(Class,Name):- !,delete_tmpfile(Name);
:metis_clock(Class,T):- !,clock(Class!watch,T);

%------< for mpsi >------------------------------------------------

:metis_read_all(_,Prompt,Ext,Out) :- !,         %%call metis_mpsi
        read_all(Prompt,Ext,Out);

local

%/*------------------------------------------------------*/
%/*      terminal type                                   */
%/*------------------------------------------------------*/

%-------< Terminal Type >---------------------------------------------

%:- public terminal_type_data/5;
%:- mode terminal_type_data(?,?,?,?,?);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% terminal_type_data( Terminal_Name, Level, Screen_Length, Top, Bottom ).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
terminal_type_data(cit600,full,39,3,41) :- !;
terminal_type_data(vt100,full,22,3,24) :- !;
terminal_type_data(psi,full,HH,1,HH) :- !,
        :get_size(#metis_window!process,_,HH);

%:- public terminal_level_data/2;
%:- mode terminal_level_data(?,?);
terminal_level_data(full,s(s(0)));      % outputs all control sequences
terminal_level_data(muf,s(0));          % only for MUF system
terminal_level_data(basic,0);           % outputs no control sequences

%/*------------------------------------------------------*/
%/*      terminal control sequences                      */
%/*                      for CIT600                      */
%/*                      for VT100                       */
%/*------------------------------------------------------*/
%:- mode control_sequence(+,+,+,-);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% control_sequence( Terminal_Type, Command, Termnal_Level, Control ).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
control_sequence(cit600,Level,Command,Control) :-
        control_for_cit600(Command,Level,Control);
control_sequence(vt100,Level,Command,Control) :-
        control_for_vt100(Command,Level,Control);
control_sequence(psi,Level,Command,Control) :-
        control_for_psi(Command,Level,Control);
control_sequence(_,Level,Command,Control) :-  !,
        control_for_any(Command,Level,Control);

%% for kl1_metis & PSI
control_sequence(Command,Control) :-  !,
        control_for_psi(Command,_,Control);

%-------< CIT600 >----------------------------------------------------

%:- mode control_for_cit600(+,+,-);
%%% video attribute
control_for_cit600(normal,s(s(_)),'[0m(B') :- !;
control_for_cit600(bold,s(s(_)),'[1m') :- !;
control_for_cit600(underline,s(s(_)),'[4m') :- !;
control_for_cit600(blink,s(s(_)),'[5m') :- !;
control_for_cit600(secret,s(s(_)),'[6m') :- !;
control_for_cit600(reverse,s(s(_)),'[7m') :- !;
control_for_cit600(graphic,s(s(_)),'(0') :- !;
control_for_cit600(ascii,s(s(_)),'(B') :- !;
control_for_cit600(big(X),s(s(_)),['#3',X,{nl},'#4',X]) :- !;
control_for_cit600(bell,_,'') :- '{FLG}bell',!;
control_for_cit600(bell,s(s(_)),'[?5h[?5l[?5h[?5l[?5h[?5l') :- !;
control_for_cit600(tab,_,'      ') :- !;
%%% erase control
control_for_cit600(clear_screen,s(s(_)),'[2J') :- !;
control_for_cit600(clear_screenA,s(s(_)),'[1J') :- !;
control_for_cit600(clear_screenE,s(s(_)),'[0J') :- !;
control_for_cit600(clear_line,s(s(_)),'[2K') :- !;
control_for_cit600(clear_lineA,s(s(_)),'[1K') :- !;
control_for_cit600(clear_lineE,s(s(_)),'[0K') :- !;
%%% cursor position
control_for_cit600(position_nl,s(_),{nl}) :- !;
control_for_cit600(position_up,s(_),'[A') :- !;
control_for_cit600(position_down,s(_),'[B') :- !;
control_for_cit600(position_right,s(_),'[C') :- !;
control_for_cit600(position_left,s(_),'[D') :- !;
control_for_cit600(position(L,C),s(s(_)),['[',L,(';'),C,'H']) :- !;
%%% cursor attribute
control_for_cit600(cursor_visible,s(s(_)),'[0v') :- !;
control_for_cit600(cursor_invisible,s(s(_)),'[1v') :- !;
control_for_cit600(cursor_underline,s(s(_)),'[2v') :- !;
control_for_cit600(cursor_block,s(s(_)),'[3v') :- !;
%%% scroll range
control_for_cit600(scroll(T,B),s(s(_)),['[',T,(';'),B,'r']) :- !;

%-------< VT100 >-----------------------------------------------------

%:- mode control_for_vt100(+,+,-);
%%% video attribute
control_for_vt100(normal,s(s(_)),'[0m(B') :- !;
control_for_vt100(bold,s(s(_)),'[1m')  :- !;
control_for_vt100(underline,s(s(_)),'[4m') :- !;
control_for_vt100(blink,s(s(_)),'[5m') :- !;
control_for_vt100(reverse,s(s(_)),'[7m') :- !;
control_for_vt100(graphic,s(s(_)),'(0') :- !;
control_for_vt100(ascii,s(s(_)),'(B') :- !;
control_for_vt100(big(X),s(s(_)),['#3',X,{nl},'#4',X]) :- !;
control_for_vt100(bell,_,'') :- '{FLG}bell',!;
control_for_vt100(bell,s(s(_)),'[?5h[?5l[?5h[?5l[?5h[?5l') :- !;
control_for_vt100(tab,_,'       ') :- !;
%%% erase control
control_for_vt100(clear_screen,s(s(_)),'[2J') :- !;
control_for_vt100(clear_screenA,s(s(_)),'[1J') :- !;
control_for_vt100(clear_screenE,s(s(_)),'[0J') :- !;
control_for_vt100(clear_line,s(s(_)),'[2K') :- !;
control_for_vt100(clear_lineA,s(s(_)),'[1K') :- !;
control_for_vt100(clear_lineE,s(s(_)),'[0K') :- !;
%%% cursor position
control_for_vt100(position_nl,s(_),{nl}) :- !;
control_for_vt100(position_up,s(_),'[A') :- !;
control_for_vt100(position_down,s(_),'[B') :- !;
control_for_vt100(position_right,s(_),'[C') :- !;
control_for_vt100(position_left,s(_),'[D') :- !;
control_for_vt100(position(L,C),s(s(_)),['[',L,(';'),C,'H']) :- !;
%%% scroll range
control_for_vt100(scroll(T,B),s(s(_)),['[',T,(';'),B,'r']) :- !;

%-------< PSI >----------------------------------------------------

%:- mode control_for_psi(+,+,-);
%%% video attribute
control_for_psi(normal,s(s(_)),'$normal') :- !;
control_for_psi(bold,s(s(_)),'$bold') :- !;
control_for_psi(underline,s(s(_)),'$underline') :- !;
control_for_psi(blink,s(s(_)),'$blink') :- !;
control_for_psi(secret,s(s(_)),'$secret') :- !;
control_for_psi(reverse,s(s(_)),'$reverse') :- !;
control_for_psi(dotted,s(s(_)),'$dotted') :- !;
control_for_psi(graphic,s(s(_)),'$graphic') :- !;
control_for_psi(ascii,s(s(_)),'$ascii') :- !;
control_for_psi(big(X),s(s(_)),'$big'(X)) :- !;
control_for_psi(bell,_,'$beep') :- '{FLG}bell',!;
control_for_psi(bell,s(s(_)),'$background_bell') :- !;
control_for_psi(tab,_,'$tab') :- !;
%%% erase control
control_for_psi(clear_screen,s(s(_)),'$clear_screen') :- !;
control_for_psi(clear_screenA,s(s(_)),'$clear_screenA') :- !;
control_for_psi(clear_screenE,s(s(S)),'$clear_screenE') :- !;
control_for_psi(clear_line,s(s(_)),'$clear_line') :- !;
%%control_for_psi(clear_lineA,s(s(_)),'$clear_lineA') :- !;
control_for_psi(clear_lineE,s(s(_)),'$clear_lineE') :- !;
%%% cursor position
control_for_psi(position_nl,s(_),'$position_nl') :- !;
control_for_psi(position_up,s(_),'$position_up') :- !;
control_for_psi(position_down,s(_),'$position_down') :- !;
control_for_psi(position_right,s(_),'$position_right') :- !;
control_for_psi(position_left,s(_),'$position_left') :- !;
control_for_psi(position_lineA,s(_),'$position_lineA') :- !;
control_for_psi(position(L,C),s(s(_)),'$position'(L,C)) :- !;
%control_for_psi(current_position(L,C),_,'$current_position'(L,C)) :- !;
%%% cursor attribute
control_for_psi(cursor_visible,s(s(_)),'$cursor_visible') :- !;
control_for_psi(cursor_invisible,s(s(_)),'$cursor_invisible') :- !;
control_for_psi(cursor_underline,s(s(_)),'$cursor_underline') :- !;
control_for_psi(cursor_block,s(s(_)),'$cursor_block') :- !;
%%% scroll range
control_for_psi(scroll_move(T,B,O),s(s(_)),'$scroll_move'(T,B,O)) :- !;
control_for_psi(scroll(T,B),s(s(_)),'$scroll'(T,B)) :- !;
%%% other controls
control_for_psi(ttyflush,_,'$ttyflush') :- !;
control_for_psi(_,_,'') :- !;

%-------< for any terminal, any level >-------------------------------

%:- mode control_for_any(+,+,-);
control_for_any(normal,_,']') :- !;
control_for_any(bold,_,'[') :- !;
control_for_any(underline,_,'[') :- !;
control_for_any(blink,_,'[') :- !;
control_for_any(reverse,_,'[') :- !;
control_for_any(graphic,_,'[') :- !;
control_for_any(ascii,_,'[') :- !;
control_for_any(big(X),_,['[',X,']']) :- !;
control_for_any(_,_,'') :- !;

%/*------------------------------------------------------*/
%/*      lininp delimiters                               */
%/*------------------------------------------------------*/
%:- mode is_line_delimiter(+,-);
is_line_delimiter(V,_) :-
        var(V),!,
        fail;
%%is_line_delimiter(26,'^Z');
is_line_delimiter(32,' ');
is_line_delimiter(37,'%');
is_line_delimiter(43,+);
is_line_delimiter(44,(','));
is_line_delimiter(45,-);
%%is_line_delimiter(46,'.');
is_line_delimiter(47,/);
is_line_delimiter(59,(';'));
is_line_delimiter(60,<);
is_line_delimiter(61,=);
is_line_delimiter(62,>);
is_line_delimiter(63,?);
is_line_delimiter(92,\);
%%is_line_delimiter(95,'_');

%:- mode is_special_character(+);
is_special_character(SP) :-
        SP =< 31,!;

%/*------------------------------------------------------*/
%/*      input term from terminal                        */
%/*------------------------------------------------------*/

%-------< read with set_proompt & monitor >---------------------------

%:- public read/2;
%:- mode read(?,?);
read(Prompt,Inp) :- !,
        read_case(Prompt),!,
        repeat,
        read(Inp),
        read_monitor(Inp),!;

read_case(Prompt) :-
        atomic(Prompt),!,
        prompt(Prompt);
read_case(Prompt) :-
        is_list(Prompt),!,
        set_prompt(Prompt);
read_case(Prompt) :- !,
        prompt('>>>> ');

%:- mode read_monitor(?);
read_monitor(Data)  :- !,
        seeing(IN),
        telling(OUT),!,
        read_monitor(IN,OUT,Data);

%:- mode read_monitor(+,+,?);
read_monitor(user,OUT,Data)  :-
        '{FLG}comlog',
        create_tmpfile(logfile,Tmp),
        tell(Tmp),!,
        printf([{quote(Data)},' .',{nl}]),
        tell(OUT);
read_monitor(user,_,_)  :- !;
read_monitor(_,user,Data) :-
        '{SYS}ttycopy',!,
        printf([Data,'.',{nl}]);
read_monitor(_,_,_) :- !;

%-------< read from file >--------------------------------------------

%:- public read_file/3;
%:- mode read_file(?,+,?);
read_file(@@,Ext,Out) :- !,
        read_file(@(''),Ext,Out);
read_file(@(Name),Ext,Out) :-
        can_file_open(read,Name,io,Ext,File),!,
        seeing(Save),
        repeat,
        see(File),
        read(One),
        ( One==end_of_file,!,
          printf([{bell},'[EOF]',{nl}]),
          see(File),
          seen,
          see(Save),
          !,fail
%%        ; printf([{quote(One)},'. ? ',{ttyflush}]),
        ; printf([One,'. ',{ttyflush}]),
          see(user),
%%          lininpCase(?,[prolog_string(";")],Num),
          lininpCase(?,[(;)],Num),
          Num\==1,
          Out=One
        ),
        see(File),
        seen,
        see(Save),!;
read_file(@(_),_,_) :- !,
        printf([{bell},'...can''t see file.',{nl}]),!,
        fail;
read_file(Inp,_,Inp) :- !;

%--------------------------------------------------%
%       read all / for mpsi                        %
%--------------------------------------------------%

read_all(Prompt,Ext,Out) :- !,
        repeat,
        read(Prompt,Inp),
        read_file_all(Inp,Ext,List),
        read_all_case(List,Out);

read_all_case(repeat,_) :- !,
        fail;
read_all_case(End,exit) :-
        is_end_of_file(End),!;
read_all_case(L,L) :- !;

%-------< read from file list >--------------------------------------------

read_file_all(@@,Ext,Out) :- !,
        read_file_all(@(''),Ext,Out);
read_file_all(@(Name),Ext,Out) :-
        can_file_open(read,Name,io,Ext,File),!,
        seeing(Save),
        repeat,
        see(File),
        read(One),
        read_file_all_case(One,Out),
        see(File),
        seen,
        see(Save),!;
read_file_all(@(_),_,abnormal) :- !,
        printf([{bell},'...can''t see file.',{nl}]),!;
read_file_all(Inp,_,Inp) :- !;

read_file_all_case(end_of_file,Out) :- !,
        printf(['[EOF]',{nl},{bell}]),
        read_file_all_retract(Out);
read_file_all_case(One,One) :- !,        
        printf([One,'. ',{ttyflush}]),
        see(user),
        lininpCase(?,[(;)],Num),
        Num\==1,
        read_file_all_assert(One),!,
        fail ;

read_file_all_assert(One) :-
        retract('{WRK}read'(L)),!,
        app_list(L,[One],NewL),
        assert('{WRK}read'(NewL));
read_file_all_assert(One) :- !,
        assert('{WRK}read'([One]));

read_file_all_retract(Out) :-
        retract('{WRK}read'(Out)),!;
read_file_all_retract(repeat) :- !;



%/*------------------------------------------------------*/ 
%/*      input characters from terminal                  */
%/*------------------------------------------------------*/
%:- public lininp/1;
%%:- mode lininp(?);
%%lininp(Buff) :- !,
%%      lininp('-> ',Buff,_),!;

%:- public lininp/2;
%:- mode lininp(+,?);
lininp(Prompt,Buff) :- !,
        lininp(Prompt,Buff,_);

%:- public lininp/3;
%:- mode lininp(+,?,-);
lininp(Prompt,Buff,Trm) :-
        nonvar(Buff),!,
        lininp(Prompt,Inp,Trm),!,
        Buff=Inp;
lininp(Prompt,Buff,Trm) :- !,
        set_prompt(Prompt,P),
        dname(P,Ph,Pt),
        myget0(Chr),!,
        lininp_do(Chr,Ph,Pt,Buff,Trm);

%:- mode lininp_do(+,?,?,-,-);
lininp_do(Chr,Ph,Pt,Buff,Trm) :-
        lininp_list(Chr,normal,W,W,B,B,Ph,Pt,Buff,Trm),!;
lininp_do(_,_,_,['^L'],abnormal) :- !;

%-------< lininp loop >-----------------------------------------------

%:- mode lininp_list(+,+,?,?,?,?,?,?,-,-);
lininp_list(7,_,_,_,_,_,_,_,['^G'],abnormal) :- !;     %/* ^G */
lininp_list(12,_,_,_,_,_,_,_,_,_) :- !,                %/* ^L */
        fail;
lininp_list(37,normal,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm) :- !, %/* '%' */
        myget0(C1),!,
        lininp_list(C1,comment,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm);
lininp_list(C,_,Wh,[],Bh,Bm1,_,_,Bh,Trm) :-
        lininp_terminate(C,Bm2,[],Trm),!,
        lininp_word_buff(Wh,Bm1,Bm2);
lininp_list(_,comment,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm) :- !,
        myget0(C1),!,
        lininp_list(C1,comment,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm);
lininp_list(C,normal,Wh,[],Bh,Bm1,Ph,[C|Pt],Buff,Trm) :-
        lininp_delimiter(C,Bm2,Bt),!,
        lininp_word_buff(Wh,Bm1,Bm2),
        myget0(C1),!,
        lininp_list(C1,normal,W,W,Bh,Bt,Ph,Pt,Buff,Trm);
lininp_list(C,Mode,Wh,Wm,Bh,Bt,Ph,[C|Pt],Buff,Trm) :-
        Wh\==Wm,!,
        lininp_code(C,Mode,NewMode,Wm,Wt),
        myget0(C1),!,
        lininp_list(C1,NewMode,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm);
lininp_list(C,Mode,Wh,Wh,Bh,Bt,Ph,[C|Pt],Buff,Trm) :-
        lininp_code(C,Mode,NewMode,Wh,Wt),
        myget0(C1),
        lininp_list(C1,NewMode,Wh,Wt,Bh,Bt,Ph,Pt,Buff,Trm),!;
lininp_list(_,Mode,W,W,Bh,Bt,Ph,Pt,Buff,Trm) :-
%        printf([{cursor_invisible},{position_left},{position_left},
%                '  ',{position_up},{nl}]),
        printf([{position_down},{cursor_invisible},{position_left},{position_left},
               '  ',{nl}]),
        dname(Prompt,Ph,Pt),
        set_prompt(Prompt),
        myget0(C1),!,
        lininp_list(C1,Mode,W,W,Bh,Bt,Ph,Pt,Buff,Trm);

%-------< lininp terminate >------------------------------------------

%:- mode lininp_terminate(+,?,?,-);
lininp_terminate(26,[end_of_file|B],B,abnormal) :- !,   %/* ^Z */
        ( not_seeing(user) ; nl ),!;
lininp_terminate(26,[end_of_file|B],B,abnormal) :- !,nl;   %/* ^Z */
lininp_terminate(27,['$ESC'|B],B,abnormal) :- !,        %/* <ESC> */
        printf([{cursor_invisible},{position_left},' ',{position_left},
                {cursor_visible},{ttyflush}]);
lininp_terminate(31,B,B,normal) :- !;                   %/* <cr> */

%-------< lininp one word >-------------------------------------------

%:- mode lininp_delimiter(+,?,?);
lininp_delimiter(32,B,B) :- !;                  %/* ' ' */
lininp_delimiter(C,[A|B],B) :-                  %/* delimiter */
        is_line_delimiter(C,A),!;
lininp_delimiter(C,['$SPECIAL'(C)|B],B) :-      %/* special */
        is_special_character(C),!;

%:- mode lininp_word_buff(+,?,?);
lininp_word_buff([],B,B) :- !;
lininp_word_buff(W,[Word|Brem],Brem) :- !,
        name(Word,W);

%-------< lininp one character >--------------------------------------

%:- mode lininp_code(+,+,?,?,?,?,-);
lininp_code(39,normal,quote,W,W) :- !;                  %/* ' in normal mode */
lininp_code(39,quote,quoteINquote,W,W) :- !;            %/* '...' */
lininp_code(39,quoteINquote,quote,[39|W],W) :- !;       %/* '...'' */
lininp_code(C,quoteINquote,normal,[C|W],W) :- !;        %/* ANY after '...' */
lininp_code(C,Mode,Mode,[C|W],W) :- !;                  %/* normal character */

%/*------------------------------------------------------*/
%/*      lininp case                                     */
%/*------------------------------------------------------*/
%:- public lininpTop/2;
%:- mode lininpTop(+,-);
lininpTop(Prompt,Top) :-
        lininp(Prompt,[Top|_]),!;
lininpTop(_,'$NULL') :- !;

%/*------------------------------------------------------*/
%/*      lininp case                                     */
%/*------------------------------------------------------*/
%:- public lininpCase/3;
%:- mode lininpCase(+,+,-);
lininpCase(Prompt,Cases,Num) :-
        lininp(Prompt,[Ans|_]),!,
        lininpCase(Cases,Ans,1,Num);
lininpCase(_,_,0) :- !;
        
%:- mode lininpCase(+,+,+,-);
lininpCase([],_,_,0) :- !;
lininpCase([Case|_],Ans,Num,Num) :-
        front_ulmatch(Ans,Case),!;
lininpCase([_|Cases],Ans,Nin,Nout) :- !,
        Nmed is Nin+1,!,
        lininpCase(Cases,Ans,Nmed,Nout);

%/*------------------------------------------------------*/
%/*      get0 with monitor                               */
%/*------------------------------------------------------*/
%:- mode myget0(-);
myget0(C) :-
        get0(C),!,
        seeing(IN),
        telling(OUT),!,
        myget0_monitor(IN,OUT,C);
myget0(26) :- !,nl;

%:- mode myget0_monitor(+,+,+);
myget0_monitor(user,OUT,C) :-
        '{FLG}comlog',
        create_tmpfile(logfile,Tmp),
        tell(Tmp),!,
        myput(C),!,
        tell(OUT);
myget0_monitor(user,_,_) :- !;
myget0_monitor(_,user,C) :-
        '{SYS}ttycopy',!,
        myput(C);
myget0_monitor(_,_,_) :- !;

%:- mode myput(+);
myput(26) :- nl;
%%myput(C) :- C>=31,!,put(C);
%%myput(_) :- !;
myput(C) :- !,put(C);

%/*------------------------------------------------------*/
%/*      set prompt                                      */
%/*------------------------------------------------------*/

%-------< set prompt >------------------------------------------------

%%:- public set_prompt/1;
%:- mode set_prompt(+);
set_prompt(Atom) :- !,
        set_prompt(Atom,_);

%:- mode set_prompt(+,-);
set_prompt(Atom,Pout) :-
        atomic(Atom),!,
        set_prompt_list([Atom],Prompt,Ph,[]),
        prompt(Prompt),
        name(Pout,Ph);
set_prompt(Plist,Pout) :-
        is_list(Plist),!,
        set_prompt_list(Plist,Prompt,Ph,[]),
        prompt(Prompt),
        name(Pout,Ph);
set_prompt(_,'??????') :- !,
        prompt('??????');

%:- mode set_prompt_list(+,-,?,?);
set_prompt_list([],[Chr1,Chr2],X,X) :- !,
%%        get_control_sequence(Type,Level,clear_lineE,Chr1),
%%        get_control_sequence(Type,Level,cursor_visible,Chr2);
        control_sequence(clear_lineE,Chr1),
        control_sequence(cursor_visible,Chr2);
set_prompt_list([{Control}|Rem],[Char|Prem],Xh,Xt) :- !,
%%        get_control_sequence(_,_,Control,Char),!,
        control_sequence(Control,Char),!,
        set_prompt_list(Rem,Prem,Xh,Xt);
set_prompt_list([One|Rem],[One|Prem],Xh,Xt) :- !,
        dname(One,Xh,Xm),!,
        set_prompt_list(Rem,Prem,Xm,Xt);

%-------< prompt with monitor >---------------------------------------

%:- mode prompt(+);
prompt(P) :- !,
        prompt(_,P),
        seeing(In),!,
        prompt_monitor(In,P);

%:- mode prompt_monitor(+,+);
prompt_monitor(user,_) :- !;
prompt_monitor(_,P) :-
        '{SYS}ttycopy',!,
%        printf([P,{ttyflush}]);
        printf(P);
prompt_monitor(_,_) :- !;

%/*------------------------------------------------------*/
%/*      printf                                          */
%/*------------------------------------------------------*/
%:- public printf/1;
%:- mode printf(?);
printf(Item) :-
        printf_sub(Item),
        fail;
printf(_) :- !;

%:- mode printf_sub(?);
printf_sub(Item) :- !,
        printf_get_status(Item,More),!,
        printf_sub_end(More);

%:- mode printf_get_status(+,-);
printf_get_status(Item,More) :-
        '{SYS}print'(Mstat),!,
        printf_case(Mstat,Item,More);
printf_get_status(Item,More) :- !,
        printf_list(Item,[],_,normal,More,[],_);

%:- mode printf_case(+,+,-);
printf_case('MORE_listing'(Title,Size),Item,More) :- !,
        counter(refer,printf_more_count,Line),
        printf_list(Item,[],_,more(Line,Title,Size),More,[],_);
printf_case('MORE_no_listing',Item,More) :- !,
        printf_list(Item,[],_,no_more,More,[],_);

%:- mode printf_sub_end(+);
printf_sub_end(normal) :- !;
printf_sub_end(no_more) :- !;
printf_sub_end(more(Line,_,_)) :- !,
        counter(set,printf_more_count,Line);

%:- mode printf_list(+,+,-,+,-,+,-);
printf_list([],V,V,M,M,S,S) :- !;
printf_list([One|Rem],Vin,Vout,Min,Mout,Sin,Sout) :- !,
        printf_list_one(Min,One,Vin,Vmed,Mmed,Sin,Smed),!,
        printf_list(Rem,Vmed,Vout,Mmed,Mout,Smed,Sout);
printf_list(One,Vin,Vout,Min,Mout,Sin,Sout) :- !,
        printf_list_one(Min,One,Vin,Vout,Mout,Sin,Sout);

%:- mode printf_list_one(+,+,+,-,+,+,-);
printf_list_one(no_more,{more_end},Vin,Vout,Mout,Sin,Sout) :- !,
        port({more_end},Vin,Vout,no_more,Mout,Sin,Sout);
printf_list_one(no_more,_,V,V,no_more,S,S) :- !;
printf_list_one(Min,One,Vin,Vout,Mout,Sin,Sout) :- !,
        port(One,Vin,Vout,Min,Mout,Sin,Sout);

%-------< port >------------------------------------------------------

%:- mode port(+,+,-,+,-,+,-,+,-);
port('',V,V,M,M,S,S);
port({Control},Vin,Vout,Min,Mout,Sin,Sout) :- !,
        port_control(Control,Vin,Vout,Min,Mout,Sin,Sout);
port(Term,Vin,Vout,M,M,S,S) :- !,
        write(Term,Vin,Vout);

%:- mode port_control(+,+,-,+,-,+,-);
port_control(Command,Vin,Vout,Min,Mout,Sin,Sout) :-
        new_port(Command,NewCommand),!,
        printf_list(NewCommand,Vin,Vout,Min,Mout,Sin,Sout);
port_control(monitor(equations,X),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        W_ = #metis_buildin!tell,
        #metis_buildin!tell := #metis_window!equations,
        printf_list(X,Vin,Vout,Min,Mout,Sin,Sout),
        #metis_buildin!tell := W_ ;
port_control(monitor(rules,X),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        W_ = #metis_buildin!tell,
        #metis_buildin!tell := #metis_window!rules,
        printf_list(X,Vin,Vout,Min,Mout,Sin,Sout),
        #metis_buildin!tell := W_ ;
port_control(repeat(N,Obj),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        port_loop(N,Obj,Vin,Vout,Min,Mout,Sin,Sout);
port_control(nl,V,V,more(L,Title,Size),Mout,Sin,Sout) :- !,
        nl,
        printf_morecheck(Title,L,Size,Mout,Sin,Sout);
port_control(nl,V,V,M,M,S,S) :- !,
        nl;
port_control(nl(N),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        port_loop(N,{nl},Vin,Vout,Min,Mout,Sin,Sout);
port_control(tab(N),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        port_loop(N,{tab},Vin,Vout,Min,Mout,Sin,Sout);
port_control(space,V,V,M,M,S,S) :- !,
        tab(1);
port_control(space(C),V,V,M,M,S,S) :- !,
        tab(C);
port_control(locate(P,L,Obj),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        printf_locate(P,L,Obj,Vin,Vout,Min,Mout,Sin,Sout);
port_control(time(T),V,V,M,M,S,S) :- !,
        write_time(T);
port_control(line,V,V,M,M,S,S) :- !,
        write(
-------------------------------------------------------
        );
port_control(log,V,V,M,M,S,S) :- !,
        ('{FLG}log',!,log;true),!;
port_control(nolog,V,V,M,M,S,S) :- !,
        nolog;
port_control(more_begin(Title),Vin,Vout,Min,Mout,Sin,Sout) :- !,
        get_terminal_length(Size),!,
        port_control(more_begin(Title,Size),Vin,Vout,Min,Mout,Sin,Sout);
port_control(more_begin(Title,S0),V,V,_,more(0,Title,Size),S,S) :- !,
        Size is S0-1,
        abolish('{SYS}print',1),!,
        asserta('{SYS}print'('MORE_listing'(Title,Size)));
port_control(more_end,V,V,_,normal,S,S) :- !,
        printf_more_end;
port_control(k(Kterm),Vin,Vout,M,M,Sin,Sout) :- !,
        :real_var(#metis_mpsi,Kterm,Term,Sin,Sout),
        write(Term,Vin,Vout);
port_control(sexpression(Sterm),Vin,Vout,M,M,S,S) :- !,
        from_Sexpression_and_successor(Sterm,Term),!,
        write(Term,Vin,Vout);
port_control(string(Lis),V,V,Min,Mout,S,S) :- !,
        putl(Lis,Min,Mout);
port_control(quote(Term),Vin,Vout,M,M,S,S) :- !,
        writeq(Term,Vin,Vout);
port_control(Control,Vin,Vout,Min,Mout,Sin,Sout) :-  !,
        control_sequence(Control,Char),!,
        printf_list(Char,Vin,Vout,Min,Mout,Sin,Sout);

%:- mode port_loop(+,+,+,-,+,-,+,-);
port_loop(0,_,V,V,M,M,S,S) :- !;
port_loop(N,Obj,Vin,Vout,Min,Mout,Sin,Sout) :- !,
        printf_list(Obj,Vin,Vmed,Min,Mmed,Sin,Smed),
        N1 is N-1,!,
        port_loop(N1,Obj,Vmed,Vout,Mmed,Mout,Smed,Sout);

%-------< More >------------------------------------------------------

printf_more_end :- !,
        abolish('{SYS}print',1);

%:- mode printf_morecheck(+,+,+,-,+,-);
printf_morecheck(Title,Line,Size,Out,Sin,Sout) :-
        CurrentL is Line+1,
        printf_morecheck_case(Title,CurrentL,Size,Out,Sin,Sout),!;

%:- mode printf_morecheck_case(+,+,+,-,+,-);
printf_morecheck_case(Title,CurrentL,Size,Out,Sin,Sout) :-
        CurrentL >= Size,!,
        seeing(Cin),
        ( Cin==user ; see(user) ),
        printf_morecheck_inq(Title,Size,Out),
        ( Cin==user ; see(Cin) ),!,
        printf_list([{position_up},{clear_line},{position_up},
                     {position_nl}],[],_,normal,_,Sin,Sout);
printf_morecheck_case(Title,L,Size,more(L,Title,Size),S,S) :- !;

%:- mode printf_morecheck_inq(+,+,-);
printf_morecheck_inq(Title,_,no_more) :-
        lininpCase([{reverse},
                ' --- More ( ',Title,' ) ---    (*y/n) ? ',
                {normal}],[prolog_string("no")],Num),
        Num==1,!,
        abolish('{SYS}print',1),!,
        asserta('{SYS}print'('MORE_no_listing'));
printf_morecheck_inq(Title,Size,more(0,Title,Size)) :- !;

%:- public printf_nomore/0;
printf_nomore :- !,
        '{SYS}print'('MORE_no_listing');

%-------< locate >----------------------------------------------------

printf_locate(P,L,Obj,Vin,Vout,Min,Mout,Sin,Sout) :- !,
        printf_length(Obj,L,SP),
        printf_locate_acc(P,SP,SP1,SP2),
        tab(SP1),
        printf_list(Obj,Vin,Vout,Min,Mout,Sin,Sout),
        tab(SP2);

printf_locate_acc(center,SP,SP1,SP2) :- !,
        SP1 is SP/2,
        SP2 is SP-SP1;
printf_locate_acc(left,SP,0,SP) :- !;
printf_locate_acc(right,SP,SP,0) :- !;

%-------< atomic length >---------------------------------------------

printf_length(Atom,L,SP) :- !,
        printf_length_get(Atom,Alength),
        ( Alength>=L,
          SP=0
        ; SP is L-Alength
        ),!;

printf_length_get([H|T],Alength) :- !,
        printf_length_get_l([H|T],0,Alength);
printf_length_get(Atom,Alength) :- !,
        atomic_length(Atom,Alength);

printf_length_get_l([],L,L) :- !;
printf_length_get_l([A|Arem],Lin,Lout) :- !,
        atomic_length(A,Ltmp),
        Lmed is Lin+Ltmp,!,
        printf_length_get_l(Arem,Lmed,Lout);

atomic_length(Atom,Length) :- !,
        name(Atom,Alis),
        length(Alis,Length);

%-------< put string >------------------------------------------------

putl([],M,M) :- !;
putl([C|Rem],Min,Mout) :- !,
        putone(C,Min,Mmed),!,
        putl(Rem,Mmed,Mout);

putone(31,Min,Mout) :- !,port({nl},[],_,Min,Mout,[],_);
putone(C,M,M) :- !,put(C);


%/*------------------------------------------------------*/
%/*      set terminal type                               */
%/*------------------------------------------------------*/
%:- public set_terminal_type/1;
%:- mode set_terminal_type(+);
set_terminal_type(init) :- !,
        printf([{scroll(1,24)},{scroll(1,42)}]),
        abolish('{SYS}ttytype',1),
        abolish('{SYS}ttylevel',1),!,
        abolish('{SYS}ttylength',1);
set_terminal_type(Type) :-
        terminal_type_data(Type,Level,Length,Top,Bottom),!,
        terminal_level_data(Level,Succ),
        abolish('{SYS}ttytype',1),
        asserta('{SYS}ttytype'(Type)),
        abolish('{SYS}ttylevel',1),
        asserta('{SYS}ttylevel'(Succ)),
        abolish('{SYS}ttylength',1),
        asserta('{SYS}ttylength'(Length)),!,
        printf({scroll(Top,Bottom)});
set_terminal_type(Type) :-
        terminal_level_data(Type,Succ),!,
        abolish('{SYS}ttylevel',1),!,
        asserta('{SYS}ttylevel'(Succ));


%/*------------------------------------------------------*/
%/*      get terminal type                               */
%/*------------------------------------------------------*/

%-------< get terminal type >-----------------------------------------

%:- public get_terminal_type/1;
%:- mode get_terminal_type(-);
get_terminal_type(Type) :-
        '{SYS}ttytype'(Type),!;
get_terminal_type(unknown) :- !;

%-------< get terminal level >----------------------------------------

%:- public get_terminal_level/1;
%:- mode get_terminal_level(-);
get_terminal_level(Level) :-
        '{SYS}ttylevel'(Level),!;
get_terminal_level(0) :- !;

%-------< get terminal length >---------------------------------------

%:- public get_terminal_length/1;
%:- mode get_terminal_length(-);
get_terminal_length(Size) :-
        '{SYS}ttylength'(Size),!;
get_terminal_length(20) :- !;

%-------< get terminal range >----------------------------------------

%:- public get_terminal_range/2;
%:- mode get_terminal_range(-,-);
get_terminal_range(Top,Bottom) :-
        '{SYS}ttytype'(Type),!,
        terminal_type_data(Type,_,_,Top,Bottom);
get_terminal_range(3,22) :- !;

%-------< get control character >-------------------------------------

%:- public get_control_sequence/4;
%:- mode get_control_sequence(+,?,?,-);
get_control_sequence(Type,Level,Ctrl,Char) :-
        ( nonvar(Type) ; get_terminal_type(Type) ),
        ( nonvar(Level) ; get_terminal_level(Level) ),!,
        control_sequence(Type,Level,Ctrl,Char);
get_control_sequence(_,_,_,'') :- !;

%/*------------------------------------------------------*/
%/*      file open                                       */
%/*------------------------------------------------------*/

%%-----< read file open >--------------------------------------------------
%
%read_file_open(Name,File) :- !,
%        can_file_open(read,Name,io,['trs','axm',''],File);

%-------< can file open >---------------------------------------------

%:- public can_file_open/2;
%:- mode can_file_open(+,+);
can_file_open(read,File) :- !,
        seeing(Current),
        nofileerrors,
        see(File),
        seen,!,
        see(Current);
can_file_open(write,File) :- !,
        telling(Current),
        nofileerrors,
        tell(File),
        told,!,
        tell(Current);

%-------< can file open with extention >------------------------------

%%:- public can_file_open/4;
%%:- mode can_file_open(+,+,+,-);
%%can_file_open(Flg,Name,Ext,File) :- !,
%%      can_file_open(Flg,Name,io,Ext,File) :- !;
%:- public can_file_open/5;
%:- mode can_file_open(+,+,+,+,-);
can_file_open(Flg,'',Key,Ext,File) :- !,
        ref(current_file(Key,Name)),!,
        can_file_open(Flg,Name,Key,Ext,File);
can_file_open(Flg,Name,_,Ext,File) :-
        can_file_open_add_ext_one(Name,dummy,_),!,
        can_file_open_add_ext(Name,Ext,File),
        can_file_open(Flg,File),!;
can_file_open(Flg,Name,_,_,Name) :- !,
        can_file_open(Flg,Name);

%:- mode can_file_open_add_ext(+,+,-);
can_file_open_add_ext(_,[],_) :- !,fail;
can_file_open_add_ext(Name,[Ext|_],File) :-
        can_file_open_add_ext_one(Name,Ext,File);
can_file_open_add_ext(Name,[_|Erem],File) :- !,
        can_file_open_add_ext(Name,Erem,File);
can_file_open_add_ext(Name,Ext,File) :- !,
        can_file_open_add_ext_one(Name,Ext,File);

%:- mode can_file_open_add_ext_one(+,+,-);
can_file_open_add_ext_one(Name,Ext,File) :- !,
        name(Name,Nlis),
        name(Ext,Elis),
        can_file_open_add_ext_lis(Nlis,Elis,Flis),!,
        name(File,Flis);

%:- mode can_file_open_add_ext_lis(+,+,-);
can_file_open_add_ext_lis([46|_],_,_) :- !,fail;
can_file_open_add_ext_lis([],Elis,[46|Elis]) :- !;
can_file_open_add_ext_lis([C|Nlis],Elis,[C|Flis]) :- !,
        can_file_open_add_ext_lis(Nlis,Elis,Flis);

%-------< file open >-------------------------------------------------

%%:- public file_open/2;
%%:- mode file_open(+,+);
%%file_open(read,File) :- !,
%%      file_open(read,io,File);

%:- public file_open/3;
%:- mode file_open(+,+,+);
file_open(read,Key,File) :- !,
        see(File),
        file_open_file_name(File,Name),!,
        set(current_file(Key,Name));
file_open(write,Key,File) :- !,
        tell(File),
        file_open_file_name(File,Name),!,
        set(current_file(Key,Name));

%:- mode file_open_file_name(+,-);
file_open_file_name(File,Name) :- !,
        name(File,Flis),
        file_open_file_name_l(Flis,Nlis),!,
        name(Name,Nlis);

%:- mode file_open_file_name_l(+,-);
file_open_file_name_l([46|_],[]) :- !;
file_open_file_name_l([],[]) :- !;
file_open_file_name_l([C|Flis],[C|Nlis]) :- !,
        file_open_file_name_l(Flis,Nlis);

%-------< file close >------------------------------------------------

%:- public file_close/1;
%:- mode file_close(+);
file_close(read) :- !,
        seen;
file_close(write) :- !,
        told;

%-------< is end_of_file >--------------------------------------------

%:- public is_end_of_file/1;
%:- mode is_end_of_file(?);
is_end_of_file(End) :- !,
        is_end_of_file(End,prolog_string("exit"),_,_);

%:- public is_end_of_file/4;
%:- mode is_end_of_file(?,+,-,-);
is_end_of_file(end_of_file,_,'EXIT','') :- 
        seeing(user),!,
        nl;
is_end_of_file(end_of_file,_,'EXIT','') :- !;
is_end_of_file(End,Msg,End,Rem) :- !,
        atomic(End),
        name(End,Elis),!,
        front_ulmatch(Elis,Msg,Rem);

%/*------------------------------------------------------*/
%/*      create / delete temporary file                  */
%/*------------------------------------------------------*/

%-------< create temp file >------------------------------------------

%:- public create_tmpfile/2;
%:- mode create_tmpfile(+,-);
create_tmpfile(Name,File) :-
        '{SYS}jobno'(Name,File),!;
create_tmpfile(Name,File) :- !,
        plsys(jobno(JNO)),
        name(Name,[N1,N2,N3|_]),
        create_tmpfile_jno([N1,N2,N3|Nt],Nt,JNO,File),
        can_file_open(write,File),!,
        asserta('{SYS}jobno'(Name,File));

%:- mode create_tmpfile_jno(+,-,+,-);
create_tmpfile_jno(Nh,Nt,JNO,File) :-
        dname(JNO,Nt,[46,116,109,112]), % make 'Name+JNO.tmp'
        name(File,Nh);
create_tmpfile_jno(Nh,Nt,JNO,File) :- !,
        JNO1 is JNO+1,
        JNO1 < 1000,!,
        create_tmpfile_jno(Nh,Nt,JNO1,File);

%-------< delete temp file >------------------------------------------

%:- public rename_tmpfile/2;
%:- mode rename_tmpfile(+,+);
rename_tmpfile(Name,NewFile) :-
        '{SYS}jobno'(Name,File),
        tell(File),
        told,
        rename(File,NewFile),!,
        retract_all('{SYS}jobno'(Name,File));
rename_tmpfile(_,_) :- !;

%:- public delete_tmpfile/1;
%:- mode delete_tmpfile(+);
delete_tmpfile(Name) :- !,
         rename_tmpfile(Name,_);

%/*------------------------------------------------------*/
%/*      clock                                           */
%/*------------------------------------------------------*/
%:- public clock/1;
%:- mode clock(?);
clock(W,time(Sec,Msec)) :-
        var(T),!,
        :stop(W),
        :show(W,Time),
        :reset(W),
        :get_count(Time,Tsec),
        Sec = Tsec / 1000,
        Msec = Tsec mod 1000,
        :start(W);
clock(W,_) :- !,
        :stop(W),
        :reset(W),
        :start(W);
%       statistics(runtime,_);

%/*------------------------------------------------------*/
%/*      write time                                      */
%/*------------------------------------------------------*/
%:- op(950,xfy,#);
%:- mode write_time(+);
write_time(time(Sec,Msec)) :- !,
        write(Sec),write('.'),write(Msec);
write_time(T) :- !,
        write(T);
%write_time(xwd(U,L)) :- !,
%        write_sep(U,U1,U2),
%        write_sep(L,L1,L2),!,
%        write_time9(U1#U2#L1#L2#[]);
%write_time(Time) :- !,
%        write_time9(Time#[]);
%
%%:- mode write_time9(+);
%write_time9(MSec) :- !,
%    write_divide_bignum(MSec,10,CSec,Mili3),
%    write_divide_bignum(CSec,10,DSec,Mili2),
%    write_divide_bignum(DSec,10,Sec,Mili1),
%    write_bignum(Sec), write(.), write(Mili1), write(Mili2),write(Mili3);
%
% write_non_suppress(0,0) :- !;
% write_non_suppress(0,Int) :- write({Int}), !;
% write_non_suppress(N,Int) :- N > 0,
%         Digit is (Int mod 10),
%         Int1 is (Int/10),
%         N1 is N-1, !,
%         write_non_suppress(N1,Int1), write(Digit);
%
%:- mode write_sep(+,-,-);
%write_sep(U,UU,UL) :-
%        U < 0,!,
%        UU is (U+131072)/512+256,
%        UL is (U+131072) mod 512;
%write_sep(U,UU,UL) :- !, % U >= 0,
%        UU is U/512,
%        UL is U mod 512;
%
%:- mode write_bignum(+);
%write_bignum(X) :- 
%        write_bignum9(X),
%        fail;
%write_bignum(_) :- !;
%
%:- mode write_bignum9(+);
%write_bignum9([]) :- !;
%write_bignum9(Bignum) :-
%        write_divide_bignum(Bignum,10,Q,R),!,
%        write_bignum9(Q), write(R);
%
%:- mode write_divide_bignum(+,+,-,-);
%write_divide_bignum([],_,[],0) :- !;
%write_divide_bignum(0#Big,D,Q,R) :- !,
%        write_divide_bignum(Big,D,Q,R);
%write_divide_bignum(M#Big,D,Q,R) :-
%        M<D,!,
%        write_divide_bignum9(Big,M,D,Q,R);
%write_divide_bignum(M#Big,D,L#Q,R) :- !,
%        L is M/D,
%        Y is M mod D,!,
%        write_divide_bignum9(Big,Y,D,Q,R);
%
%:- mode write_divide_bignum9(+,+,+,-,-);
%write_divide_bignum9([],N,_,[],N) :- !;
%write_divide_bignum9(M#Big,N,D,L#Q,R) :-
%        X is N*512+M,
%        L is X/D,
%        Y is X mod D,!,
%        write_divide_bignum9(Big,Y,D,Q,R);
%
%:- op(0,xfy,#);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       interface                                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%% metis_assert
'{DB}title'(A) :- !, interface('{DB}title'(A)); 
'{DB-op}inf'(A,B,C,D) :- !, interface('{DB-op}inf'(A,B,C,D));
'{DB-op}cons'(A) :- !, interface('{DB-op}cons'(A));
'{DB-op}less'(A,B) :- !, interface('{DB-op}less'(A,B));
'{DB-eq}###'(A,B,C,D,E,F,G,H,I,J) :- !, interface('{DB-eq}###'(A,B,C,D,E,F,G,H,I,J));
'{DB-eq}#/#'(A,B,C,D,E,F,G,H,I,J,K) :- !, interface('{DB-eq}#/#'(A,B,C,D,E,F,G,H,I,J,K));
'{CPC}current'(A) :- !, interface('{CPC}current'(A));
'{CPC}evaluated'(A) :- !, interface('{CPC}evaluated'(A));
'{DB-rl}>>>'(A,B,C,D,E,F) :- !, interface('{DB-rl}>>>'(A,B,C,D,E,F));
'{DB-rl}#>>'(A,B,C,D,E,F,G) :- !, interface('{DB-rl}#>>'(A,B,C,D,E,F,G));
'{DB-rl}##>'(A,B,C,D,E,F) :- !, interface('{DB-rl}##>'(A,B,C,D,E,F));
'{DB-rl}#<<'(A,B,C,D,E,F,G) :- !, interface('{DB-rl}#<<'(A,B,C,D,E,F,G));
'{DB-rl}##<'(A,B,C,D,E,F) :- !, interface('{DB-rl}##<'(A,B,C,D,E,F));
'{DB-rl}</>'(A,B,C,D,E,F,G) :- !, interface('{DB-rl}</>'(A,B,C,D,E,F,G));
'{CPC}>>>'(A,B,C,D,E) :- !, interface('{CPC}>>>'(A,B,C,D,E));
'{CPC}#>>'(A,B,C,D,E) :- !, interface('{CPC}#>>'(A,B,C,D,E));
'{CPC}##>'(A,B,C,D) :- !, interface('{CPC}##>'(A,B,C,D));
'{CPC}#<<'(A,B,C,D,E) :- !, interface('{CPC}#<<'(A,B,C,D,E));
'{CPC}##<'(A,B,C,D) :- !, interface('{CPC}##<'(A,B,C,D));
'{HIS}'(A) :- !, interface('{HIS}'(A));
%%%%% for save/restore
'{CNT}'(A,B) :- !, interface('{CNT}'(A,B));
'{CNT}id'(A,B) :- !, interface('{CNT}id'(A,B));
%%%%% flags
'{FLG}bell' :- !, interface('{FLG}bell');
'{FLG}trace'(A) :- !, interface('{FLG}trace'(A));
'{FLG}completion' :- !, interface('{FLG}completion');
'{FLG}monitor'(A,B) :- !, interface('{FLG}monitor'(A,B));
'{FLG}history' :- !, interface('{FLG}history');  % save delted data
'{FLG}comlog' :- !, interface('{FLG}comlog');  % make command log file
'{SYS}ttycopy' :- !, interface('{SYS}ttycopy');
'{FLG}log' :- !, interface('{FLG}log');  % make prolog.log
'{FLG}to_interactive' :- !, interface('{FLG}to_interactive');
'{DFT}monitor'(A,B) :- !, interface('{DFT}monitor'(A,B)); 
'{DFT}trace'(A) :- !, interface('{DFT}trace'(A)); 
'{DB-op}form'(A,B,C) :- !, interface('{DB-op}form'(A,B,C));
'{SYS}com_mode'(A) :- !, interface('{SYS}com_mode'(A));
'{SYS}version'(A) :- !, interface('{SYS}version'(A));
'{SYS}compiled'(A,B,C) :- !, interface('{SYS}compiled'(A,B,C));
'{SYS}jobno'(A,B) :- !, interface('{SYS}jobno'(A,B));
'{SYS}ttylength'(A) :- !, interface('{SYS}ttylength'(A));
'{SYS}ttylevel'(A) :- !, interface('{SYS}ttylevel'(A));
'{SYS}print'(A) :- !, interface('{SYS}print'(A));
'{SYS}ttytype'(A) :- !, interface('{SYS}ttytype'(A));
'{DFT}ttytype'(A) :- !, interface('{DFT}ttytype'(A));
'{CPC}terminate' :- !, interface('{CPC}terminate');
'{SYS}command_file'(A,B) :- !, interface('{SYS}command_file'(A,B));
'{SYS}compiled_date'(A,B,C) :- !, interface('{SYS}compiled_date'(A,B,C));
'{SYS}current_file'(A,B) :- !, interface('{SYS}current_file'(A,B));
'{SYS}executable_file'(A) :- !, interface('{SYS}executable_file'(A));
'{DFT}'(A) :- !, interface('{DFT}'(A));
'{CPC}induction'(A) :- !, interface('{CPC}induction'(A));

%%%%%%% metis_command
command(A,B,C,D,E,F) :- interface(command(A,B,C,D,E,F) );
default_command(A,B) :- interface(default_command(A,B) );
cpc_mode_and_id(B,C) :- interface(cpc_mode_and_id(B,C) );

%%%%%%% metis_main
%%metis ) => :metis_metis(#metis_main);
%%c => :metis_c(#metis_main);
%%continue => :metis_continue(#metis_main);
command_select(A,B,C,D,E) :- interface(command_select(A,B,C,D,E) );
portray(A) :- interface(portray(A) );
orient(A,B,C) :- interface(orient(A,B,C) );
%%i(#metis_main) :- i => :;
%%interactive(#metis_main) :- interactive(#metis_main);
less(A,B) :- interface(less(A,B) );
can_less(A,B,C,D,E,F) :- interface(can_less(A,B,C,D,E,F) );
reduce_one(A,B,C) :- interface(reduce_one(A,B,C) );
reduce_ass :- interface(reduce_ass );
refer(A,B,C,D) :- interface(refer(A,B,C,D) );
refer_match(A,B,C,D) :- interface(refer_match(A,B,C,D) );
set(A) :- interface(set(A) );
ref(A) :- interface(ref(A) );
new_port(A,B) :- interface(new_port(A,B) );

%%%%%%% metis_utility
to_skolem(A) :- interface(to_skolem(A));
operator_infix(Xfx):- interface( operator_infix(Xfx));
operator_prefix(Xfx):- interface( operator_prefix(Xfx));
operator_postfix(Xfx):- interface( operator_postfix(Xfx));
is_var(V) :- interface( is_var(V));
to_skolem(A,B,C) :- interface( to_skolem(A,B,C));
to_skolem_list(A) :- interface( to_skolem_list(A));
to_skolem_list(A,B,C) :- interface( to_skolem_list(A,B,C));
from_skolem(A,B) :- interface( from_skolem(A,B));
from_skolem_list(A,B) :- interface( from_skolem_list(A,B));
to_successor_one(A,B) :- interface( to_successor_one(A,B));
from_Sexpression_and_successor(A,B) :- interface( from_Sexpression_and_successor(A,B));
from_successor_one(A,B) :- interface( from_successor_one(A,B));
to_linear(A,B,C) :- interface( to_linear(A,B,C));
get_top_operator(A,B) :- interface( get_top_operator(A,B));
get_top_operator_list(A,B) :- interface( get_top_operator_list(A,B));
get_top_sub_operator(A,B,C) :- interface( get_top_sub_operator(A,B,C));
get_top_sub_operator_list(A,B,C) :- interface( get_top_sub_operator_list(A,B,C));
get_one_list(A,B,C) :- interface( get_one_list(A,B,C));
get_first_operator(A,B) :- interface( get_first_operator(A,B));
get_operators_sweep(A,B) :- interface( get_operators_sweep(A,B));
get_operators(A,B) :- interface( get_operators(A,B));
get_variables_sweep(A,B) :- interface( get_variables_sweep(A,B));
get_variables(A,B) :- interface( get_variables(A,B));
list_to_atom(A,B) :- interface( list_to_atom(A,B));
list_to_dlist(A,B,C) :- interface( list_to_dlist(A,B,C));
list_from_dlist(A,B,C) :- interface( list_from_dlist(A,B,C));
lower_and_upper_string(A,B) :- interface( lower_and_upper_string(A,B));
lower_and_upper(A,B) :- interface( lower_and_upper(A,B));
unify_occ(A,B) :- interface( unify_occ(A,B));
dname(A,B,C) :- interface( dname(A,B,C));
member_of_list(A,B,C) :- interface( member_of_list(A,B,C));
compareSet(A,B,C) :- interface( compareSet(A,B,C));
delete_list(A,B,C,D) :- interface( delete_list(A,B,C,D));
delete_one_list(A,B,C,D) :- interface( delete_one_list(A,B,C,D));
can_delete_list(A,B,C,D) :- interface( can_delete_list(A,B,C,D));
sweep_list(A,B,C) :- interface( sweep_list(A,B,C));
union_list(A,B,C,D) :- interface( union_list(A,B,C,D));
intersect_list(A,B,C,D) :- interface( intersect_list(A,B,C,D));
intersect_list(A,B,C,D,E,F) :- interface( intersect_list(A,B,C,D,E,F));
app_list(A,B,C) :- interface( app_list(A,B,C));
rev_list(A,B) :- interface( rev_list(A,B));
front_ulmatch(A,B) :- interface( front_ulmatch(A,B));
front_ulmatch(A,B,C) :- interface( front_ulmatch(A,B,C));
middle_ulmatch(A,B) :- interface( middle_ulmatch(A,B));
is_list(A) :- interface( is_list(A));
is_string(A) :- interface( is_string(A));
counter(A,B) :- interface( counter(A,B));
counter(A,B,C) :- interface( counter(A,B,C));
counter(A,B,C,D) :- interface( counter(A,B,C,D));
trace_on(A) :- interface(trace_on(A));
traceoff :- interface( traceoff);
trace(A) :- interface( trace(A));
trace(A,B) :- interface( trace(A,B));
is_trace(A) :- interface( is_trace(A));
notrace(A) :- interface( notrace(A));
not_seeing(A) :- interface( not_seeing(A));
retract_all(A) :- interface( retract_all(A));
bagoft(A,B,C) :- interface(bagoft(A,B,C));
not_not_unify(A,B) :- interface(not_not_unify(A,B));

%%%%%%% metis_buildin
abolish(Clause,Arity):- interface(abolish(Clause,Arity));
assert(Clause):- interface(assert(Clause));
assert(Clause,Ref):- interface(assert(Clause,Ref));
asserta(Clause):- interface(asserta(Clause));             
asserta(Clause,Ref):- interface(asserta(Clause,Ref));
assertz(Clause):- interface(assertz(Clause));
assertz(Clause,Ref):- interface(assertz(Clause,Ref));
bagof(Data,Pred,List):- interface(bagof(Data,Pred,List));
call(Clause):- interface(call(Clause));
notcall(Clause):- interface(notcall(Clause));
clause(Hed,Body,Ref):- interface(clause(Hed,Body,Ref));
clause(Hed,Body):- interface(clause(Hed,Body));
compare(OP,L,R):- interface(compare(OP,L,R));
erase(Ref):- interface(erase(Ref));
trimcore :- true;
terminal_open:- interface(terminal_open);
terminal_close:- interface(terminal_close);
get0(X):- interface(get0(X));   
length(List,L):- interface(length(List,L));
name(X,List):- interface(name(X,List));
numbervars(Term,Cin,Cout):- interface(numbervars(Term,Cin,Cout));
nl:- interface(nl);
op(P,F,O):- interface(op(P,F,O));
print(Format,Arg_list):- interface(print(Format,Arg_list));
put(X):- interface(put(X));
read(X):- interface(read(X));
retract(Clause):- interface(retract(Clause));
rename(Old_file,New_file):- interface(rename(Old_file,New_file));
see(Fanam):- interface(see(Fanam));
seeing(Fnam):- interface(seeing(Fnam));
seen:- interface(seen);
sort(X,List):- interface(sort(X,List));
tell(Fanam):- interface(tell(Fanam));
told:- interface(told);
telling(Fnam):- interface(telling(Fnam));
write(X):- interface(write(X));
write(X,Y,Z):- interface(write(X,Y,Z));
'=..'(Term,List):- interface('=..'(Term,List));
functor(Term,A,B):- interface(functor(Term,A,B));
tab(A):- interface(tab(A));
prompt(A,B):- interface(prompt(A,B)); 
print(A):- interface(print(A));
ttyflush:- interface(ttyflush);
log:- interface(log);
nolog:- interface(nolog);
plsys(A):- interface(plsys(A));
nofileerrors:- interface(nofileerrors);
writeq(A):- interface(writeq(A));
writeq(A,B,C):- interface(writeq(A,B,C));
nonvar(A):- interface(nonvar(A));
var(A):- interface(var(A));
statistics(A,B) :- interface(statistics(A,B));
compile(A)  :- true;
reconsult(A)  :- true;
incore(A)  :- true;
halt :- true;
abort :- true;
 
end.