%*****************************************************************************
%
%       Metis Assert
%               Multi - PSI version
%
%               created by      : ???
%               version         : 1.0
%               revision        : 0.0
%               date created    :
%               date changed    :
%               comments        :
%*****************************************************************************

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%    class METIS ASSERT    %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
class metis_assert has

    component
            index:=Index:- (:create(#extensible_hash_index,Index,100) );

    %%%%%%% Initialize %%%%%%%
    :initialize(Class) :- !,
            :create(#extensible_hash_index,Index,100),
            Class!index := Index ;
    %%%%%%% Methods %%%%%%%
    :assert(Class,Clause) :- !,:assert(Class,Clause,_);
    :assert(Class,Clause,Ref) :- !,:assertz(Class,Clause,Ref);
    :asserta(Class,Clause) :- !,:asserta(Class,Clause,_);
    :asserta(Class,(Head:-Body),Ref) :- !,
            :get_attribute(Class,Head,Obj,Key),!,
            :asserta(Obj,Key,(Head:-Body),Ref);
    :asserta(Class,Head,Ref) :- !,:asserta(Class,(Head:-true),Ref);
    :assertz(Class,Clause) :- !,:assertz(Class,Clause,_);
    :assertz(Class,(Head:-Body),Ref) :- !,
            :get_attribute(Class,Head,Obj,Key),!,
            :assertz(Obj,Key,(Head:-Body),Ref);
    :assertz(Class,Head,Ref) :- !,:assertz(Class,(Head:-true),Ref);
    :call(Class,Pred) :- !,
            :get_attribute(Class,Pred,Obj,Key),!,
            :call(Obj,Key,Pred);
    :clause(Class,Head,Body) :- !,:clause(Class,Head,Body,_);
    :clause(Class,Head,Body,Ref) :- !,
            :get_attribute(Class,Head,Obj,Key),!,
            :clause(Obj,Key,(Head:-Body),Ref);
    :retract(Class,(Head:-Body)) :- !,
            :get_attribute(Class,Head,Obj,Key),!,
            :retract(Obj,Key,(Head:-Body));
    :retract(Class,Head) :- !,:retract(Class,(Head:-true));
    :abolish(Class,Functor,Arity) :- !,
            :get_obj(Class,Functor,Arity,Obj),!,
            :abolish(Obj);
    %%%%%%% Erase %%%%%%%
    :erase(Class,Obj) :- !,
            erase(Obj);
    %%%%%%% Utility %%%%%%%
    :list(Class,Functor,Arity,List) :- !,
            :get_obj(Class,Functor,Arity,Obj),
            :list(Obj,List);
    %%%%%%% Get attribute %%%%%%%
    :get_attribute(Class,Head,Obj,Key) :- !,
            functor(Head,Functor,Arity),
            :get_obj(Class,Functor,Arity,Obj),
            key(Functor,Arity,Head,Key);
    %%%%%%% Get object %%%%%%%
    :get_obj(Class,Functor,Arity,Obj) :- 
            :get_at(Class!index,Obj,Functor),!;
    :get_obj(Class,Functor,Arity,New) :- !,
            :create(#metis_assert_node,New),
            :add_at(Class!index,New,Functor),
            set_init_data(Class,Functor,Arity);

local

    %%%%%%% Functor %%%%%%%
    functor({F,_},F,1) :- !;
    functor({F,_,_},F,2) :- !;
    functor({F,_,_,_},F,3) :- !;
    functor({F,_,_,_,_},F,4) :- !;
    functor({F,_,_,_,_,_},F,5) :- !;
    functor({F,_,_,_,_,_,_},F,6) :- !;
    functor({F,_,_,_,_,_,_,_},F,7) :- !;
    functor({F,_,_,_,_,_,_,_,_},F,8) :- !;
    functor({F,_,_,_,_,_,_,_,_,_},F,9) :- !;
    functor({F,_,_,_,_,_,_,_,_,_,_},F,10) :- !;
    functor(Head,Head,0) :-
            atomic(Head),!;
    functor(Head,Functor,Arity) :-
            stack_vector(Head,Length),!,
            first(Head,Functor),
            Arity is Length-1;
    %%%%%%% Erase %%%%%%%
    erase(Obj) :- !,
            :refer(Obj,_,PrevObj,NextObj),
            :modify(PrevObj,nextObj,NextObj),
            :modify(NextObj,prevObj,PrevObj);
    %%%%%%% initial values %%%%%%%
    set_init_data(Class,Functor,Arity) :-
            init_data(Functor,Arity,Data),
            :assertz(Class,Data),
            fail;
    set_init_data(_,_,_) :- !;

    init_data('{DFT}',1,'{DFT}'(trace(2)));
    init_data('{DFT}ttytype',1,'{DFT}ttytype'(psi));
    init_data('{DFT}',1,'{DFT}'(operator(_,fixed,_,_)));
    init_data('{DFT}monitor',2,'{DFT}monitor'(cit600,20));
    init_data('{DFT}monitor',2,'{DFT}monitor'(vt100,11));
    init_data('{DFT}monitor',2,'{DFT}monitor'(psi,38));
    init_data('{DFT}graph',4,'{DFT}graph'(70,axis(0,100,10,50),axis(0,100,10,50),scroll));
    init_data('{FLG}graph',4,'{FLG}graph'(70,axis(0,100,10,50),axis(0,100,10,50),scroll));
    init_data('{FLG}completion',0,'{FLG}completion');
    init_data('{FLG}monitor',2,'{FLG}monitor'(graph,data));
%%  init_data('{FLG}history',0,'{FLG}history');
    init_data('{FLG}comlog',0,'{FLG}comlog');
    init_data('{FLG}bell',0,'{FLG}bell');
    init_data(kk,3,kk(0,0,0));    % for DEBUGGING
    %%%%%%% Key data %%%%%%%
    key('{DB-eq}###',10,'{DB-eq}###'(Lop,Rop,_,_,_,_,_,_,_,_),key(Lop,Rop)) :- !;
    key('{DB-eq}#/#',11,'{DB-eq}#/#'(Lop,Rop,_,_,_,_,_,_,_,_,_),key(Lop,Rop)) :- !;
    key('{DB-rl}>>>',6,'{DB-rl}>>>'(Lop,Lsubop,_,_,_,_),key(Lop,Lsubop)) :- !;
    key('{DB-rl}#>>',7,'{DB-rl}#>>'(Lop,Lsubop,Rop,_,_,_,_),key(Lop,Lsubop,Rop)):-!;
    key('{DB-rl}##>',6,'{DB-rl}##>'(Lop,Rop,_,_,_,_),key(Lop,Rop)) :- !;
    key('{DB-rl}#<<',7,'{DB-rl}#<<'(Lop,Lsubop,Rop,_,_,_,_),key(Lop,Lsubop,Rop)):-!;
    key('{DB-rl}##<',6,'{DB-rl}##<'(Lop,Rop,_,_,_,_),key(Lop,Rop)) :- !;
    key('{DB-rl}</>',7,'{DB-rl}</>'(Lop,Rop,_,_,_,_,_),key(Lop,Rop)) :- !;
    key('{CPC}>>>',5,'{CPC}>>>'(Lop,Lsubop,_,_,_),key(Lop,Lsubop)) :- !;
    key('{CPC}#>>',5,'{CPC}#>>'(Lop,Lsubop,_,_,_),key(Lop,Lsubop)) :- !;
    key('{CPC}##>',4,'{CPC}##>'(Lop,_,_,_),Lop) :- !;
    key('{CPC}#<<',5,'{CPC}#<<'(Lop,Lsubop,_,_,_),key(Lop,Lsubop)) :- !;
    key('{CPC}##<',4,'{CPC}##<'(Lop,_,_,_),Lop) :- !;
    key('{DB-op}inf',4,'{DB-op}inf'(Op,_,_,_),Op) :- !;
    key('{DB-op}less',2,'{DB-op}less'(Lop,_),Lop) :- !;
    key('$BAGOF',2,'$BAGOF'(ID,_),ID) :- !;
    key(kk,3,kk(A,B,C),key(A,B)) :- !;  %%%% for DEBUGGING
    key(_,_,_,key) :- !;

end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%    class METIS ASSERT NODE    %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
class metis_assert_node has

    :create(Class,Obj) :- !,
            :new(Class,Obj),
            :initialize(Obj);

instance

    component
            index;

    %%%%%%% Initialize %%%%%%%
    :initialize(Instance) :- !,
            freeze([],Freeze),
            Instance!index:=Freeze;
    :asserta(Instance,Key,Clause,Ref) :- !,
            :add_obj(Instance,a,Key,Obj),
            :asserta(Obj,Clause,Ref);
    :assertz(Instance,Key,Clause,Ref) :- !,
            :add_obj(Instance,z,Key,Obj),
            :assertz(Obj,Clause,Ref);
    :clause(Instance,Key,Clause,Ref) :- !,
            :get_obj(Instance,Key,Obj),
            :clause(Obj,Clause,Ref);
    :retract(Instance,Key,Clause) :- !,
            :get_obj(Instance,Key,Obj),
            :retract(Obj,Clause);
    :call(Instance,Key,Pred) :- !,
            :get_obj(Instance,Key,Obj),
            :call(Obj,Pred);
    %%%%%%% Abolish %%%%%%%
    :abolish(Instance) :- !,
            :initialize(Instance);
    %%%%%%% Utility %%%%%%%
    :list(Instance,``(Key#List)) :- !,
            :get_obj(Instance,Key,Obj),
            :list(Obj,List);
    %%%%%%% Get object %%%%%%%
    :get_obj(Instance,Key,Obj) :- !,
            melt(Instance!index,List),!,
            get_index(List,Key,Obj);
    %%%%%%% Add object %%%%%%%
    :add_obj(Instance,P,Key,Obj) :- !,
            melt(Instance!index,List),!,
            :add_obj_(Instance,P,List,Key,Obj);
    :add_obj_(Instance,_,List,Key,Obj) :-
            get_indexW(List,Key,Obj),!;
    :add_obj_(Instance,P,List,Key,New) :- !,
            :create(#metis_assert_branch,New),
            add_index(P,List,Key,New,NewList),
            freeze(NewList,Freeze),
            Instance!index:=Freeze;

local

    %%%%%%%% Index %%%%%%%%
    get_index([idx(X,Obj)|_],X,Obj);
    get_index([_|Rem],X,Obj) :- !,
            get_index(Rem,X,Obj);
    get_indexW([idx(XR,Obj)|_],XL,Obj) :-
            same_structure(XL,XR),!;
    get_indexW([_|Rem],X,Obj) :- !,
            get_indexW(Rem,X,Obj);
    add_index(a,List,Key,Obj,[idx(Key,Obj)|List]) :- !;
    add_index(z,List,Key,Obj,NewList) :- !,
            app(List,[idx(Key,Obj)],NewList);
    app([],X,X) :- !;
    app([I|Rem],Add,[I|NewRem]) :- !,app(Rem,Add,NewRem);
    %%%%%%% Same structure %%%%%%%
    same_structure(L,R) :-
            L==R,!;
    same_structure(L,R) :- !,
            type(L,T),type(R,T),!,
            same_structure_(L,R);
    same_structure_(L,_) :-
            unbound(L),!;
    same_structure_(L,R) :-
            stack_vector(L,_),!,
            vector_to_list(L,[],[_|Larg]),
            vector_to_list(R,[],[_|Rarg]),!,
            same_structure_arg(Larg,Rarg);
    same_structure_(L,R) :-
            list(L),!,
            same_structure_arg(Larg,Rarg);
    same_structure_arg([],[]) :- !;
    same_structure_arg([L|Lrem],[R|Rrem]) :- !,
            same_structure(L,R),!,
            same_structure_arg(Lrem,Rrem);

end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%    class metis assert branch    %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
class metis_assert_branch has

    :create(Class,New) :- !,
            :new(Class,New),
            :initialize(New);

instance

    component
            top_obj,
            bot_obj;

    %%%%%%% Initalize %%%%%%%
    :initialize(Instance) :- !,
            Instance!top_obj:=Instance,
            Instance!bot_obj:=Instance;
    %%%%%%% Asserta %%%%%%%
    :asserta(Instance,Clause,New) :- !,
            :new(#metis_assert_leaf,New),
            :record(New,Clause,Instance,Instance!top_obj),
            :modify(Instance!top_obj,prevObj,New),
            Instance!top_obj:=New;
    %%%%%%% Assertz %%%%%%%
    :assertz(Instance,Clause,New) :- !,
            :new(#metis_assert_leaf,New),
            :record(New,Clause,Instance!bot_obj,Instance),
            :modify(Instance!bot_obj,nextObj,New),
            Instance!bot_obj:=New;
    %%%%%%% Clause %%%%%%%
    :clause(Instance,Clause,Obj) :- !,
            sequential(Instance!top_obj,Obj,Clause,_,_);
    %%%%%%% Retract %%%%%%%
    :retract(Instance,Clause) :- !,
            sequential(Instance!top_obj,Obj,Clause,_,_),
            :erase(#metis_assert,Obj);
    %%%%%%% Call %%%%%%%
    :call(Instance,Pred) :- !,
            call(Instance!top_obj,Pred);
    %%%%%%% Utility %%%%%%%
    :list(Instance,List) :- !,
            list(Instance!top_obj,List);
    %%%%%%% Record/Refer for top/bottom data %%%%%%%
%%  :record(Instance,_,_,_,_,_) :- !;
    :refer(Instance,'NULL','NULL','NULL') :- !;
    :modify(Instance,nextObj,NextObj) :- !,
            Instance!top_obj:=NextObj;
    :modify(Instance,prevObj,PrevObj) :- !,
            Instance!bot_obj:=PrevObj;

local

    %%%%%%% Sequential %%%%%%%
    sequential(Io,Oo,Oc,Op,On) :- !,
            :refer(Io,Ic,Ip,In),!,
            sequential_(Ic,Ip,In,Io,Oc,Op,On,Oo);
    sequential_('NULL',_,_,_,_,_,_,_) :- !,fail;
    sequential_(C,P,N,O,C,P,N,O);
    sequential_(_,_,In,_,Oc,Op,On,Oo) :- !,
            sequential(In,Oo,Oc,Op,On);
    %%%%%%% Call %%%%%%%
    call(Obj,Pred) :-
            :refer(Obj,C,_,N),!,
            call_(C,Pred,N);
    call_('NULL',_,_) :- !,
            fail;
    call_((Pred:-Body),Pred,N) :-
            do_call_body(Body);
    call_(_,Pred,NextObj) :- !,
            call(NextObj,Pred);
    do_call_body(true) :- !;
    do_call_body(fail) :- !,fail;
    do_call_body((H,T)) :- !,
            do_call_body(H),do_call_body(T);
    do_call_body((H;T)) :- !,
            (do_call_body(H);do_call_body(T));
    %%%%%%% Utility %%%%%%%
    list(Obj,List) :- !,
            :refer(Obj,Clause,_,NextObj),!,
            list(Clause,NextObj,List);
    list('NULL',_,[]) :- !;
    list(Clause,NextObj,[Clause|Rem]) :- !,
            list(NextObj,Rem);

end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%    class METIS ASSERT LEAF    %%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
class metis_assert_leaf has

instance

    component
            clause,
            prevObj,
            nextObj;

    %%%%%%% Record %%%%%%%
    :record(Class,Clause,PrevObj,NextObj) :- !,
            freeze(Clause,Fclause),
            Class!clause:=Fclause,
            Class!prevObj:=PrevObj,
            Class!nextObj:=NextObj;
    %%%%%%% Refer %%%%%%%
    :refer(Class,Clause,Class!prevObj,Class!nextObj) :- !,
            melt(Class!clause,Clause);
    %%%%%%% Modify %%%%%%%
    :modify(Class,prevObj,PrevObj) :- !,
            Class!prevObj:=PrevObj;
    :modify(Class,nextObj,NextObj) :- !,
            Class!nextObj:=NextObj;

end.



