We will now show you MENDELS ZONE, a development support system for
concurrent programs.  This support system is implemented in the
parallel mashine multi-PSI, and generates KL1 programs from program
specifications.

APPROACH
 The approach is summarized by the following 4 points.  The first
point is the Petri net based extension of KL1.  This extension makes
it possible to represent concurrent programs in a natural way.  The
second point is formal specifications using logic. Users describe
specifications by equational logic and temporal logic.  The third
point is the verification based on a theorem proving method.  This
procedure is implemented in parallel to use the PSI machine's
capabilities efficiently.  The last point is the automatic program
generation from specifications.

START OF DEMONSTRATION
 This is the program generation flow on MENDLES ZONE.  I will
demonstrate the system following this flow.  The example is the
development of a plant control system.

OBJECT GENERATION AND VERIFICATION

A concurrent program is constructed from independent processes called
``objects''.  The program generation flow is separated into 2 phase,
``object generation'' and ``object composition''. Now, we'll show you
the ``object generation'' phase. The behavior of an object is
represented as predicates called ``methods''.  First, the users
describe the specifications of methods based on equational logic in
this way.  A method ``find_changes'' is declared in this area, and
defined in this area by equational logic.  This method finds changes
of plant data.  If users want to verify the correctness of the
specification, they describe theorems the specification should
satisfy.  This window shows theorems of this specification.  MENDELS
ZONE automatically checks whether these theorems are valid or not in
the specification based on a theorem proving method. So, I will start
the verification procedure. The procedure is implemented in parallel,
so as to utilize the computiong power of the parallel machine
efficiently.  Now, the procedure terminated with the word `PROVED'.
After verifying the correctness of the specification, MENDELS ZONE
automatically generates program parts corresponding to the
specifications.


ADJUSTMENT OF TIMING
This is the Petri net representation of an object.  Black rectangles
are methods, and lines represent data flows.  In the first phase,
these methods were generated, and in the second phase users connect
the mothods using this Petri net editor.  Usually these methods are
executed concurrently, but sometimes methods have to be executed
sequentially. For example, this object has a storage, which is called
``plant data base''.  Some method refers the data base, and another
one renews it.  We must adjust the execution order.  In such a case,
users describe timing constraints in this way.  MENDELS ZONE
automatically adjust the Petri net so as to satisfy the timing
constraints.  These blue parts were automatically added, and this
object now satisfies the constraint. Completed objects are registered
in an object library.

OBJECT COMPOSITION
In the third ``object composition'' phase, users compose the objects
using the Petri net editor.  Now, I try to connect 2 objects as a
example.  In this way, objects can be composed using only mouse
operations.  I will show the whole structure of the plant control
system.  Further more, if timing constraints between objects are
necessary, they can be described in the same manner as the methods.
But in this case, there was no constraint between objects.  Finally,
we'll compile this Petri net into a KL1 program.  The program can be
executed on multi-PSI.

EVALUATION
Lastly, I present an evaluation of MENDELS ZONE. This control system
was originally implemented manually in KL1, and we developed an almost
identical system using MENDELS ZONE.  By comparing the two cases, we
tried to evaluate the effectiveness of MENDELS ZONE. This graph shows
the description sizes of each case.  The program size of the control
system by a conventional approach is about 4900 lines.  The size of
the specification we described is about 3700 lines.  he automatically
generated KL1 program is about 6200 lines.  We think that the formal
specifications were described more compactly than expected.

This graph shows the developing time of each case. The development on
MENDELS ZONE required less time than the conventional approach.  As
you see from the graph, this fact is caused by the reduction of
debugging time.  In our judgement, the verification and the automatic
program generation were efficient in generating a correct program.

CONCLUSION
We'll now summarize the development result as a conclusion.  The
development of a practical system using MENDELS ZONE took only half
the time compared to the conventional approach. Automatic programming
techniques were effectively applied to the development of the
practical system by utilizing the computing power of fifth generation
computer systems.  That concludes our demonstration.  Thank you for
your attention.

