% (C)1992 Institute for New Generation Computer Technology
% $BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
% (Read COPYRIGHT for detailed information.)

%
%   ******************************
%   * FGCS 92 Version            *
%   * Reduce Graph Main          *
%   * 1992-05-20 Naoshi Uchihira *
%   ******************************
%

class main_reduce has
nature
        pimfep##as_pimos_string_io_device ;

instance

attribute 
        in_file_name:=">sys>user>MENDELuser>TEMP>tableau.std",
        out_file_name:=">sys>user>MENDELuser>TEMP>tab_to_main.std" ;

%*********************************************
%*** KL1 Interface: called by tableau_main ***
%*********************************************

:io(Class,0,_,Ans) :- !,
    %:trace_string_io(Class),
    !,read_file(Class,StartNode,EdgeList),
    !,:go(#reduce,StartNode,EdgeList,NewStartNode,ReducedEdgeList),
    !,write_file(Class,NewStartNode,ReducedEdgeList),!,
    Ans="ok" ;

local

% --- READ FILE ---

read_file(Class,StartNode,EdgeList2) :-
    :get_path_name(#path,temp,PathString),
    :append(#string,[PathString,"tableau.std"],In_file_name),
    :create(#standard_input_file,File,In_file_name),
%    :create(#standard_input_file,File,Class!in_file_name),
    read_file2(File,EdgeList),
    edge_filter(EdgeList,StartNode,EdgeList2),
    :close_input(File),
    %EdgeList=[edge(0,1,g(true)),edge(1,2,g(a)),
    %    edge(1,3,g(b)),edge(2,1,g(b)),edge(3,1,g(a))],
    true ;

read_file2(File,[Edge|EL]) :-
    :gett(File,Edge),
    !,read_file2(File,EL) ;
read_file2(_,[]) ;

edge_filter(EL1,SN,EL2) :-
    SN = 1,
    edge_filter2(EL1,EL2) ;

edge_filter2([],[]) ;
edge_filter2([Edge|EL1],EL2) :-
    Edge=e(0,1,_,_), % Dummy Edge in Tableau Method
    !,edge_filter2(EL1,EL2) ;
edge_filter2([Edge1|EL1],[Edge2|EL2]) :-
    trans_edge_form(Edge1,Edge2),
    !,edge_filter2(EL1,EL2) ;   


trans_edge_form(Edge1,Edge2) :-
    Edge1=e(N1,N2,l(PL,NL,MKG,EL),FLG),
    trans_edge_form2(PL,NL,Label),
    Edge2=edge(N1,N2,Label) ;
trans_edge_form(_,edge(0,0,g(error))) ;

%   ::::::::::::::::::::::::::::::
%   :: Translate Edge Format    ::
%   :: m(AP) = invisible method ::
%   :: g(AP) = visible method   ::
%   ::::::::::::::::::::::::::::::
trans_edge_form2([AP],invisible,m(AP)) ;
trans_edge_form2([AP],_,g(AP)) ;
trans_edge_form2([],_,m(true)) ;
trans_edge_form2(_,_,g(error)) ;

% --- WRITE FILE ---

write_file(Class,n(SN),EL) :-
    :get_path_name(#path,temp,PathString),
    :append(#string,[PathString,"tab_to_main.std"],Out_file_name),
    :create(#standard_output_file,File,Out_file_name),
%    :create(#standard_output_file,File,Class!out_file_name),
    get_info(EL,ML,NL),
    write_file1(File,SN,ML,NL),
    write_file2(File,EL),
    :close_output(File),
    true ;

write_file1(File,SN,ML,NL) :-
    :putt(File,omega_automaton),nl(File),
    :putt(File,methods(ML)),nl(File),
    :putt(File,start_node(SN)),nl(File),
    :putt(File,omega_nodes(NL)),nl(File) ;

write_file2(File,[]) ;
write_file2(File,[Edge1|EL]) :-
    post_trans_edge(Edge1,Edge2),
    :putt(File,Edge2),nl(File),
    write_file2(File,EL) ;

post_trans_edge(edge(n(N1),n(N2),g(M)),e(N1,N2,M)) ;
post_trans_edge(edge(n(N1),n(N2),g(M)),e(0,0,error)) ;

nl(File) :-
    :putb(File,". ",2),:putl(File) ;
    
get_info([],[],[]) ;
get_info([edge(n(N1),n(N2),g(M))|EL],ML1,NL1) :-
    get_info(EL,ML2,NL2),
    get_info2([N1,N2],NL2,NL1),
    get_info2([M],ML2,ML1) ;


get_info2([],L,L) ;
get_info2([E|L1],L2,L3) :-
    member(E,L2),
    !,get_info2(L1,L2,L3) ;
get_info2([E|L1],L2,L3) :-
    !,get_info2(L1,[E|L2],L3) ;

member(A, [A|_]) ;
member(A, [_|L]) :- member(A, L) ;


end.