/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define TRUE 1
#define FALSE 0
#define SINGLE  1 
#define MAXLINE 256
#define MAXSEQS 100
#define MAXCOLUMN 1000
#define MAXPAIRS  1000
#define MAXIMUM   9999
#define BASES 7  /* A,U,G,C,T,other base,GAP */
#define PERCENT_D  70 /* default percent */
#define ORIGINAL 0
#define SELECT 1

FILE *fpr;    /* file pointer */
char datafile[MAXLINE]; /* data file name */

int singleMode;  /* data is only one sequence => TRUE,more than two sequences => FALSE */
int Percent;   /* consensus % */
int NoOfSeqs;  /* number of sequences */
int NoOfColumn; /* number of columns */
int Renzoku; /* number of consecutive pairs */
int  file_flag; /* flag whether data file is read or not */
int pre_percent; /* percent value before changed by scale */


char *seq_names[MAXSEQS];  /* array for sequence names */
char *sequences[MAXSEQS];  /* array for sequences */
int  consensus[MAXCOLUMN][2]; /* dominant base and its number of each column */

int pair_matrix_all_1[MAXCOLUMN][MAXCOLUMN]; /* pair percent */
int pair_matrix_all_2[MAXCOLUMN][MAXCOLUMN]; /* kind of base pair */

#define RENZOKU    3   /* default number of consecutive pairs  */
#define RENZOKU_MAX    50   /* maximum of consecutive pairs (default) */
int findPair;

int PairList[MAXPAIRS][3]; /* list of base pairs (column1 ,column2, pairvalue) */


#define ADE 0  /* adenine */
#define URA 1  /* uracil */
#define GUA 2  /* guanine */
#define CIT 3  /* cytosine */
#define TIM 4  /* thymine */
#define OTHER 5 /* A,U,G,C,T $B0J30(B */
#define GAP 6  /* gap */

int table_made; /* flag whether consensus_table is made or not */
int fileChanged; /* flag whether data file is changed or not */
                 /* calc_zahyou_data() sets FALSE */
int percentChanged; /* flag whether percent chaged or not */
int renzokuChanged; /* flag whether renzoku(consecutive) changed or not */


/* pairvalue */
#define A_T      3  /*  A-T */
#define G_C      2  /*  G-C */ 
#define BOTH    1  /* A-T and G-C */
#define NONE   99  /* no base pairs */

int toggle_flag;

/* for X-Window  */


#define SMALL      50
#define HANKEIS    150 /* radius small */
#define HANKEIL    250 /* radius large */
#define SUU        30  /* distance between circle and column number */
#define X0        50  /* x location of XArc (default) */
#define Y0        50  /* y location of XArc (default) */
#define AKI       15  /* angle of opening in circle (default) */
#define ANGLE      4  /* angle for one column (default) */ 
#define LINE_W1    8   /* line width of Arc (default) */
#define LINE_W2    2   /* width of line that bind pairs (default) */

int  xarc0,yarc0; /* location of XArc (x,y) */
int  xo,yo; /* center of XArc (x,y) */
 
int hankei;  /* radius */
double aki;  /* angle of opening in circle */
double angle; /* angle for one column */ 
int zahyou_table[MAXCOLUMN][4]; /* location of each column    */
                                /*   0     1       2           3       */
                                /*   x     y    x for number  y for number */


int NoOfHyoujiColumn;            /* (number of columns) - (number of gap column) */
int PairListForHyouji[MAXPAIRS][5];   /* position   of pair columns */
                           /* 0     column1 without gap column */
                           /* 1     column2 without gap column */
                           /* 2     kind of base pair */
                           /* 3     column1 */
                           /* 4     column2 */

int consensus_for_hyouji[MAXCOLUMN];  /* kind of dominant base in each column except gap column */
int original_hyouji_table[MAXCOLUMN];  /* order  of each base when gap columns are excluded */

int default_hankei;  /* default size of radius */
int daCreated;       /* flag whether da is created or not */
int resized;         /* flag whether size of circle_da changed or not */

#define GAP_COLUMN     -1

int hanrei_start_x;         /* position x of starting explanatory notes */
int hanrei_start_y;         /* position y of starting explanatory notes */
#define  HANREI_START_X   10    /* position x of starting explanatory notes (default) */
#define  HANREI_START_Y   16    /* position y of starting explanatory notes (default) */

int GCcreated;

int columns[MAXPAIRS][2];  /* items selected from list */


