/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ------------------------------------------------------------------ */
/*              readfile.c                                            */
/*         read data file                                             */
/* ------------------------------------------------------------------ */

/*   data file format    */
/* seqname1:ABCDEFGHIJ   */
/* seqname2:ACCCBDEHIJ   */
/* length of each seqence(= number of columns) is considerd as same   */

#include   <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include "ste.h"
/*
#define DEBUG TRUE
*/
#define TOO_MANY_ILLEGAL  20
extern int pre_percent;
int       nameLength; /* length of seqName */
int read_datafile(fpr)
     FILE *fpr;
{
  char buffer[MAXCOLUMN+1];
  char *p1,*p2;
  int  line; /* line counter of datafile  */
  int  i,illegal;
  int  illegal_flag;
    
  NoOfSeqs = 0;
  NoOfColumn = 0;
  line = 0;
  illegal = 0;
  illegal_flag = 0;

  for(;;)
    {
      if(fgets(buffer,MAXCOLUMN,fpr) == NULL)
	{
	  /*  printf("end of file \n");*/
	  break;   /* end of file, so get out of loop */
	}
      
      /*    printf("buffer = %s\n",buffer);*/
      
      line++;
      
      for(p1=buffer;*p1 == ' ' || *p1 == '\t' ;p1++)
	;       /* skip space and tab */
      if(*p1 == ';') continue;        /* comment, so get next line */
      else if(*p1 == '%') continue;   /* comment, so get next line */
      else if(*p1 == '#') continue;   /* comment, so get next line */
      else if(*p1 == '\n') continue;  /* empty line, so get next line */
      
      /*    printf("*p1= %c\n",*p1);*/
      
      p2 = p1; /* keep  copy of pointer to the head of line */
      
      for(i=0 ; *p1!=':' ; p1++)
	{
	  i++; /* count length of seqname */
	  
	  if(*p1 == '\n') /* this line has no  ':' */
	    {
	      fprintf(stderr,"illegal format in line %d\n",line);
	      fprintf(stderr,"     %s\n",p2);
	      illegal++;
	      illegal_flag = TRUE;
	      break;
	    }
	}
      if(illegal_flag)    /* illegal line, so get next line */
	continue;
      
      if(NoOfColumn == 0) /* first data */ 
	{
	  nameLength = i;
	}
      
      if((seq_names[NoOfSeqs] =
	  (char *)calloc((nameLength + 1),sizeof(char))) == NULL)
	{       
	  fprintf(stdout,"fail to alloc memory for seq_name %d:%s \n",line,p2);
	  exit(1);
	}
      
      p1 = seq_names[NoOfSeqs]; 
      while(*p2 != ':')
	{
	  *p1++ = *p2++;
	}
      p2++;
      NoOfColumn = strlen(p2)-1; /* ignore last '\n' */
      if((sequences[NoOfSeqs] =
	  (char *)calloc((NoOfColumn + 1),sizeof(char))) == NULL)
	{       
	  fprintf(stdout,"fail to alloc memory for line %d:%s \n",line,p2);
	  exit(1);
	}
      p1 = sequences[NoOfSeqs];
      /*	  while(*p2 != '\n') */
      for(i=0;i!=NoOfColumn;i++)
	{
	  if(isalpha(*p2) || *p2 == '-')
	    {
	      *p1++ = *p2++;
	    }
	  
	}
      NoOfSeqs++;
      
    }
  /*
    printf(" nameLength = %d, NoOfColumn = %d\n",nameLength,NoOfColumn);
    */
#ifdef DEBUG
  printf("Number of data = %d ,\n", NoOfSeqs);
  printf("Number of column = %d ,\n", NoOfColumn);
  
  for(i=0;i!= NoOfSeqs;i++)
    printf("sequences[%3d] = %s:%s\n",i,seq_names[i],sequences[i]);
  
#endif
/*  printf("illegal = %d\n",illegal); */
  if(illegal >= TOO_MANY_ILLEGAL)
    { /* illeagal data file */
      return NULL;
    }
  else if(NoOfSeqs == 0)
    { /* illeagal data file */
      return NULL;
    }
  else  
    {
      if(NoOfSeqs == 1)
	{
	  singleMode = TRUE;
	  Percent = 100;
	}
      else
	{
	  if(singleMode)
	    { /* treating one sequence before reading this file */
	      /*	      printf("pre_percent = %d\n",pre_percent); */
	      if(pre_percent == 100) /* reset to default percent */
		{Percent = PERCENT_D;
		 /*		 printf("new percent = %d ",Percent); */
	       }
	      else
		{Percent = pre_percent;
		 /*		 printf("new percent e = %d ",Percent); */
	       }
	      
	    }
	  singleMode = FALSE;
	}
#ifdef DEBUG
      printf("single flag = %d\n",singleMode);
#endif      
      return TRUE;
    }

}


/* ----------------- end of "readfile.c" --------------------- */
