/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*         makePairList.c                                            */
/* ----------------------------------------------------------------- */

#include   <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include   "ste.h"
#include   "stem_s.h"
/*
#define DEBUG TRUE 
*/

/* read matrix and make PairList */
void makePairList()
{
  int column1_start,column2_start,
      column1,column2;
  int renzokucount, /* counter of consecutive pairs */
      pairCount;
  int j;
  int tempPairList[RENZOKU_MAX][3];

  pairCount = 0;
  /* find consecutive base pairs from pair_matrix_all_1 */
  column1_start=NoOfColumn-2;
  column2_start=NoOfColumn-1;
/*
#ifdef DEBUG 
  printf("Percent = %d\n",Percent);
#endif
*/
  for(column1 = column1_start;column1 >= 0;column1--)
    {
      column2 = column2_start;
      column1_start = column1;
/*
#ifdef DEBUG 
      printf("column1,column2 = %d,%d\n",column1,column2);
#endif
*/
      renzokucount = 0;
      while(column1 < column2)
	{
	  if(original_hyouji_table[column1] != GAP_COLUMN && original_hyouji_table[column2] != GAP_COLUMN)
	    { /* neither column1 nor column2 are gap */
	      if(pair_matrix_all_1[column1][column2] >= Percent ) 
		{ /* percentage of base pairs >= Percent */
		  tempPairList[renzokucount][0] = column1;
		  tempPairList[renzokucount][1] = column2;
		  tempPairList[renzokucount][2] = pair_matrix_all_2[column1][column2];
		  renzokucount++;
/*		 
#ifdef DEBUG
		    printf("tempPairList = %d,%d,%d\n",
		    column1,column2,pair_matrix_all_2[column1][column2]);
		    printf("renzokucount = %d\n",renzokucount);
#endif
*/		 
		}
	      else
		{ /* pair_matrix_all_1[column1][column2] < Percent */
		  if(renzokucount == 0) 
		    ;
		  else if(renzokucount < Renzoku) /* consecutive count is not enough */
		    renzokucount = 0;             /* reset renzokucount */
		  else /* renzokucount >= Renzoku */
		    { /* consecutive count is same or more than Renzoku -> write to PairList */
		      for(j = 0;j!=renzokucount;j++)
			{
			  PairList[pairCount][0] = tempPairList[j][0];
			  PairList[pairCount][1] = tempPairList[j][1];
			  PairList[pairCount][2] = tempPairList[j][2];
			  pairCount++;
			  
			  /*
			    #ifdef DEBUG 
			    printf("renzoku = %d(in A)\n",renzokucount);
			    printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
			    printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
			    #endif
			    */
			}
		      renzokucount = 0; /* reset renzokucount */
		    }
		}
	    }
	  else if(original_hyouji_table[column1] == GAP_COLUMN && original_hyouji_table[column2] == GAP_COLUMN)
	     /* both column1 and column2 = gap column */
	    ;
	    
	  else if(original_hyouji_table[column1] == GAP_COLUMN)
	    { /* column1 = gap column */
	      column2++;
	    }
	  else if(original_hyouji_table[column2] == GAP_COLUMN)
	    { /* column2 = gap column */
	      column1--;
	    }
	  column1++;
	  column2--;
	}
      if( renzokucount >= Renzoku) 
	{ /* consecutive count is same or more than Renzoku -> write to PairList */
	  for(j = 0;j!=renzokucount;j++)
	    {
	      PairList[pairCount][0] = tempPairList[j][0];
	      PairList[pairCount][1] = tempPairList[j][1];
	      PairList[pairCount][2] = tempPairList[j][2];
	      pairCount++;
/*	      
#ifdef DEBUG 
	      printf("renzoku(outside while loop) = %d\n",renzokucount);
	      printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
	      printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
#endif
*/
	    }
	  renzokucount = 0; /* reset renzokucount */
	}
      else
	renzokucount = 0;
      column1 = column1_start;
    }

 
  column2_start =NoOfColumn-2; 

  for(column2 = column2_start;column2 > 0;column2--)
    {
      column1 = 0;
      column2_start = column2;
/*
#ifdef DEBUG 
      printf("column1,column2 = %d,%d\n",column1,column2);
#endif
*/
      renzokucount = 0;
      while(column1 < column2)
	{
	  if(original_hyouji_table[column1] != GAP_COLUMN && original_hyouji_table[column2] != GAP_COLUMN)
	    { /* neither column1 nor column2 are gap */
	      
	      if(pair_matrix_all_1[column1][column2] >= Percent ) 
		{ /* percentage of base pairs >= Percent */
		  tempPairList[renzokucount][0] = column1;
		  tempPairList[renzokucount][1] = column2;
		  tempPairList[renzokucount][2] = pair_matrix_all_2[column1][column2]; /* kind of base pair */
		  renzokucount++;
		  /*
		    #ifdef DEBUG
		    printf("tempPairList = %d,%d,%d\n",
		    column1,column2,pair_matrix_all_2[column1][column2]);
		    printf("renzokucount = %d\n",renzokucount);
		    #endif
		    */
		}
	      else
		{ /* pair_matrix_all_1[column1][column2] < Percent */
		  if(renzokucount == 0) 
		    ;
		  else if(renzokucount < Renzoku) /* consecutive count is not enough */
		    renzokucount = 0;             /* reset renzokucount */
		  else /* renzokucount >= Renzoku */
		    { /* consecutive count is same or more than Renzoku -> write to PairList */
		      for(j = 0;j!=renzokucount;j++)
			{
			  PairList[pairCount][0] = tempPairList[j][0];
			  PairList[pairCount][1] = tempPairList[j][1];
			  PairList[pairCount][2] = tempPairList[j][2];
			  pairCount++;
/*
#ifdef DEBUG 
			    printf("renzoku = %d(in B)\n",renzokucount);
			    printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
			    printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
#endif */
			}
		      renzokucount = 0; /* reset renzokucount */
		    }
		}
	    }
	  else if(original_hyouji_table[column1] == GAP_COLUMN && original_hyouji_table[column2] == GAP_COLUMN)
	    /* both column1 and column2 = gap column */
	    ;
	  
	  else if(original_hyouji_table[column1] == GAP_COLUMN)
	    { /* column1 = gap column */
	      column2++;
	    }
	  else if(original_hyouji_table[column2] == GAP_COLUMN)
	    { /* column2 = gap column */
	      column1--;
	    }
	  
	  column1++;
	  column2--;
	}
      if( renzokucount >= Renzoku) 
	{ /* consecutive count is same or more than Renzoku -> write to PairList */
	  for(j = 0;j!=renzokucount;j++)
	    {
	      PairList[pairCount][0] = tempPairList[j][0];
	      PairList[pairCount][1] = tempPairList[j][1];
	      PairList[pairCount][2] = tempPairList[j][2];
	      pairCount++;
/*	      
#ifdef DEBUG 
	      printf("renzoku(in B) = %d\n",renzokucount);
	      printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
	      printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
#endif */
	    }
	  renzokucount = 0; /* reset renzokucount */
	}
      else
	renzokucount = 0;
      column2 = column2_start;
    }




  PairList[pairCount][0] = MAXIMUM; /* sign the end of PairList */
/*
#ifdef DEBUG
  j  = 0;
  while(PairList[j][0] != MAXIMUM)
    {
      printf("j = %3d,  ",j);
      printf("PairList[%3d][0] = %3d, ",j, PairList[j][0]);
      printf("PairList[%3d][1] = %3d,",j, PairList[j][1]);
      printf("PairList[%3d][2] = %3d\n",j, PairList[j][2]); 
      j++;
    }
   printf("last : PairList[%5d][0] = %d\n",j, PairList[j][0]);
#endif
*/
}

/* make pair list of selected sequences */
void makePairList_s()
{
  int column1_start,column2_start,
      column1,column2;
  int renzokucount,pairCount;
  int j;
  int tempPairList[RENZOKU_MAX][3];

  pairCount = 0;
  /* find consecutive base pairs from pair_matrix_all_1_s */
  column1_start=NoOfColumn-2;
  column2_start=NoOfColumn-1;
/*
#ifdef DEBUG 
  printf("Percent_s = %d\n",Percent_s);
#endif
*/
  for(column1 = column1_start;column1 >= 0;column1--)
    {
      column2 = column2_start;
      column1_start = column1;
/*
#ifdef DEBUG 
      printf("column1,column2 = %d,%d\n",column1,column2);
#endif
*/
      renzokucount = 0;
      while(column1 < column2)
	{
	  if(original_hyouji_tableS[column1] != GAP_COLUMN && original_hyouji_tableS[column2] != GAP_COLUMN)
	    { /* neither column1 nor column2 are gap */
	      if(pair_matrix_all_1_s[column1][column2] >= Percent_s ) 
		{ /* percentage of base pairs >= Percent_s */
		  tempPairList[renzokucount][0] = column1;
		  tempPairList[renzokucount][1] = column2;
		  tempPairList[renzokucount][2] = pair_matrix_all_2_s[column1][column2];
		  renzokucount++;
/*		 
#ifdef DEBUG
		    printf("tempPairList = %d,%d,%d\n",
		    column1,column2,pair_matrix_all_2_s[column1][column2]);
		    printf("renzokucount = %d\n",renzokucount);
#endif
*/		 
		}
	      else
		{ /* pair_matrix_all_1_s[column1][column2] < Percent_s */
		  if(renzokucount == 0) /* no pairs yet */
		    ;
		  else if(renzokucount < Renzoku_s) /* consecutive count < Renzoku_s */
		    renzokucount = 0;             /* reset renzokucount */
		  else /* renzokucount >= Renzoku_s */
		    { /* consecutive count is same or more than Renzoku_s -> write to PairListSelected */
		      for(j = 0;j!=renzokucount;j++)
			{
			  PairListSelected[pairCount][0] = tempPairList[j][0];
			  PairListSelected[pairCount][1] = tempPairList[j][1];
			  PairListSelected[pairCount][2] = tempPairList[j][2];
			  pairCount++;
			  
			  /*
			    #ifdef DEBUG 
			    printf("renzoku_s = %d(in A)\n",renzokucount);
			    printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
			    printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
			    #endif
			    */
			}
		      renzokucount = 0; /* reset renzokucount */
		    }
		}
	    }
	  else if(original_hyouji_tableS[column1] == GAP_COLUMN && 
		  original_hyouji_tableS[column2] == GAP_COLUMN)
	     /* both column1 and column2 = gap column */
	    ;
	    
	  else if(original_hyouji_tableS[column1] == GAP_COLUMN)
	    { /* column1 = gap column */
	      column2++;
	    }
	  else if(original_hyouji_tableS[column2] == GAP_COLUMN)
	    { /* column2 = gap column */
	      column1--;
	    }
	  column1++;
	  column2--;
	}
      if( renzokucount >= Renzoku_s) 
	{ /* consecutive count is same or more than Renzoku_s -> write to PairListSelected */
	  for(j = 0;j!=renzokucount;j++)
	    {
	      PairListSelected[pairCount][0] = tempPairList[j][0];
	      PairListSelected[pairCount][1] = tempPairList[j][1];
	      PairListSelected[pairCount][2] = tempPairList[j][2];
	      pairCount++;
/*	      
#ifdef DEBUG 
	      printf("renzoku(outside while loop) = %d\n",renzokucount);
	      printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
	      printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
#endif
*/
	    }
	  renzokucount = 0; /* reset renzokucount */
	}
      else
	renzokucount = 0;
      column1 = column1_start;
    }

  
  column2_start =NoOfColumn-2; 

  for(column2 = column2_start;column2 > 0;column2--)
    {
      column1 = 0;
      column2_start = column2;
/*
#ifdef DEBUG 
      printf("column1,column2 = %d,%d\n",column1,column2);
#endif
*/
      renzokucount = 0;
      while(column1 < column2)
	{
	  if(original_hyouji_tableS[column1] != GAP_COLUMN && original_hyouji_tableS[column2] != GAP_COLUMN)
	    { /* neither column1 nor column2 are gap */
	      
	      if(pair_matrix_all_1_s[column1][column2] >= Percent_s ) 
		{ /* percentage of base pairs >= Percent_s */
		  tempPairList[renzokucount][0] = column1;
		  tempPairList[renzokucount][1] = column2;
		  tempPairList[renzokucount][2] = pair_matrix_all_2_s[column1][column2];
		  renzokucount++;
		  /*
		    #ifdef DEBUG
		    printf("tempPairList = %d,%d,%d\n",
		    column1,column2,pair_matrix_all_2_s[column1][column2]);
		    printf("renzokucount = %d\n",renzokucount);
		    #endif
		    */
		}
	      else
		{ /* pair_matrix_all_1_s[column1][column2] < Percent_s */
		  if(renzokucount == 0) /* no pairs  */
		    ;
		  else if(renzokucount < Renzoku_s) /* consecutive count < Renzoku_s */
		    renzokucount = 0;             /* reset renzokucount */
		  else /* renzokucount >= Renzoku_s */
		    { /* consecutive count is same or more than Renzoku_s -> write to PairListSelected */
		      for(j = 0;j!=renzokucount;j++)
			{
			  PairListSelected[pairCount][0] = tempPairList[j][0];
			  PairListSelected[pairCount][1] = tempPairList[j][1];
			  PairListSelected[pairCount][2] = tempPairList[j][2];
			  pairCount++;
			  /*
			    #ifdef DEBUG 
			    printf("renzoku = %d(in B)\n",renzokucount);
			    printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
			    printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
			    #endif */
			}
		      renzokucount = 0; /* reset renzokucount */
		    }
		}
	    }
	  else if(original_hyouji_tableS[column1] == GAP_COLUMN && original_hyouji_tableS[column2] == GAP_COLUMN)
	    /* both column1 and column2 = gap column */
	    ;
	  
	  else if(original_hyouji_tableS[column1] == GAP_COLUMN)
	    { /* column1 = gap column */
	      column2++;
	    }
	  else if(original_hyouji_tableS[column2] == GAP_COLUMN)
	    { /* column2 = gap column */
	      column1--;
	    }
	  
	  column1++;
	  column2--;
	}
      if( renzokucount >= Renzoku_s) 
	{ /* consecutive count is same or more than Renzoku_s -> write to PairListSelected */
	  for(j = 0;j!=renzokucount;j++)
	    {
	      PairListSelected[pairCount][0] = tempPairList[j][0];
	      PairListSelected[pairCount][1] = tempPairList[j][1];
	      PairListSelected[pairCount][2] = tempPairList[j][2];
	      pairCount++;
/*	      
#ifdef DEBUG 
	      printf("renzoku(in B) = %d\n",renzokucount);
	      printf("Pair[%3d][0] = %2d, ",j, tempPairList[j][0]);
	      printf("Pair[%3d][1] = %2d\n" ,j,tempPairList[j][1]);
#endif */
	    }
	  renzokucount = 0; /* reset renzokucount */
	}
      else
	renzokucount = 0;
      column2 = column2_start;
    }




  PairListSelected[pairCount][0] = MAXIMUM; /* sign the end of PairListSelected */

#ifdef DEBUG
  j  = 0;
  while(PairListSelected[j][0] != MAXIMUM)
    {
      printf("j = %3d,  ",j);
      printf("PairListSelected[%3d][0] = %3d, ",j, PairListSelected[j][0]);
      printf("PairListSelected[%3d][1] = %3d,",j, PairListSelected[j][1]);
      printf("PairListSelected[%3d][2] = %3d\n",j, PairListSelected[j][2]); 
      j++;
    }
   printf("last : PairListSelected[%5d][0] = %d\n",j, PairListSelected[j][0]);
#endif

}

/* ------------------------------------------------------------ */

/* make PairListForHyouji from PairList and original_hyouji_table */
void makePairListForHyouji(select_flag)
     int  select_flag;
  /* select_flag == TRUE -> SELECT */
  /* select_flag == FALSE -> ORIGINAL */
{
  int i,pairBase1,pairBase2;

  i = 0;
  if(!select_flag)
    { /* ORIGINAL */
      while(PairList[i][0] != MAXIMUM)
	{
	  pairBase1 = PairList[i][0];
	  pairBase2 = PairList[i][1];
	  
	  PairListForHyouji[i][0] = original_hyouji_table[pairBase1];
	  PairListForHyouji[i][1] = original_hyouji_table[pairBase2];
	  PairListForHyouji[i][2] = PairList[i][2];
	  PairListForHyouji[i][3] = pairBase1;
	  PairListForHyouji[i][4] = pairBase2;
	  i++;
	}
      
      PairListForHyouji[i][0] = MAXIMUM; /* sign the end of PairListForHyouji */
      
#ifdef DEBUG
      i  = 0;
      while(PairListForHyouji[i][0] != MAXIMUM)
	{
	  printf("PairListForHyouji[%3d][0] = %3d, ",i, PairListForHyouji[i][0]);
	  printf("PairListForHyouji[%3d][1] = %3d, ",i, PairListForHyouji[i][1]);
	  printf("PairListForHyouji[%3d][2] = %3d, ",i, PairListForHyouji[i][2]); 
	  printf("PairListForHyouji[%3d][3] = %3d, ",i, PairListForHyouji[i][3]);
	  printf("PairListForHyouji[%3d][4] = %3d\n ",i, PairListForHyouji[i][4]);
	  i++;
	}
      
#endif 
    }

  if(select_flag)
    { /* SELECT */
      while(PairListSelected[i][0] != MAXIMUM)
	{
	  pairBase1 = PairListSelected[i][0];
	  pairBase2 = PairListSelected[i][1];
	  
	  PairListForHyoujiS[i][0] = original_hyouji_tableS[pairBase1];
	  PairListForHyoujiS[i][1] = original_hyouji_tableS[pairBase2];
	  PairListForHyoujiS[i][2] = PairListSelected[i][2];
	  PairListForHyoujiS[i][3] = pairBase1;
	  PairListForHyoujiS[i][4] = pairBase2;
	  i++;
	}
      
      PairListForHyoujiS[i][0] = MAXIMUM; /* sign the end of PairListForHyoujiS */
      
#ifdef DEBUG
      i  = 0;
      while(PairListForHyoujiS[i][0] != MAXIMUM)
	{
	  printf("PairListForHyoujiS[%3d][0] = %3d, ",i, PairListForHyoujiS[i][0]);
	  printf("PairListForHyoujiS[%3d][1] = %3d, ",i, PairListForHyoujiS[i][1]);
	  /*     printf("PairListForHyoujiS[%3d][2] = %3d, ",i, PairListForHyoujiS[i][2]); */
	  printf("PairListForHyoujiS[%3d][3] = %3d, ",i, PairListForHyoujiS[i][3]);
	  printf("PairListForHyoujiS[%3d][4] = %3d\n ",i, PairListForHyoujiS[i][4]);
	  i++;
	}
      
#endif
    }
}

/* -------------- end of "makePairList.c" ---------------------------- */
