/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ------------------------------------------------------------------- */
/*        hanreiNew.c                                                  */
/*                   write explanatory notes                           */
/* ------------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <sys/types.h>
#include <stdio.h>
#include   <string.h>
#include  "ste.h"
#define COLORS 27 

extern GC gc_hanrei,         /* GC for explanatory notes */
          gc_base[BASES];    /* GC for each base color   */
extern XColor    Colors[COLORS];

struct base_data {
  char *name,      /* name of base */
       *colorname; /* name of color */
  int  mojisuu;    /* number of characters */
};

struct base_data BaseData[6] = {
  "Adenine", "OrangeRed",  7,
  "Uracil",  "IndianRed3", 6,
  "Guanine", "Blue",       7,
  "Cytosine","turquoise",  8,
  "Thymine", "salmon",     7,
  "others",  "gray",       6
  };

struct base_data LineData[3] = {
  "G-C",    "MediumSlateBlue",3,
  "A-T(U)", "VioletRed",      6,
  "G-C+A-T","DarkSeaGreen",   7
  };

XFontStruct *f1; 

/*  write explanatory notes */
void writeHanrei(wd,client_data,cdata)
     Widget     wd;
     caddr_t    client_data;
     XmDrawingAreaCallbackStruct     *cdata;
{
  Display *d;
  Window w1;
/*  XFontStruct *f1; */
/*  Font f1;*/
  int i,arc_x,arc_y,arc_width,arc_height,arc_angle1,arc_angle2,
      line_x1,line_y1,line_x2,
      hanrei_moji_x,hanrei_moji_y,
      font_width,font_height;

  d = XtDisplay(wd);  /* get Display pointer */
  w1 = XtWindow(wd);  /* get Window ID */

/* for debug */
/*  for(i=0;i!=6;i++)
    {
      printf("color for %s => %s\n",BaseData[i].name,BaseData[i].colorname);
    }
*/

/* draw circles */
  arc_x = hanrei_start_x;

  for(i=0;i!=6;i++)
    {
      arc_y = hanrei_start_y + (i%3)*16-10;
      arc_width = 10;       
      arc_height = 10;
      arc_angle1 = 0;
      arc_angle2 = 360*64;
      if(i >= 3)
	arc_x = hanrei_start_x + 90;
      XFillArc(d,w1,gc_base[i],arc_x,arc_y,arc_width,arc_height,arc_angle1,arc_angle2);
    }

  /* explanatory notes on  bases */

  XSetForeground(d,gc_hanrei,MyColor(d,"black"));

  /* find fonts */
   f1 = XLoadQueryFont(d,"a16");
   if(!f1)
      f1 = XLoadQueryFont(d,"a14");
   if(!f1)
      f1 = XLoadQueryFont(d,"9x13");
   if(!f1)
      f1 = XLoadQueryFont(d,"k16");
   if(!f1)
      f1 = XLoadQueryFont(d,"r16");
   if(!f1)
      f1 = XLoadQueryFont(d,"fixed");
   if(!f1)
      f1 = XLoadQueryFont(d,"variable");
   if(!f1)
      f1 = XLoadQueryFont(d,"6x13");
   if(!f1) {
      fprintf(stderr,"Can't find font for explanatory notes\n");
      exit(1);
   }
      /* get height and width of font */
/*  font_width = f1->max_bounds.rbearing; 
      
  font_height = f1->max_bounds.ascent + f1->max_bounds.descent;*/

/*  f1 = XLoadFont(d,"a16"); */
  XSetFont(d,gc_hanrei,f1->fid);
  for(i=0;i!=6;i++)
    {
      if(i >= 3)
	hanrei_moji_x = hanrei_start_x +90 + 20;
      else
	hanrei_moji_x = hanrei_start_x + 20;
      hanrei_moji_y = hanrei_start_y + (i%3)*16;
      XDrawString(d,w1,gc_hanrei,hanrei_moji_x,hanrei_moji_y,BaseData[i].name,BaseData[i].mojisuu);
    }
  /* explanatory notes on line colors  bind base pairs */
  hanrei_moji_x = hanrei_start_x  +90*2+30;
  for(i=0;i!=3;i++)
    {
      hanrei_moji_y = hanrei_start_y + i*16;
      XDrawString(d,w1,gc_hanrei,hanrei_moji_x,hanrei_moji_y,LineData[i].name,LineData[i].mojisuu);
    }

  XSetLineAttributes(d,gc_hanrei,2,LineSolid,CapButt,JoinMiter);

  /* draw lines which bind base pairs */
  line_x1 = hanrei_start_x + 90*2 + 3;
  line_x2 = line_x1 + 20;
  for(i=0;i!=3;i++)
    {
      line_y1 = hanrei_start_y + i*16 - 5;
      XSetForeground(d,gc_hanrei,MyColor(d,LineData[i].colorname));
      XDrawLine(d,w1,gc_hanrei,line_x1,line_y1,line_x2,line_y1);
    }

}

/* ----------------- end of "hanreiNew.c" ---------------------- */
