/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/*    exposeHandle.c                                                       */
/*            handle the exposure events of widget "da"                    */
/* ----------------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>
#include "ste.h"
#include  "stem_s.h"

#define COLORS 27 
#define XSTART 30
#define YSTART 42
#define MAXRECTS 30  /* upper limit of exposed rectangles */


#define DEBUG TRUE


extern Widget da; 
extern Display  *d;
extern Window    win; 
extern GC   gc_da; 
extern Pixmap  pixmap_da;

void exposeHandle(w,c_data,call_data)
     Widget         w;
     caddr_t        c_data;
     XmDrawingAreaCallbackStruct  *call_data;
{
  int       i;
  static XRectangle  exp_rect[MAXRECTS];
  static int exp_rect_count;

  exp_rect_count=0;

/* event reading loop */

  /* make sure static rectangle array is not full */
  if(exp_rect_count < MAXRECTS )
    {
      exp_rect[exp_rect_count].x      = call_data->event->xexpose.x;
      exp_rect[exp_rect_count].y      = call_data->event->xexpose.y;
      exp_rect[exp_rect_count].width  = call_data->event->xexpose.width;
      exp_rect[exp_rect_count].height = call_data->event->xexpose.height;
    }
  exp_rect_count++;
  
/* if exposed regions still exists, return */
  if(call_data->event->xexpose.count != 0)
    return;

  if(call_data->event->xexpose.count == 0)
    {/* last event of series */
      if(exp_rect_count < MAXRECTS )
	{
	  XSetClipRectangles(d,gc_da,0,0,exp_rect,exp_rect_count,Unsorted);
	}
      else
	{ /* too many rectangles,so redraw whole window */
	  XClearWindow(d,win);
	  XSetClipMask(d,gc_da,None);
	}
      /* copy rectangles from pixmap */
      for(i=0;i!=exp_rect_count;i++)
	{
	  XCopyArea(d,pixmap_da,win,gc_da,
		    exp_rect[exp_rect_count].x,exp_rect[exp_rect_count].y,
		    exp_rect[exp_rect_count].width,exp_rect[exp_rect_count].height,
		    exp_rect[exp_rect_count].x,exp_rect[exp_rect_count].y);
#ifdef DEBUG
	  printf("exp_rect_count=%d\n",exp_rect_count);
	  printf("exp_rect[%d].x=%d\n",exp_rect_count,exp_rect[exp_rect_count].x);
	  printf("exp_rect[%d].y=%d\n",exp_rect_count,exp_rect[exp_rect_count].y);
	  printf("exp_rect[%d].width=%d\n",exp_rect_count,exp_rect[exp_rect_count].width);
	  printf("exp_rect[%d].height=%d\n",exp_rect_count,exp_rect[exp_rect_count].height);
#endif
	}
      /* reset exposure count and ready for next event series */
      exp_rect_count = 0;
    }
}


/* ---------- end of "exposeHandle.c" ---------------------------------------- */
