/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* --------------------------------------------------------- */
/*           dispseqs.c                                      */
/* --------------------------------------------------------- */
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>
#include "ste.h"
#include  "stem_s.h"

#define COLORS 27 
#define XSTART 30
#define YSTART 42

/*
#define DEBUG TRUE
*/
extern int nameLength; /* length of seqName */
extern unsigned long MyColor();
extern XColor    Colors[COLORS];
extern Pixmap  pixmap_da;

XFontStruct      *fs;

int  selectMode; /* flag --- select mode or not */

int       height,width;

Display  *d;
Window    win; 
GC   gc_da[9] ;   /* GC for base colors */
GC   gc_for_Num;  /* GC for scale */


void dispSeqs(w)
     Widget         w; 
/*     caddr_t        client_data;
     XmDrawingAreaCallbackStruct  *cdata; */
{
  int       screen;
  int       x, y, x_start,y_start;
  int       i,j,k;
  char     *ptr;
  int     Num,mojisuu,full_Num;
  char    NumString[5];

  if(!daCreated)
    { /* called the first time da (drawing widget for display alignment) is created */
      
      d = XtDisplay(w);
      win = XtWindow(w); 
      screen = DefaultScreen(d);
/*      for(i=0;i!=3;i++) */
	gc_for_Num = XCreateGC(d,win,0,0);
      
      /* load fonts */
      fs = XLoadQueryFont(d,"a14");
/*      if(fs) printf("a14 loaded\n"); */
      if(!fs)
	fs = XLoadQueryFont(d,"9x13");
      if(!fs)
	fs = XLoadQueryFont(d,"k14");
      if(!fs)
	fs = XLoadQueryFont(d,"r14");
      if(!fs)
	fs = XLoadQueryFont(d,"variable");
      if(!fs)
	fs = XLoadQueryFont(d,"fixed");
      if(!fs)
	fs = XLoadQueryFont(d,"6x13");
      if(!fs)
	{
	  fprintf(stderr,"Can't find font for alighnment\n");
	  exit(1);
	}
/*      fs = XLoadQueryFont(d,"a14"); */
      /* get height and width of font */
      width = fs->max_bounds.rbearing; 
      
      height = fs->max_bounds.ascent + fs->max_bounds.descent;
      /*
	printf("width = %d, height = %d\n",width,height);
	*/  
      /* set colors to GC */
      
      for(i=0;i!=9;i++)
	gc_da[i] = XCreateGC(d,win,0,0);
      
      
      for(i=0;i!=9;i++)
	{
	  switch(i)
	    {
	    case ADE:
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],Colors[0].pixel);
	      break;
	    case URA:
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],Colors[1].pixel);
	      break;
	    case GUA:
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],Colors[6].pixel);
	      break;
	    case CIT:
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],Colors[2].pixel);
	      break;
	    case TIM:
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],Colors[19].pixel);
	      break;
	    case OTHER: 
	      XSetForeground(d,gc_da[i],Colors[25].pixel);
	      break;
	    case GAP: /* gap */
	      XSetForeground(d,gc_da[i],MyColor(d,"white"));
	      XSetBackground(d,gc_da[i],Colors[26].pixel);
	      break;
	    case 7: /* pair */
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],MyColor(d,"white"));
	      break;
	    case 8: /* pair for selected sequences*/
	      XSetForeground(d,gc_da[i],MyColor(d,"black"));
	      XSetBackground(d,gc_da[i],MyColor(d,"Yellow"));
	      break;
	    }
	  XSetFont(d,gc_da[i],fs->fid);
	}
      daCreated = TRUE;
    }

  if(!file_flag) /* data file is not read */
    {
      XSetForeground(d,gc_for_Num,MyColor(d,"black"));
      XFillRectangle(d,pixmap_da,gc_for_Num,0,0,1000,1000);  
    }
    
  else
    { /* data file is read */
      /* clear  window */
      
      XSetForeground(d,gc_for_Num,MyColor(d,"black"));
      XFillRectangle(d,pixmap_da,gc_for_Num,0,0,1000,1000);  
      
      /*  draw scale */
      
      XSetFont(d,gc_for_Num,fs->fid);
      XSetForeground(d,gc_for_Num,MyColor(d,"white"));
      
      x = XSTART + (nameLength+1)*width;
      y = YSTART - height*2;
      Num = 0;
      full_Num =( NoOfColumn/10 +1 ) * 10 +1;
      for(i = 0;i!=full_Num;i++)
	{
	  if((i % 10 ) == 0)
	    XDrawString(d,pixmap_da,gc_for_Num,x,y,"0",1);
	  if((i % 10 ) == 9 && i > 0)
	    {
	      Num = i / 10 + 1;
	      /*	  printf("Num = %d ",Num); */
	      mojisuu = NumberToString(Num,NumString);
	      XDrawString(d,pixmap_da,gc_for_Num,x,y,NumString,mojisuu);
	    }
	  else
	    ;
	  x = x + width;
	}
      y = y+height;
      x = XSTART + (nameLength+1)*width;
      for(i = 0;i!=full_Num;i++)
	{
	  if((i % 10 ) == 0)
	    {
	      XDrawString(d,pixmap_da,gc_for_Num,x,y,"|",1);
	    }
	  else
	    XDrawString(d,pixmap_da,gc_for_Num,x,y,"-",1);
	  x = x + width;
	}
      
      
      /* draw alignments */
      
      /* draw each sequence's name */
      
      x_start = XSTART;
      y_start = YSTART;
      x = x_start;
      y = y_start;
      
      for(i = 0;i!=NoOfSeqs;i++)
	{
	  ptr = seq_names[i];
	  if(selectMode && selectedSeqs[i] == TRUE)  /* current sequence is selected one */
	    XSetBackground(d,gc_for_Num,MyColor(d,"gray"));
	  else
	    XSetBackground(d,gc_for_Num,MyColor(d,"black"));
	  XDrawImageString(d,pixmap_da,gc_for_Num,x,y,seq_names[i], nameLength); 
	  
	  y = y + height;
	}
      
      /* next,draw alignment */
      x_start = x_start + (nameLength+1)*width ;
      y_start = YSTART;
      x = x_start;
      y = y_start;
      
      for(i = 0;i!=NoOfSeqs;i++)
	{
	  ptr = sequences[i];

#ifdef DEBUG
	    printf("sequence[%d] = %s\n",i,ptr);
#endif      

	  while(*ptr != '\0')
	    {
	      switch(*ptr)
		{
		case 'A':
		  XDrawImageString(d,pixmap_da,gc_da[ADE],x,y,"A",1);
		  break;
		case 'C':
		  XDrawImageString(d,pixmap_da,gc_da[CIT],x,y,"C",1);
		  break;
		case 'G':
		  XDrawImageString(d,pixmap_da,gc_da[GUA],x,y,"G",1);
		  break;
		case 'T':
		  XDrawImageString(d,pixmap_da,gc_da[TIM],x,y,"T",1);
		  break;
		case 'U':
		  XDrawImageString(d,pixmap_da,gc_da[URA],x,y,"U",1);
		  break;
		case '-':  /* gap */
		  XDrawImageString(d,pixmap_da,gc_da[GAP],x,y,"-",1);
		  break;
		default:  /* unknown base */
		  XDrawImageString(d,pixmap_da,gc_da[OTHER],x,y," ",1);
		  break;
		}
	      x = x + width; 
	      ptr++;
	    }
/*	  printf("seq %2d drawed\n",i); */
	  x = x_start;
	  y = y + height;
	}
    }
}


/* ---------------------- end of "dispseqs.c" ------------------------ */
