/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ----------------------------------------------------------------------- */
/*    dispPairs.c                                                          */
/*            emphasize selected base pairs                                */
/* ----------------------------------------------------------------------- */

#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>
#include "ste.h"
#include  "stem_s.h"

#define COLORS 27 
#define XSTART 30
#define YSTART 42

/*
#define DEBUG TRUE
*/
extern int nameLength; 
extern unsigned long MyColor();
extern XColor    Colors[COLORS];
extern XFontStruct      *fs;
extern Pixmap    pixmap_da;

extern   int ItemSelected;
extern   int    dispPairs; /* flag for emphasize selected base pairs or not */

extern   int check_pair();

extern Widget da; 

extern int       height,width;

extern Display  *d;
/*
extern Window    win; 
*/
extern GC   gc_da[8] ; 


void dispSelectedPair(w,columns,cdata)
     Widget         w;
     int            columns[MAXPAIRS][2]; /* column numbers of selected base pairs */
     XmAnyCallbackStruct  *cdata;
{
  int       x, y, x_start,y_start,x_temp;
  int       i,j,k;
  char     *ptr ,*ptrTemp;
  int     pairCheck; 
  int     col1,col2,previous_col1;
/*
  printf("dispPairs = %d\n",dispPairs);
*/
  if(!dispPairs)
    ; /* not emphasize base pairs */
  else
    { /* emphasize base pairs */
      x_start = XSTART;
      y_start = YSTART;
/*      
      printf("ItemSelected = %d\n",ItemSelected); 
*/      
      if(ItemSelected)
	{      /* base pairs is selected from list */
	  x_start = x_start + (nameLength+1)*width ;
	  x = x_start;
	  y = y_start;
	  
	  for(i = 0;i!=NoOfSeqs;i++)
	    {
	      ptr = sequences[i];
	      previous_col1 =  0;
	      for(j=0;j!=ItemSelected;j++)
		{
		  col1 = columns[j][0];
		  col2 = columns[j][1];
		  
		  /* check pairs */
		  if(col1 > col2 )
		    pairCheck = check_pair(i,col2,col1);
		  else
		    pairCheck = check_pair(i,col1,col2);
		  
		  if(pairCheck != FALSE)
		    { /* bases of column1 and column2 make base pair 
                         in this sequence        */
		      /* set ptr to  col1  */
		      for(k = previous_col1;k!=col1;k++)
			{
			  ptr++;
			  x = x+width;
			}
		      switch(*ptr)
			{ /* emphasize base at  column1 */
			  case'A':
			  XDrawImageString(d,pixmap_da,gc_da[7],x,y,"A",1);
			  break;
			case 'C':
			  XDrawImageString(d,pixmap_da,gc_da[7],x,y,"C",1);
			  break;
			case 'G':
			  XDrawImageString(d,pixmap_da,gc_da[7],x,y,"G",1);
			  break;
			case 'T':
			  XDrawImageString(d,pixmap_da,gc_da[7],x,y,"T",1);
			  break;
			case 'U':
			  XDrawImageString(d,pixmap_da,gc_da[7],x,y,"U",1);
			  break;
			default: /* unknown base */
			  XDrawImageString(d,pixmap_da,gc_da[OTHER],x,y," ",1);
			  break;
			}
		      /*   printf("change color for column[%2d],%c ",col1,*ptr); */
		      ptrTemp = ptr;
		      x_temp = x;
		      /* set ptr to  column2 */
		      for(k = col1;k!=col2;k++)
			{
			  ptrTemp++;
			  x_temp = x_temp + width;
			}
		      switch(*ptrTemp)
			{ /* emphasize base at column2 */
			  case'A':
			  XDrawImageString(d,pixmap_da,gc_da[7],x_temp,y,"A",1);
			  break;
			case 'C':
			  XDrawImageString(d,pixmap_da,gc_da[7],x_temp,y,"C",1);
			  break;
			case 'G':
			  XDrawImageString(d,pixmap_da,gc_da[7],x_temp,y,"G",1);
			  break;
			case 'T':
			  XDrawImageString(d,pixmap_da,gc_da[7],x_temp,y,"T",1);
			  break;
			case 'U':
			  XDrawImageString(d,pixmap_da,gc_da[7],x_temp,y,"U",1);
			  break;
			default: /* unknown base */
			  XDrawImageString(d,pixmap_da,gc_da[OTHER],x_temp,y," ",1);
			  break;
			}
		      /*  printf("change color for column[%2d],%c\n",col2,*ptrTemp); */
		      previous_col1 = col1;
		    }
		  else
		    ;
		}
	      x = x_start;
	      y = y + height;
	    }
	}
    }
}


/* ---------- end of "dispPairs.c" ---------------------------------------- */
