/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* ---------------------------------------------------------------- */
/*       dispCircleNew.c                                            */
/* ---------------------------------------------------------------- */
#include <X11/StringDefs.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <math.h>
#include <Xm/DrawingA.h>
#include "ste.h"
#include "stem_s.h"

#define SUUJI_AKI   50  /* distance between circle and number */
/*
#define DEBUG TRUE 
*/
double aki;   /* angle of opening in circle */
int    hanreiHyouji; /* flag for write explanatory notes */

extern unsigned long MyColor();
extern GC gc_h ,select_gc;
extern GC gc_base[BASES];
extern void calc_zahyou_data();
extern void hyoujiPairNumber();
extern Widget circle_da,hanrei_da,da;
extern int initial_da_width;     
extern int initial_da_height;    
extern int current_da_width;     
extern int current_da_height;    
extern int default_hankei;    /* default radius */

void dispCircle_1(wd,select_flag)
     Widget     wd;
     int       select_flag;
{
  Display *d;
  Window  w0;
  GC      gc;

  int l,     /* diameter  */
  count1,base,n1,n2,new_hankei;
  static int    n1_x,n1_y,n2_x,n2_y; 
  double    angle1,
  drawAngle1,drawAngle2;
  unsigned long    color;
  
  d = XtDisplay(wd);  /* get Display pointer */
  w0 = XtWindow(wd);  /* get window ID */
/*  printf("dispCircle_1 called\n"); */

  l =  hankei*2;   /* get diameter length */
  
  if(percentChanged || renzokuChanged || resized)
    { /* "percent" or consensus or widget size changed */
/*      printf("scale value changed\n"); */
/*      printf("current:width = %d, height = %d\n",current_da_width,current_da_height); */
      XClearArea(d,w0,0,0,current_da_width,current_da_height,False);  
      percentChanged = FALSE;
      renzokuChanged = FALSE;
    }
  
  /* draw circle with base colors */
  angle1 = aki + 90; /* set initial angle */
  drawAngle1 = angle*64; /* get angle for 1 base (column) */
  
  for(count1 = 0;count1 != NoOfHyoujiColumn;count1++)
    {
      base = consensus_for_hyouji[count1];
      drawAngle2 = angle1*64;
      XDrawArc(d,w0,gc_base[base],xarc0,yarc0,l,l,(int)drawAngle2,(int)drawAngle1);
      angle1 = angle1+angle; 
    }
  
  /* create GC for lines and set attributes */
  gc = XCreateGC(d,w0,0,0); 
  XSetLineAttributes(d,gc,LINE_W2,LineSolid,CapButt,JoinMiter);
  
  
  count1 = 0;
  
  while(PairListForHyouji[count1][0] != MAXIMUM)
    {
      /* get column number of base pair */
      n1 = PairListForHyouji[count1][0];
      n2 = PairListForHyouji[count1][1];
      
      n1_x=zahyou_table[n1][0];      /* location of column1 */
      n1_y=zahyou_table[n1][1];
      n2_x=zahyou_table[n2][0];      /* location of column2 */
      n2_y=zahyou_table[n2][1];
      
      switch(PairList[count1][2])
	{ /* change colors according to the kind of base pair */
	case A_T:  color = MyColor(d,"VioletRed"); /* A-T(U) */  break; 
	case G_C:  color = MyColor(d,"MediumSlateBlue"); /* G-C */  break;
	case BOTH:  color = MyColor(d,"DarkSeaGreen"); /* A-T+G-C */   break;
	default:  color = MyColor(d,"white"); /* unknown pair */ break;
	}
      
      XSetForeground(d,gc,color);		      
      XDrawLine(d,w0,gc,n1_x,n1_y,n2_x,n2_y); /* draw lines between base pairs */
      count1++;
    }
}



void dispCircle(wd,select_flag,cdata) 
     Widget       wd;
     int          select_flag;
     XmDrawingAreaCallbackStruct     *cdata;
{

  dispCircle_1(circle_da,ORIGINAL);
  
  if(!hanreiHyouji)    /* window is too small to write explanatory note */
    XtUnmapWidget(hanrei_da);
  else                 /* write explanatory notes */
    XtMapWidget(hanrei_da);
  if(file_flag)     
    hyoujiPairNumber(circle_da,ORIGINAL); /* write pair numbers */

}  


void dispCircleS(wd,client_data,cdata) /* called when select mode */
     Widget     wd;
     caddr_t    client_data;
     XmDrawingAreaCallbackStruct     *cdata;
{
  
  Display *d;
  Window w0;
  GC gc;

  int l,     /* diameter */
  count1,base,n1,n2;
  static int    n1_x,n1_y,n2_x,n2_y; 
  double    angle1,
  drawAngle1,drawAngle2;
  unsigned long    color;
  
  d = XtDisplay(wd);  /* get Display pointer */
  w0 = XtWindow(wd);  /* get window ID */
  
  l =  hankei_s*2;   /* get diameter length */
  
  if(percentChangedS || renzokuChangedS)
    { /* Percent_s or  Renozku_s (consencutive) changed */
      XClearArea(d,w0,0,0,500,500,False); 
      percentChangedS = FALSE;
      renzokuChangedS = FALSE;
    }
  
  
  /* draw circle */
#ifdef DEBUG
  printf("diameter = %5d\n",l);
  printf("xarc0_s = %3d  yarc0_s = %3d\n",xarc0_s,yarc0_s);
#endif

  angle1 = aki_s + 90; /* set initial angle */
  drawAngle1 = angle_s*64; /* angle for 1 base */
  for(count1 = 0;count1 != NoOfHyoujiColumnS;count1++)
    {
      base = consensus_for_hyoujiS[count1];
      drawAngle2 = angle1*64;
      XDrawArc(d,w0,gc_base[base],xarc0_s,yarc0_s,l,l,(int)drawAngle2,(int)drawAngle1);
      angle1 = angle1+angle_s; 
    }
  
  /* create GC for lines and set attributes */
  gc = XCreateGC(d,w0,0,0); 
  XSetLineAttributes(d,gc,LINE_W2,LineSolid,CapButt,JoinMiter);
  
  count1 = 0;
  
  while(PairListForHyoujiS[count1][0] != MAXIMUM)
    {
      /* get column number of base pairs in selected sequences */
      n1 = PairListForHyoujiS[count1][0];
      n2 = PairListForHyoujiS[count1][1];
      
      n1_x=zahyou_table_s[n1][0];   /* location of column 1 */
      n1_y=zahyou_table_s[n1][1];
      n2_x=zahyou_table_s[n2][0];   /* location of column 2 */
      n2_y=zahyou_table_s[n2][1];
      
      switch(PairListSelected[count1][2])
	{ /* change line colors according to the kind of base pair */
	case A_T:  color = MyColor(d,"VioletRed"); /* A-T(U) */  break; 
	case G_C:  color = MyColor(d,"MediumSlateBlue"); /* G-C */  break;
	case BOTH:  color = MyColor(d,"DarkSeaGreen"); /* A-T+G-C */   break;
	default:  color = MyColor(d,"white"); /* unknown pair */ break;
	}
      
      XSetForeground(d,gc,color);		      
      XDrawLine(d,w0,gc,n1_x,n1_y,n2_x,n2_y); /* draw lines */
      count1++;
    }
  hyoujiPairNumber(wd,SELECT); /* write number */
}  


/* decide write explanatory note or not */
int decideHanreiHyouji(current_da_width)
     int  current_da_width;
{
  int hyoujiSpace;

  hyoujiSpace = current_da_width - ( 70   +      100*2  +      12);
                           /* close_button  *//* 2 scales */ /* offset */

  if(hyoujiSpace <= 282) /* window is too small  */
    return FALSE;
  else
    return TRUE;
}


/* called when size of circle_da changed */
void resize(wd,select_flag,cdata)
     Widget     wd;
     int        select_flag;
     XmDrawingAreaCallbackStruct *cdata;
{
  int n,new_width,new_height,new_hankei1,new_hankei2,new_hankei;
  Arg   args[2];
  Dimension width_d,height_d;
/*      printf("circle_da size changed ");  */
  /* size of circle_da changed  */

  /* get new width and height */
  n=0;
  XtSetArg(args[n],XtNwidth,&width_d);
  n++;
  XtSetArg(args[n],XtNheight,&height_d);
  n++;
  XtGetValues(wd,args,n);

  new_width = (int)width_d;
  new_height = (int)height_d;
  
/*  printf("new_width = %d, new_height = %d\n",new_width,new_height);
*/

  if(current_da_width != new_width || current_da_height != new_height)
    {
      current_da_width = new_width;
      current_da_height = new_height;
      
      new_hankei1 = new_width * default_hankei/initial_da_width;
      new_hankei2 = new_height * default_hankei / initial_da_height;
      
      /*  printf("new_hankei1 = %d,new_hankei2 = %d\n",new_hankei1,new_hankei2); */
      /* set new radius according to new width or new height */
      new_hankei = new_hankei1 < new_hankei2 ? new_hankei1:new_hankei2;
      
      if (new_hankei < 50)   /* lower limit of radius */
	new_hankei = 50;
      hankei = new_hankei;
      resized = TRUE;
/*      printf("new hankei = %d\n",hankei); */
      calc_zahyou_data(ORIGINAL); /* calculate location according to new radius */
      hanreiHyouji = decideHanreiHyouji(current_da_width);
      dispCircle(wd,select_flag,cdata);
    }
}


/* -------------- end of "dispCircleNew.c" ------------------------------- */
