/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------*/
/*     colormap.c                                                  */
/*        create colormap                                          */
/*-----------------------------------------------------------------*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#define COLORS 27 
#define BASES  7
Colormap     myCmap;
XColor    Colors[COLORS]; 

/* this color map is  accordant to that of "alignment editor (nucleic acid mode) " */
unsigned long  my_color[COLORS][3] = {
    65535L,  18866L,   9930L,      /* A */
     4608L,  55808L,   5888L,      /* B */ 
        0L,  65535L,  44683L,      /* C */
     4608L,  55808L,   5888L,      /* D */
     4608L,  55808L,   5888L,      /* E */
    47104L,   1792L,  47360L,      /* F */
        0L,  37732L,  65535L,      /* G */
        0L,    256L,  65280L,      /* H */
    65280L,   8960L,   9728L,      /* I */
        0L,      0L,      0L,      /* J */
        0L,    256L,  65280L,      /* K */
    65280L,   8960L,   9728L,      /* L */
    65280L,   8960L,   9728L,      /* M */
    65535L,  65535L,  65535L,      /* N */
        0L,      0L,      0L,      /* O */
    63744L,  46336L,  27904L,      /* P */
     8192L,  65280L,  27136L,      /* Q */
        0L,    256L,  65280L,      /* R */
     3584L,  60928L,  60672L,      /* S */
    65535L,  37732L,  12908L,      /* T */
        0L,      0L,      0L,      /* U */
    65280L,   8960L,   9728L,      /* V */
    31744L,   1024L,  47872L,      /* W */
        0L,      0L,      0L,      /* X */
    48655L,      0L,  43690L,      /* Y */
    20000L,  20000L,  20000L,      /* Z */
      100L,    100L,    100L       /* gap */
};



void   createColormap(w)
     Widget        w;
{
  int       i;
  int       screen;
  Display   *d;

  d = XtDisplay(w);
  screen = DefaultScreen(d);
  myCmap = DefaultColormap(d,screen);
  
  /* create color map */
  for(i=0;i!=COLORS;i++)
    {
      Colors[i].red    = my_color[i][0];
      Colors[i].green  = my_color[i][1];
      Colors[i].blue   = my_color[i][2];
    }
      
  for(i=0;i!=COLORS;i++)
    { 
      XAllocColor(d,myCmap,&Colors[i]);
    } 
}  
  
/*-------------- end of "colormap.c" ------------------------------*/
