/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------*/
/*     circleSelect.c                                              */
/*        make widgets and callback functions for                  */
/*                circular representation (for selected sequences) */
/*-----------------------------------------------------------------*/


#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <sys/types.h>
#include <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include  "ste.h"
#include  "stem_s.h"
#define COLORS 27 

#define DEBUG TRUE

extern void scale_callback_percent();
extern void scale_callback_renzoku();
extern void createListS();
extern void dispCircleS(); /* draw circle (select mode) */
extern void selectUndispSelect();


Widget  select_form, select_da,select_frame,select_scale_p,select_scale_r; 
extern Widget select_list_pair,select_pop;

/* called when "close" button pushed */
void select_close(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  if(select_list_pair)
    selectUndispSelect(w,client_data,call_data);
  XtPopdown(select_pop);
}



void createCircleS(parent)
     Widget     parent;
{
  Widget pb_select_close;
  Arg    args[10];
  int    n ;
  
  /* create popup shell */
  
  select_pop = XtCreatePopupShell("select_pop",topLevelShellWidgetClass,parent,NULL,0);
  n = 0;
  XtSetArg(args[n],XmNwidth,500);
  n++;
  XtSetArg(args[n],XmNheight,500);
  n++;
  XtSetArg(args[n],XmNminWidth,550);
  n++;
  XtSetArg(args[n],XmNminHeight,500);
  n++;
  XtSetValues(select_pop,args,n);
  
  /* create form  */
  select_form = XtCreateManagedWidget("select_form",xmFormWidgetClass,select_pop,NULL,0);
  
  /* create push button "close" and add callback function */
  pb_select_close = XmCreatePushButton(select_form,"pb_select_close",NULL,0);  /* close */
  XtManageChild(pb_select_close);
  XtAddCallback(pb_select_close,XmNactivateCallback,select_close,NULL);

  /* create "percent" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Percent); /* set parent's Percent value */
  n++;
  XtSetArg(args[n],XmNleftWidget,pb_select_close);
  n++;
  select_scale_p = XmCreateScale(select_form,"select_scale_p",args,n);
  XtManageChild(select_scale_p);
  XtAddCallback(select_scale_p,XmNvalueChangedCallback,scale_callback_percent,SELECT);
  
  /* create "consecutive" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Renzoku); /* set parent's consecutive value */
  n++;
  XtSetArg(args[n],XmNleftWidget,select_scale_p);
  n++;
  select_scale_r = XmCreateScale(select_form,"select_scale_r",args,n);
  XtManageChild(select_scale_r);
  XtAddCallback(select_scale_r,XmNvalueChangedCallback,scale_callback_renzoku,SELECT);

  /* create list */
  createListS(select_form);
  
  /* create drawingArea */
  /* create frame */
  select_frame = XmCreateFrame(select_form,"select_frame",NULL,0);
  XtManageChild(select_frame); 
  select_da = XmCreateDrawingArea(select_frame,"select_da",NULL,NULL);
  XtManageChild(select_da);

  XtRealizeWidget(select_pop);

  XtAddCallback(select_da,XmNexposeCallback,dispCircleS,NULL); 

}

/*-------------- end of "circleSelect.c" ------------------------------*/
