/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"
#include "aedit.h"
#include "align.h"

#define CONSNUM 100

tree_base()
{
  struct DATA0 d0;
  struct ALIGN ps;
  int i,j,k,leng;

  readSeq_tree(&ps,&d0);

  for(j=0;j<ps.SeqNum;j++){
    for(i=j+1;i<ps.SeqNum;i++){

      d0.X = ps.Leng[i];
      d0.Y = ps.Leng[j];
      d0.NumX = 1;
      d0.NumY = 1;

      for(k=0;k<ps.Leng[i];k++){
	d0.CSeq1[0][k] = ps.CSeq[i][k];
	d0.Seq1[0][k] = ps.Seq[i][k];
      }
      for(k=0;k<ps.Leng[j];k++){
	d0.CSeq2[0][k] = ps.CSeq[j][k];
	d0.Seq2[0][k] = ps.Seq[j][k];
      }

      generateD_00(&d0);

      if(d0.J % 2 == 0) ps.CMatrix[i][j] = d0.Vec0[d0.I].xy;
      if(d0.J % 2 == 1) ps.CMatrix[i][j] = d0.Vec1[d0.I].xy;

    }
  }

  for(i=0;i<ps.SeqNum-1;i++){
    minimumCost(&ps,&d0);
  }
  leng = ps.Leng[0];
  writeSeq_align(&ps,&d0,leng);
}


minimumCost(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k,m,cost=1000000000;
  int newcost,oldcost,pos;
  int mx,my;

  for(j = 0;j < fs->SeqNum;j++){
    for(i = j+1;i < fs->SeqNum;i++){
      newcost = fs->CMatrix[i][j];
      if(newcost < cost){
	cost = newcost;
	fs->R1 = j;
	fs->R2 = i;
      }
    }
  }

  d0->X = fs->Leng[fs->R2];
  d0->Y = fs->Leng[fs->R1];
  
  d0->NumX = fs->Num[fs->R2];
  d0->NumY = fs->Num[fs->R1];

  for(i=0;i<d0->NumX;i++){
    m = fs->NumVec[fs->R2][i];
    k = 0;
    while(fs->CSeq[m][k] == '-'){
      fs->CSeq1_C[i][k] = '#';
      fs->Seq1_C[i][k] = fs->Seq[m][k];
      fs->Cons1_C[i][k] = fs->Cons[m][k];
      k++;
    }
    while(k<d0->X){
      fs->CSeq1_C[i][k] = fs->CSeq[m][k];
      fs->Seq1_C[i][k] = fs->Seq[m][k];
      fs->Cons1_C[i][k] = fs->Cons[m][k];
      k++;
    }
    k--;
    while(fs->CSeq[m][k] == '-'){
      fs->CSeq1_C[i][k] = '#';
      k--;
    }
  }
  for(i=0;i<d0->NumY;i++){
    m = fs->NumVec[fs->R1][i];
    k = 0;
    while(fs->CSeq[m][k] == '-'){
      fs->CSeq2_C[i][k] = '#';
      fs->Seq2_C[i][k] = fs->Seq[m][k];
      fs->Cons2_C[i][k] = fs->Cons[m][k];
      k++;
    }
    while(k<d0->Y){
      fs->CSeq2_C[i][k] = fs->CSeq[m][k];
      fs->Seq2_C[i][k] = fs->Seq[m][k];
      fs->Cons2_C[i][k] = fs->Cons[m][k];
      k++;
    }
    k--;
    while(fs->CSeq[m][k] == '-'){
      fs->CSeq2_C[i][k] = '#';
      k--;
    }
  }

  pos = constraint(fs,d0);

  for(i=0;i<d0->NumX;i++){
    mx = fs->NumVec[fs->R2][i];
    for(j=0;j<pos;j++){
      fs->CSeq[mx][j] = fs->DCSeq[mx][j];
      fs->Seq[mx][j] = fs->DSeq[mx][j];
      fs->Cons[mx][j] = fs->DCons[mx][j];
    }
  }
  for(i=0;i<d0->NumY;i++){
    my = fs->NumVec[fs->R1][i];
    for(j=0;j<pos;j++){
      fs->CSeq[my][j] = fs->DCSeq[my][j];
      fs->Seq[my][j] = fs->DSeq[my][j];
      fs->Cons[my][j] = fs->DCons[my][j];
    }
  }

  for(j=0;j<fs->R1;j++){
    oldcost = fs->CMatrix[fs->R1][j];
    fs->CMatrix[fs->R1][j] = ( fs->CMatrix[fs->R2][j] + oldcost ) / 2;
  }
  for(i=fs->R1+1;i<fs->R2;i++){
    oldcost = fs->CMatrix[i][fs->R1];
    fs->CMatrix[i][fs->R1] = ( fs->CMatrix[fs->R2][i] + oldcost ) / 2;
  }
  for(i = fs->R2+1;i < fs->SeqNum;i++){
    oldcost = fs->CMatrix[i][fs->R1];
    fs->CMatrix[i][fs->R1] = ( fs->CMatrix[i][fs->R2] + oldcost ) / 2;
  }

  for(i=0;i<fs->R2;i++){
    fs->CMatrix[fs->R2][i] = 1000000000;
  }

  for(i = fs->R2+1;i < fs->SeqNum;i++){
    fs->CMatrix[i][fs->R2] = 1000000000;
  }

  fs->Leng[fs->R1] = pos;
  fs->Leng[fs->R2] = 0;

  fs->Num[fs->R1] = d0->NumX + d0->NumY;
  fs->Num[fs->R2] = 0;

  j = d0->NumY;
  for(i=0;i<d0->NumX;i++){
    fs->NumVec[fs->R1][j] = fs->NumVec[fs->R2][i];
    j++;
  }
}



int constraint(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k;
  int x1,y1,a,b,pos=0;
  int mx,my;

  char ConsNum[CONSNUM];
  int ConsPos1[CONSNUM];
  int ConsPos2[CONSNUM];
  int ConsN;

  k = 0;
  for(i=0;i<d0->X;i++){
    for(j=0;j<d0->NumX;j++){
      if(fs->Cons1_C[j][i] > 96){
	for(a=0;a<d0->Y;a++){
	  for(b=0;b<d0->NumY;b++){
	    if(fs->Cons2_C[b][a] > 96){
/*	      if(fs->Cons1_C[j][i] < fs->Cons2_C[b][a]) goto label1;*/
	      if(fs->Cons1_C[j][i] == fs->Cons2_C[b][a]){
		ConsNum[k] = fs->Cons1_C[j][i];
		ConsPos1[k] = i;
		ConsPos2[k] = a;
		k++;
		goto label1;
	      }
	      else {}
	      break;
	    }
	    else {}
	  }
	}
      }
      else {}
    }
  label1:{}
  }

  ConsN = k;
  if(ConsN > 0){
    d0->X = ConsPos1[0] + 1;
    d0->Y = ConsPos2[0] + 1;
    x1 = d0->X - 1;
    y1 = d0->Y - 1;
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<x1;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
      d0->Seq1[i][x1] = 14;
      d0->CSeq1[i][x1] = fs->CSeq1_C[i][x1];
      fs->Cons1[i][x1] = fs->Cons1_C[i][x1];
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<y1;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
      d0->Seq2[i][y1] = 14;
      d0->CSeq2[i][y1] = fs->CSeq2_C[i][y1];
      fs->Cons2[i][y1] = fs->Cons2_C[i][y1];
    }
    generateD_00(d0);
    pos = makeAlignmentString1(fs,d0,pos);
    pos--;
    for(k=1;k<ConsN;k++){
      d0->X = ConsPos1[k] - ConsPos1[k-1] + 1;
      d0->Y = ConsPos2[k] - ConsPos2[k-1] + 1;
      x1 = d0->X - 1;
      y1 = d0->Y - 1;
      for(i=0;i<d0->NumX;i++){
	a = ConsPos1[k-1];
	d0->Seq1[i][0] = 14;
	d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
	fs->Cons1[i][0] = fs->Cons1_C[i][a];
	a++;
	for(j=1;j<x1;j++){
	  d0->Seq1[i][j] = fs->Seq1_C[i][a];
	  d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	  fs->Cons1[i][j] = fs->Cons1_C[i][a];
	  a++;
	}
	d0->Seq1[i][x1] = 14;
	d0->CSeq1[i][x1] = fs->CSeq1_C[i][a];
	fs->Cons1[i][x1] = fs->Cons1_C[i][a];
      }
      for(i=0;i<d0->NumY;i++){
	b = ConsPos2[k-1];
	d0->Seq2[i][0] = 14;
	d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
	fs->Cons2[i][0] = fs->Cons2_C[i][b];
	b++;
	for(j=1;j<y1;j++){
	  d0->Seq2[i][j] = fs->Seq2_C[i][b];
	  d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	  fs->Cons2[i][j] = fs->Cons2_C[i][b];
	  b++;
	}
	d0->Seq2[i][y1] = 14;
	d0->CSeq2[i][y1] = fs->CSeq2_C[i][b];
	fs->Cons2[i][y1] = fs->Cons2_C[i][b];
      }
      generateD_00(d0);
      pos = makeAlignmentString(fs,d0,pos);
      pos--;
    }
    
    d0->X = fs->Leng[fs->R2] - ConsPos1[ConsN-1];
    d0->Y = fs->Leng[fs->R1] - ConsPos2[ConsN-1];
    for(i=0;i<d0->NumX;i++){
      a = ConsPos1[ConsN-1];
      d0->Seq1[i][0] = 14;
      d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
      fs->Cons1[i][0] = fs->Cons1_C[i][a];
      a++;
      for(j=1;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][a];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	fs->Cons1[i][j] = fs->Cons1_C[i][a];
	a++;
      }
    }
    for(i=0;i<d0->NumY;i++){
      b = ConsPos2[ConsN-1];
      d0->Seq2[i][0] = 14;
      d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
      fs->Cons2[i][0] = fs->Cons2_C[i][b];
      b++;
      for(j=1;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][b];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	fs->Cons2[i][j] = fs->Cons2_C[i][b];
	b++;
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString(fs,d0,pos);
  }
  else {
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString1(fs,d0,pos);
  }

  return pos;
}


int makeAlignmentString(fs,d0,pos)
struct ALIGN *fs;
struct DATA0 *d0;
int pos;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	mx = fs->NumVec[fs->R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || 
	   d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 26;
	  ACons[mx][i] = 95;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	  ACons[mx][i] = fs->Cons1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	mx = fs->NumVec[fs->R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || 
	   d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 26;
	  ACons[mx][i] = 95;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	  ACons[mx][i] = fs->Cons1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	mx = fs->NumVec[fs->R2][k];
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      for(k=0;k<d0->NumY;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  for(k=0;k<d0->NumX;k++){
    mx = fs->NumVec[fs->R2][k];
    if(ASeq[mx][Leng-1] == 14 && ACSeq[mx][Leng-1] != 'O'){
      fs->DSeq[mx][pos] = ACSeq[mx][Leng-1] - 'A';
    }
    else {
      fs->DSeq[mx][pos] = ASeq[mx][Leng-1];
    }
    fs->DCSeq[mx][pos] = ACSeq[mx][Leng-1];
    fs->DCons[mx][pos] = ACons[mx][Leng-1];
    j = pos+1;
    for(i=Leng-2;i>-1;i--){
      fs->DCSeq[mx][j] = ACSeq[mx][i];
      fs->DSeq[mx][j] = ASeq[mx][i];
      fs->DCons[mx][j] = ACons[mx][i];
      j++;
    }
  }
  for(k=0;k<d0->NumY;k++){
    my = fs->NumVec[fs->R1][k];
    if(ASeq[my][Leng-1] == 14 && ACSeq[my][Leng-1] != 'O'){
      fs->DSeq[my][pos] = ACSeq[my][Leng-1] - 'A';
    }
    else {
      fs->DSeq[my][pos] = ASeq[my][Leng-1];
    }
    fs->DCSeq[my][pos] = ACSeq[my][Leng-1];
    fs->DCons[my][pos] = ACons[my][Leng-1];
    j = pos+1;
    for(i=Leng-2;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  return j;
}


int makeAlignmentString1(fs,d0,pos)
struct ALIGN *fs;
struct DATA0 *d0;
int pos;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	mx = fs->NumVec[fs->R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || 
	   d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 26;
	  ACons[mx][i] = 95;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	  ACons[mx][i] = fs->Cons1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	mx = fs->NumVec[fs->R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || 
	   d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 26;
	  ACons[mx][i] = 95;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	  ACons[mx][i] = fs->Cons1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++) {
	my = fs->NumVec[fs->R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 26;
	ACons[my][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	mx = fs->NumVec[fs->R2][k];
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 26;
	ACons[mx][i] = 95;
      }
      for(k=0;k<d0->NumY;k++){
	my = fs->NumVec[fs->R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 26;
	  ACons[my][i] = 95;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	  ACons[my][i] = fs->Cons2[k][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  for(k=0;k<d0->NumX;k++){
    mx = fs->NumVec[fs->R2][k];
    j = pos;
    for(i=Leng-1;i>-1;i--){
      fs->DCSeq[mx][j] = ACSeq[mx][i];
      fs->DSeq[mx][j] = ASeq[mx][i];
      fs->DCons[mx][j] = ACons[mx][i];
      j++;
    }
  }
  for(k=0;k<d0->NumY;k++){
    my = fs->NumVec[fs->R1][k];
    j = pos;
    for(i=Leng-1;i>-1;i--){
      fs->DCSeq[my][j] = ACSeq[my][i];
      fs->DSeq[my][j] = ASeq[my][i];
      fs->DCons[my][j] = ACons[my][i];
      j++;
    }
  }
  return j;
}


readSeq_tree(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int  i,j,num;

  for(num=0;num<Info.alignnum;num++){
    j=0;
    for(i=send_left;i<send_right+1;i++){
      if(Info.codeAlign[num][i]==26 || Info.codeAlign[num][i]==27) {}
      else {
	fs->Seq[num][j]=Info.codeAlign[num][i];
	fs->CSeq[num][j]=Info.codeAlign[num][i] + 'A';
	fs->Cons[num][j]=Calc_constraint[num][i];
	j++;
      }
    }
    fs->Leng[num] = j;
    fs->Num[num] = 1;
    fs->NumVec[num][0] = num;
  }  
  fs->SeqNum = num;

  if(left_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][0]=14;
/*      fs->CSeq[i][0]='O'; */
    }      
  }
  if(right_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][fs->Leng[i]-1]=14;
/*      fs->CSeq[i][fs->Leng[i]-1]='O'; */
    }      
  }

  d0->U = UU_n;
  d0->V = VV_n;
  d0->S = SS_n;
  d0->Cut = cut;

}


writeSeq_align(fs,d0,leng)
struct ALIGN *fs;
struct DATA0 *d0;
int leng;
{
  int  i,j,num;

  for(num = 0;num < fs->SeqNum;num++){
    i = send_left;
    Calc_constraint[num][i] = fs->Cons[num][0];
/*    printf("%c",Calc_constraint[num][i]);*/
    if(fs->Seq[num][0] == 100) Calc_codeAlign[num][i]=26;
    else if(left_flag == TRUE) Calc_codeAlign[num][i] = fs->CSeq[num][0] - 'A';
    else Calc_codeAlign[num][i] = fs->Seq[num][0];
    i++;
    for(j = 1;j < leng-1;j++){
      Calc_constraint[num][i] = fs->Cons[num][j];
/*      printf("%c",Calc_constraint[num][i]);*/
      if(fs->Seq[num][j] == 100) Calc_codeAlign[num][i]=26;
      else Calc_codeAlign[num][i] = fs->Seq[num][j];
    i++;
    }
    Calc_constraint[num][i] = fs->Cons[num][j];
/*    printf("%c\n",Calc_constraint[num][i]);*/
    if(fs->Seq[num][j] == 100) Calc_codeAlign[num][i]=26;
    else if(right_flag == TRUE) Calc_codeAlign[num][i] = fs->CSeq[num][j] - 'A';
    else Calc_codeAlign[num][i] = fs->Seq[num][j];
/*    i++; */
  }  
  new_send_right = i;
/*  printf("%d,%d\n",left_flag,right_flag);*/
}
