/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"
#include "aedit.h"

struct sort {
  char Seq[SEQNUM][MAXBUFF];
  char CSeq[SEQNUM][MAXBUFF];
  
  int Leng[SEQNUM];
  int Num[SEQNUM];
  int NumVec[SEQNUM][SEQNUM];
  int SeqNum;
  int CMatrix[SEQNUM][SEQNUM];
};

extern int UU_s;
extern int VV_s;
extern int SS_s;
extern int Cut_s;

sorter_init(sort_num)
int *sort_num;
{
  struct sort ps;
  struct DATA0 d0;
  int i,j,k;

  readSeq_init(&ps,&d0);

  for(j=0;j<ps.SeqNum;j++){
    for(i=j+1;i<ps.SeqNum;i++){

      d0.X = ps.Leng[i];
      d0.Y = ps.Leng[j];
      d0.NumX = 1;
      d0.NumY = 1;

      for(k=0;k<ps.Leng[i];k++){
	d0.CSeq1[0][k] = ps.CSeq[i][k];
	d0.Seq1[0][k] = ps.Seq[i][k];
      }
      for(k=0;k<ps.Leng[j];k++){
	d0.CSeq2[0][k] = ps.CSeq[j][k];
	d0.Seq2[0][k] = ps.Seq[j][k];
      }

      generateD_00(&d0);
      
      if(d0.J % 2 == 0) ps.CMatrix[i][j] = d0.Vec0[d0.I].xy;
      if(d0.J % 2 == 1) ps.CMatrix[i][j] = d0.Vec1[d0.I].xy;

    }
  }

  for(i=0;i<ps.SeqNum-1;i++){
    minimumCost_init(&ps,&d0);
  }
  
  for(i=0;i<Info.alignnum;i++){
    sort_num[i] = ps.NumVec[0][i];
    printf("%d,",sort_num[i]);
  }
  printf("\n");
}


minimumCost_init(fs,d0)
struct sort *fs;
struct DATA0 *d0;
{
  int i,j,k,m,cost=100000000;
  int newcost,oldcost;
  int R1,R2;

  for(j = 0;j < fs->SeqNum;j++){
    for(i = j+1;i < fs->SeqNum;i++){
      newcost = fs->CMatrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  d0->NumX = fs->Num[R2];
  d0->NumY = fs->Num[R1];

  for(j = 0;j < R1;j++){
    oldcost = fs->CMatrix[R1][j];
    fs->CMatrix[R1][j] = ( fs->CMatrix[R2][j] + oldcost ) / 2;
  }
  for(i = R1 + 1;i < R2;i++){
    oldcost = fs->CMatrix[i][R1];
    fs->CMatrix[i][R1] = ( fs->CMatrix[R2][i] + oldcost ) / 2;
  }
  for(i = R2 + 1;i < fs->SeqNum;i++){
    oldcost = fs->CMatrix[i][R1];
    fs->CMatrix[i][R1] = ( fs->CMatrix[i][R2] + oldcost ) / 2;
  }

  for(i = 0;i < R2;i++){
    fs->CMatrix[R2][i] = 100000000;
  }

  for(i = R2 + 1;i < fs->SeqNum;i++){
    fs->CMatrix[i][R2] = 100000000;
  }

  fs->Num[R1] = d0->NumX + d0->NumY;
  fs->Num[R2] = 0;

  j = d0->NumY;
  for(i=0;i<d0->NumX;i++){
    fs->NumVec[R1][j] = fs->NumVec[R2][i];
    j++;
  }
}


readSeq_init(fs,d0)
struct sort *fs;
struct DATA0 *d0;
{
  int  i,j,num;

  for(num=0;num<Info.alignnum;num++){
    j=0;
    for(i=Info.dataStartIndex;i<Info.dataEndIndex+1;i++){
      if(Info.codeAlign[num][i]==26 || Info.codeAlign[num][i]==27) {}
      else {
	fs->Seq[num][j]=Info.codeAlign[num][i];
	fs->CSeq[num][j]=Info.codeAlign[num][i] + 'A';
	j++;
      }
    }
    fs->Leng[num] = j;
    fs->Num[num] = 1;
    fs->NumVec[num][0] = num;
  }  
  fs->SeqNum = num;

  d0->U = UU_s;
  d0->V = VV_s;
  d0->S = SS_s;
  d0->Cut = Cut_s;

}
