/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"
#include "aedit.h"
#include "align.h"

#define CONSNUM 100

ria()
{
  struct DATA0 d0;
  struct ALIGN ps;
  int leng,res;

  readSeq_ria(&ps,&d0);

  res = 1;
/*  res = check_constraint(&ps); */

  if(res == 0){
/*    makeDialog();  */
    writeSeq_align(&ps,&d0,ps.Leng0);
  }
  else{
    leng = ria1(&ps,&d0);
    writeSeq_align(&ps,&d0,leng);
  }

}


int ria1(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k,ST,M;
  int energy,oldenergy,pos,lengx,lengy;

  for(i=0;i< fs->SeqNum ;i++){
    for(j=0;j< fs->Leng0;j++){
      fs->OSeq[i][j] = fs->Seq[i][j];
      fs->OCSeq[i][j] = fs->CSeq[i][j];
      fs->OCons[i][j] = fs->Cons[i][j];
    }
  }

  d0->NumX = 1;
  d0->NumY = fs->SeqNum - 1;

  d0->X = d0->Y = fs->Leng0;

  oldenergy = makeEnergy_ria(fs,d0,d0->X);

  ST = 0;  
  for(;;){
    ST++;
    for(M=0;M< fs->SeqNum ;M++){

      k = 0;
      while(fs->OCSeq[M][k] == '-'){
	fs->CSeq1_C[0][k] = '#';
	fs->Seq1_C[0][k] = fs->OSeq[M][k];
	fs->Cons1_C[0][k] = fs->OCons[M][k];
	k++;
      }
      while(k<d0->X){
	fs->CSeq1_C[0][k] = fs->OCSeq[M][k];
	fs->Seq1_C[0][k] = fs->OSeq[M][k];
	fs->Cons1_C[0][k] = fs->OCons[M][k];
	k++;
      }
      k--;
      while(fs->OCSeq[M][k] == '-'){
	fs->CSeq1_C[0][k] = '#';
	k--;
      }
      
      for(j=0;j<M;j++){
	k = 0;
	while(fs->OCSeq[j][k] == '-'){
	  fs->CSeq2_C[j][k] = '#';
	  fs->Seq2_C[j][k] = fs->OSeq[j][k];
	  fs->Cons2_C[j][k] = fs->OCons[j][k];
	  k++;
	}
	while(k<d0->Y){
	  fs->CSeq2_C[j][k] = fs->OCSeq[j][k];
	  fs->Seq2_C[j][k] = fs->OSeq[j][k];
	  fs->Cons2_C[j][k] = fs->OCons[j][k];
	  k++;
	}
	k--;
	while(fs->OCSeq[j][k] == '-'){
	  fs->CSeq2_C[j][k] = '#';
	  k--;
	}
      }
      for(j=M+1;j< fs->SeqNum ;j++){
	k = 0;
	while(fs->OCSeq[j][k] == '-'){
	  fs->CSeq2_C[j-1][k] = '#';
	  fs->Seq2_C[j-1][k] = fs->OSeq[j][k];
	  fs->Cons2_C[j-1][k] = fs->OCons[j][k];
	  k++;
	}
	while(k<d0->Y){
	  fs->CSeq2_C[j-1][k] = fs->OCSeq[j][k];
	  fs->Seq2_C[j-1][k] = fs->OSeq[j][k];
	  fs->Cons2_C[j-1][k] = fs->OCons[j][k];
	  k++;
	}
	k--;
	while(fs->OCSeq[j][k] == '-'){
	  fs->CSeq2_C[j-1][k] = '#';
	  k--;
	}
      }
      remove_allgap(fs,d0);

      lengx = d0->X;
      lengy = d0->Y;

      pos = constraint_ria(fs,d0,M,lengx,lengy); 
      d0->X = d0->Y = pos;

      for(i=0;i< fs->SeqNum ;i++){
	for(j=0;j<pos;j++){
	  fs->OCSeq[i][j] = fs->DCSeq[i][j];
	  fs->OSeq[i][j] = fs->DSeq[i][j];
	  fs->OCons[i][j] = fs->DCons[i][j];
	}

      }

    }
    
    energy = makeEnergy_ria(fs,d0,d0->X);

    if(energy < oldenergy){
      oldenergy = energy;
      fs->Leng0 = pos;
      for(i=0;i< fs->SeqNum ;i++){
	for(k=0;k< fs->Leng0 ;k++){
	  fs->CSeq[i][k] = fs->OCSeq[i][k];
	  fs->Seq[i][k] = fs->OSeq[i][k];
	  fs->Cons[i][k] = fs->OCons[i][k];
	}
      }
    }
    else break;
  }
  return fs->Leng0;
}


int constraint_ria(fs,d0,M,lengx,lengy)
struct ALIGN *fs;
struct DATA0 *d0;
int M,lengx,lengy;
{
  int i,j,k;
  int x1,y1,a,b,c,pos=0;
  int mx,my;

  char ConsNum[CONSNUM];
  int ConsPos1[CONSNUM];
  int ConsPos2[CONSNUM];
  int ConsN;
  int Pos[MAXBUFF];
  int PosNum[MAXBUFF];
  int count;

  k = 0;
  for(i=0;i<d0->X;i++){
    for(j=0;j<d0->NumX;j++){
      if(fs->Cons1_C[j][i] > 96){
	count = 0;
	for(a=0;a<d0->Y;a++){
	  for(b=0;b<d0->NumY;b++){
	    if(fs->Cons1_C[j][i] == fs->Cons2_C[b][a]){
	      Pos[count] = a;
	      PosNum[count] = 1;
	      count++;
	      for(c=b+1;c<d0->NumY;c++){
		if(fs->Cons1_C[j][i] == fs->Cons2_C[c][a]) PosNum[count]++;
	      }
	      break;
	    }
	    else {}
	  }
	}
	if(count > 0){
	  ConsNum[k] = fs->Cons1_C[j][i];
	  ConsPos1[k] = i;
	  ConsPos2[k] = max_calum(PosNum,Pos,count);
	  k++;
	  goto label1;
	}
      }
      else {}
    }
  label1:{}
  }

  ConsN = k;
  if(ConsN > 0){
    d0->X = ConsPos1[0] + 1;
    d0->Y = ConsPos2[0] + 1;
    x1 = d0->X - 1;
    y1 = d0->Y - 1;
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<x1;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
      d0->Seq1[i][x1] = 14;
      d0->CSeq1[i][x1] = fs->CSeq1_C[i][x1];
      fs->Cons1[i][x1] = fs->Cons1_C[i][x1];
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<y1;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
      d0->Seq2[i][y1] = 14;
      d0->CSeq2[i][y1] = fs->CSeq2_C[i][y1];
      fs->Cons2[i][y1] = fs->Cons2_C[i][y1];
    }

    generateD_00(d0);
    pos = makeAlignmentString1_ria(fs,d0,pos,M);
    pos--;
    for(k=1;k<ConsN;k++){
      d0->X = ConsPos1[k] - ConsPos1[k-1] + 1;
      d0->Y = ConsPos2[k] - ConsPos2[k-1] + 1;
      x1 = d0->X - 1;
      y1 = d0->Y - 1;
      for(i=0;i<d0->NumX;i++){
	a = ConsPos1[k-1];
	d0->Seq1[i][0] = 14;
	d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
	fs->Cons1[i][0] = fs->Cons1_C[i][a];
	a++;
	for(j=1;j<x1;j++){
	  d0->Seq1[i][j] = fs->Seq1_C[i][a];
	  d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	  fs->Cons1[i][j] = fs->Cons1_C[i][a];
	  a++;
	}
	d0->Seq1[i][x1] = 14;
	d0->CSeq1[i][x1] = fs->CSeq1_C[i][a];
	fs->Cons1[i][x1] = fs->Cons1_C[i][a];
      }
      for(i=0;i<d0->NumY;i++){
	b = ConsPos2[k-1];
	d0->Seq2[i][0] = 14;
	d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
	fs->Cons2[i][0] = fs->Cons2_C[i][b];
	b++;
	for(j=1;j<y1;j++){
	  d0->Seq2[i][j] = fs->Seq2_C[i][b];
	  d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	  fs->Cons2[i][j] = fs->Cons2_C[i][b];
	  b++;
	}
	d0->Seq2[i][y1] = 14;
	d0->CSeq2[i][y1] = fs->CSeq2_C[i][b];
	fs->Cons2[i][y1] = fs->Cons2_C[i][b];
      }

      generateD_00(d0);
      pos = makeAlignmentString_ria(fs,d0,pos,M);
      pos--;
    }

    d0->X = lengx - ConsPos1[ConsN-1];
    d0->Y = lengy - ConsPos2[ConsN-1];
    for(i=0;i<d0->NumX;i++){
      a = ConsPos1[ConsN-1];
      d0->Seq1[i][0] = 14;
      d0->CSeq1[i][0] = fs->CSeq1_C[i][a];
      fs->Cons1[i][0] = fs->Cons1_C[i][a];
      a++;
      for(j=1;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][a];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][a];
	fs->Cons1[i][j] = fs->Cons1_C[i][a];
	a++;
      }
    }
    for(i=0;i<d0->NumY;i++){
      b = ConsPos2[ConsN-1];
      d0->Seq2[i][0] = 14;
      d0->CSeq2[i][0] = fs->CSeq2_C[i][b];
      fs->Cons2[i][0] = fs->Cons2_C[i][b];
      b++;
      for(j=1;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][b];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][b];
	fs->Cons2[i][j] = fs->Cons2_C[i][b];
	b++;
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString_ria(fs,d0,pos,M);
  }
  else {
    for(i=0;i<d0->NumX;i++){
      for(j=0;j<d0->X;j++){
	d0->Seq1[i][j] = fs->Seq1_C[i][j];
	d0->CSeq1[i][j] = fs->CSeq1_C[i][j];
	fs->Cons1[i][j] = fs->Cons1_C[i][j];
      }
    }
    for(i=0;i<d0->NumY;i++){
      for(j=0;j<d0->Y;j++){
	d0->Seq2[i][j] = fs->Seq2_C[i][j];
	d0->CSeq2[i][j] = fs->CSeq2_C[i][j];
	fs->Cons2[i][j] = fs->Cons2_C[i][j];
      }
    }
    generateD_00(d0);
    pos = makeAlignmentString1_ria(fs,d0,pos,M);
  }

  return pos;
}


int makeAlignmentString_ria(fs,d0,pos,M)
struct ALIGN *fs;
struct DATA0 *d0;
int pos,M;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[M][i] = '-';
	ASeq[M][i] = 26;
	ACons[M][i] = 95;
      }
      else{
	ACSeq[M][i] = d0->CSeq1[0][d0->I-1];
	ASeq[M][i] = d0->Seq1[0][d0->I-1];
	ACons[M][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	  ACons[k][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->SeqNum ;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[k][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[M][i] = '-';
	ASeq[M][i] = 26;
	ACons[M][i] = 95;
      }
      else{
	ACSeq[M][i] = d0->CSeq1[0][d0->I-1];
	ASeq[M][i] = d0->Seq1[0][d0->I-1];
	ACons[M][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 26;
	ACons[k][i] = 95;
      }
      for(k=M+1;k< fs->SeqNum ;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 26;
	ACons[k][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      ACSeq[M][i] = '-';
      ASeq[M][i] = 26;
      ACons[M][i] = 95;
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	  ACons[k][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->SeqNum;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[k][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString_ria error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  for(k=0;k< fs->SeqNum ;k++){
    if(ASeq[k][Leng-1] == 14 && ACSeq[k][Leng-1] != 'O'){
      fs->DSeq[k][pos] = ACSeq[k][Leng-1] - 'A';
    }
    else {
      fs->DSeq[k][pos] = ASeq[k][Leng-1];
    }
    fs->DCSeq[k][pos] = ACSeq[k][Leng-1];
    fs->DCons[k][pos] = ACons[k][Leng-1];
    j = pos+1;
    for(i=Leng-2;i>-1;i--){
      fs->DCSeq[k][j] = ACSeq[k][i];
      fs->DSeq[k][j] = ASeq[k][i];
      fs->DCons[k][j] = ACons[k][i];
      j++;
    }
  }

  return j;
}


int makeAlignmentString1_ria(fs,d0,pos,M)
struct ALIGN *fs;
struct DATA0 *d0;
int pos,M;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];
  char ACons[SEQNUM][MAXBUFF];
  int Leng;

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[M][i] = '-';
	ASeq[M][i] = 26;
	ACons[M][i] = 95;
      }
      else{
	ACSeq[M][i] = d0->CSeq1[0][d0->I-1];
	ASeq[M][i] = d0->Seq1[0][d0->I-1];
	ACons[M][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	  ACons[k][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->SeqNum ;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[k][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      if(d0->CSeq1[0][d0->I-1] == '#' || 
	 d0->CSeq1[0][d0->I-1] == '-'){
	ACSeq[M][i] = '-';
	ASeq[M][i] = 26;
	ACons[M][i] = 95;
      }
      else{
	ACSeq[M][i] = d0->CSeq1[0][d0->I-1];
	ASeq[M][i] = d0->Seq1[0][d0->I-1];
	ACons[M][i] = fs->Cons1[0][d0->I-1];
      }
      for(k=0;k<M;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 26;
	ACons[k][i] = 95;
      }
      for(k=M+1;k< fs->SeqNum ;k++) {
	ACSeq[k][i] = '-';
	ASeq[k][i] = 26;
	ACons[k][i] = 95;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      ACSeq[M][i] = '-';
      ASeq[M][i] = 26;
      ACons[M][i] = 95;
      for(k=0;k<M;k++){
	if(d0->CSeq2[k][d0->J-1] == '#' || 
	   d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k][d0->J-1];
	  ACons[k][i] = fs->Cons2[k][d0->J-1];
	}
      }
      for(k=M+1;k< fs->SeqNum ;k++){
	if(d0->CSeq2[k-1][d0->J-1] == '#' || 
	   d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[k][i] = '-';
	  ASeq[k][i] = 26;
	  ACons[k][i] = 95;
	}
	else{
	  ACSeq[k][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[k][i] = d0->Seq2[k-1][d0->J-1];
	  ACons[k][i] = fs->Cons2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString1_ria error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng = i;

  for(k=0;k< fs->SeqNum ;k++){
    j = pos;
    for(i=Leng-1;i>-1;i--){
      fs->DCSeq[k][j] = ACSeq[k][i];
      fs->DSeq[k][j] = ASeq[k][i];
      fs->DCons[k][j] = ACons[k][i];
      j++;
    }
  }

  return j;
}


int makeEnergy_ria(fs,d0,X)
struct ALIGN *fs;
struct DATA0 *d0;
int X;
{
  int i,j,k,K,m,mx,my;
  int energy=0;

  for(i=0;i< fs->SeqNum ;i++){
    j = 0;
    while(fs->OCSeq[i][j] == '-'){
      fs->OCSeq[i][j] = '#';
      j++;
    }
   j = X - 1;
    while(fs->OCSeq[i][j] == '-'){
      fs->OCSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i< fs->SeqNum ;i++){
    for(j=i+1;j< fs->SeqNum ;j++){
      for(k=0;k< X;k++){
	if((fs->OCSeq[i][k] == '-' || fs->OCSeq[i][k] == '#') 
	   && (fs->OCSeq[j][k] == '-' || fs->OCSeq[j][k] == '#')) {}
	else if(fs->OCSeq[i][k] == '#' || fs->OCSeq[j][k] == '#') energy += d0->S;
	else if(fs->OCSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->OCSeq[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(fs->OCSeq[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(fs->OCSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(fs->OCSeq[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(fs->OCSeq[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  if(fs->OCons[i][k] == 96 && fs->OCons[j][k] == 96)
	    energy += Dmatrix[fs->OSeq[i][k]][fs->OSeq[j][k]];
	  else if(fs->OCons[i][k] == fs->OCons[j][k]) energy += -1000;
	  else energy += 1000;
	}
      }
    }
  }
  for(i=0;i< fs->SeqNum ;i++){
    j = 0;
    while(fs->OCSeq[i][j] == '#'){
      fs->OCSeq[i][j] = '-';
      j++;
    }
    j = X - 1;
    while(fs->OCSeq[i][j] == '#'){
      fs->OCSeq[i][j] = '-';
      j--;
    }
  }

  return energy;
}


readSeq_ria(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int  i,j,num;

  for(num=0;num<Info.alignnum;num++){
    j=0;
    for(i=send_left;i<send_right+1;i++){

      if(Info.codeAlign[num][i]==26) fs->CSeq[num][j] = '-';
      else if(Info.codeAlign[num][i]==27) fs->CSeq[num][j] = '#';
      else fs->CSeq[num][j]=Info.codeAlign[num][i] + 'A';

      fs->Seq[num][j]=Info.codeAlign[num][i];
      fs->Cons[num][j]=Calc_constraint[num][i];
      j++;
    }
  }  
  fs->Leng0 = j;
  fs->SeqNum = num;

  if(left_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][0]=14;
/*      fs->CSeq[i][0]='O'; */
    }      
  }
  if(right_flag == TRUE){
    for(i=0;i<fs->SeqNum;i++){
      fs->Seq[i][fs->Leng0-1]=14;
/*      fs->CSeq[i][fs->Leng0-1]='O'; */
    }      
  }

  d0->U = UU_n;
  d0->V = VV_n;
  d0->S = SS_n;
  d0->Cut = cut;

}


int max_calum(PosNum,Pos,count)
int PosNum[];
int Pos[];
int count;
{
  int i,max,pos;

  max = 0;
  for(i=0;i<count;i++){
    if(PosNum[i] > max){
      max = PosNum[i];
      pos = i;
    }
  }

  return Pos[pos];

}
