/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	motif_search2.c
----------------------------------------------------------------------*/

#include	<string.h>

#include	"aedit.h"

/*--------------------------------------------------------------------*/

/*--------------------------------------------------------------------*/
#ifdef	MOTIF_SEARCH_NEW
/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*
  դθ
*/

void search_pattern_2(sgcnt)
int sgcnt;	/* I:ѥΥȿ */
{
	void	decide_pattern_r();

#ifdef	DEBUG
	(void)printf("search_pattern_2 --- in\n");
#endif

	decide_pattern_r(sgcnt, 0);
}

/*
  աѥηʺƵ
*/

static void
decide_pattern_r(sgcnt, sgaid)
int	sgcnt;	/* I:ѥΥȿ */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	int		i, j;
	int		plength;
	extern int	now_min[MAX_NUM_PATTERN];
	extern int	now_max[MAX_NUM_PATTERN];
	extern int	now_repeat[MAX_NUM_PATTERN];
	extern int	now_index[MAX_NUM_PATTERN];
	extern Bool	now_alrpflag[MAX_ALIGN];
	extern void	check_pattern();
	extern void	fatal_error();

#ifdef	DEBUG
	(void)printf("decide_pattern_r --- sgcnt, sgaid = %d %d\n", sgcnt, sgaid);
#endif

	if (sgaid <= sgcnt - 1) {
		for (i = *(now_min+sgaid); i <= *(now_max+sgaid); i++) {
			*(now_repeat+sgaid) = i;
			decide_pattern_r(sgcnt, sgaid + 1);
		}
	}
/*
	else if (sgaid == sgcnt - 1) {
		*(now_repeat+sgaid) = *(now_min+sgaid);
		decide_pattern_r(sgcnt, sgaid + 1);
	}
*/
	else if (sgaid == sgcnt) {
		for (plength = 0, i = 0; i < sgcnt; i++)
			plength += *(now_repeat+i);
		for (i = Info.dataStartIndex; i <= Info.dataEndIndex; i++) {
			if (i + plength - 1 > Info.dataEndIndex) {
#ifdef	DEBUG
(void)printf("decide_pattern_r --- short cut i, plength, Info.dataEndIndex = %d %d %d\n",
	     i, plength, Info.dataEndIndex);
#endif
				break;
			}
			for (*(now_index) = i, j = 1; j < sgcnt; j++)
				*(now_index+j) = *(now_index+j-1) + *(now_repeat+j-1);
			for (j = 0; j < Info.alignnum; j++)
				*(now_alrpflag+j) = True;
			check_pattern(sgcnt);
		}
	}
	else
		fatal_error("decide_pattern_r", "sgcnt, sgaid = %d %d\n",
			    sgcnt, sgaid);
}

/*
  ѥΥåʸ
*/

static void
check_pattern(sgcnt)
int	sgcnt;		/* I:ѥΥȿ */
{
	extern int	now_index[MAX_NUM_PATTERN];
	extern int	now_repeat[MAX_NUM_PATTERN];
	extern INFO	Info;
	extern Bool	now_alrpflag[MAX_ALIGN];
	extern Bool	now_forbidden[MAX_NUM_PATTERN];
	extern Bool	now_others[MAX_NUM_PATTERN];
	int		pflag;
	int		i;
	extern void	fatal_error();
	int		check_pattern_f();
	int		check_pattern_o();
	int		check_pattern_m();
#ifdef	DEBUG
	void		output_now_segment();
#endif

#ifdef	DEBUG
	output_now_segment(sgcnt);
#endif

	for (pflag = 1, i = 0; i < sgcnt; i++) {
#ifdef	CHECK
		if (*(now_index+i) + *(now_repeat+i) - 1 > Info.dataEndIndex)
			fatal_error("check_pattern",
				    "pattern out of Info.dataEndIndex\n");
#endif
		if (*(now_forbidden+i) == True &&
		    *(now_others+i) == False     ) {
			if (!check_pattern_f(*(now_index+i), i)) {
				pflag = 0;
				break;
			}
		}
		else if (*(now_forbidden+i) == False &&
			 *(now_others+i) == True       ) {
			if (!check_pattern_o(*(now_index+i), i)) {
				pflag = 0;
				break;
			}
		}
		else if (*(now_forbidden+i) == False &&
			 *(now_others+i) == False      ) {
			if (!check_pattern_m(*(now_index+i), i)) {
				pflag = 0;
				break;
			}
		}
		else
			fatal_error(
				"check_pattern",
				"now_forbidden and now_others illegal i = %d\n",
				i);
	}

	if (pflag)
		add_motif(sgcnt);
}

/*
  §ѥΥåʸ
*/

static int
check_pattern_f(alcaid, sgaid)
int	alcaid;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	extern INFO	Info;
	extern char	Char1[128];
	extern int	now_repeat[MAX_NUM_PATTERN];
	extern char	now_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];
	extern int	motif_cut;
	int		pcount;
	int		pflag;
	int		i, j;

	for (pcount = 0, i = 0; i < Info.alignnum; i++) {
		if (*(now_alrpflag+i) != True)
			continue;
#ifdef	DEBUG
		(void)printf("check_pattern_f --- i, alcaid, sgaid = %d %d %d\n",
			     i, alcaid, sgaid);
		(void)printf("check_pattern_f --- *(now_repeat+sgaid) = %d\n",
			     *(now_repeat+sgaid));
		(void)printf("check_pattern_f --- (char *)(now_amino+sgaid) = %s\n",
			     (char *)(now_amino+sgaid));
#endif
		for (pflag = 1, j = 0; j < *(now_repeat+sgaid); j++) {
#ifdef	DEBUG
(void)printf("check_pattern_f --- *(Char1+*(*(Info.codeAlign+i)+alcaid+j)) = %c\n",
	     Char1[*(*(Info.codeAlign+i)+alcaid+j)]);
#endif
			if (strchr((char *)(now_amino+sgaid),
				   *(Char1+*(*(Info.codeAlign+i)+alcaid+j)))
				!= (char *)NULL) {
				pflag = 0;
				break;
			}
		}
		if (pflag)
			pcount++;
		else
			*(now_alrpflag+i) = False;
	}

#ifdef	DEBUG
	(void)printf("check_pattern_f --- pcount = %d\n", pcount);
#endif

	if (pcount > 0							    &&
	    100.0 * (float)pcount / (float)Info.alignnum >= (float)motif_cut  )
		pflag = 1;
	else
		pflag = 0;

	return pflag;
}

/*
  ǤեѥΥåʸ
*/

/*ARGSUSED*/
static int
check_pattern_o(alcaid, sgaid)
int	alcaid;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	return 1;
}

/*
  աѥΥåʸ
*/

static int
check_pattern_m(alcaid, sgaid)
int	alcaid;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	extern INFO	Info;
	extern char	Char1[128];
	extern int	now_repeat[MAX_NUM_PATTERN];
	extern char	now_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];
	extern int	motif_cut;
	int		pcount;
	int		pflag;
	int		i, j;

	for (pcount = 0, i = 0; i < Info.alignnum; i++) {
		if (*(now_alrpflag+i) != True)
			continue;
#ifdef	DEBUG
		(void)printf("check_pattern_m --- i, alcaid, sgaid = %d %d %d\n",
			     i, alcaid, sgaid);
		(void)printf("check_pattern_m --- *(now_repeat+sgaid) = %d\n",
			     *(now_repeat+sgaid));
		(void)printf("check_pattern_m --- (char *)(now_amino+sgaid) = %s\n",
			     (char *)(now_amino+sgaid));
#endif
		for (pflag = 1, j = 0; j < *(now_repeat+sgaid); j++) {
#ifdef	DEBUG
(void)printf("check_pattern_m --- *(Char1+*(*(Info.codeAlign+i)+alcaid+j)) = %c\n",
	     *(Char1+*(*(Info.codeAlign+i)+alcaid+j)));
#endif
			if (strchr((char *)(now_amino+sgaid),
				   *(Char1+*(*(Info.codeAlign+i)+alcaid+j)))
				== (char *)NULL) {
				pflag = 0;
				break;
			}
		}
		if (pflag)
			pcount++;
		else
			*(now_alrpflag+i) = False;
	}

#ifdef	DEBUG
	(void)printf("check_pattern_m --- pcount = %d\n", pcount);
#endif

	if (pcount > 0							    &&
	    100.0 * (float)pcount / (float)Info.alignnum >= (float)motif_cut  )
		pflag = 1;
	else
		pflag = 0;

	return pflag;
}

/*--------------------------------------------------------------------*/

/*
  ߤΥѥ󡦥ν
*/

void
output_now_segment(sgcnt)
int	sgcnt;	/* I:ѥΥȿ */
{
	extern char	now_title[MAX_BUFF_MOTIF];
	extern char	now_pattern[MAX_BUFF_MOTIF];
	extern INFO	Info;
#ifdef	MOTIF_SEARCH_NEW
	extern Bool	now_alrpflag[MAX_ALIGN];
#else
	extern Bool	forbidden_flag[MAX_ALIGN];
#endif
	extern char	now_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];
	extern Bool	now_forbidden[MAX_NUM_PATTERN];
	extern Bool	now_others[MAX_NUM_PATTERN];
	extern int	now_min[MAX_NUM_PATTERN];
	extern int	now_max[MAX_NUM_PATTERN];
	extern int	now_repeat[MAX_NUM_PATTERN];
	extern int	now_index[MAX_NUM_PATTERN];
	char		buf[MAX_BUFF_MOTIF];
	char		*p;
	int		i;
	extern void	fatal_error();

	(void)printf("***** now_segment (start) *****\n");

	(void)strncpy(buf, now_title, MAX_BUFF_MOTIF);
	p = strchr(buf, '\n');
	if (p == (char *)NULL)
		fatal_error("output_now_segment", "p == (char *)NULL (title)");
	*p = '\0';
	(void)printf("now_title = %s\n", buf);
	(void)strncpy(buf, now_pattern, MAX_BUFF_MOTIF);
	p = strchr(buf, '\n');
	if (p == (char *)NULL)
		fatal_error("output_now_segment", "p == (char *)NULL (pattern)");
	*p = '\0';
	(void)printf("now_pattern = %s\n", buf);

#ifdef	MOTIF_SEARCH_NEW
	for (i = 0; i < Info.alignnum; i++)
		(void)printf("now_alrpflag[%d] = %d\n", i, *(now_alrpflag+i));
#else
	for (i = 0; i < Info.alignnum; i++)
		(void)printf("forbidden_flag[%d] = %d\n", i, *(forbidden_flag+i));
#endif

	for (i = 0; i < sgcnt; i++) {
		(void)strncpy(buf, (char *)(now_amino+i), MAX_NUM_PATTERN);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_now_segment", "p == (char *)NULL (amino)");
		*p = '\0';
		(void)printf("now_amino[%d] = %s\n", i, buf);
		(void)printf("now_forbidden[%d] = %d\n", i, *(now_forbidden+i));
		(void)printf("now_others[%d] = %d\n", i, *(now_others+i));
		(void)printf("now_min[%d] = %d\n", i, *(now_min+i));
		(void)printf("now_max[%d] = %d\n", i, *(now_max+i));
		(void)printf("now_repeat[%d] = %d\n", i, *(now_repeat+i));
		(void)printf("now_index[%d] = %d\n", i, *(now_index+i));
	}

	(void)printf("***** now_segment (end) *****\n");
}

/*
  աꥹȤΥ롼Ȥν
*/

void
output_motif_root_l()
{
	extern Motif	*Motif_root;
	void		output_motif_l();

	(void)printf("***** Motif_root (start) *****\n");

	output_motif_l(Motif_root);

	(void)printf("***** Motif_root (end) *****\n");
}

/*
  աꥹȤν
*/

void
output_motif_l(motif)
Motif	*motif;	/* I: */
{
	extern INFO	info;
	char		buf[MAX_BUFF_MOTIF];
	char		*p;
	int		i;
	extern void	fatal_error();
	void		output_segment_l();

	if (motif != (Motif *)NULL) {
		(void)printf("p_next = %u\n", motif->p_next);
		(void)strncpy(buf, motif->title, MAX_BUFF_MOTIF);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_motif_l", "p == (char *)NULL (title)");
		*p = '\0';
		(void)printf("title = %s\n", buf);
		(void)strncpy(buf, motif->pattern, MAX_BUFF_MOTIF);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_motif_l", "p == (char *)NULL (pattern)");
		*p = '\0';
		(void)printf("pattern = %s\n", buf);
#ifdef	MOTIF_SEARCH_NEW
		for (i = 0; i < Info.alignnum; i++)
			(void)printf("alrpflag[%d] = %d\n",
				     i, motif->alrpflag[i]);
#else
		for (i = 0; i < Info.alignnum; i++)
			(void)printf("forbidden_align[%d] = %d\n",
				     i, motif->forbidden_align[i]);
#endif
		(void)printf("segment_count = %d\n", motif->segment_count);
		(void)printf("p_next_seg = %u\n", motif->p_next_seg);
		output_segment_l(motif->p_next_seg);
		output_motif_l(motif->p_next);
	}
}

/*
  ѥ󡦥ȡꥹȤν
*/

void
output_segment_l(segment)
Segment	*segment;	/* I:ѥ󡦥 */
{
	char		buf[MAX_NUM_PATTERN];
	char		*p;
	extern void	fatal_error();

	if (segment != (Segment *)NULL) {
		(void)printf("p_next_seg = %u\n", segment->p_next_seg);
		(void)strncpy(buf, segment->amino, MAX_NUM_PATTERN);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_segment_l", "p == (char *)NULL (amino)");
		*p = '\0';
		(void)printf("amino = %s\n", buf);
		(void)printf("forbidden = %d\n", segment->forbidden);
		(void)printf("others = %d\n", segment->others);
		(void)printf("min = %d\n", segment->min);
		(void)printf("max = %d\n", segment->max);
		(void)printf("repeat = %d\n", segment->repeat);
		(void)printf("index = %d\n", segment->index);
		output_segment_l(segment->p_next_seg);
	}
}

/*--------------------------------------------------------------------*/
#endif	MOTIF_SEARCH_NEW
/*--------------------------------------------------------------------*/

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
