/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	motif_search.c 
----------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>

#include "aedit.h"

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

#define DISP_MOTIF_NUM 8

void editEH(), cancelCB(), toggle3();

extern Widget  menu_top;

extern Widget	da;

int		motif_cut = 80;		/* աѥ
					    饤ȹԿФ
					    չԿγ */
static int	main_num = 0, sub_num = 0;

Widget dialog_motif, list, pb_search, pb_constraint, pb_undisp;
Widget dialog_motif_sub, list_sub;

Motif	*p_motif = NULL;		/* оݤȤƤĤΥ
					    */
Motif	*p_sub[MAX_NUM_PATTERN];	/* դΥ֥ꥹ */
char	now_title[MAX_BUFF_MOTIF];	/* оݤȤƤդ
					   ȥʥ̡ */
char	now_pattern[MAX_BUFF_MOTIF];	/* оݤȤƤդ
					   ѥʥ̡ */
char	now_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];
					/* оݤȤƤդ
					   ̥ߥλ̾ */
Bool	now_forbidden[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   ̶§ե饰 */
Bool	now_others[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   Ǥեե饰 */
#ifdef	MOTIF_SEARCH_NEW
Bool	now_alrpflag[MAX_ALIGN];	/* 饤ȹѥ
					   ե饰ʳ) */
#else
Bool	forbidden_flag[MAX_ALIGN];	/* §ǡե饰 */
#endif
int	now_min[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   ̺Ǿ */
int	now_max[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   ̺祵 */
int	now_repeat[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   ̷֤ */
int	now_index[MAX_NUM_PATTERN];	/* оݤȤƤդ
					   ƬΥ̥饤
					   ⥤ǥå */

static int	dict_mode;	/* ⡼ */

/*--------------------------------------------------------------------*/

/*
  ΥХåؿ
*/

static void motif_scaleCB(w,flag,call_data)
Widget   w;
int      flag;
XmScaleCallbackStruct  *call_data;
{
    motif_cut = call_data->value;
}

/*
  ʣդθ
*/

Bool check_overlap_motif()
{
    Motif *p_now = Motif_root;
    Segment *p_now_seg;
    Bool overlap_flag = False;
    char select_motif_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];    
    int select_motif_index[MAX_NUM_PATTERN];    
    int select_motif_num, i, count, align;

    i = 0;
    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg!=NULL){
        if (!p_now_seg->forbidden && !p_now_seg->others){
	    strcpy(&select_motif_amino[i][0], p_now_seg->amino);
            select_motif_index[i] = p_now_seg->index;
	    i++;
	}
        p_now_seg = p_now_seg->p_next_seg;
    }
    select_motif_num  = i;

    count = 0;
    while (p_now!=NULL){
        if (p_now==p_motif){
            p_now = p_now->p_next;
	    continue;
	}
	p_now_seg = p_now->p_next_seg;
        while (p_now_seg!=NULL){
          if (!p_now_seg->forbidden && !p_now_seg->others){
	    for (i=0; i<select_motif_num; i++){
	      if (select_motif_index[i]==p_now_seg->index){
		for (align=0; align<Info.alignnum; align++){
#ifdef	MOTIF_SEARCH_NEW
		  if (p_motif->alrpflag[align] == False ||
		      p_now->alrpflag[align] == False     )
			continue;
#else
		  if (p_motif->forbidden_align[align] ||
		      p_now->forbidden_align[align]     )
			continue;
#endif
                  if (index(&select_motif_amino[i][0], 
                            (int)Info.codeAlign[align][select_motif_index[i]]+'A') &&
                      index(p_now_seg->amino,
			    (int)Info.codeAlign[align][p_now_seg->index]+'A'))
		  overlap_flag = True;
		}
	      }
            }
          }
          p_now_seg = p_now_seg->p_next_seg;
        }
	if (overlap_flag){
	    /*printf("%s%s", p_now->title, p_now->pattern);*/
            overlap_flag = False;
	    p_sub[count] = p_now;
	    count++;
	}
        p_now = p_now->p_next;
    }
    sub_num = count;    
    if (count>0){
        return True;
    }else{
        return False;
    }
}

/*
  աꥹȡʥåȡˤ˥դϿ
*/

static void add_motif_list()
{
    Arg args[10];      
    Motif *p_now = Motif_root;
    char motif_name[MAX_BUFF_MOTIF];
    int count = 0, i;
#if	1
	int	dummy;
#endif

    /*fprintf(stderr, "list items:%d\n", count);*/
    while (p_now!=NULL){
        strcpy(motif_name, p_now->title);
        strcat(motif_name, p_now->pattern);
	count++;
	XmListAddItem(list,
		      XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET),
		      count);
	p_now = p_now->p_next;
    }
    main_num = count;
    fprintf(stderr, "motif exist  %d\n", count);
    if (count>DISP_MOTIF_NUM && count<37){
        strcpy(motif_name, " \n ");
	for (i=count+1; i<=37; i++)
	    XmListAddItem(list,
			  XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET),
			  i);	    
    }
    XtSetArg(args[0],XmNvisibleItemCount, 1);
    XtSetValues(list, args, 1);
    if (count>0){
#if	0
(void)printf("count = %d\n", count);
#endif
        if (count<DISP_MOTIF_NUM){
            XtSetArg(args[0],XmNvisibleItemCount, count + 1);
            XtSetValues(list, args, 1);
            XtSetArg(args[0],XmNvisibleItemCount, count);
            XtSetValues(list, args, 1);
        }else{
	    XtSetArg(args[0],XmNvisibleItemCount, DISP_MOTIF_NUM + 1);
            XtSetValues(list, args, 1);
	    XtSetArg(args[0],XmNvisibleItemCount, DISP_MOTIF_NUM);
            XtSetValues(list, args, 1);
        }
    }

#if	0
XtSetArg(args[0],XmNvisibleItemCount, &dummy);
XtGetValues(list, args, 1);
(void)printf("visible count %d\n", dummy);
XtSetArg(args[0],XmNitemCount, &dummy);
XtGetValues(list, args, 1);
(void)printf("item count %d\n", dummy);
#endif
}

/*
  աꥹȡʥåȡˤդʥꥢˤ
*/

void delete_motif_list()
{
    Motif *p_now = Motif_root;
    char motif_name[MAX_BUFF_MOTIF];

    while (p_now!=NULL){
        strcpy(motif_name, p_now->title);
        strcat(motif_name, p_now->pattern);
        if (XmListItemExists(list,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
            XmListDeleteItem(list,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
	p_now = p_now->p_next;
    }
    strcpy(motif_name, " \n ");
    while (XmListItemExists(list,
			    XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET))) {
        XmListDeleteItem(list,
			 XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
    }
}

/*
  ա֥ꥹȡʥåȡˤ˥դϿ
*/

void process_sub()
{
    Arg args[10];     
    char motif_name[MAX_BUFF_MOTIF];
    int i;
#if	1
	int	dummy;
#endif

    fprintf(stderr, "overlap motif exist  %d\n", sub_num);
    XtSetArg(args[0],XmNvisibleItemCount, 1);
    XtSetValues(list_sub, args, 1);
    if (sub_num>0){
#if	0
(void)printf("sub_num = %d\n", sub_num);
#endif
        if (sub_num<DISP_MOTIF_NUM){
            XtSetArg(args[0],XmNvisibleItemCount, sub_num + 1);
            XtSetValues(list_sub, args, 1);
            XtSetArg(args[0],XmNvisibleItemCount, sub_num);
            XtSetValues(list_sub, args, 1);
        }else{
	    XtSetArg(args[0],XmNvisibleItemCount, DISP_MOTIF_NUM + 1);
            XtSetValues(list_sub, args, 1);
	    XtSetArg(args[0],XmNvisibleItemCount, DISP_MOTIF_NUM);
            XtSetValues(list_sub, args, 1);
        }
    }
    for (i=0; i<sub_num; i++){
        strcpy(motif_name, p_sub[i]->title);
        strcat(motif_name, p_sub[i]->pattern);
	XmListAddItem(list_sub,
		      XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET),
		      i+1);
    }
    if (sub_num>DISP_MOTIF_NUM && sub_num<37){
        strcpy(motif_name, " \n ");
	for (i=sub_num+1; i<=37; i++)
	    XmListAddItem(list_sub,
			  XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET),
			  i);	    
    }

    XtPopup(dialog_motif_sub,XtGrabNone);
}

/*
  ա֥ꥹȡʥåȡˤդʥꥢˤ
*/

void	delete_motif_sublist()
{
	int	i;
	char	motif_name[MAX_BUFF_MOTIF];

	if (sub_num <= 0)
		return;

	for (i = 0; i < sub_num; i++) {
		(void)strcpy(motif_name, p_sub[i]->title);
		(void)strcat(motif_name, p_sub[i]->pattern);
		if (XmListItemExists(
			list_sub,
			XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
			XmListDeleteItem(
				list_sub,
				XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
	}
	(void)strcpy(motif_name, " \n ");
	while (XmListItemExists(
		list_sub,
		XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
		XmListDeleteItem(list_sub,
				 XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));

	sub_num = 0;

	XtPopdown(dialog_motif_sub);
}

/*
  ա֥ꥹȡʥåȡˤΥդ򤵤줿˸ƤФ
Хåؿ
*/

static void motif_select_subCB(w,flag,call_data)
Widget   w;
int      flag;
XmListCallbackStruct  *call_data;
{
    Segment	*p_now_seg;
    int		i;
    extern void	display_aedit_win_2();

    /*fprintf(stderr, "select no:%d\n", call_data->item_position);*/
    if (p_motif) undisp_one_motif_2(XtDisplay(da), XtWindow(da));
    if (call_data->item_position > sub_num) return;
    for (i=0; i<sub_num; i++){
        if (call_data->item_position == i+1){
	    p_motif = p_sub[i];
	    break;
	}
    }
    /* դɽ褦˥饤ɽ֤ */
    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg->forbidden || p_now_seg->others)
	p_now_seg = p_now_seg->p_next_seg;
    if (p_now_seg->index>=(Info.dispStartIndex+PerLine) ||
        p_now_seg->index<Info.dispStartIndex){
        Info.dispStartIndex = p_now_seg->index-(int)(PerLine/2);
	if (Info.dispStartIndex<Info.dataStartIndex)
		Info.dispStartIndex = Info.dataStartIndex;
/*
	disp(True);
*/
	display_aedit_win_2();
    }
    disp_one_motif_2(XtDisplay(da), XtWindow(da));
}

/*
  աꥹȡʥåȡˤΥդ򤵤줿˸ƤФ륳
Хåؿ
*/

static void motif_selectCB(w,flag,call_data)
Widget   w;
int      flag;
XmListCallbackStruct  *call_data;
{
    Motif	*p_now = Motif_root;
    Segment	*p_now_seg;
    char	motif_name[MAX_BUFF_MOTIF];
    int		i, count = 0;
    extern void	display_aedit_win_2();

    /*fprintf(stderr, "select no:%d\n", call_data->item_position);*/
    if (p_motif){
        undisp_one_motif_2(XtDisplay(da), XtWindow(da));
        strcpy(motif_name, p_motif->title);
        strcat(motif_name, p_motif->pattern);
        if (XmListItemExists(list_sub,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
            XmListDeselectItem(list_sub,
			       XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
    }
    XtSetSensitive(pb_undisp, True);
    XtSetSensitive(pb_search, False);

    if (call_data->item_position > main_num){
        if (sub_num>0) XtPopdown(dialog_motif_sub);
        return;
    }
    while (p_now!=NULL){
        count++;
        if (call_data->item_position == count){
            /*xms = XmStringCreateLtoR(motif[i].comment, XmSTRING_DEFAULT_CHARSET);*/
	    p_motif = p_now;
	    break;
	}
	p_now = p_now->p_next;
    }
    /* դɽ褦˥饤ɽ֤ */
    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg->forbidden || p_now_seg->others)
	p_now_seg = p_now_seg->p_next_seg;
    if (p_now_seg->index>=(Info.dispStartIndex+PerLine) ||
        p_now_seg->index<Info.dispStartIndex){
        Info.dispStartIndex = p_now_seg->index-(int)(PerLine/2);
	if (Info.dispStartIndex<Info.dataStartIndex)
		Info.dispStartIndex = Info.dataStartIndex;
/*
	disp(True);
*/
	display_aedit_win_2();
    }
    disp_one_motif_2(XtDisplay(da), XtWindow(da));

    for (i=0; i<sub_num; i++){
        strcpy(motif_name, p_sub[i]->title);
        strcat(motif_name, p_sub[i]->pattern);
        if (XmListItemExists(list_sub,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
            XmListDeleteItem(list_sub,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
    }
    strcpy(motif_name, " \n ");
    while (XmListItemExists(list_sub,
			    XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET))) {
        XmListDeleteItem(list_sub,
			 XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
    }
    if (check_overlap_motif()){
        process_sub();
    }else{
	XtPopdown(dialog_motif_sub);
    }
}

/*
  ae_prosite.mtf ޤ ae_user.mtf κ
*/

void process_str_pa(f_data, str_pa)
FILE *f_data;
char *str_pa;
{
    char *p_now = str_pa;
    char amino[MAX_BUFF_MOTIF];
    char num[MAX_BUFF_MOTIF];
    int min, max;
    Bool forbidden_flag = False, others_flag = False;

    amino[0] = num[0] = '\0';
    min = max = 0;
    while(*p_now!='.'){
        switch(*p_now){
            /*case '[':
                break;
            case ']':
                break;
            case '}':
                break;*/
            case '{':
                forbidden_flag = True;
                break;
            case 'x':
                others_flag = True;
		amino[0]='x'; amino[1]='\0';
                break;
            case '(':
                num[0] = '\0';
                break;
            case ')':
                max = atoi(num);
                if (min==0) min = max;
                break;
            case ',':
                min = atoi(num);
                num[0] = '\0';
                break;
            case '-':
		if (min==0 && max==0) min = max = 1;
                fprintf(f_data,
			"%s\n%d\n%d\n%d\n%d\n",
			amino, forbidden_flag, others_flag, min, max);
                amino[0] = num[0] = '\0';
                min = max = 0;
                forbidden_flag = False; others_flag = False;
                break;
	    default:
                if (*p_now>='0' && *p_now<='9'){
		    strncat(num, p_now, 1);
                }
                if (*p_now>='A' && *p_now<='Z'){
		    strncat(amino, p_now, 1);
                }
	}
        p_now++;
    }
    if (min==0 && max==0)
	min = max = 1;

    fprintf(f_data,
	    "%s\n%d\n%d\n%d\n%d\n",
	    amino, forbidden_flag, others_flag, min, max);
}

/*
  ae_prosite.tmp  ae_prosite.mtf κ
ޤ ae_user.tmp  ae_user.mtf κ
*/

void update_prosite_data()
{
    FILE *f_temp, *f_data;
    char str1[MAX_BUFF_MOTIF], str_de[MAX_BUFF_MOTIF], str_pa[MAX_BUFF_MOTIF];
    int previous = '/';

    if (dict_mode == 1) {
        if ((f_temp = fopen("ae_prosite.tmp", "r")) == (FILE *)NULL)
		fatal_error("update_prosite_data", "fopen error (ae_prosite.tmp)\n");
        if ((f_data = fopen("ae_prosite.mtf", "w")) == (FILE *)NULL)
		fatal_error("update_prosite_data", "fopen error (ae_prosite.mtf)\n");
    }
    else {
        if ((f_temp = fopen("ae_user.tmp", "r")) == (FILE *)NULL)
		fatal_error("update_prosite_data", "fopen error (ae_user.tmp)\n");
        if ((f_data = fopen("ae_user.mtf", "w")) == (FILE *)NULL)
		fatal_error("update_prosite_data", "fopen error (ae_user.mtf)\n");
    }

    str_de[0] = str_pa[0] = '\0';
    while (fgets(str1, MAX_BUFF_MOTIF, f_temp) != NULL){
        if (str1[0]=='/' && str1[1]=='/'){
	    if (str_pa[0]!='\0'){
	        fprintf(f_data, str_de);
	        fprintf(f_data, str_pa);
	        process_str_pa(f_data, str_pa);
	        fprintf(f_data, "//\n");
	    }
	    str_de[0] = str_pa[0] = '\0';
	    previous = '/';
	}
        if (str1[0]=='D' && str1[1]=='E'){
	    if (previous=='D'){
	        sprintf(strchr(str_de,'\n'), &str1[5]);
	    }else{
                sprintf(str_de, &str1[5]);
	    }
	    previous = 'D';
	}
        if (str1[0]=='P' && str1[1]=='A'){
	    if (previous=='P'){
	        sprintf(strchr(str_pa,'\n'), &str1[5]);	        
	    }else{
                sprintf(str_pa, &str1[5]);
	    }
	    previous = 'P';
	}
    }
    fclose(f_temp);
    fclose(f_data);
}

/*
  աꥹȤΥꥢʥ
*/

void delete_motif()
{
    Motif *p_now = Motif_root, *p_old = Motif_root;
    Segment *p_now_seg, *p_old_seg;

    while (p_now!=NULL){
        p_old = p_now;
	p_now_seg = p_now->p_next_seg;
	while (p_now_seg!=NULL){
            p_old_seg = p_now_seg;
	    p_now_seg = p_now_seg->p_next_seg;
	    XtFree(p_old_seg);
	}
        p_now = p_now->p_next;
        XtFree(p_old);
    }
    Motif_root = NULL;
    p_motif = (Motif *)NULL;
}

/*
  աꥹȤ˥դɲä
*/

void add_motif(segment_cnt)
int segment_cnt;	/* ȿ */
{
    Motif *p_now = Motif_root, *p_old = Motif_root;
    Segment *p_now_seg, *p_old_seg;
    Bool first_flag = True;
    int i, count = 0;

    while (p_now!=NULL){
        count++;
        p_old = p_now;
        p_now = p_now->p_next;
    }

    if((p_now = (Motif *)calloc(1, sizeof(Motif))) == NULL){
	fatal_error("add_motif", "calloc error (Motif)\n");
    }else{
        if (count==0){
	    Motif_root = p_now;
        }else{
            p_old->p_next = p_now;
	}
        p_now->p_next = NULL;
	strcpy(p_now->title, now_title);
	strcpy(p_now->pattern, now_pattern);
#ifdef	MOTIF_SEARCH_NEW
	for (i=0; i<Info.alignnum; i++)
		p_now->alrpflag[i] = now_alrpflag[i];
#else
	for (i=0; i<Info.alignnum; i++)
		p_now->forbidden_align[i] = forbidden_flag[i];
#endif
/*
	p_now->segment_count = segment_cnt-1; 
*/
	p_now->segment_count = segment_cnt; 
	for (i=0; i<segment_cnt; i++){
            if((p_now_seg = (Segment *)calloc(1, sizeof(Segment))) == NULL){
		fatal_error("add_motif", "calloc error (Segment)\n");
            }else{
	        if (first_flag){
		    p_now->p_next_seg = p_now_seg;
		    first_flag = False;
		}else{
		    p_old_seg->p_next_seg = p_now_seg;
		}
		p_now_seg->p_next_seg = NULL;
		strcpy(p_now_seg->amino, &now_amino[i][0]);
		p_now_seg->forbidden = now_forbidden[i];
		p_now_seg->others = now_others[i];
		p_now_seg->min = now_min[i];
		p_now_seg->max = now_max[i];
		p_now_seg->repeat = now_repeat[i];
		p_now_seg->index = now_index[i];
	    }
	    p_old_seg = p_now_seg;
	}
    }
}

/*
  դθʣѥ
*/

#ifndef	MOTIF_SEARCH_NEW

Bool process_others(start, end, i, dir)  /* other aminoacid */
int *start, *end, i, dir;
{
#if	0
	(void)printf("process_others --- *start, *end, i, dir = %d %d %d %d\n",
		     *start, *end, i, dir);
#endif

/* new */
	if (dir == RIGHT) {
		if (*start + now_min[i] > Info.dataEndIndex)
			return False;
		else
			*start += now_min[i];
		if (*end + now_max[i] > Info.dataEndIndex)
			*end = Info.dataEndIndex;
		else
			*end += now_max[i];
	}
	else {
		if (*start - now_max[i] < Info.dataStartIndex)
			*start = Info.dataStartIndex;
		else
			*start -= now_max[i];
		if (*end - now_min[i] < Info.dataStartIndex)
			return False;
		else
			*end -= now_min[i];
	}

#if	0
	(void)printf("process_others --- return True\n");
#endif

    return True;
}

#endif

/*
  դθʶ§ѥ
*/

#ifndef	MOTIF_SEARCH_NEW

Bool process_forbidden(start, end, i, dir)  /* forbidden pattern */
int *start, *end, i, dir;
{
    int align, count, k, count_align;

#if	0
	(void)printf("process_forbidden --- *start, *end, i, dir = %d %d %d %d\n",
		     *start, *end, i, dir);
#endif

    /*printf("forbidden %d\n", i);*/
    if (now_min[i]!=now_max[i]){
        fprintf(stderr, "forbidden pattern not fixed!!\n%s%s", 
                now_title, now_pattern);
	return False;
    }
    if (*start!=*end){ 
        fprintf(stderr, "forbidden point not fixed!!\n%s%s", 
                now_title, now_pattern);
	return False;
    }
    for (align=0; align<Info.alignnum; align++){
	if (forbidden_flag[align]) continue;
	count = 0;
        for (k = *start; k*dir < (*start+now_max[i]*dir)*dir; k += dir){
            if (index(&now_amino[i][0], (int)Info.codeAlign[align][k]+'A')){
	        count++;
	    }
	}
	if (count==now_max[i]) forbidden_flag[align] = True;
    }
    count_align = 0;
    for (align=0; align<Info.alignnum; align++){
	if (forbidden_flag[align]) count_align++;
    }
    if (100*count_align/Info.alignnum > (100-motif_cut)) return False;
    *start += now_max[i]*dir;
    *end += now_max[i]*dir;

#if	0
	(void)printf("process_forbidden --- return True\n");
#endif

    return True;
}

#endif

/*
  դθʥաѥ
*/

#ifndef	MOTIF_SEARCH_NEW

Bool  process_motif(start, end, i)  /* motif pattern */
int *start, *end, i;
{
    int j, k, align, count, count_align, motif_ratio;

#if	0
	(void)printf("process_motif --- *start, *end, i = %d %d %d\n",
		     *start, *end, i);
#endif

    /*printf("motif amino %d \n", i);*/
    if (now_min[i]!=now_max[i]){
        fprintf(stderr, "motif pattern not fixed!!\n%s%s", 
                now_title, now_pattern);
	return False;
    }
    now_index[i] = -1;
    motif_ratio = 0;
    for (j = *start; j <= *end; j++){
        count_align = 0;
        for (align=0; align<Info.alignnum; align++){
	    if (forbidden_flag[align]) continue;
	    count = 0;
            for (k=j; k<j+now_max[i]; k++){
                if (index(&now_amino[i][0], (int)Info.codeAlign[align][k]+'A')){
	            count++;
	        }
	    }
	    if (count==now_max[i]) count_align++;
	}
	if (100*count_align/Info.alignnum >= motif_cut){
	    if (motif_ratio<(100*count_align/Info.alignnum)){
	        motif_ratio = 100*count_align/Info.alignnum;
		now_index[i] = j;
                /*printf("  %d\n", j);*/
		break;
	    }
	}
    }
   if (now_index[i]==-1) return False;
   *start = *end = now_index[i]+now_max[i];

#if	0
	(void)printf("process_motif --- return True\n");
#endif

   return True;
}

#endif

/*
  ո
*/

#ifndef	MOTIF_SEARCH_NEW

void search_pattern(segment_cnt)
int segment_cnt;
{
    int i, j, k, align, count, count_align, motif_ratio;
    int first_motif, temp_start, temp_end;
    int first_start = Info.dataStartIndex;
    int first_end = Info.dataEndIndex;
    int start = Info.dataStartIndex;
    int end = Info.dataEndIndex;
    Bool exist_flag = True;

#ifdef	DEBUG
	(void)printf("search_pattern --- in\n");
#endif

    /*printf("%s", now_title);
    printf("%s", now_pattern);*/
    for (align=0; align<Info.alignnum; align++) forbidden_flag[align] = False;
    for (i=0; i<segment_cnt; i++){
        if (!now_others[i] && !now_forbidden[i]){
	    first_motif = i;
	    break;
	}
    }        

    for (;;){
    RE_SEARCH:
	first_end = Info.dataEndIndex;
        if (!process_motif(&first_start, &first_end, first_motif)) return;
        start = end = now_index[first_motif]-1;
        for (i=first_motif-1; i>=0; i--){
            if (now_others[i]){
	        if (!process_others(&start, &end, i, LEFT)) goto RE_SEARCH;
	    }
            if (now_forbidden[i]){
	        if (!process_forbidden(&start, &end, i, LEFT)) goto RE_SEARCH;
	    }
        }
        start = first_start; end = first_end;	
        for (i=first_motif+1; i<segment_cnt; i++){
            if (now_others[i]){
	        if (!process_others(&start, &end, i, RIGHT)) goto RE_SEARCH;
	    }
            if (now_forbidden[i]){
	        if (now_min[i]!=now_max[i]){
		    fprintf(stderr, "forbidden pattern not fixed!!\n%s%s", 
			    now_title, now_pattern);
	            goto RE_SEARCH;	        
		}
	        if (start!=end){
		    temp_start = start+now_max[i];
		    temp_end = end+now_max[i];
		    if (!process_motif(&temp_start, &temp_end, i+1)) goto RE_SEARCH;
		    start = temp_start-now_max[i+1]-now_max[i]; 
		    end = temp_end-now_max[i+1]-now_max[i]; 
		}
	        if (!process_forbidden(&start, &end, i, RIGHT)) goto RE_SEARCH;
	    }
            if (!now_others[i] && !now_forbidden[i]){
	        if (!process_motif(&start, &end, i)) goto RE_SEARCH;
	    }
        }
        add_motif(segment_cnt);
    }

    /*printf("!!exists.\n");
    fprintf(stderr, "%s exists.\n", now_title);*/
}

#endif

/*
  Search ܥ򤵤줿˸ƤФ륳Хåؿ
  ae_prosite.dat ޤ ae_user.dat ɤ߹
*/

static void searchCB(widget, client_data, call_data)
Widget	widget;
caddr_t	client_data, call_data;
{
	extern char	motif_dir[BUFSIZ];
	char		pathname[BUFSIZ];
	char		command[BUFSIZ];
    FILE *f_data;
    Bool header_flag = True;
    struct stat input_data, mtf_data;
    int  r;
    int  i, read_count = 0, segment_cnt = 0;
    char read_buff[MAX_BUFF_MOTIF];

    if (dict_mode == 1) {
	if (*motif_dir == '\0')
		(void)strcpy(pathname, "prosite.dat");
	else {
		(void)strcpy(pathname, motif_dir);
		(void)strcat(pathname, "/prosite.dat");
	}
        if (stat(pathname, &input_data))
		fatal_error("searchCB", "stat error (prosite.dat)\n");
        r = stat("ae_prosite.mtf", &mtf_data);
        if (r || input_data.st_mtime > mtf_data.st_mtime){
	    (void)sprintf(command, "egrep '//|DE   |PA   ' %s > ae_prosite.tmp", pathname);
            system(command);
            update_prosite_data();
        }
    }
    else {
	if (*motif_dir == '\0')
		(void)strcpy(pathname, "user.dat");
	else {
		(void)strcpy(pathname, motif_dir);
		(void)strcat(pathname, "/user.dat");
	}
        if (stat(pathname, &input_data))
		fatal_error("searchCB", "stat error (user.dat)\n");
        r = stat("ae_user.mtf", &mtf_data);
        if (r || input_data.st_mtime > mtf_data.st_mtime){
	    (void)sprintf(command, "egrep '//|DE   |PA   ' %s > ae_user.tmp", pathname);
            system(command);
            update_prosite_data();
        }
    }

/*
    delete_motif_sublist();
*/
    delete_motif_list();
    delete_motif();

    /* read loop */
    segment_cnt = 0;
    if (dict_mode == 1) {
        if ((f_data = fopen("ae_prosite.mtf", "r")) == (FILE *)NULL)
		fatal_error("searchCB", "fopen error (ae_prosite.mtf)\n");
    }
    else {
        if ((f_data = fopen("ae_user.mtf", "r")) == (FILE*)NULL)
		fatal_error("searchCB", "fopen error (ae_user.mtf)\n");
    }
    while (fgets(read_buff, MAX_BUFF_MOTIF, f_data) != NULL){ 
        read_count++;
        if (read_buff[0]=='/' && read_buff[1]=='/'){
#if	0
	    fprintf(stderr, "%s%s", now_title, now_pattern);
	    for(i = 0; i < segment_cnt; i++){
                (void)printf("%s%d\t%d\t%d\t%d\n",
			     &now_amino[i][0],
			     now_forbidden[i], 
			     now_others[i],
			     now_min[i],
			     now_max[i]);
	    }
#endif
#ifdef	MOTIF_SEARCH_NEW
	    search_pattern_2(segment_cnt);
#else
	    search_pattern(segment_cnt);
#endif
	    header_flag = True;
	    read_count = 0;
	    segment_cnt = 0;
	}
	if (header_flag){
	    switch (read_count){
	        case 1:
	            strcpy(now_title, read_buff);
		    break;
		case 2:
		    strcpy(now_pattern, read_buff);
		    header_flag = False;
		    read_count = 0;
		    break;
		default:
		    break;
	    }
	}else{
	    switch (read_count){
	        case 1:
	            strcpy(&now_amino[segment_cnt][0], read_buff);
		    break;
		case 2:
		    now_forbidden[segment_cnt] = (Bool)atoi(read_buff);
		    break;
		case 3:
		    now_others[segment_cnt] = (Bool)atoi(read_buff);
		    break;
		case 4:
		    now_min[segment_cnt] = atoi(read_buff);
		    break;
		case 5:
		    now_max[segment_cnt] = atoi(read_buff);
		    read_count = 0;
		    segment_cnt++;
		    break;
		default:
		    break;
	    }
	}
    }

    fclose(f_data);

#ifdef	DEBUG
    output_motif_root_l();
#endif

    add_motif_list();
}

/*
  Undisp ܥ򤵤줿˸ƤФ륳Хåؿ
  оݤȤƤĤΥդõ
*/

static void undispCB(w,flag,call_data)
Widget   w;
int      flag;
caddr_t  *call_data;
{
    int i, j, k, align, count, start, end;
    char motif_name[MAX_BUFF_MOTIF];

    XtSetSensitive(pb_undisp, False);
    XtSetSensitive(pb_search, True);
    XmListDeselectAllItems(list);
    XmListDeselectAllItems(list_sub);
    for (i=0; i<sub_num; i++){
        strcpy(motif_name, p_sub[i]->title);
        strcat(motif_name, p_sub[i]->pattern);
        if (XmListItemExists(list_sub,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET)))
            XmListDeleteItem(list_sub,
			     XmStringCreateLtoR(motif_name, XmSTRING_DEFAULT_CHARSET));
    }
    undisp_one_motif_2(XtDisplay(da), XtWindow(da));
    XtPopdown(dialog_motif_sub);
    sub_num = 0;
    p_motif = NULL;
}

/*
  Exit ܥ򤵤줿˸ƤФ륳Хåؿ
*/

static void cancel_motifCB(w,flag,call_data)
Widget   w;
int      flag;
caddr_t  *call_data;
{
    XtPopdown(dialog_motif_sub);
    XtPopdown(dialog_motif);
}

/*
  MotifSearch ܥ򤵤줿˸ƤФ륳Хåؿ
*/

void motif_search(dictmode)
int	dictmode;
{
    int  bb_width = 435, bb_height = 350;
    static Bool first_flag = True;
    static Widget bb, scale, pb_exit, bb_sub;
    Arg    args[10];
    extern motif_list_ready;

    dict_mode = dictmode;

#if	0
    (void)printf("motif_search --- dict_mode = %d\n", dict_mode);
#endif

    if (first_flag){
        first_flag = False;
	motif_list_ready = True;
        XtSetArg(args[0],XmNallowShellResize,True);
        XtSetArg(args[1],XmNheight,350);
        dialog_motif = XtCreatePopupShell("motif_search_dialog",
					  transientShellWidgetClass,
					  menu_top,
					  args, 2);
        XtSetArg(args[1],XmNx,450);
        dialog_motif_sub = XtCreatePopupShell("motif_search_overlap_dialog",
					      transientShellWidgetClass,
					      menu_top,
					      args, 2);

        XtSetArg(args[0],XmNwidth,bb_width);
        XtSetArg(args[1],XmNheight,bb_height);
        bb = XmCreateBulletinBoard(dialog_motif, "motif_search", args, 2);
	XtManageChild(bb);
        bb_sub = XmCreateBulletinBoard(dialog_motif_sub,
				       "motif_search_sub",
				       args, 2);
	XtManageChild(bb_sub);
        
        XtSetArg(args[0],XmNorientation,XmHORIZONTAL);
        XtSetArg(args[1],XmNprocessingDirection, XmMAX_ON_RIGHT);
        XtSetArg(args[2],XmNshowValue,True);
        XtSetArg(args[3],XmNx,0);
        XtSetArg(args[4],XmNy,20);
        XtSetArg(args[5],XmNwidth,200);
	scale = XmCreateScale(bb, "cut_value", args, 6);
	XtManageChild(scale);
        XtAddCallback(scale,XmNdragCallback,motif_scaleCB,2);
        XtAddCallback(scale,XmNvalueChangedCallback,motif_scaleCB,2);

        XtSetArg(args[0],XmNx,212);
        XtSetArg(args[1],XmNy,30);
        pb_search = XmCreatePushButton(bb, "Search", args, 2);
	XtManageChild(pb_search); 
        XtAddCallback(pb_search,XmNactivateCallback,searchCB,NULL);
        XtSetArg(args[0],XmNx,267);
        pb_constraint = XmCreatePushButton(bb, "Constraint", args, 2);
	XtManageChild(pb_constraint);
        XtAddCallback(pb_constraint,XmNactivateCallback,cancel_motifCB,NULL);
        XtSetArg(args[0],XmNx,350);
        pb_undisp = XmCreatePushButton(bb, "Undisp", args, 2);
	XtManageChild(pb_undisp);
        XtAddCallback(pb_undisp,XmNactivateCallback,undispCB,NULL);
        XtSetArg(args[0],XmNx,405);
        pb_exit = XmCreatePushButton(bb, "Exit", args, 2);
	XtManageChild(pb_exit);
        XtAddCallback(pb_exit,XmNactivateCallback,cancel_motifCB,NULL);

        XtSetArg(args[0],XmNwidth,bb_width);
        XtSetArg(args[1],XmNheight,275);
        XtSetArg(args[2],XmNx,0);
        XtSetArg(args[3],XmNy,60);
        XtSetArg(args[4],XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
 	list = (Widget)XmCreateScrolledList(bb, "list", args, 5);
        XtManageChild(list);
	XtAddCallback(list, XmNbrowseSelectionCallback, motif_selectCB, NULL);
        XtSetArg(args[0],XmNheight,0);
        XtSetArg(args[1],XmNx,0);
        XtSetArg(args[2],XmNy,0);
        XtSetArg(args[3],XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
 	list_sub = (Widget)XmCreateScrolledList(bb_sub, "list_sub", args, 4);
        XtManageChild(list_sub);
	XtAddCallback(list_sub, XmNbrowseSelectionCallback, motif_select_subCB, NULL);

	XtSetSensitive(pb_constraint, False);
	XtSetSensitive(pb_undisp, False);
    }
    XtVaSetValues(scale, XmNvalue, motif_cut, NULL);
    XtPopup(dialog_motif,XtGrabNone); 
    if (sub_num>0) XtPopup(dialog_motif_sub,XtGrabNone);  
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
