/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	main.c
----------------------------------------------------------------------*/

#include  <stdio.h>
#include  <math.h>
#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/cursorfont.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>
#include  <X11/Shell.h>
#include  <X11/keysym.h>
#include  <Xm/DrawingA.h>
#include  <Xm/MessageB.h>
#include  <Xm/PushB.h>
#include  <Xm/PushBG.h>
#include  <Xm/RowColumn.h>
#include  <Xm/Text.h>
#include  <Xm/ToggleBG.h>
#include  <Xm/ToggleB.h>
#include  <Xm/Scale.h>
#include  <Xm/ScrollBar.h>
#include  <Xm/ScrolledW.h>
#include  <Xm/SelectioB.h>
#include  <Xm/MainW.h>
#include  <varargs.h>
#include  <signal.h>
#include  <setjmp.h>
#include  <ctype.h>
#include  "aedit.h"
#include  "menu.h"


#define EV_MASK  (ButtonPressMask  | \
                  ButtonReleaseMask  | \
                  PointerMotionMask  | \
                  KeyReleaseMask     | \
                  KeyPressMask     | \
                  ExposureMask     | \
                  EnterWindowMask     | \
                  LeaveWindowMask     | \
                  VisibilityChangeMask     | \
                  SubstructureNotifyMask     | \
                  ColormapChangeMask     | \
                  PropertyChangeMask     | \
                  ResizeRedirectMask     | \
                  SubstructureRedirectMask     | \
                  FocusChangeMask     | \
                  StructureNotifyMask)


/* append (begin) */

#if	0
#define	DEBUG
#endif

#if	0
#define	OUTPUT_EVENT
#endif

/* append (end) */

void processEvent();
extern net_okCB();
extern net_cancelCB();

extern MENUITEM  file_menu[], edit_menu[], edit_mode_menu[], font_menu[],
                 logfile_menu[], options_menu[], color_menu[], network_menu[];
/*
extern MENUITEM  file_sub_menu1[];
*/
extern MENUITEM  options_sub_menu1[], options_sub_menu2[], options_sub_menu3[];

XtAppContext  app1, app2, app3;

Widget        menu_top, aedit_top, pd_edit, da, da2, w2, result;
Widget        sw, net_ok, net_cancel, pd_net;
Display  *dpy1, *dpy2, *dpy3;

extern XtAppContext	apc_gltrupg, apc_gltrnj;
extern Display		*dsp_gltrupg, *dsp_gltrnj;
extern Widget		da_gltrupg, da_gltrnj;
extern Boolean		draw_gltrupg, draw_gltrnj;

jmp_buf  JumpEnv;

/*--------------------------------------------------------------------*/

extern MENUITEM	options_submenu_tree[];
extern MENUITEM	options_submenu_motif_search[];
extern MENUITEM	stemfinder_submenu[];

/*--------------------------------------------------------------------*/

sig_hand(sig)
int sig;
{
	void		exit();

  socketClose();
/*  printf("Socket close done.\n"); */
  exit(0);
}
  
/*--------------------------------------------------------------------*/
   
refresh(w,client_data,call_data)
Widget  w;
caddr_t client_data,call_data;
{
	extern void	display_aedit_win_2();

	display_aedit_win_2();
}

/*--------------------------------------------------------------------*/

process_OK_button(w,client_data,call_data)
Widget  w;
caddr_t client_data,call_data;
{
process_OK();
}

select_da(w)
Window w;
{
   if (w == XtWindow(da)){
#ifdef	OUTPUT_EVENT
   (void)printf("select da\n");
#endif
       TheDisplay = dpy2;
       TheWindow = XtWindow(da);
       Result_draw = False;
       draw_gltrupg = False;
       draw_gltrnj = False;
   }
   if (w == XtWindow(da2)){
#ifdef	OUTPUT_EVENT
   (void)printf("select da2\n");
#endif
       TheDisplay = dpy3;
       TheWindow = XtWindow(da2);
       Result_draw = True;
       draw_gltrupg = False;
       draw_gltrnj = False;
   }
/* append (begin) */
   if (w == XtWindow(da_gltrupg)){
#ifdef	OUTPUT_EVENT
   (void)printf("select da_gltrupg\n");
#endif
       TheDisplay = dsp_gltrupg;
       TheWindow = XtWindow(da_gltrupg);
       Result_draw = False;
       draw_gltrupg = True;
       draw_gltrnj = False;
   }
   if (w == XtWindow(da_gltrnj)){
#ifdef	OUTPUT_EVENT
   (void)printf("select da_gltrnj\n");
#endif
       TheDisplay = dsp_gltrnj;
       TheWindow = XtWindow(da_gltrnj);
       Result_draw = False;
       draw_gltrupg = False;
       draw_gltrnj = True;
   }
/* append (end) */
}


main(argc,argv)
int   argc;
char *argv[];
{
	extern char	motif_dir[BUFSIZ];
	extern char	*usage_format;
   Widget   rowcol, w, menubar;
   Arg   args[10];
   XSetWindowAttributes  att, att2;
   FILE *fp, *openRcFile(), *openFile();
   XGCValues   gcv;
   Cursor      cs;
   int     i, dummy, code, fg, bg, c;
   XWMHints  wmh, wmh2;
   char     str[20];
   char  *p;
   XFontStruct  *fs;
   XEvent   event1, event2, event3;
	char	aedfile[BUFSIZ], mfile[BUFSIZ];
	int	mflag;
	char	msg[BUFSIZ];
	char	*md;
	void	argument_proc();
	void	error();
	void	exit();
	char	*getenv();

/* append (begin) */

	XEvent		event4, event5;
/*
	extern void	unlink_tmpaedfile();
	void		set_tmpaedfile_name();
*/
	extern void	set_nmatrix();
	extern void	set_dmatrix();
	void		set_tmpaedfile_alarm();

/* append (end) */

	/* $BI8=`=PNO$N%P%C%U%!$rL$;HMQ$H$9$k(B */
	setbuf(stdout, NULL);

	/* $B%0%m!<%P%kJQ?t$K%G%U%)%k%H$NCM$r@_Dj$9$k(B */
	setGlobalDefault();

	/* aedit.rc$B%U%!%$%k$rFI$_9~$`(B */
	fp = openRcFile();
	if (fp) {
		readRcFile(fp);
		fclose(fp);
	}

	if ((md = getenv("AEDIT_MOTIF_DIR")) == (char *)NULL)
		*motif_dir = '\0';
	else
		(void)strcpy(motif_dir, md);

	/* $B0z?t$N=hM}!J#1!K(B */
	argument_proc(&argc, argv, aedfile, &mflag, mfile);

	if (mflag == 1) {
		/* Nmatrix$B$N@_Dj(B */
		if (mfile[0] != '\0')
			set_nmatrix(mfile);
		NA_flag =True;
	}
	else if (mflag == 2) {
		/* Dmatrix$B$N@_Dj(B */
		if (mfile[0] != '\0')
			set_dmatrix(mfile);
	}

#if	0
	if (NA_flag == True)
		output_nmatrix();
	else
		output_dmatrix();
#endif

#if	0

   if (argc==2  && !strcmp(argv[1], "-n")){
      NA_flag =True;
      argc=1;
   }
   if (argc == 3){
       if (!strcmp(argv[2], "-n")){
           NA_flag =True;
           argc=2;
       }
       if (!strcmp(argv[1], "-n")){
           NA_flag =True;
           argc=2;
           argv[1] = argv[2];
       }
   }

#endif

   if (NA_flag){
      UU = 20; VV = 5; SS = 5;
      fprintf(stderr, "*****  Nucleic Acid Mode  *****\n");
   }

/* append (begin) */

/*
	set_tmpaedfile_name();
	unlink_tmpaedfile();
*/

	/* $B%F%s%]%i%j%U%!%$%k!J%"%i%$%a%s%H!&%(%G%#%?!&%U%!%$%k!K$N@_Dj(B */
	set_tmpaedfile_alarm();

/* append (end) */

   signal(SIGINT,sig_hand);
   signal(SIGQUIT,sig_hand);
   signal(SIGTERM,sig_hand);
   signal(SIGHUP,sig_hand);

   XtToolkitInitialize();
   app1 = XtCreateApplicationContext();
   dpy1 = XtOpenDisplay(app1,NULL,"menu_top","Menutop",NULL,0,&argc,argv);

   XtSetArg(args[0],XmNx,  0);
   XtSetArg(args[1],XmNy,  1);
   XtSetArg(args[2],XmNallowShellResize,  True);
   fprintf(stderr, "PASS1\n");

   menu_top = XtAppCreateShell("Top Menu","Menutop",applicationShellWidgetClass,
                                dpy1,args,3);
   fprintf(stderr, "PASS2\n");

   app2= XtCreateApplicationContext();
   dpy2 = XtOpenDisplay(app2,NULL,"aedit_top","Aedit",NULL,0,&argc,argv);
   fprintf(stderr, "PASS3\n");

   XtSetArg(args[0],XmNx,   0);
   XtSetArg(args[1],XmNy,   100);
   XtSetArg(args[2],XmNwidth, 1000);
   XtSetArg(args[3],XmNheight, 850);
   XtSetArg(args[4],XmNallowShellResize,  True);
   XtSetArg(args[5],XmNminWidth, 800);
   XtSetArg(args[6],XmNminHeight, 600);
   aedit_top = XtAppCreateShell("aedit_top","Aedit",applicationShellWidgetClass,
                                dpy2,args,7);

   fprintf(stderr, "PASS4\n");

   TheDisplay = dpy2;
     
/* append (begin) */

	create_window_gltrupg_1(&argc, argv);
	create_window_gltrnj_1(&argc, argv);

/* append (end) */

   app3 = XtCreateApplicationContext();
   dpy3 = XtOpenDisplay(app3,NULL,"result","Result",NULL,0,&argc,argv);
   fprintf(stderr, "PASS5\n");

   XtSetArg(args[0],XmNx,   1);
   XtSetArg(args[1],XmNy,   500);
   XtSetArg(args[2],XmNwidth, 1000);
   XtSetArg(args[3],XmNheight, 850);
   XtSetArg(args[4],XmNallowShellResize,  True);
   XtSetArg(args[5],XmNminWidth, 800);
   XtSetArg(args[6],XmNminHeight, 200);
   /*XtSetArg(args[7],XmNmappedWhenManaged,  False);*/
   result = XtAppCreateShell("Result","Result",applicationShellWidgetClass,
                                dpy3,args,7);

   fprintf(stderr, "PASS6\n");

	/* $B0z?t$N=hM}!J#2!K(B */

	if (*aedfile != '\0') {
		(void)strcpy(FileName, aedfile);
		if ((fp = fopen(FileName, "r")) == NULL) {
			(void)fprintf(stderr, "%s can't open\n", FileName);
			exit(1);
		}
		readSeq(fp);
		fclose(fp);
	}
	else {
		initSeq();
		*FileName = '\0';  /* mark of no file specified currently */
	}

	if (argc != 1) {
		(void)sprintf(msg, usage_format, *argv);
		error(msg);
	}

#if	0

   if(argc==1) {
      initSeq();
      FileName[0]=0;  /* mark of no file specified currently */
   }
   else if(argc==2) {
      strcpy(FileName,argv[1]);
      if((fp = fopen(FileName,"r")) == NULL) {
         fprintf(stderr,"%s can't open\n",FileName);
         exit(1);
      }
      readSeq(fp);
      fclose(fp);
   }
   else {
      fprintf(stderr,"usage: %s [file] \n",argv[0]);
      exit(1);
   }

#endif

   rowcol = XtVaCreateManagedWidget("rowcol",
               xmRowColumnWidgetClass, menu_top,
               XmNorientation, XmHORIZONTAL,
               XmNwidth,  800,
               XmNheight, 28,
               NULL);

   /* Load initial fonts */
   fs = XLoadQueryFont(TheDisplay,"a16");
   if(!fs) {
      fs = XLoadQueryFont(TheDisplay,"9x13");
/*
(void)printf("main --- font name is 9x13\n");
*/
   }
   if(!fs)
      fs = XLoadQueryFont(TheDisplay,"a14");
   if(!fs)
      fs = XLoadQueryFont(TheDisplay,"k16");
   if(!fs)
      fs = XLoadQueryFont(TheDisplay,"r16");
   if(!fs)
      fs = XLoadQueryFont(TheDisplay,"variable");
   if(!fs) {
      fs = XLoadQueryFont(TheDisplay,"fixed");
/*
(void)printf("main --- font name is fixed\n");
*/
   }
   if(!fs)
      fs = XLoadQueryFont(TheDisplay,"6x13");
   if(!fs) {
      fprintf(stderr,"Can't find font for menu\n");
      exit(1);
   }

   menubar = XmCreateMenuBar(rowcol, "menubar", NULL,0);
   (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"File",'F',file_menu);
   pd_edit = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Edit",'E',edit_menu);
   (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"EditMode",'M',edit_mode_menu);
   (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"TreeDrawer",'T',options_submenu_tree); 
   if (NA_flag)
      (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"StemFinder",'S',stemfinder_submenu); 
   else
      (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"MotifSearch",'S',options_submenu_motif_search); 
   pd_net =  BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Alignment",'A',network_menu);  
   (void)BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Options",'O',options_menu);
  
   /* Initial state is View(VIEW) mode */
   XtSetSensitive(pd_edit,False);
   XtSetSensitive(pd_net,False);
   XtManageChild(menubar);

   w = XmCreatePushButton(rowcol,"Refresh", NULL,0);
   XtAddCallback(w,XmNactivateCallback,refresh,NULL);
   XtManageChild(w);
   w2 = XmCreatePushButton(rowcol,"  Set  ", NULL, 0);
   XtAddCallback(w2,XmNactivateCallback,process_OK_button,NULL);
   XtManageChild(w2);
   XtSetSensitive(w2, False);

   /*** drawing area ***/
   da = XtVaCreateManagedWidget("da",
                   xmDrawingAreaWidgetClass, aedit_top,
                   XmNwidth,  1000,
                   XmNheight,  850,
                   NULL);

/* append (begin) */

	create_window_gltrupg_2();
	create_window_gltrnj_2();

/* append (end) */

   /*** drawing area for result data ***/
   XtSetArg(args[0], XmNscrollingPolicy, XmAUTOMATIC);
   XtSetArg(args[1], XmNscrollBarDisplayPolicy, XmSTATIC);
   XtSetArg(args[2], XmNscrollBarPlacement, XmTOP_LEFT);
   XtSetArg(args[3], XmNwidth, 1000);
   XtSetArg(args[4], XmNheight, 850);
   sw = XmCreateScrolledWindow(result, "sw", args, 5); XtManageChild(sw);
   XtSetArg(args[0], XmNx, 12);
   net_ok = XmCreatePushButton(sw, "Embed", args,1); 
   XtManageChild(net_ok); 
   XtAddCallback(net_ok, XmNactivateCallback, net_okCB, NULL);
   XtSetArg(args[0], XmNx, 65);
   net_cancel = XmCreatePushButton(sw, "Cancel", args, 1); 
   XtManageChild(net_cancel);
   XtAddCallback(net_cancel, XmNactivateCallback, net_cancelCB, NULL);
   da2 = XmCreateDrawingArea(sw, "da2", NULL, NULL); XtManageChild(da2); 
   XmScrolledWindowSetAreas(sw, NULL, NULL, da2);

   XtRealizeWidget(aedit_top);
   /*XtRealizeWidget(result);*/
  
   XtAddEventHandler(da,EV_MASK,
                     False,processEvent,NULL);
   XtAddEventHandler(da2,EV_MASK,
                     False,processEvent,NULL);
/* append (begin) */
   XtAddEventHandler(da_gltrupg,EV_MASK,
                     False,processEvent,NULL);
   XtAddEventHandler(da_gltrnj,EV_MASK,
                     False,processEvent,NULL);
/* append (end) */
   initial_common_dialog(menu_top);

   TheWindow = XtWindow(da);
   TheScreen = DefaultScreen(TheDisplay);
   TheDepth = DefaultDepth(TheDisplay,TheScreen);
   TheBlackPixel = BlackPixel(TheDisplay,TheScreen);
   TheWhitePixel = WhitePixel(TheDisplay,TheScreen);
   TheColormap = DefaultColormap(TheDisplay,TheScreen);
   TheRoot = RootWindow(TheDisplay,TheScreen);

   /* Set WinW, WinH */
    XGetGeometry(TheDisplay,TheWindow,&dummy,&dummy,&dummy,
                 &WinW,&WinH,&dummy,&dummy);
    fprintf(stderr, "WinW,WinH=%d,%d\n",WinW,WinH);

   initOurColors();   

   /* Big Text fonts */
   FontStruct = XLoadQueryFont(TheDisplay,"a24");
   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"k24");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"rk24");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"k16");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"a16");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"9x15");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"variable");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"fixed");

   XSetFont(TheDisplay,BigTextGC,FontStruct->fid);

   /* Middle Text fonts */
   FontStruct = XLoadQueryFont(TheDisplay,"fg-20");
   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"a16");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"9x15");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"9x13");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"variable");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"k16");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"fixed");

   XSetFont(TheDisplay,MiddleTextGC,FontStruct->fid);

   /* Normal Text fonts */
   FontStruct = XLoadQueryFont(TheDisplay,"a14");
   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"rk14");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"fg-16");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"fixed");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"k14");

   if(!FontStruct)
      FontStruct = XLoadQueryFont(TheDisplay,"variable");

   if (NA_flag) FontStruct = XLoadQueryFont(TheDisplay,"5x8");

   for(code=0; code<MAXCODE; ++code)  {
      XSetFont(TheDisplay,AminoCharGC[code],FontStruct->fid);
   }

   XSetFont(TheDisplay,TextGC,FontStruct->fid);
   XSetFont(TheDisplay,BlackGC,FontStruct->fid);
   XSetFont(TheDisplay,WhiteGC,FontStruct->fid);
   XSetFont(TheDisplay,FixedColumnGC,FontStruct->fid);

   fontParams();

   /* set initial cursor position */
   ActiveCol = 0;
   ActiveIndex = INITIAL_DATA_START_INDEX;
   ActiveAlign = 0;
   ActiveYo = TopMargin + 2*BoxH;   /* 2*BoxH for display column lines */
   ActiveXo = LeftMargin;

/***
   XtSetArg(args[0],XmNbackground,&bg);
   XtGetValues(da,args,1);
   XSetForeground(TheDisplay, DrawBackGC, bg);
***/

   att.backing_store = WhenMapped;
   XChangeWindowAttributes(TheDisplay, XtWindow(da),
                            CWBackingStore,&att);

   wmh.input = False;
   wmh.flags = InputHint;
   XSetWMHints(TheDisplay,XtWindow(aedit_top),&wmh);
   XStoreName(TheDisplay, XtWindow(aedit_top),
              "Alignment Editor  Ver. 1.60                 (c)ICOT , 1994");

   /*att2.backing_store = WhenMapped;
   XChangeWindowAttributes(dpy3, XtWindow(da2),
                            CWBackingStore,&att2);
   wmh2.input = FALSE;
   wmh2.flags = InputHint;
   XSetWMHints(dpy3,XtWindow(result),&wmh2);*/

/*   setjmp(JumpEnv); */

/*   printf("Enter Loop\n"); */

   XtRealizeWidget(menu_top);

   adjustMenuItems();

   for (i=0; i<MAX_ALIGN_LENG; i++){
       Region_divide[i] = False;
       Region_flag[i] = False;
   }
   for (i=0; i<3; i++) Button_flag[i] = False;

   for(;;) {
      if(XtAppPending(app1)) {   /* if exist event */
          XtAppNextEvent(app1,&event1);
          if(event1.type == MappingNotify) {
             XRefreshKeyboardMapping(&event1);
             fprintf(stderr, "MappingNotify event occured in top_menu\n"); 
          }
          else
             XtDispatchEvent(&event1);
      }

      if(XtAppPending(app2)) {   /* if exist event */
          XtAppNextEvent(app2,&event2);
          if(event2.type == MappingNotify) {
             XRefreshKeyboardMapping(&event2);
             fprintf(stderr, "MappingNotify event occured in aedit\n"); 
          }
          else
             XtDispatchEvent(&event2);
      }

      if(XtAppPending(app3)) {   /* if exist event */
          XtAppNextEvent(app3,&event3);
          if(event3.type == MappingNotify) {
             XRefreshKeyboardMapping(&event3);
             fprintf(stderr, "MappingNotify event occured in aedit\n"); 
          }
          else
             XtDispatchEvent(&event3);
      }

/* append (begin) */
      if(XtAppPending(apc_gltrupg)) {   /* if exist event */
          XtAppNextEvent(apc_gltrupg,&event4);
          if(event4.type == MappingNotify) {
             XRefreshKeyboardMapping(&event4);
             fprintf(stderr, "MappingNotify event occured in aedit\n"); 
          }
          else
             XtDispatchEvent(&event4);
      }

      if(XtAppPending(apc_gltrnj)) {   /* if exist event */
          XtAppNextEvent(apc_gltrnj,&event5);
          if(event5.type == MappingNotify) {
             XRefreshKeyboardMapping(&event5);
             fprintf(stderr, "MappingNotify event occured in aedit\n"); 
          }
          else
             XtDispatchEvent(&event5);
      }
/* append (end) */
   }
}


void processEvent(w,client_data,event)
Widget   w;
caddr_t  client_data;
XEvent   *event;
{
   int    i,count,status;
   XEvent ahead;
   static unsigned long serial_bak=0;

   select_da(event->xany.window);
/*   fprintf(stderr, "drawing:%d  type:%d\n", Result_draw, event->type);*/

   switch(event->type) {
   case Expose:
#ifdef	OUTPUT_EVENT
      (void)printf("Expose event occur \n");
#endif
      if(event->xexpose.count==0) {
         /*fprintf(stderr, "new:%d\n", event->xany.serial);*/
         /*fprintf(stderr, "bak:%d\n", serial_bak);*/
         if (!(Result_draw && (serial_bak == event->xany.serial))){
             /*printf("ExposureNotify event occur \n");*/
             disp(TRUE);
             serial_bak = event->xany.serial;
         }
      }
      break;
   case MappingNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("MappingNotify event occur \n");
#endif
      XRefreshKeyboardMapping(event);
      break;
   case ConfigureNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("ConfigureNotify event occur \n");
#endif
      if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
          WinW = event->xconfigure.width;
          WinH = event->xconfigure.height;
          fontParams();
      }

      count=XEventsQueued(TheDisplay,QueuedAfterReading);
      for(i=0; i<count; ++i) {
          XPeekEvent(TheDisplay,&ahead);
          if(ahead.type == Expose)  return;
      }

      if (!Result_draw) {
          disp(TRUE);
      }
      break;
   case EnterNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("EnterNotify event occur \n");
#endif
#ifdef	TWM
      XSetInputFocus(TheDisplay,TheWindow,RevertToParent,event->xcrossing.time);
      status=XGrabKeyboard(TheDisplay,TheWindow,True,
                           GrabModeAsync,GrabModeAsync,event->xcrossing.time+1);
      printGrabStatus("EnterNotify",status); 
      XFlush(TheDisplay);
#endif
      break;
   case LeaveNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("LeaveNotify event occur \n");
#endif
      XAllowEvents(TheDisplay,AsyncKeyboard,event->xcrossing.time);
      XUngrabKeyboard(TheDisplay,event->xcrossing.time);
      XFlush(TheDisplay);
      break;
   case ButtonRelease:
#ifdef	OUTPUT_EVENT
      (void)printf("ButtonRelease event occur \n");
#endif
      if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
	  if (EditMode == MOVE_ALIGNMENT) {
	      if (event->xbutton.button == Button1) {
                  Button_flag[event->xbutton.button - 1] = False;
	          button_release_mval(w, event);
	      }
	  }
	  else if (EditMode == ALIGNMENT_MANUAL) {
	      if (event->xbutton.button == Button1 ||
		  event->xbutton.button == Button3   ) {
                  Button_flag[event->xbutton.button - 1] = False;
	          button_release_almn(w, event);
	      }
	  }
	  else {
              Button_flag[event->xbutton.button - 1] = False;
              processRelease(w,event);
	  }
      }
      break;
   case ButtonPress:
#ifdef	OUTPUT_EVENT
      (void)printf("ButtonPress event occur \n");
#endif
      if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
	  if (EditMode == MOVE_ALIGNMENT) {
	      if (event->xbutton.button == Button1) {
                  Button_flag[event->xbutton.button - 1] = True;
	          button_press_mval(w, event);
	      }
	  }
	  else if (EditMode == ALIGNMENT_MANUAL) {
	      if (event->xbutton.button == Button1 ||
		  event->xbutton.button == Button3   ) {
                  Button_flag[event->xbutton.button - 1] = True;
	          button_press_almn(w, event);
	      }
	  }
	  else {
              Button_flag[event->xbutton.button - 1] = True;
              processPress(w,event);
	  }
      }
      break;
   case MotionNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("MotionNotify event occur \n");
#endif
      if ((Button_flag[0] || Button_flag[1] || Button_flag[2]) &&
	  !Result_draw                                         &&
	  !draw_gltrupg                                        &&
	  !draw_gltrnj                                           ) {
	  if (EditMode == MOVE_ALIGNMENT)
	      pointer_motion_mval(w, event);
	  else if (EditMode == ALIGNMENT_MANUAL)
	      pointer_motion_almn(w, event);
	  else
	      processMotion(w, event);
      }
      break;
   case KeyPress:
#ifdef	OUTPUT_EVENT
      (void)printf("KeyPress event occur \n");
#endif
      set_Shift_flag(w, event);
      /*fprintf(stderr, "%d %d %d\n", event->xkey.state, event->xkey.keycode, XK_Shift_L);*/
      /*if(EditMode == VIEW || EditMode == NORMAL) {
         if(processKeyPress2(w,event) && 
            CalcColumnCost) 
              disp_cost(True);
      }*/
      if (EditMode == INSERT || EditMode == OVER_WRITE){
         if(processKeyPress1(w,event) &&   /* if modified */
            CalcColumnCost) 
              disp_cost(True);
      }
      break;
   case KeyRelease:
#ifdef	OUTPUT_EVENT
      (void)printf("KeyRelease event occur \n");
#endif
      reset_Shift_flag(w, event);
      break;
   case VisibilityNotify:
#ifdef	OUTPUT_EVENT
      (void)printf("VisibilityNotify event occur \n");
#endif
      break;
   case FocusIn:
#ifdef	OUTPUT_EVENT
      (void)printf("FocusIn event occur \n");
#endif
      if (Result_flag && !Result_draw){
	  Result_flag = False;
	  disp_cost(True);
	  disp(True);
      }
      break;
   case FocusOut:
#ifdef	OUTPUT_EVENT
      (void)printf("FocusOut event occur \n");
#endif
      break;
   default :
#ifdef	OUTPUT_EVENT
      (void)printf("unexpected event occur (%d)\n", event->type);
#endif
      break;
   }
}



/* HYOUSI KANNKEI NO Global variables */
/* This must be called when fonts/window size/alignment strings  has changed */
fontParams()
{
  int          i;
  INFO         *cp;
  XChar2b      theChar;
  XCharStruct  metrics;
  int direction,fontascent,fontdescent,xoff,yoff;

  BoxW = FontStruct->max_bounds.width + FONT_PAD*2;
  BoxH = FontStruct->descent + FontStruct->ascent + FONT_PAD*2;
  LeftMargin = MaxAlignName*BoxW+20;

  Info.rowH = (Info.alignnum+YobiN)*BoxH;

  if(FontStruct->min_byte1 != 0) Kanji=True;
  else                           Kanji=False;

  if(Kanji) {
     for(i=0; ; ++i) {
        if(XChar2[i].byte1==0)  break;
        XTextExtents16(FontStruct,&XChar2[i],1,&direction,
                      &fontascent,&fontdescent,&metrics);

        if(FontStruct->per_char==NULL ||
           FontStruct->min_bounds.width == FontStruct->max_bounds.width) {
            /* Fixed size fonts */
            XOffset[i] = FONT_PAD;
            YOffset[i] = BoxH- (FONT_PAD + metrics.descent);
        }
        else {
            XOffset[i] = (BoxW - (metrics.rbearing - metrics.lbearing))/2
                       - FONT_PAD - metrics.lbearing;
            YOffset[i] = BoxH - (BoxH-(metrics.descent + metrics.ascent))/2
                          + FONT_PAD + FontStruct->ascent - metrics.ascent;
        }
     }
  }
  else {
     for(i=0; ; ++i) {
        if(Char1[i]==0)  break;
        XTextExtents(FontStruct,&Char1[i],1,&direction,
                      &fontascent,&fontdescent,&metrics);

        if(FontStruct->per_char==NULL ||
           FontStruct->min_bounds.width == FontStruct->max_bounds.width) {
            /* Fixed size fonts */
            XOffset[i] = FONT_PAD;
            YOffset[i] = BoxH- (FONT_PAD + metrics.descent);
        }
        else {
            XOffset[i] = (BoxW - (metrics.rbearing - metrics.lbearing))/2
                       - FONT_PAD - metrics.lbearing;
            YOffset[i] = BoxH - (BoxH-(metrics.descent + metrics.ascent))/2
                          + FONT_PAD + FontStruct->ascent - metrics.ascent;
        }
     }
  }

  /* adjust YOffset for '-' */
   YOffset[GAP_INNER_CODE] -= BoxH/3;
   YOffset['-'] -= BoxH/3;
/***
fprintf(stderr, "min_char_or_byte2=%d,max_char_or_byte2=%d\n",
        FontStruct->min_char_or_byte2, FontStruct->max_char_or_byte2);

fprintf(stderr, "min_bounds.width=%d,max_bounds.width=%d\n",
        FontStruct->min_bounds.width,FontStruct->max_bounds.width);

fprintf(stderr, "min_byte1=%d,max_byte1=%d\n",
        FontStruct->min_byte1, FontStruct->max_byte1);
***/

     PerLine = (WinW - LeftMargin - RightMargin)/BoxW;
}




whoGetKeyboard()
{
   Window  win=0;
   int     revert_to;
   char    *str;

   XGetInputFocus(TheDisplay,&win,&revert_to);
   if(revert_to==RevertToParent)  str="ReverToParent";
   else if(revert_to==RevertToPointerRoot)  str="ReverToPointerRooot";
   else if(revert_to==RevertToNone)  str="ReverToNone";
   fprintf(stderr, "window = %d(0x%x), revert_to = %s\n",win,win,str);   
}

printGrabStatus(msg,status)
char *msg;
int  status;
{
   /*printf("%s\n",msg);*/
   if(status==GrabSuccess)          /*printf("Grabsuccess\n")*/;
   else if(status==AlreadyGrabbed)  fprintf(stderr, "AlreadyGrabbed\n");
   else if(status==GrabNotViewable) fprintf(stderr, "GrabNotViewable\n");
   else if(status==GrabInvalidTime) fprintf(stderr, "GrabInvalidTime\n");
   else if(status==GrabFrozen)      fprintf(stderr, "GrabFrozen\n");
}



/* Global Value WO Menu HYOUJI NI HAN'EI SASERU */
adjustMenuItems()
{
/***
   if(EditMode==VIEW) 
      XtCallCallbacks(edit_mode_menu[0].w,
                      XmNvalueChangedCallback,True);
   else if(EditMode==NORMAL) 
      XtCallCallbacks(edit_mode_menu[1].w,
                      XmNvalueChangedCallback,True);
   else if(EditMode==INSERT) 
      XtCallCallbacks(edit_mode_menu[2].w,
                      XmNvalueChangedCallback,True);
   else if(EditMode==OVER_WRITE) 
      XtCallCallbacks(edit_mode_menu[3].w,
                      XmNvalueChangedCallback,True);

   if(CalcColumnCost==0)
      XtCallCallbacks(options_sub_menu1[0].w,
                      XmNvalueChangedCallback,True);
   else
      XtCallCallbacks(options_sub_menu1[1].w,
                      XmNvalueChangedCallback,True);

   if(AminoTextCase==UPPER)
      XtCallCallbacks(options_sub_menu2[0].w,
                      XmNvalueChangedCallback,True);
   else
      XtCallCallbacks(options_sub_menu2[1].w,
                      XmNvalueChangedCallback,True);
***/
}

/*--------------------------------------------------------------------*/

/* ---> file_menu.c */

#if	0

static void	set_tmpaedfile_name()
{
/*
	(void)tmpnam(tmpaedfile_msd_name);
	(void)tmpnam(tmpaedfile_asd_name);
*/

#ifdef	DEBUG
	(void)printf("set_tmpaedfile_name --- tmpaedfile_msd_name = %s\n",
		     tmpaedfile_msd_name);
	(void)printf("set_tmpaedfile_name --- tmpaedfile_asd_name = %s\n",
		     tmpaedfile_asd_name);
#endif
}

#endif

static void	set_tmpaedfile_alarm()
{
	void	output_tmpaedfile();

	(void)alarm(tmpaedfile_asd_interval);

	(void)signal(SIGALRM, output_tmpaedfile);
}

static void	output_tmpaedfile()
{
	extern void	save_tmpaedfile_asd();

#ifdef	DEBUG
	(void)printf("output_tmpaedfile --- in\n");
#endif

	(void)alarm(0);

	if (tmpaedfile_asd_proc == TMPAEDFILE_ASD_PROC_NONE) {
#if	0
		(void)printf("");
#endif
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_SAVE;
		save_tmpaedfile_asd();
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
	}

	(void)alarm(tmpaedfile_asd_interval);

	(void)signal(SIGALRM, output_tmpaedfile);
}

/*--------------------------------------------------------------------*/

static void	argument_proc(argc, argv, aedfile, mflag, mfile)
int	*argc;
char	*argv[];
char	*aedfile;
int	*mflag;
char	*mfile;
{
	extern char	*usage_format;
	char		msg[BUFSIZ];
	char		**head;
	int		i, j;
#ifdef	DEBUG
	char		**pp;
#endif
	void		error();
	void		exit();

#ifdef	DEBUG
	(void)printf("argument_proc --- *argc = %d\n", *argc);
	pp = argv;
	do
		(void)printf("argument_proc --- pp = %s\n", *pp);
	while (*++pp != (char *)NULL);
	do
		(void)printf("argument_proc --- pp = %s\n", *pp);
	while (*++pp != (char *)NULL);
#endif

	*aedfile = '\0';
	*mflag = 0;
	*mfile = '\0';

	(void)sprintf(msg, usage_format, *argv);

	head = argv;
	i = j = 1;

	while (*++argv != (char *)NULL) {
	    if (**argv == '-') {
		switch (*(*argv+1)) {
		    case 'a' :
			if (*(*argv+2) != '\0')
			    error(msg);
			if (*aedfile != '\0')
			    error(msg);
			if (*(argv+1) == (char *)NULL || **(argv+1) == '-')
			    error(msg);
			(void)strcpy(aedfile, *++argv);
			(*argc) -= 2;
			j += 2;
			break;
		    case 'n':
			if (*(*argv+2) != '\0')
			    error(msg);
			if (*mflag != 0)
			    error(msg);
			(*argc)--;
			j++;
			if (*(argv+1) != (char *)NULL && **(argv+1) != '-') {
				(void)strcpy(mfile, *++argv);
				(*argc)--;
				j++;
			}
			*mflag = 1;
			break;
		    case 'd' :
			if (*(*argv+2) != '\0')
			    error(msg);
			if (*mflag != 0)
			    error(msg);
			(*argc)--;
			j++;
			if (*(argv+1) != (char *)NULL && **(argv+1) != '-') {
				(void)strcpy(mfile, *++argv);
				(*argc)--;
				j++;
			}
			*mflag = 2;
			break;
		    default :
#if	1
			if (i < j)
			    *(head+i) = *argv;
			i++;
		    	j++;
#else
			error(msg);
#endif
			break;
		}
	    }
	    else {
#if	1
		if (i < j)
		    *(head+i) = *argv;
		i++;
		j++;
#else
		error(msg);
#endif
	    }
	}

#if	0
	if (i < j) {
		*(head+i) = '\0';
		i++;
		while (*++argv != (char *)NULL) {
			*(head+i) = *argv;
			i++;
		}
		*(head+i) = '\0';
	}
#endif

#ifdef	DEBUG
	(void)printf("argument_proc --- aedfile = %s\n", aedfile);
	(void)printf("argument_proc --- *mflag = %d\n", *mflag);
	(void)printf("argument_proc --- mfile = %s\n", mfile);
	(void)printf("argument_proc --- *argc = %d\n", *argc);
	pp = head;
	do
		(void)printf("argument_proc --- pp = %s\n", *pp);
	while (*++pp != (char *)NULL);
	do
		(void)printf("argument_proc --- pp = %s\n", *pp);
	while (*++pp != (char *)NULL);
#endif
}

static void	error(msg)
char	*msg;
{
	void	exit();

	(void)fprintf(stderr, "%s", msg);

	exit(1);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
