/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	global.c
----------------------------------------------------------------------*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <stdio.h>
#include  "aedit.h"

Display        *TheDisplay;
int            TheScreen;
Window         TheRoot;
Colormap       TheColormap;
int            TheDepth;
unsigned long   TheBlackPixel;  /*  System "Black" color */
unsigned long   TheWhitePixel;  /*  System "White" color */
XFontStruct  *FontStruct;
Window       TheWindow;
Pixmap       ThePixmap; 


int WinW, WinH;   /* window width and height */

int MaxAlignName; /* max length of alignment name
                   * used for calculate LeftMargin
                   */

/* for speed up. (avoid to calculate each time) */
int  BoxW, BoxH;   /* current fonts */
int  PerLine;  


/* for active point */
int  ActiveXo,ActiveYo, ActiveIndex, ActiveAlign = -1, ActiveCol;
int  EditMode;     /* Edit Mode (Insert or Delete) */


/* margins of string display window */
int   LeftMargin=130, RightMargin=40, TopMargin=75, BottomMargin=224; 
int   AnMargin=10;
int   BarMargin=200;
int   BarLeng=190;

int   BouPlusMargin=135;    /* BOU Graph plus  margin */
int   BouMinusMargin=25;    /* BOU Graph minus margin */
int   BouMaxValue;    
int   BouMaxRatio;

int   YobiN = 5;   /* Yobi Gyou */

int   QuitFlag = 0;

char  FileName[100];

INFO  Info;

char  CurrentCost[20], PreviousCost[20];

int   UU, VV;   /* amino vs innergap,  gap cost u + kv */
int   WW;       /* innergap vs innergap */
int   PP;       /* outgap vs innergap */
int   QQ;       /* outgap vs outgap */
int   SS;       /* amino vs outgap */
int   UUVV;

int   ReverseFlag;   /* TRUE if align strings backwards */

int   IdenticalRatio;    /* 0 to 100 % */

int   CalcColumnCost;        /* if true, calc each column cost every time,
                              * if false, calc only when refresh.
                              */
int   AminoTextCase;
 
int   RecvCount;   /* count times that get data from socket */

#define X  1000
short  Dmatrix[26][26] = 
{
/*
  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z
*/
{-2, 0, 2, 0, 0, 4,-1, 1, 1, X, 1, 2, 1, 0, X,-1, 0, 2,-1,-1, X, 0, 6, 0, 3, 0},/* A */
{ 0,-2, 4,-3,-2, 5, 0,-1, 2, X,-1, 3, 2,-2, X, 1,-1, 1, 0, 0, X, 2, 5, 0, 3,-2},/* B */
{ 2, 4,-12,5, 5, 4, 3, 3, 2, X, 5, 6, 5, 4, X, 3, 5, 4, 0, 2, X, 2, 8, 3, 0, 5},/* C */
{ 0,-3, 5,-4,-3, 6,-1,-1, 2, X, 0, 4, 3,-2, X, 1,-2, 1, 0, 0, X, 2, 7, 1, 4,-3},/* D */
{ 0,-2, 5,-3,-4, 5, 0,-1, 2, X, 0, 3, 2,-1, X, 1,-2, 1, 0, 0, X, 2, 7, 1, 4,-3},/* E */
{ 4, 5, 4, 6, 5,-9, 5, 2,-1, X, 5,-2, 0, 4, X, 5, 5, 4, 3, 3, X, 1, 0, 2,-7, 5},/* F */
{-1, 0, 3,-1, 0, 5,-5, 2, 3, X, 2, 4, 3, 0, X, 1, 1, 3,-1, 0, X, 1, 7, 1, 5, 1},/* G */
{ 1,-1, 3,-1,-1, 2, 2,-6, 2, X, 0, 2, 2,-2, X, 0,-3,-2, 1, 1, X, 2, 3, 1, 0,-2},/* H */
{ 1, 2, 2, 2, 2,-1, 3, 2,-5, X, 2,-2,-2, 2, X, 2, 2, 2, 1, 0, X,-4, 5, 1, 1, 2},/* I */
{ X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X},/* J */
{ 1,-1, 5, 0, 0, 5, 2, 0, 2, X,-5, 3, 0,-1, X, 1,-1,-3, 0, 0, X, 2, 3, 1, 4, 0},/* K */
{ 2, 3, 6, 4, 3,-2, 4, 2,-2, X, 3,-6,-4, 3, X, 3, 2, 3, 3, 2, X,-2, 2, 1, 1, 3},/* L */
{ 1, 2, 5, 3, 2, 0, 3, 2,-2, X, 0,-4,-6, 2, X, 2, 1, 0, 2, 1, X,-2, 4, 1, 2, 2},/* M */
{ 0,-2, 4,-2,-1, 4, 0,-2, 2, X,-1, 3, 2,-2, X, 1,-1, 0,-1, 0, X, 2, 4, 0, 2,-1},/* N */
{ X, X, X, X, X, X, X, X, X, X, X, X, X, X,-X, X, X, X, X, X, X, X, X, X, X, X},/* O */
{-1, 1, 3, 1, 1, 5, 1, 0, 2, X, 1, 3, 2, 1, X,-6, 0, 0,-1, 0, X, 1, 6, 1, 5, 0},/* P */
{ 0,-1, 5,-2,-2, 5, 1,-3, 2, X,-1, 2, 1,-1, X, 0,-4,-1, 1, 1, X, 2, 5, 1, 4,-3},/* Q */
{ 2, 1, 4, 1, 1, 4, 3,-2, 2, X,-3, 3, 0, 0, X, 0,-1,-6, 0, 1, X, 2,-2, 1, 4, 0},/* R */
{-1, 0, 0, 0, 0, 3,-1, 1, 1, X, 0, 3, 2,-1, X,-1, 1, 0,-2,-1, X, 1, 2, 0, 3, 0},/* S */
{-1, 0, 2, 0, 0, 3, 0, 1, 0, X, 0, 2, 1, 0, X, 0, 1, 1,-1,-3, X, 0, 5, 0, 3, 1},/* T */
{ X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X, X},/* U */
{ 0, 2, 2, 2, 2, 1, 1, 2,-4, X, 2,-2,-2, 2, X, 1, 2, 2, 1, 0, X,-4, 6, 1, 2, 2},/* V */
{ 6, 5, 8, 7, 7, 0, 7, 3, 5, X, 3, 2, 4, 4, X, 6, 5,-2, 2, 5, X, 6,-17,4, 0, 6},/* W */
{ 0, 0, 3, 1, 1, 2, 1, 1, 1, X, 1, 1, 1, 0, X, 1, 1, 1, 0, 0, X, 1, 4, 1, 2, 1},/* X */
{ 3, 3, 0, 4, 4,-7, 5, 0, 1, X, 4, 1, 2, 2, X, 5, 4, 4, 3, 3, X, 2, 0, 2,-10,4},/* Y */
{ 0,-2, 5,-3,-3, 5, 1,-2, 2, X, 0, 3, 2,-1, X, 0,-3, 0, 0, 1, X, 2, 6, 1, 4,-3} /* Z */
};

#define N 10000
#define S -20 
#define O 10 

short  Nmatrix[26][26] =
{
/*
   A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
*/
{  S,N,O,N,N,N,O,N,N,N,N,N,N,O,N,N,N,N,N,O,N,N,N,N,N,N},/* A */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* B */
{  O,N,S,N,N,N,O,N,N,N,N,N,N,O,N,N,N,N,N,O,N,N,N,N,N,N},/* C */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* D */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* E */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* F */
{  O,N,O,N,N,N,S,N,N,N,N,N,N,O,N,N,N,N,N,O,N,N,N,N,N,N},/* G */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* H */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* I */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* J */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* K */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* L */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* M */
{  O,N,O,N,N,N,O,N,N,N,N,N,N,O,N,N,N,N,N,O,N,N,N,N,N,N},/* N */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* O */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* P */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* Q */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* R */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* S */
{  O,N,O,N,N,N,O,N,N,N,N,N,N,O,N,N,N,N,N,S,N,N,N,N,N,N},/* T */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* U */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* V */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* W */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* X */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N},/* Y */
{  N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N,N} /* Z */
};


short  Triple[26] = 
{
/*
A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z 
*/
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};


/* Kanji mode or not */
int  Kanji;

/* each char's offset */
int XOffset[128], YOffset[128];

/* inner code --> char code */
/* ascii code */
char Char1[128]={
  /* This area is for Inner code --> char code area */
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 
  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 
  '-', '?', ' ', ' ', ' ', ' ', 

  /* And after here, Normal ascii code */
/* FROM HERE, Ascii char */
  ' ',  '!',  '"',  '#',  '$',  '%',  '&',  '\'',  '(',  ')', 
  '*',  '+',  ',',  '-',  '.',  '/', 
  '0',  '1',  '2',  '3',  '4',  '5',  '6',  '7',  '8',  '9', 
  ':',  ';',  '<',  '=',  '>',  '?',  '@', 
  'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 
  'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 
  '[',  '\\',  ']',  '^',  '_',  ' ', 
  'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 
  'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 
  '{',  '|',  '}', 
  0
};



XChar2b XChar2[128] = 
{
  /* This area is for Inner code --> char code area */
 {0x39, 0x53},    /* Alanine */
 {0x23, 0x42},    /* B */
 {0x3b, 0x60},    /* Cystein */
 {0x44, 0x2b},    /* D */
 {0x41, 0x70},    /* E */
 {0x45, 0x2b},    /* F */
 {0x37, 0x2a},    /* G */
 {0x48, 0x6b},    /* H */
 {0x30, 0x6b},    /* I */
 {0x23, 0x4a},    /* J */
 {0x4d, 0x78},    /* K */
 {0x4f, 0x24},    /* L */
 {0x48, 0x53},    /* M */
 {0x4c, 0x40},    /* N */
 {0x23, 0x4f},    /* O */
 {0x39, 0x75},    /* P */
 {0x4d, 0x68},    /* Q */
 {0x4d, 0x2d},    /* R */
 {0x36, 0x5c},    /* S */
 {0x3a, 0x7e},    /* T */
 {0x23, 0x55},    /* U */
 {0x3f, 0x4b},    /* V */
 {0x44, 0x3b},    /* W */
 {0x23, 0x58},    /* X */
 {0x37, 0x6c},    /* Y */
 {0x23, 0x5a},    /* Z */
 {0x21, 0x5d},    /* - */
 {0x21, 0x29},    /* ? */
 {0x21, 0x21},    /*   */
 {0x21, 0x21},    /*   */
 {0x21, 0x21},    /*   */
 {0x21, 0x21},    /*   */

/* FROM HERE, Ascii char */
 {0x21, 0x21},    /*   */
 {0x21, 0x2a},    /* ! */
 {0x21, 0x49},    /* " */
 {0x21, 0x74},    /* # */
 {0x21, 0x70},    /* $ */
 {0x21, 0x73},    /* % */
 {0x21, 0x75},    /* & */
 {0x21, 0x47},    /* ' */
 {0x21, 0x4a},    /* ( */
 {0x21, 0x4b},    /* ) */
 {0x21, 0x76},    /* * */
 {0x21, 0x5c},    /* + */
 {0x21, 0x24},    /* , */
 {0x21, 0x5d},    /* - */
 {0x21, 0x25},    /* . */
 {0x21, 0x3f},    /* / */
 {0x23, 0x30},    /* 0 */
 {0x23, 0x31},    /* 1 */
 {0x23, 0x32},    /* 2 */
 {0x23, 0x33},    /* 3 */
 {0x23, 0x34},    /* 4 */
 {0x23, 0x35},    /* 5 */
 {0x23, 0x36},    /* 6 */
 {0x23, 0x37},    /* 7 */
 {0x23, 0x38},    /* 8 */
 {0x23, 0x39},    /* 9 */
 {0x21, 0x27},    /* : */
 {0x21, 0x28},    /* ; */
 {0x21, 0x63},    /* < */
 {0x21, 0x61},    /* = */
 {0x21, 0x64},    /* > */
 {0x21, 0x29},    /* ? */
 {0x21, 0x77},    /* @ */
 {0x23, 0x41},    /* A */
 {0x23, 0x42},    /* B */
 {0x23, 0x43},    /* C */
 {0x23, 0x44},    /* D */
 {0x23, 0x45},    /* E */
 {0x23, 0x46},    /* F */
 {0x23, 0x47},    /* G */
 {0x23, 0x48},    /* H */
 {0x23, 0x49},    /* I */
 {0x23, 0x4a},    /* J */
 {0x23, 0x4b},    /* K */
 {0x23, 0x4c},    /* L */
 {0x23, 0x4d},    /* M */
 {0x23, 0x4e},    /* N */
 {0x23, 0x4f},    /* O */
 {0x23, 0x59},    /* P */
 {0x23, 0x51},    /* Q */
 {0x23, 0x52},    /* R */
 {0x23, 0x53},    /* S */
 {0x23, 0x54},    /* T */
 {0x23, 0x55},    /* U */
 {0x23, 0x56},    /* V */
 {0x23, 0x57},    /* W */
 {0x23, 0x58},    /* X */
 {0x23, 0x59},    /* Y */
 {0x23, 0x5a},    /* Z */
 {0x21, 0x4e},    /* [ */
 {0x21, 0x6f},    /* \ */
 {0x21, 0x4f},    /* ] */
 {0x21, 0x30},    /* ^ */
 {0x21, 0x32},    /* _ */
 {0x22, 0x23},    /*  */
 {0x23, 0x61},    /* a */
 {0x23, 0x62},    /* b */
 {0x23, 0x63},    /* c */
 {0x23, 0x64},    /* d */
 {0x23, 0x65},    /* e */
 {0x23, 0x66},    /* f */
 {0x23, 0x67},    /* g */
 {0x23, 0x68},    /* h */
 {0x23, 0x69},    /* i */
 {0x23, 0x6a},    /* j */
 {0x23, 0x6b},    /* k */
 {0x23, 0x6c},    /* l */
 {0x23, 0x6d},    /* m */
 {0x23, 0x6e},    /* n */
 {0x23, 0x6f},    /* o */
 {0x23, 0x79},    /* p */
 {0x23, 0x71},    /* q */
 {0x23, 0x72},    /* r */
 {0x23, 0x73},    /* s */
 {0x23, 0x74},    /* t */
 {0x23, 0x75},    /* u */
 {0x23, 0x76},    /* v */
 {0x23, 0x77},    /* w */
 {0x23, 0x78},    /* x */
 {0x23, 0x79},    /* y */
 {0x23, 0x7a},    /* z */
 {0x21, 0x50},    /* { */
 {0x21, 0x43},    /* | */
 {0x21, 0x51},    /* } */
 {0,    0   }     /* end mark */
};



/* Cost KEISAN KANNKEI NO Global variables */
setGlobalDefault()
{
   UU=7;  VV=1;   WW=0;  PP=0;  QQ=0;   SS=0;  
   UUVV = UU+VV;
   ReverseFlag = FALSE;

   BouMaxValue = 1200;    
   BouMaxRatio = 67;

   IdenticalRatio=90;     /* 0 to 100 % */

   CalcColumnCost=True;  /* if true, calc each column cost every time */

   EditMode = VIEW;

   AminoTextCase = UPPER; 
}


Bool NA_flag = False;
Bool Button_flag[3] = False;

/* data for constraint */
int Const_no = -1;
int Region_no = 0;
Bool Region_divide[MAX_ALIGN_LENG];
Bool Region_flag[MAX_ALIGN_LENG];
Constraint Const_head[MAX_CONSTRAINT];

/* data for alignment */
int Calc_leng;
int New_calc_leng;
Bool Result_flag = False;
Bool Result_draw = False;
int Calc_columnCost[MAX_ALIGN_LENG];
char Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
char Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];

/* root of motif list */
Motif *Motif_root = NULL;

int   Calc_columnCost[MAX_ALIGN_LENG];   
int   Calc_columnCostMax;
int   Calc_columnCostMin;
int   Calc_cost;            /* alignment's  total cost */
int   Calc_startPos[MAX_ALIGN], Calc_endPos[MAX_ALIGN];  /* Out gap start/end position */
int   Calc_firstP[MAX_ALIGN][MAX_ALIGN];
int   Calc_outGapP[MAX_ALIGN];


/*--------------------------------------------------------------------*/

/* append (begin) */

int	data_exist = 0;

XtAppContext	apc_gltrupg, apc_gltrnj;
Display		*dsp_gltrupg, *dsp_gltrnj;
Widget		da_gltrupg, da_gltrnj;
Boolean		draw_gltrupg = False, draw_gltrnj = False;

char	motif_dir[BUFSIZ];
char	dmatrix_file_name[BUFSIZ];	/* unused */

char	*tmpaedfile_msd_name = "tmp_msd.aed";
char	*tmpaedfile_asd_name = "tmp_asd.aed";
int	tmpaedfile_asd_interval = 5 * 60;	/* second */
int	tmpaedfile_asd_interval_remain;	/* second */
int	tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;

char	*usage_format =
	"Usage: %s [ -a aed_file ] [ -n [ nmatrix_file ] | -d [ dmatrix_file ] ]\n";

/* append (end) */

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
