/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	file_menu.c 
		treat file menu items commands.
----------------------------------------------------------------------*/

#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

/* append (begin) */

#include <unistd.h>

/* append (end) */

#include <Xm/DialogS.h>
#include <Xm/RowColumn.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Label.h>
#include <Xm/SeparatoG.h>
#include <Xm/BulletinB.h>
#include <Xm/Text.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>

#include "menu.h"
#include "aedit.h"

/* append (begin) */

#if	0
#define	DEBUG
#endif

/* append (end) */

static Widget file_save_text;
extern Widget pb_search, pb_undisp;
extern void cancelCB();
Bool motif_list_ready = False;
		
/* append (begin) */

extern int	data_exist;

extern void	popUpWarnDialog();
extern Boolean	testSeq();
extern void	writeSeq();
extern void	readSeq();

/* append (end) */

/*--------------------------------------------------------------------*/

extern MENUITEM	logfile_menu[];

/*--------------------------------------------------------------------*/

/* called when cancel button of file_selection_dialog is pushed */
void  cancel_fsdCB(w,fsd,call_data)
Widget   w, fsd;
caddr_t  call_data;
{
  XtUnmanageChild(fsd); 
}

/* called when ok button of file_selection_dialog is pushed */
void  file_okCB(w,fsd,call_data)
Widget   w, fsd;
XmFileSelectionBoxCallbackStruct  *call_data;
{
  char *fname;
  FILE *fp,*openFile();
/* append (begin) */
  char ems[BUFSIZ];
  void unlink_tmpaedfile();
  void exit();
/* append (end) */

  fprintf(stderr, "at HERE\n"); 
  XmStringGetLtoR(call_data->value, XmSTRING_DEFAULT_CHARSET, &fname);
  fprintf(stderr, "fname=%s, strlen(fname)=%d, fname[0]=%d\n",fname,strlen(fname),fname[0]);

  if(strlen(fname) == 0  ||  fname[0]==0)  
     popUpWarnDialog("You must specify a file name");
  else {
     fp = fopen(fname,"r");
     if (fp==NULL){ 
         popUpWarnDialog("file %s can't open for reading.",fname);
     }else if(!testSeq(fp)){
         if (strrchr(fname,'/')){ 
             popUpWarnDialog("file %s can't read.",(strrchr(fname,'/')+1));
         }else{
             popUpWarnDialog("file %s can't read.",fname);
         }
     }else {  /* open success */
/* append (begin) */
#if	0
	unlink_tmpaedfile();
#endif
	reset_base_count();
	reset_alignment_manual();
	reset_gltrupg();
	reset_gltrnj();
	data_exist = 1;
/* append (end) */
         strcpy(FileName,fname);    /* save file name */
         initInfo();
	 rewind(fp);
#if	0
	output_info("before readSeq");
#endif
         readSeq(fp);
#if	0
	output_info("after readSeq");
#endif
         fclose(fp);
         fontParams();
         ActiveCol = 0;
         ActiveIndex = INITIAL_DATA_START_INDEX;
         ActiveAlign = 0;
         ActiveYo = TopMargin + 2*BoxH;
         ActiveXo = LeftMargin;
	 clear_const();
	 if (motif_list_ready){
	     delete_motif_sublist();
	     delete_motif_list();
	     delete_motif();
  	     XtSetSensitive(pb_search, True);
	     XtSetSensitive(pb_undisp, False);
	 }
	 disp_editmode_etc();
	 disp_cost(True);
         disp(True);
     }
  }
  XtFree(fname);
  XtUnmanageChild(fsd); 
}


/* called when open item of file menu is selected */
static void file_open(w,client_data,cbs)
Widget   w;
int     client_data;   /* not used */
XmAnyCallbackStruct *cbs;
{
  static Widget fsd=NULL;
  extern Widget  menu_top;
  Arg    args[10];

  if(!fsd) {
     fsd = XmCreateFileSelectionDialog(menu_top, "file_selection_dialog", args, 0);
     XtAddCallback(fsd, XmNcancelCallback, cancel_fsdCB, fsd);
     XtAddCallback(fsd, XmNokCallback, file_okCB, fsd);
  }
  XtManageChild(fsd);
  XFlush(TheDisplay);
}


/* called when ok button of file_save dialog is pushed */
static void  file_save_okCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  char *fname;
  FILE *fp;
  void overwrite();

  fname = XmTextGetString(file_save_text);
  fprintf(stderr, "fname=%s\n",fname); 
  fp = fopen(fname,"r");
  if(fp==NULL)  {  /* file not exist */
     fp = fopen(fname,"w");
     if(fp==NULL) {
        popUpWarnDialog("file %s can't open for writing.",fname);
        goto BYEBYE;
     }
     writeSeq(fp); 
     strcpy(FileName,fname);    /* save file name */
     disp_editmode_etc();
     fclose(fp);
  }
  else {  /* file already exist */
     fclose(fp);
     fp = fopen(fname,"w");
     if(fp==NULL) {
        popUpWarnDialog("file %s can't open for writing.",fname);
        goto BYEBYE;
     }
     popUpConfirmDialog(overwrite,fp,False,"File already exist. Overwrite it?");
  }
BYEBYE:
  XtFree(fname);
  XtPopdown(dialog); 
}


static void overwrite(w,fp,call_data)
Widget w;
FILE *fp;
XmAnyCallbackStruct  *call_data;
{
   if(call_data->reason == XmCR_OK) {
      writeSeq(fp);
      strcpy(FileName, XmTextGetString(file_save_text));    /* save file name */
      disp_editmode_etc();
      fclose(fp);
   }
}



/* called when save item of file menu is selected */
static void file_save(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  Widget bb,label,ok,cancel;
  extern Widget  menu_top;
  Arg    args[10];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNx, cbs->event->xbutton.x_root-30);
     XtSetArg(args[1],XmNy, cbs->event->xbutton.y_root-30);
     XtSetArg(args[2],XmNautoUnmanage, False);
     dialog = XtCreatePopupShell("file_save_dialog",xmDialogShellWidgetClass, menu_top,
                                  args,3);
     XtSetArg(args[0],XmNautoUnmanage, False);
     bb=XmCreateBulletinBoard(dialog,"file_save_bb",args,1);  
     label=XmCreateLabel(bb,"file_save_label",NULL,0); XtManageChild(label);

     file_save_text=XmCreateText(bb,"file_save_text",NULL,0); 
     XtManageChild(file_save_text);

     ok=XmCreatePushButton(bb,"file_save_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,file_save_okCB,dialog);
     cancel=XmCreatePushButton(bb,"file_save_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);

     XtVaSetValues(bb, XmNdefaultButton,ok,NULL);
     XtManageChild(bb);
  }
  XtVaSetValues(dialog,
                XmNx, cbs->event->xbutton.x_root-30,
                XmNy, cbs->event->xbutton.y_root-30,
                NULL);
  XtPopup(dialog,XtGrabNone); 
  XFlush(TheDisplay);
}

/*--------------------------------------------------------------------*/

/* append (begin) */

/*ARGSUSED*/
static void confirm_save_tmpaedfile_msd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	save_tmpaedfile_msd();
	void	exit();

#ifdef	DEBUG
	(void)printf("confirm_save_tmpaedfile_msd_cb --- in\n");
#endif

	if(call_data->reason == XmCR_OK) {
#ifdef	DEBUG
		(void)printf("confirm_save_tmpaedfile_msd_cb --- ok\n");
#endif
		save_tmpaedfile_msd();
	}
}

/*ARGSUSED*/
static void save_tmpaedfile_msd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
#ifdef	DEBUG
	(void)printf("save_tmpaedfile_msd_cb --- in\n");
#endif
  
	popUpConfirmDialog(
		confirm_save_tmpaedfile_msd_cb, NULL, True,
		"Are you sure you want to save on the temporary file (M.S.D.) ?");
}

static void save_tmpaedfile_msd()
{
	void save_tmpaedfile();

	save_tmpaedfile(tmpaedfile_msd_name);
}

void save_tmpaedfile_asd()
{
	void save_tmpaedfile();

	save_tmpaedfile(tmpaedfile_asd_name);
}

static void save_tmpaedfile(tmpaedfilename)
char	*tmpaedfilename;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	exit();

#ifdef	DEBUG
	(void)printf("save_tmpaedfile --- in\n");
#endif

	if ((fp = fopen(tmpaedfilename, "w")) == NULL) {
		(void)sprintf(ems, "file %s open error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	writeSeq(fp);

	if (fflush(fp) == EOF) {
		(void)sprintf(ems, "file %s flush error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	if (fclose(fp) == EOF) {
		(void)sprintf(ems, "file %s close error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void confirm_restore_tmpaedfile_msd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	restore_tmpaedfile();

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_msd_cb --- in\n");
#endif

	if(call_data->reason != XmCR_OK)
		return;

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_msd_cb --- ok\n");
#endif

	if (access(tmpaedfile_msd_name, F_OK) != 0 ||
	    access(tmpaedfile_msd_name, R_OK) != 0   ) {
		popUpWarnDialog("readable temporary file (M.S.D.) not exist.");
		return;
	}

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_msd_cb --- file exist\n");
#endif

	restore_tmpaedfile(tmpaedfile_msd_name);
}

/*ARGSUSED*/
static void restore_tmpaedfile_msd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
#ifdef	DEBUG
	(void)printf("restore_tmpaedfile_msd_cb --- in\n");
#endif
  
	popUpConfirmDialog(
		confirm_restore_tmpaedfile_msd_cb, NULL, True,
		"Are you sure you want to restore the temporary file (M.S.D.) ?");
}

/*ARGSUSED*/
static void confirm_restore_tmpaedfile_asd_cb(wd, d1, call_data)
Widget			wd;
caddr_t			d1;
XmAnyCallbackStruct	*call_data;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	restore_tmpaedfile();

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_asd_cb --- in\n");
#endif

	if(call_data->reason != XmCR_OK) {
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_asd_cb --- ok\n");
#endif

	if (access(tmpaedfile_asd_name, F_OK) != 0 ||
	    access(tmpaedfile_asd_name, R_OK) != 0   ) {
		popUpWarnDialog("readable temporary file (A.S.D.) not exist.");
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}

#ifdef	DEBUG
	(void)printf("confirm_restore_tmpaedfile_asd_cb --- file exist\n");
#endif

	restore_tmpaedfile(tmpaedfile_asd_name);
	tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
	(void)alarm(tmpaedfile_asd_interval);
}

/*ARGSUSED*/
static void restore_tmpaedfile_asd_cb(wd, d1, d2)
Widget   wd;
caddr_t  d1, d2;
{
	tmpaedfile_asd_interval_remain = alarm(0);
  
#ifdef	DEBUG
	(void)printf("restore_tmpaedfile_asd_cb --- in\n");
	(void)printf("restore_tmpaedfile_asd_cb --- temaedfile_asd_proc = %d\n",
		     tmpaedfile_asd_proc);
	(void)printf(
	    "restore_tmpaedfile_asd_cb --- temaedfile_asd_interval_remain = %d\n",
	    tmpaedfile_asd_interval_remain);
#endif

	if (tmpaedfile_asd_proc == TMPAEDFILE_ASD_PROC_NONE) {
		tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_RESTORE;
	}
	else {
		(void)fprintf(stderr, "restore_tmpaedfile_asd_cb --- warning\n");
		(void)alarm(tmpaedfile_asd_interval_remain);
		return;
	}

	popUpConfirmDialog(
		confirm_restore_tmpaedfile_asd_cb, NULL, True,
		"Are you sure you want to restore the temporary file (A.S.D.) ?");
}

static void restore_tmpaedfile(tmpaedfilename)
char	*tmpaedfilename;
{
	FILE	*fp;
	char	ems[BUFSIZ];
	void	exit();

	if ((fp = fopen(tmpaedfilename, "r")) == NULL) {
		(void)sprintf(ems, "file %s open error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	if (!testSeq(fp)) {
		popUpWarnDialog("temporary file %s can't read.", tmpaedfilename);
		return;
	}

#ifdef	DEBUG
	(void)printf("restore_tmpaedfile --- read test pass\n");
#endif
	reset_base_count();
	reset_alignment_manual();
	reset_gltrupg();
	reset_gltrnj();
	data_exist = 1;

	initInfo();

	rewind(fp);
	readSeq(fp);

	if (fclose(fp) == EOF) {
		(void)sprintf(ems, "file %s close error.\n", tmpaedfilename);
		(void)fprintf(stderr, ems);
		exit(1);
	}

	fontParams();
	ActiveCol = 0;
	ActiveIndex = INITIAL_DATA_START_INDEX;
	ActiveAlign = 0;
	ActiveYo = TopMargin + 2*BoxH;
	ActiveXo = LeftMargin;
	clear_const();
	if (motif_list_ready){
		delete_motif_sublist();
		delete_motif_list();
		delete_motif();
		XtSetSensitive(pb_search, True);
		XtSetSensitive(pb_undisp, False);
	}

	disp_editmode_etc();
	disp_cost(True);
	disp(True);
}

/* append (end) */

/*--------------------------------------------------------------------*/

static void	confirm_quitCB(w,client_data,call_data)
Widget			w;
caddr_t			client_data;
XmAnyCallbackStruct	*call_data;
{
	char	ems[BUFSIZ];
	void	exit();
	void	unlink_tmpaedfile();

	if(call_data->reason == XmCR_OK)  {
		socketClose();
#if	0
/* append (begin) */
		unlink_tmpaedfile();
/* append (end) */
#endif
		exit(0);
	}
}

void quit(w,client_data,call_data)
Widget   w;
caddr_t client_data,call_data;
{
  popUpConfirmDialog(confirm_quitCB,NULL,True,"Are you sure you want to quit ?");
}

/*--------------------------------------------------------------------*/

void	unlink_tmpaedfile()
{
	void	unlink_file();

	unlink_file(tmpaedfile_msd_name);
	unlink_file(tmpaedfile_asd_name);
}

static void	unlink_file(filename)
char	*filename;
{
	char	ems[BUFSIZ];

	if (access(filename, F_OK) == 0) {
#ifdef	DEBUG
		(void)printf("unlink_file --- filename = %s\n", filename);
#endif
		if (unlink(filename) != 0) {
			(void)sprintf(ems,
				      "file %s unlink error.\n",
				      filename);
			(void)fprintf(stderr, ems);
			exit(1);
		}
	}
}

/*--------------------------------------------------------------------*/

/* append (begin) */

MENUITEM	file_sub_menu1[] = {
			{"Save(M.S.D.)", &xmPushButtonGadgetClass, 'S', NULL,
			 NULL, save_tmpaedfile_msd_cb, (caddr_t)True, NULL, 
			 True, True, XmONE_OF_MANY},
			{"Restore(M.S.D.)", &xmPushButtonGadgetClass, 'M', NULL,
			 NULL, restore_tmpaedfile_msd_cb, (caddr_t)False, NULL, 
			 True, False, XmONE_OF_MANY},
			{ "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
			  NULL, (caddr_t)NULL, NULL, True},
			{"Restore(A.S.D.)", &xmPushButtonGadgetClass, 'A', NULL,
			 NULL, restore_tmpaedfile_asd_cb, (caddr_t)False, NULL, 
			 True, False, XmONE_OF_MANY},

			{NULL}
};

/* append (end) */

MENUITEM file_menu[] = {
   { "Open", &xmPushButtonGadgetClass, 'O', NULL, NULL,
      file_open, (caddr_t)NULL, NULL, True},
   { "Save", &xmPushButtonGadgetClass, 'S', NULL, NULL,
      file_save, (caddr_t)NULL, NULL, True},
/* append (begin) */
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "LogFile", &xmPushButtonGadgetClass, 'L', NULL, NULL,
      NULL, (caddr_t)NULL, logfile_menu, True},
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Temporary", &xmPushButtonGadgetClass, 'T', NULL, NULL,
      NULL, (caddr_t)NULL, file_sub_menu1, True},
/* append (end) */
   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},
   { "Quit", &xmPushButtonGadgetClass, 'Q', NULL, NULL,
      quit, (caddr_t)NULL, NULL, True},
   {NULL},
};

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
