/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* file.c */

#include <ctype.h>
#include <pwd.h>
#include "aedit.h"

#define RC_FILE  ".aeditrc"


/* User not specify file name at command line argument,	
 * so, we make default set,Info. alignnum=10)
 */
int initSeq()
{
   char *to_inner_code(), buff[30];
   int  i;

   Info.alignnum = 10;
   Info.dataStartIndex = INITIAL_DATA_START_INDEX;
   Info.dispStartIndex = INITIAL_DATA_START_INDEX;
   Info.dataEndIndex = Info.dataStartIndex - 1;
   Info.empty = True;
   for(i=0; i<Info.alignnum; ++i) {
       Info.codeAlign[i] = to_inner_code("");  /* empty string */
       sprintf(buff,"Alignment %02d",i);
       strcpy(Info.alignname[i],buff);
   }
   MaxAlignName = strlen(buff);
}



int readSeq(fp)
FILE  *fp;
{
   char buff[MAX_BUFF_LENG], alignbuff[MAX_BUFF_LENG], 
        *p, *index(), *str_alloc(), *to_inner_code();
   int  i,leng, maxleng, flag, count;
   Bool not_flag = False;

   /* free before memory */
   for(i=0; i<Info.alignnum; ++i) {
#if	0
      if(Info.codeAlign[i])
         free(Info.codeAlign[i]);
#endif
      if(Info.codeAlign[i]) {
         if (!free(Info.codeAlign[i])) {
		(void)fprintf(stderr, "readSeq: free error\n");
	 }
      }
      Info.codeAlign[i] = NULL;
   }

   for(;;) {  /* read Info.alignnum  */
       if(fgets(buff,MAX_BUFF_LENG-1,fp) == NULL) {
          fprintf(stderr,"Uexpected EOF in reading Info.alignnum\n");
          return EOF;
       }
       if(buff[0]==0  || buff[0]==' ' || buff[0]=='%'  ||  buff[0]==';'  ||
          buff[0]=='\n' || buff[0]=='\t')  continue;

       if (!strncmp(buff, "num=", 4)){
           Info.alignnum = atoi(&buff[4]);
       }else{
           Info.alignnum = MAX_ALIGN;
	   rewind(fp);
           not_flag = True;
       }
       fprintf(stderr, "Info.alignnum=%d\n",Info.alignnum);
       break;
   }      
   
   MaxAlignName=0;
   Info.dataStartIndex = INITIAL_DATA_START_INDEX;
   Info.dispStartIndex = INITIAL_DATA_START_INDEX;
   Info.columnCostMax = -1000000;
   Info.columnCostMin =  1000000;
   Calc_columnCostMax = -1000000;
   Calc_columnCostMin =  1000000;

   Info.empty = False;
   maxleng = 0;  /* maxlength  */
   flag=0;   /* set 1 when next line is expected(at end of line '\') */
   count = 0;
   for(;;) {
      if(count >= Info.alignnum ) break;

      MOTOI:
      if(fgets(buff,MAX_BUFF_LENG-1,fp) == NULL) {
         fprintf(stderr,"Unexpected EOF in reading Info.codeAlign\n");
         if (not_flag){
	     Info.alignnum = count;
      	     Info.dataEndIndex = Info.dataStartIndex + maxleng-1;
             fprintf(stderr, "Info.alignnum=%d\n",Info.alignnum);
   	     for(i=0; i<Info.alignnum; ++i) {
             /* Make the length equal by adding gap at end */
      		 adjust_leng(&Info.codeAlign[i][Info.dataStartIndex],
                   	     Info.dataEndIndex - Info.dataStartIndex + 1);
   	     }
         }
         return EOF;
      }
      if(buff[0]==0  || buff[0]=='%'  ||  buff[0]==';')  goto MOTOI;
      if(flag==0 && (buff[0]==' '  || buff[0]=='\t'  ||  buff[0]=='\n'))  
          goto MOTOI;

      buff[strlen(buff)-1] = 0;
      /*fprintf(stderr,"flag=%d, buff=%s\n",flag,buff);*/
         
      p=index(buff,':');
      if(p == NULL  && flag==0) {
         fprintf(stderr,"Alignment Name or Number is missing\n");
         exit(1);
      }
      else if(p != NULL  && flag==1) {
         fprintf(stderr,"Alignment Name is duplicated.\n");
         exit(1);
      }
      else if(flag==0) { /* set tile  and first line*/
         *p=0;    /* ';' --> 0 */
         strncpy(Info.alignname[count],buff,MAX_ALIGN_NAME_LENG);

         if(strlen(Info.alignname[count]) > MaxAlignName)
              MaxAlignName = strlen(Info.alignname[count]);

         ++p; /* p point to just after ':' */
         skip_space(&p); 
         align_copy(alignbuff,p,&flag);
         /* fprintf(stderr,"at here here flag=%d\n",flag); */
         if(flag==0)  { /* no next line */
             leng = strlen(alignbuff);
             if(leng>maxleng)  maxleng = leng;
             Info.codeAlign[count] = to_inner_code(alignbuff);
             count++;
         }    
      }
      else if(flag==1) { /* next line*/
         p = buff;
         skip_space(&p);   /* fprintf(stderr,"at here p=%s\n",p); */
         align_cat(alignbuff,p,&flag);
         if(flag==0)  { /* no next line */
            leng = strlen(alignbuff);
            if(leng>maxleng)  maxleng = leng;
            Info.codeAlign[count] = to_inner_code(alignbuff);
            count++;
         }    
      }
      Info.dataEndIndex = Info.dataStartIndex + maxleng-1;
   }


/*      DW(); */
   for(i=0; i<Info.alignnum; ++i) {
     /* Make the length equal by adding gap at end */
      adjust_leng(&Info.codeAlign[i][Info.dataStartIndex],
                   Info.dataEndIndex - Info.dataStartIndex + 1);
   }
   /* DW(); */
   return 0;
}



skip_space(p)
char  **p;
{
  for(; **p == ' ' || **p == '\t' || **p == '\n'; (*p)++)  
     ;
}


align_copy(dest,src,flag)
char  *dest, *src;
int   *flag;
{
  *flag = 0;
  for(;;) {
      if(*src == 0)     break;
      if(*src == '\\')   {
          *flag=1;
          break;
      }
      if(isalpha(*src) || *src=='-') 
        *dest++ = *src++;
  }
  *dest=0;
}


align_cat(dest,src,flag)
char  *dest, *src;
int   *flag;
{
/*  printf("dest=%s\n",dest); */
  dest += strlen(dest);
/*  printf("after dest=%s\n",dest); */

  *flag = 0;
  for(;;) {
      if(*src == 0)     break;
      if(*src == '\\')   {
          *flag=1;
          break;
      }
      if(isalpha(*src) || *src=='-') 
        *dest++ = *src++;
  }
  *dest=0;
}



adjust_leng(p, maxleng)
char  *p;     /* inner code array */
int   maxleng;
{
   int  i,leng;
   
   p[maxleng+1] = 0xFF;
   for(i=maxleng; i>0;  --i) {
       if(p[i] == 0xFF || p[i] == -1) break;
       p[i] = GAP_INNER_CODE;
   }
   p[i] = GAP_INNER_CODE;    /* also cjhnge -1 --> GAP_INNER_CODE */
}


char *to_inner_code(align)
char  *align;    /* IN  : ascii code array */
{
  int  i;
  char  *head, *malloc();
  char  *inner;
  
  if((head=malloc(MAX_ALIGN_LENG+1)) == NULL) {
     fprintf(stderr,"malloc failed in to_inner_code\n");
     exit(1);
  }
  for (i = 0; i < MAX_ALIGN_LENG + 1; i++)
	*(head+i) = 0;

  inner = head + INITIAL_DATA_START_INDEX;

  for(i=0; ; ++i) {
     if(align[i]==0)             break;
     else if(isupper(align[i]))  inner[i] = align[i] - 'A';
     else if(islower(align[i]))  inner[i] = align[i] - 'a';
/*
     else if(align[i]=='-'){     inner[i] = GAP_INNER_CODE;
*/
     else if(align[i]=='-' || align[i]=='#'){     inner[i] = GAP_INNER_CODE;
	      }
     else                        inner[i] = OTHER_INNER_CODE;
  }
  inner[i] = 0xFF;   /* mark of end. (0 can't be used because this is
                    * Alanine inner code.)
                    */
  return head;
}



DW()
{
   int i,j;

   fprintf(stderr, "alignnum=%d\n", Info.alignnum);
   fprintf(stderr, "dataStartIndex=%d, dispStartIndex=%d, dataEndIndex=%d\n",
           Info.dataStartIndex,Info.dispStartIndex,Info.dataEndIndex);
   fprintf(stderr, "rowH=%d, cost=%d\n", Info.rowH,Info.cost);

   fprintf(stderr, "columnAtrib\n");
   for(j=Info.dataStartIndex; j<=Info.dataEndIndex; ++j) {
       fprintf(stderr, " %d",Info.columnAtrib[j]);
   }

   for(i=0; i<Info.alignnum; ++i) {
      fprintf(stderr, "align#=%d, name=%s\n",i,Info.alignname[i]);
      fprintf(stderr, "codeAlign\n");
      for(j=Info.dataStartIndex; j<=Info.dataEndIndex; ++j) {
         fprintf(stderr, " %d",Info.codeAlign[i][j]);
      }
      fprintf(stderr, "\n");
   }
}


void writeSeq(fp)
FILE *fp;
{
  int code,j,leng,align;
  char buf[100];

  /*sprintf(buf,"num=%02d     %% Alignment Number \n",Info.alignnum);
  fputs(buf,fp);
  fputs("\n",fp);*/

  leng = Info.dataEndIndex - Info.dataStartIndex + 1;
  fprintf(stderr, "leng=%d\n",leng);

  for(align=0; align<Info.alignnum; ++align) {
/*     printf("%s\n",Info.alignname[align]); */

     sprintf(buf,"%s:",Info.alignname[align]);
     fputs(buf,fp);

     for(j=0; j<leng; ++j) {
         code = Info.codeAlign[align][Info.dataStartIndex+j];
/*         printf("code=%d\n",code);  */
         if(code == -1) break;
         fputc(Char1[code],fp);
     }
     fputc('\n',fp);
  }
}



/* open .aeditrc file in user home directory */
FILE *openRcFile()
{
   struct passwd *pwd, *getpwuid();
   char   path[200];

   pwd = getpwuid(getuid());

   if(pwd==NULL) {
      fprintf(stderr,"Who are you ?\n");
      exit(1);
   }
   fprintf(stderr, "pwd->pw_dir=%s\n",pwd->pw_dir);

   strcpy(path,pwd->pw_dir);
   strcat(path,"/");
   strcat(path,RC_FILE);
   fprintf(stderr, "path=%s\n",path);
   
   return fopen(path,"r");
}


/* read .aeditrc file */
readRcFile(fp)
FILE   *fp;
{
  char   *p, buff[200], atom[100], amino_name[50];
  double  value[4];
  int    i;
  void  getAtomValue();

  for(;;) {  
     NEXT:
     if(fgets(buff,200,fp) == NULL)  break;
     
     /* skip to first char */
     for(p=buff; *p==' ' || *p=='\t' ; p++) ;
     if(*p == ';')   continue;   /* comment, so go next line */
     if(*p == '#')   continue;   /* comment, so go next line */
     if(*p == '!')   continue;   /* comment, so go next line */
     if(*p == '\n')  continue;   /* empty line, so go next line */

     getAtomValue(p,atom,value);

     for(i=0; i<26; ++i) {
         sprintf(amino_name, "amino-%c-color", i+'a');
         if(strcmp(atom,amino_name)==0) {
            amino_color[i].red   = (short)value[0]; 
            amino_color[i].green = (short)value[1];
            amino_color[i].blue  = (short)value[2];
            aminoCharWorB[i] = (char)value[3];
            goto NEXT;
         }
     }
     if(strcmp(atom,"gap-color")==0) {
        amino_color[26].red   = (short)value[0]; 
        amino_color[26].green = (short)value[1];
        amino_color[26].blue  = (short)value[2];
        aminoCharWorB[26] = (char)value[3];
     }
     else if(strcmp(atom,"background-color")==0) {
        back_color.red   = (short)value[0];
        back_color.green = (short)value[1];
        back_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"fixed-column-color")==0) {
        fixed_column_color.red   = (short)value[0];
        fixed_column_color.green = (short)value[1];
        fixed_column_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"text-color")==0) {
        text_color.red   = (short)value[0];
        text_color.green = (short)value[1];
        text_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-plus-color")==0) {
        bou_plus_color.red   = (short)value[0];
        bou_plus_color.green = (short)value[1];
        bou_plus_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-minus-color")==0) {
        bou_minus_color.red   = (short)value[0];
        bou_minus_color.green = (short)value[1];
        bou_minus_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-motif-color")==0) {
        bou_motif_color.red   = (short)value[0];
        bou_motif_color.green = (short)value[1];
        bou_motif_color.blue  = (short)value[2];
     }
     else if(strcmp(atom,"bar-chart-motif-ratio")==0) {
        BouMaxRatio = (int)value[0];
     }
     else if(strcmp(atom,"bar-chart-max-value")==0) {
        BouMaxValue = (int)value[0];
     }
     else if(strcmp(atom,"identical-ratio")==0) {
        IdenticalRatio = (int)value[0];
     }
     else if(strcmp(atom,"calculate-cost-timing")==0) {
        CalcColumnCost = (int)value[0];
     }
     else if(strcmp(atom,"amino-text-case")==0) {
        AminoTextCase = (int)value[0];
     }
     else if(strcmp(atom,"uu")==0) {
        UU = (int)value[0];
        UUVV = UU+VV;
     }
     else if(strcmp(atom,"vv")==0) {
        VV = (int)value[0];
        UUVV = UU+VV;
     }
     else if(strcmp(atom,"ww")==0) {
        WW = (int)value[0];
     }
     else if(strcmp(atom,"pp")==0) {
        PP = (int)value[0];
     }
     else if(strcmp(atom,"qq")==0) {
        QQ = (int)value[0];
     }
     else if(strcmp(atom,"ss")==0) {
        SS = (int)value[0];
     }
     else if(strcmp(atom,"edit-mode")==0) {
        EditMode   = (int)value[0];
     }
     else 
       fprintf(stderr,"Unknown parameter, %s \n", atom);
  }
}


static void  getAtomValue(p,atom,value)
char    *p, atom[];
double  value[];
{
  char  buff[30];
  int   i, k;

  value[0] = value[1] = value[2] = value[3] = 0.0;

  /* ATOM NO KIRI DASI */
  for(i=0; *p != ' ' &&  *p != '\t'  &&  *p != '\n' &&  i<50; ++i) 
     if(*p >= 'A' &&  *p <= 'Z' )  atom[i] = ('a'-'A') + *p++;
     else                          atom[i] = *p++;

  atom[i] = '\0';

  if(i>=50  || *p == '\n')  return;   /* no value */
  
  for(k=0; k<4; ++k) {
     /* skip space */
     for(; *p==' ' || *p=='\t' ; p++) ;
     if(*p == '\n')  return;

     for(i=0; *p != ' ' &&  *p != '\t'  &&  *p != '\n' &&  i<20; ++i) 
         buff[i] = *p++;
     buff[i] = '\0';
  
     if(sscanf(buff,"%lf",&value[k]) != 1)   return;
  }
}


Boolean testSeq(fp)
FILE  *fp;
{
   char buff[MAX_BUFF_LENG], alignbuff[MAX_BUFF_LENG], 
        *p, *index(), *str_alloc(), *to_inner_code();
   int  i,leng, maxleng, flag, count;
   Bool not_flag = False;
   int test_MaxAlignName=0,
       test_dataStartIndex = INITIAL_DATA_START_INDEX,
       test_dispStartndex = INITIAL_DATA_START_INDEX,
       test_columnCostMax = -1000000,
       test_columnCostMin =  1000000,
       test_alignnum,
       test_dataEndIndex,
       test_empty = False;
   char  *test_codeAlign[MAX_ALIGN],  
         test_alignname[MAX_ALIGN][MAX_ALIGN_NAME_LENG+1]; 

   /* free before memory 
   for(i=0; i<test_alignnum; ++i) {
      if(test_codeAlign[i])
         free(test_codeAlign[i]);
      test_codeAlign[i] = NULL;
   }*/

   for(;;) {  /* read test_alignnum  */
       if(fgets(buff,MAX_BUFF_LENG-1,fp) == NULL) {
          fprintf(stderr,"Unexpected EOF in reading test_alignnum\n");
          return False;
       }
       if(buff[0]==0  || buff[0]==' ' || buff[0]=='%'  ||  buff[0]==';'  ||
          buff[0]=='\n' || buff[0]=='\t')  continue;

       if (!strncmp(buff, "num=", 4)){
           test_alignnum = atoi(&buff[4]);
       }else{
           test_alignnum = MAX_ALIGN;
	   rewind(fp);
           not_flag = True;
       }
       fprintf(stderr, "test_alignnum=%d\n",test_alignnum);
       break;
   }      
   
   maxleng = 0;  /* maxlength  */
   flag=0;   /* set 1 when next line is expected(at end of line '\') */
   count = 0;
   for(;;) {
      if(count >= test_alignnum ) break;

      MOTOI:
      if(fgets(buff,MAX_BUFF_LENG-1,fp) == NULL) {
         fprintf(stderr,"Unexpected EOF in reading test_codeAlign\n");
         if (not_flag){
	     test_alignnum = count;
      	     test_dataEndIndex = test_dataStartIndex + maxleng-1;
             fprintf(stderr, "test_alignnum=%d\n",test_alignnum);
   	     for(i=0; i<test_alignnum; ++i) {
             /* Make the length equal by adding gap at end */
      		 adjust_leng(&test_codeAlign[i][test_dataStartIndex],
                   	     test_dataEndIndex - test_dataStartIndex + 1);
   	     }
         }
         return True;
      }
      if(buff[0]==0  || buff[0]=='%'  ||  buff[0]==';')  goto MOTOI;
      if(flag==0 && (buff[0]==' '  || buff[0]=='\t'  ||  buff[0]=='\n'))  
          goto MOTOI;

      buff[strlen(buff)-1] = 0;
      /*fprintf(stderr,"flag=%d, buff=%s\n",flag,buff);*/
         
      p=index(buff,':');
      if(p == NULL  && flag==0) {
         fprintf(stderr,"Alignment Name or Number is missing\n");
         return False;
      }
      else if(p != NULL  && flag==1) {
         fprintf(stderr,"Alignment Name is duplicated.\n");
         return False;
      }
      else if(flag==0) { /* set tile  and first line*/
         *p=0;    /* ';' --> 0 */
         strncpy(test_alignname[count],buff,MAX_ALIGN_NAME_LENG);

         if(strlen(test_alignname[count]) > test_MaxAlignName)
              test_MaxAlignName = strlen(test_alignname[count]);

         ++p; /* p point to just after ':' */
         skip_space(&p); 
         align_copy(alignbuff,p,&flag);
         /* fprintf(stderr,"at here here flag=%d\n",flag); */
         if(flag==0)  { /* no next line */
             leng = strlen(alignbuff);
             if(leng>maxleng)  maxleng = leng;
             test_codeAlign[count] = to_inner_code(alignbuff);
             count++;
         }    
      }
      else if(flag==1) { /* next line*/
         p = buff;
         skip_space(&p);   /* fprintf(stderr,"at here p=%s\n",p); */
         align_cat(alignbuff,p,&flag);
         if(flag==0)  { /* no next line */
            leng = strlen(alignbuff);
            if(leng>maxleng)  maxleng = leng;
            test_codeAlign[count] = to_inner_code(alignbuff);
            count++;
         }    
      }
      test_dataEndIndex = test_dataStartIndex + maxleng-1;
   }


/*      DW(); */
   for(i=0; i<test_alignnum; ++i) {
     /* Make the length equal by adding gap at end */
      adjust_leng(&test_codeAlign[i][test_dataStartIndex],
                   test_dataEndIndex - test_dataStartIndex + 1);
   }
   /* DW(); */
   return True;
}

