/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	edit_mode_menu.c 
		treat edit mode menu items commands.

----------------------------------------------------------------------*/

#include <stdio.h>

#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#include "aedit.h"
#include "menu.h"

Widget   w_sav;

/*--------------------------------------------------------------------*/

void process_edit_mode(w,client_data,call_data)
Widget   w;
caddr_t client_data,call_data;
{
  int i, code;
  extern MENUITEM edit_mode_menu[], edit_menu[];
  extern Widget pd_edit, pd_net, w2;

  EditMode = (int)client_data;
  fprintf(stderr,"EditMode=%d\n",EditMode);  

  for(i=0; i<7; ++i) {
    XtVaSetValues(edit_mode_menu[i].w, XmNset,False, NULL);
  }
  XtVaSetValues(w, XmNset,True, NULL);

	/*  */
	if (EditMode != VIEW)
		reset_base_count();

	/* 饤ȡʥޥ˥奢 */
	if (EditMode != ALIGNMENT_MANUAL)
		reset_alignment_manual();

  /* ˥塼 Edit(pd_edit) */

  if(EditMode == VIEW            ||
     EditMode == MOVE_ALIGNMENT  ||
     EditMode == ALIGNMENT_MANUAL  )
	XtSetSensitive(pd_edit,False);
  else
	XtSetSensitive(pd_edit,True);

  /* ˥塼 Alignment(pd_net), Set(w2) */

  if(EditMode == CONSTRAINT){
      XtSetSensitive(w2, True);
      XtSetSensitive(pd_net, True);
      disp_align_one(ActiveAlign, ActiveIndex, 1);
      disp_all_const_data(); 
      disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1); 
  }else{
      XtSetSensitive(w2, False);
      XtSetSensitive(pd_net, False);
      disp_align_one(ActiveAlign, ActiveIndex, 1);
      not_disp_all_const_data();
      disp_scale(False, Info.dispStartIndex, PerLine);
      if (EditMode == INSERT || EditMode == OVER_WRITE) disp_activ();
  }

  /* Clear Item of edit menu*/
  if(EditMode == INSERT  ||  EditMode == OVER_WRITE) {
     XtSetSensitive(edit_menu[1].w,True);  
  }
  else {
     XtSetSensitive(edit_menu[1].w,False); 
  }
}

/*--------------------------------------------------------------------*/

void confirm_mode_change(w, client_data, call_data)
Widget w;
int client_data;
XmAnyCallbackStruct *call_data;
{
    extern MENUITEM edit_mode_menu[];

    switch (call_data->reason){
	case XmCR_CANCEL:
            XtVaSetValues(edit_mode_menu[client_data].w, XmNset,False, NULL);
	    break;     
	case XmCR_OK:
  	    process_edit_mode(w_sav,client_data,call_data);
            disp_editmode_etc();
	    break;
        default:
	    break;
    }
}

/*--------------------------------------------------------------------*/

void edit_mode(w,client_data,call_data)
Widget   w;
caddr_t client_data,call_data;
{
  int select, i;

  select = (int)client_data;
  w_sav = w;
  switch (select){
      case VIEW:
	  break;
      case NORMAL:
	  break;
      case INSERT:
	  break;
      case OVER_WRITE:
          for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
              if (Region_divide[i]){
    	          popUpConfirmDialog(confirm_mode_change, select, True, 
	           	             "Region border exists !!");
	          return; 
	      }
          }
	  break;
      case CONSTRAINT:
          for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
              if (Info.columnAtrib[i] == FIXED_COLUMN){
    	          popUpConfirmDialog(confirm_mode_change, select, True, 
	           	             "Fixed column exists !!");
	          return; 
	      }
          }
	  break;
      case MOVE_ALIGNMENT:
	  break;
      case ALIGNMENT_MANUAL:
	  break;
      default:
	  break;
  }
  process_edit_mode(w,client_data,call_data);
  disp_editmode_etc();
}

/*--------------------------------------------------------------------*/

MENUITEM edit_mode_menu[] = {
   { "View", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)VIEW, NULL, 
      True, True, XmONE_OF_MANY},

   { "Edit(Normal)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)NORMAL, NULL, 
      True, False, XmONE_OF_MANY},

   { "Edit(Constraint)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)CONSTRAINT, NULL, 
      True, False, XmONE_OF_MANY},

   { "Amino(Insert)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)INSERT, NULL, 
      True, False, XmONE_OF_MANY},

   { "Amino(Overwrite)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)OVER_WRITE, NULL, 
      True, False, XmONE_OF_MANY},
     
   { "Move(Alignment)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)MOVE_ALIGNMENT, NULL, 
      True, False, XmONE_OF_MANY},
     
   { "Alignment(Manual)", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      edit_mode, (caddr_t)ALIGNMENT_MANUAL, NULL, 
      True, False, XmONE_OF_MANY},
     
   {NULL}
};

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
