/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	display2.c  

	pending
	1. Result_draw

----------------------------------------------------------------------*/

#include	<string.h>


#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>
#include  "aedit.h"

#define MAX_RECT_SIZE  200

void swap_int();

static  XRectangle  CodeRect[MAXCODE][MAX_RECT_SIZE];
static  int         NumRect[MAXCODE];
extern int send_left, send_right;
extern Motif *p_motif;

/*--------------------------------------------------------------------*/

static int	Result_draw_dummy = False;

/*--------------------------------------------------------------------*/

#if	1
#define	DUMMY
#endif

/*--------------------------------------------------------------------*/

void	display_aedit_win_2()
{
	extern Widget	da;
	void		disp_name_2();
	void		disp_cost_2();
	void		disp_editmode_etc_2();
	void		disp_align_all_2();
	void		disp_edited_motif_2();

	XFillRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       0, 0, WinW, WinH);

	disp_name_2(XtDisplay(da), XtWindow(da));
	disp_cost_2(XtDisplay(da), XtWindow(da), False);
	disp_editmode_etc_2(XtDisplay(da), XtWindow(da));
	disp_align_all_2(XtDisplay(da), XtWindow(da), True, True);
	disp_edited_motif_2(XtDisplay(da), XtWindow(da),
			    0, Info.alignnum - 1, Info.dispStartIndex,
			    Info.dispStartIndex + PerLine - 1);

	display_base_count();

	display_target_almnidm();

	XFlush(XtDisplay(da));
}

/*--------------------------------------------------------------------*/

void	draw_string_2(display, window, flag, x, y, code, nowGC)
Display	*display;
Window	window;
Bool	flag;
GC	nowGC;
int	x, y, code;
{
   if (flag) XFillRectangle(display, window, CodeGC[code], x, y, BoxW, BoxH);

    if(Kanji) {
        XDrawString16(display, window, nowGC,
                      x+XOffset[code], y+YOffset[code],
                      &XChar2[code], 1);

    }
    else {
        XDrawString(display, window, nowGC,
                    x+XOffset[code], y+YOffset[code],
                    &Char1[code], 1);
    }
}

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

static void	disp_by_XCopyArea_2(display, window,
				    start_align, end_align, start_index, end_index, movement)
Display	*display;
Window	window;
int	start_align, end_align, start_index, end_index, movement;
{
    int xo, yo;

    if (start_index > end_index) swap_int(&start_index, &end_index);
    if (movement>0 && end_index+movement >= Info.dispStartIndex+PerLine) 
        end_index = Info.dispStartIndex+PerLine-1-movement;
    if (movement<0 && start_index+movement < Info.dispStartIndex) 
        start_index = Info.dispStartIndex-movement;

    xo = LeftMargin+(start_index-Info.dispStartIndex)*BoxW;
    yo = get_yo()+(start_align+2)*BoxH;

    XCopyArea(display, window, window, WhiteGC, xo, yo, 
	      (end_index-start_index+1)*BoxW, (end_align-start_align+1)*BoxH, 
	      xo+movement*BoxW, yo);
}

#endif

/*--------------------------------------------------------------------*/

void	disp_dragging_frame_2(display, window,
			      press_align, press_index,
			      newActiveAlign, newActiveIndex)
Display	*display;
Window	window;
int	press_align, press_index, newActiveAlign, newActiveIndex;
{
    int frame_width = BoxW/DRAG_FRAME_RATIO, xo, yo;
    int start_index, end_index, start_align, end_align;

    if (newActiveAlign==press_align && newActiveIndex==press_index) return;

    yo = get_yo() + 2*BoxH;
    xo = LeftMargin;
    start_align = press_align; end_align = newActiveAlign;
    if (start_align>end_align) swap_int(&start_align, &end_align);
    start_index = press_index; end_index = newActiveIndex;
    if (start_index>end_index) swap_int(&start_index, &end_index);
    /*fprintf(stderr, "disp: %d %d %d %d\n", start_align, end_align, start_index, end_index);*/

    XSetLineAttributes(display, FrameGC, frame_width, LineSolid, CapButt, JoinMiter);
    XDrawRectangle(display, window, FrameGC, 
	           xo+(start_index-Info.dispStartIndex)*BoxW+frame_width/2,
		   yo+start_align*BoxH+frame_width/2,
	           (end_index-start_index+1)*BoxW-frame_width, 
		   (end_align-start_align+1)*BoxH-frame_width);
}

/*--------------------------------------------------------------------*/

void	undisp_dragging_frame_2(display, window,
				press_align, press_index,
				oldActiveAlign, oldActiveIndex)
Display	*display;
Window	window;
int	press_align, press_index, oldActiveAlign, oldActiveIndex;
{
	int	align, index, start_index, end_index, start_align, end_align;
	void	disp_align_one_2();

    if (oldActiveAlign==press_align && oldActiveIndex==press_index) return;

    start_align = press_align; end_align = oldActiveAlign;
    if (start_align>end_align) swap_int(&start_align, &end_align);
    start_index = press_index; end_index = oldActiveIndex;
    if (start_index>end_index) swap_int(&start_index, &end_index);
    /*fprintf(stderr, "undisp: %d %d %d %d\n", start_align, end_align, start_index, end_index);*/

    for (align=start_align; align<=end_align; align++){
        disp_align_one_2(display, window, align, start_index, 1);
        disp_align_one_2(display, window, align, end_index, 1);
    }

    for (index=start_index+1; index<end_index; index++){
	disp_align_one_2(display, window, start_align, index, 1);
	disp_align_one_2(display, window, end_align, index, 1);
    }
    disp_edited_motif_2(display, window,
			start_align, end_align, start_index, end_index);
}

/*--------------------------------------------------------------------*/

/* display strings all, not display alignment name and cost, draw 1 char
  at time */

/*ARGSUSED*/
static void	disp_align_all_2(display, window, columnBarFlag, flag) 
Display	*display;
Window	window;
int columnBarFlag;  /* display each column Bar Graf */
int flag;   /* recalc. cost or not */
{
	int	x, y, i, j, charNum, yo, code;
	void	disp_scale_2();
	void	disp_scroll_mark_2();
	void	disp_bar_2();
	void	disp_all_const_data_2();
	void	disp_region_data_2();
	void	disp_activ_2();
	void	disp_cost_graph_2();
	void	display_ident_2();

  yo = get_yo();

  XFillRectangle(display, window, DrawBackGC,
                 LeftMargin, yo, 
                 WinW-RightMargin-LeftMargin+1, Info.rowH);

  disp_scale_2(display, window, True,Info.dispStartIndex,PerLine);
  disp_scroll_mark_2(display, window);
  disp_bar_2(display, window);

  for(code=0; code<MAXCODE; ++code) {
      NumRect[code] = 0;    /* for XDrawRectangles()  */
  }

  charNum = Info.dataEndIndex - Info.dispStartIndex + 1;
  if(charNum > PerLine)  charNum = PerLine;

  /* Display Amino Code BackGround */
  for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) { /* for each Alignment */
      for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) { /* for each char */
          code = Info.codeAlign[i][Info.dispStartIndex+j];  /*if  amino , 0<= code <25 */
          CodeRect[code][NumRect[code]].x = x;
          CodeRect[code][NumRect[code]].y = y;
          CodeRect[code][NumRect[code]].width = BoxW;
          CodeRect[code][NumRect[code]].height = BoxH;
          NumRect[code]++;
          if(NumRect[code] >= MAX_RECT_SIZE) {
             XFillRectangles(display, window, CodeGC[code],
                             CodeRect[code], NumRect[code]);
         /*             printf("overflow of CodeRect, code=%d\n",code); */
             NumRect[code]=0;
          }
      }
  }

  /* Fill Rectangle Really */
  for(code=0; code<MAXCODE; ++code) {
      if(NumRect[code] != 0)
         XFillRectangles(display, window, CodeGC[code],
                         CodeRect[code], NumRect[code]);
  }

  /* Display Amino Code char */
  if(Kanji) {
      for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) {
          for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) {
              code = Info.codeAlign[i][Info.dispStartIndex+j];
              XDrawString16(display, window, AminoCharGC[code], 
                             x+XOffset[code], y+YOffset[code],
                             &XChar2[code], 1);
          }
      }
  }
  else {
      for(i=0, y=yo+2*BoxH; i<Info.alignnum; ++i, y += BoxH) {
          for(j=0, x=LeftMargin; j<charNum; ++j, x += BoxW) {
              code = Info.codeAlign[i][Info.dispStartIndex+j];
              XDrawString(display, window, AminoCharGC[code],
                          x+XOffset[code], y+YOffset[code],
                           &Char1[code], 1);
          }
      }
  }

  XFlush(display);

/* display constraint data (in case of refiner tool) */
  if (EditMode == CONSTRAINT){
    disp_all_const_data_2(display, window);
    disp_region_data_2(display, window,
		       Info.dispStartIndex, Info.dispStartIndex+PerLine-1); 
  }

	disp_activ_2(display, window);

	if(columnBarFlag)
		disp_cost_graph_2(display, window, Info.dispStartIndex,charNum);

	display_ident_2(display, window, Info.dispStartIndex,charNum);
}

/*--------------------------------------------------------------------*/

/* display all constraint data */

static void	disp_all_const_data_2(display, window)
Display	*display;
Window	window;
{
	extern void	disp_all_const_2();
	int		i;
	GC		nowGC;

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const_2(display, window,
			   i, nowGC, 0, 0, 0);
      }
}

/*--------------------------------------------------------------------*/

/* display region data */

static void	disp_region_data_2(display, window, start, end)
Display	*display;
Window	window;
int	start, end;
{
      int	i;
      void	disp_region_one_2();

      if (EditMode != CONSTRAINT) return;
      if (end>Info.dataEndIndex) end = Info.dataEndIndex;

      for (i=start; i<=end; i++){
	  if (Region_flag[i]){
	      disp_region_one_2(display, window, i, WhiteGC);
	      continue;
	  }else
	  if (Region_divide[i]){
	      disp_region_one_2(display, window, i, FixedColumnGC);
	      continue;
	  }else{
	  disp_region_one_2(display, window, i, DrawBackGC);
          }
      }
}

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

/* display result constraint */

static void	disp_result_const_data_2(display, window)
Display	*display;
Window	window;
{
	extern int	left_flag, right_flag, send_left;
	int		i, align;
	void		disp_constraint_2();

    if (left_flag){
	for (align=0; align<Info.alignnum; align++){
            disp_constraint_2(display, window,
			      align, send_left, Gray8GC[CONST_GRAY]);
	}
    }
    if (right_flag){
	for (align=0; align<Info.alignnum; align++){
            disp_constraint_2(display, window,
			      align, send_left+New_calc_leng-1,
                              Gray8GC[CONST_GRAY]);
	}
    }
    for (align=0; align<Info.alignnum; align++){
	for(i=send_left; i<send_left+New_calc_leng; i++){
	    if ((int)Calc_constraint[align][i]>96){
                disp_constraint_2(display, window,
				  align, i, Gray8GC[CONST_GRAY]);
	    }
	}
    }
}

#endif

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

/* display one column constraint data */

static void	disp_one_column_const_2(display, window, index)
Display	*display;
Window	window;
int	index;
{
	extern void	disp_all_const_2();
	int		i;
	GC		nowGC;
	void		disp_region_one_2();

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const_2(display, window,
			   i, nowGC, 1, 0, index);
      }
      disp_region_one_2(display, window, index, DrawBackGC);
      if (Region_flag[index]) disp_region_one_2(display, window, index, WhiteGC);
      if (Region_divide[index]) disp_region_one_2(display, window, index, FixedColumnGC);
}

#endif

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

/* display  one alignment constraint data */

static void	disp_one_align_const_2(display, window, align)
Display	*display;
Window	window;
int	align;
{
	extern void	disp_all_const_2();
	int		i;
	GC		nowGC;

      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
	      nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  disp_all_const_2(display, window,
			   i, nowGC, 2, align, 0);
      }
}

#endif

/*--------------------------------------------------------------------*/

/* disp one alignment from startIndex charNum interval */

static void	disp_align_one_2(display, window, align, startIndex, charNum)
Display	*display;
Window	window;
int	align;
int	startIndex;     /* display start index */
int	charNum;
{
	extern void	disp_all_const_2();
	int		startcol,x,xo,yo,i,j,code;
	GC		nowGC;

  if (!Result_draw_dummy && Info.dispStartIndex>startIndex && charNum==1) return;

  if (!Result_draw_dummy) {
      startcol = startIndex - Info.dispStartIndex;
  }else{
      startcol = startIndex - send_left;
  }
  xo = LeftMargin+startcol*BoxW;

  if((!Result_draw_dummy) && (charNum > PerLine - startcol))
     charNum = PerLine - startcol;

  if((charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) &&
     (!Result_draw_dummy))
     charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;

  yo = get_yo() + (align+2)*BoxH;
  if(Kanji) {
     for(i=startIndex, j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
         code = Info.codeAlign[align][i];
         XFillRectangle(display, window, CodeGC[code],
                        x, yo, BoxW, BoxH); 
         XDrawString16(display, window, AminoCharGC[code], 
                       x+XOffset[code],yo+YOffset[code],
                       &XChar2[code], 1);
      }
  }
  else { 

     for(i=startIndex, j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
         if (Result_draw_dummy){
	     code = Calc_codeAlign[align][i];
	 }else{
             code = Info.codeAlign[align][i];
	 }
         XFillRectangle(display, window, CodeGC[code],
                        x, yo, BoxW, BoxH); 
         XDrawString(display, window, AminoCharGC[code], 
                     x+XOffset[code], yo+YOffset[code],
                     &Char1[code], 1);                            
     }
  }
  if (EditMode==CONSTRAINT && !Result_draw_dummy){
      for (i=0; i<=Const_no; i++){
          if (Const_head[i].active){
              nowGC = Gray8GC[CONST_GRAY];
	  }else{
	      nowGC = WhiteGC;
	  }
	  for (j=startIndex; j<(startIndex+charNum); j++){
	      disp_all_const_2(display, window,
			       i, nowGC, 3, align, j);
	  }
      }
  }
}

/*--------------------------------------------------------------------*/

/* Display Identical Column */

static void	display_ident_2(display, window, startIndex, charNum)
Display	*display;
Window	window;
int	startIndex;      /* start index of display */
int	charNum;	  /* char num. to be display */
{
	int	x, xo, yo, i, j, startcol, code;
	void	draw_string_2();
	int	identical_2();

  yo = get_yo() + (Info.alignnum+2)*BoxH;
  if (Result_draw_dummy){
      startcol = 0;
  }else{
      startcol = startIndex - Info.dispStartIndex;
  }
  xo = LeftMargin+startcol*BoxW;

  if (!Result_draw_dummy){
      if(charNum > Info.dataEndIndex - Info.dispStartIndex + 1)
         charNum = Info.dataEndIndex - Info.dispStartIndex + 1;

      if(charNum > PerLine - startcol)
         charNum = PerLine - startcol;
  }

  XFillRectangle(display, window, DrawBackGC,
                 xo, yo, charNum*BoxW, BoxH);          

  for(i=startIndex,j=0, x=xo; j<charNum; ++j, ++i, x += BoxW) {
      if(!identical_2(i,IdenticalRatio,&code))  continue; 

      /* don't display Gap in identical column */
      if(code == GAP_INNER_CODE  ||
         code == OTHER_INNER_CODE )  continue;   

      draw_string_2(display, window, False, x, yo, code, TextGC);
  }

  /* erase Right part for string becomes short */
/***
  XFillRectangle(display, window, DrawBackGC,
                 x, yo, WinW-x-4, BoxH); 
***/

  XFlush(display);
}

/*--------------------------------------------------------------------*/

static void	disp_scroll_mark_2(display, window)
Display	*display;
Window	window;
{
	int	xo, yo;
	void	draw_string_2();

  if (Result_draw_dummy) return;

/*  printf("in disp_scroll_mark_2\n"); */
  yo = get_yo()+BoxH;
  xo = LeftMargin;

  XFillRectangle(display, window, DrawBackGC,
                 xo-BoxW, yo, BoxW, BoxH);          
  XFillRectangle(display, window, DrawBackGC,
                 xo+PerLine*BoxW,yo, BoxW,BoxH);          

  if(!firstPage()) {
      draw_string_2(display, window, False, xo-BoxW, yo, '<', TextGC);
  }

  if(!lastPage()) {
      draw_string_2(display, window, False, xo+PerLine*BoxW, yo, '>', TextGC);
  }     
}

/*--------------------------------------------------------------------*/

/* display one motif */

void	disp_one_motif_2(display, window)
Display	*display;
Window	window;
{
	Segment	*p_now_seg;
	int	i, align;
	void	disp_constraint_2();

    if (!p_motif) return;

    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg!=NULL){
        if (!p_now_seg->forbidden && !p_now_seg->others){
            for (align=0; align<Info.alignnum; align++){
#ifdef	MOTIF_SEARCH_NEW
                if (p_motif->alrpflag[align] != True) continue;
                for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->repeat; i++){
                    if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		        if (!check_const(align, i))
			    disp_constraint_2(display, window,
					      align, i, FixedColumnGC);
	            }
	        }
#else
                if (p_motif->forbidden_align[align]) continue;
                for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->max; i++){
                    if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		        if (!check_const(align, i))
			    disp_constraint_2(display, window,
					      align, i, FixedColumnGC);
	            }
	        }
#endif
            }
	}
	p_now_seg = p_now_seg->p_next_seg;
    }
}

/* erase one motif */

void	undisp_one_motif_2(display, window)
Display	*display;
Window	window;
{
	Segment	*p_now_seg;
	int	i, align;
	void	disp_align_one_2();

    if (!p_motif) return;

    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg!=NULL){
        if (!p_now_seg->forbidden && !p_now_seg->others){
            for (align=0; align<Info.alignnum; align++){
#ifdef	MOTIF_SEARCH_NEW
                if (p_motif->alrpflag[align] != True) continue;
                for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->repeat; i++){
                    if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		        disp_align_one_2(display, window, align, i, 1);
	            }
	        }
#else
                if (p_motif->forbidden_align[align]) continue;
                for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->max; i++){
                    if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		        disp_align_one_2(display, window, align, i, 1);
	            }
	        }
#endif
            }
	}
	p_now_seg = p_now_seg->p_next_seg;
    }
}

/*--------------------------------------------------------------------*/

static void	disp_edited_motif_2(display, window,
				    start_align, end_align, start_index, end_index)
Display	*display;
Window	window;
int start_align, end_align, start_index, end_index;
{
	Segment	*p_now_seg;
	int	i, align;
	void	disp_constraint_2();

    if (!p_motif) return;
    if (start_index > end_index) swap_int(&start_index, &end_index);

    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg!=NULL){
        if (!p_now_seg->forbidden && !p_now_seg->others){
	    if (p_now_seg->index>=start_index && (p_now_seg->index+p_now_seg->max-1)<=end_index){
	        for (align=start_align; align<=end_align; align++){
#ifdef	MOTIF_SEARCH_NEW
                    if (p_motif->alrpflag[align] != True) continue;
                    for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->repeat; i++){
                        if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		            if (!check_const(align, i))
				disp_constraint_2(display, window,
						  align, i, FixedColumnGC);
		        }
		    }
#else
                    if (p_motif->forbidden_align[align]) continue;
                    for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->max; i++){
                        if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		            if (!check_const(align, i))
				disp_constraint_2(display, window,
						  align, i, FixedColumnGC);
		        }
		    }
#endif
		}
	    }
	}
	p_now_seg = p_now_seg->p_next_seg;
    }
}

/*--------------------------------------------------------------------*/

#if	0

static undisp_edited_motif_2(display, window,
			     start_align, end_align, start_index, end_index)
Display	*display;
Window	window;
int start_align, end_align, start_index, end_index;
{
	Segment	*p_now_seg;
	int	i, align;
	void	disp_align_one_2();

    if (!p_motif) return;
    if (start_index > end_index) swap_int(&start_index, &end_index);

    p_now_seg = p_motif->p_next_seg;
    while (p_now_seg!=NULL){
        if (!p_now_seg->forbidden && !p_now_seg->others){
	    if (p_now_seg->index>=start_index && (p_now_seg->index+p_now_seg->max-1)<=end_index){
	        for (align=start_align; align<=end_align; align++){
#ifdef	MOTIF_SEARCH_NEW
                    if (p_motif->alrpflag[align] != True) continue;
                    for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->repeat; i++){
                        if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		            disp_align_one_2(display, window, align, i, 1);
		        }
		    }
#else
                    if (p_motif->forbidden_align[align]) continue;
                    for (i=p_now_seg->index; i<p_now_seg->index+p_now_seg->max; i++){
                        if (index(p_now_seg->amino, (int)Info.codeAlign[align][i]+'A')){
		            disp_align_one_2(display, window, align, i, 1);
		        }
		    }
#endif
		}
	    }
	}
	p_now_seg = p_now_seg->p_next_seg;
    }
}

#endif

/*--------------------------------------------------------------------*/

/* disp one constraint point */

void	disp_constraint_2(display, window, align, index, nowGC)
Display	*display;
Window	window;
int	align, index;
GC	nowGC;
{
	int		code, nowXo, nowYo;
	extern int	send_left;
	GC		string_color;
	void		draw_string_2();

/*
(void)printf("disp_constraint_2 --- align, index = %d %d\n",
	     align, index);
*/

  if (index<Info.dispStartIndex || index>=(Info.dispStartIndex+PerLine)) return;

  if (nowGC == WhiteGC){
      string_color = BlackGC;
  }else{
      string_color = WhiteGC;
  }

  if (!Result_draw_dummy){
      nowXo = LeftMargin + BoxW*(index-Info.dispStartIndex);
  }else{
      nowXo = LeftMargin + BoxW*(index-send_left);
  }
  nowYo = get_yo() + (align+2)*BoxH;

  XFillRectangle(display, window, nowGC,
                 nowXo, nowYo, BoxW, BoxH);

  if (!Result_draw_dummy){
      code = Info.codeAlign[align][index];
  }else{
      code = Calc_codeAlign[align][index];
  }

  if(Info.dataEndIndex+1 == index)  /* cursor is out of string */
      ;
  else {
     draw_string_2(display, window, False, nowXo, nowYo, code, string_color);
  }
  XFlush(display);
}

/*--------------------------------------------------------------------*/

/* disp one region point */

static void	disp_region_one_2(display, window, index, nowGC) 
Display	*display;
Window	window;
int	index;
GC	nowGC;
{
	int	code, nowXo, nowYo;
	GC	string_color;
	void	draw_string_2();

  nowXo = LeftMargin + BoxW*(index-Info.dispStartIndex);
  nowYo = get_yo() + BoxH;

  XFillRectangle(display, window,nowGC,
                 nowXo, nowYo, BoxW, BoxH);

  if (((index-Info.dataStartIndex) % 10) == 9){
      code = '|';
  }else{
      code = '-';
  }
  if (nowGC == WhiteGC){
      string_color = BlackGC;
  }else{
      string_color = WhiteGC;
  }

  draw_string_2(display, window, False, nowXo, nowYo, code, string_color);
  XFlush(display);
}

/*--------------------------------------------------------------------*/

/* disp active point */

static void	disp_activ_2(display, window)
Display	*display;
Window	window;
{
	int	code;
	void	draw_string_2();

	if (EditMode == CONSTRAINT       ||
	    EditMode == VIEW             ||
	    EditMode == MOVE_ALIGNMENT   ||
	    EditMode == ALIGNMENT_MANUAL ||
	    EditMode == NORMAL             )
		return;
 
  XFillRectangle(display, window, WhiteGC,
                 ActiveXo, ActiveYo, BoxW, BoxH);

  code = Info.codeAlign[ActiveAlign][ActiveIndex]; 

  if(Info.dataEndIndex+1 == ActiveIndex)  /* cursor is out of string */
      ;
  else {
      draw_string_2(display, window, False, ActiveXo, ActiveYo, code, BlackGC);
  }
  XFlush(display);
}


static int	identical_2(index,ratio,maxcode)
int index;  
int ratio;      /* parcent ( 0 to 100) */
int *maxcode;     /* most length align number, caller use for draw char */
{
  int  align, beforecode, code, limitnum, maxcount;
  static int count[MAXCODE];

  if(!Result_draw_dummy && Info.dataEndIndex<index)   return 0;  /* end of string */

  limitnum = Info.alignnum*ratio/100;
  if(limitnum>Info.alignnum) limitnum = Info.alignnum;

  if(limitnum == Info.alignnum)  { 
     /* all must be same, so we can choose simple hi-speed method */
     if (Result_draw_dummy){
         beforecode = Calc_codeAlign[0][index];         
     }else{
         beforecode = Info.codeAlign[0][index];
     }
     for(align=1; align<Info.alignnum; ++align)  {
        if (Result_draw_dummy){
            code = Calc_codeAlign[align][index];         
        }else{
            code = Info.codeAlign[align][index];
        }
        if(beforecode != code)  return 0;
        beforecode = code;
     }
     *maxcode = code;
     return 1;
  }
  else {
     for(align=0; align<Info.alignnum; ++align)  {
        if (Result_draw_dummy){
            code = Calc_codeAlign[align][index];         
        }else{
            code = Info.codeAlign[align][index];
        }
        count[code]++;
     }
     maxcount = -1; 
     for(code=0; code<MAXCODE; ++code) {
         if(maxcount<count[code])  {
            *maxcode = code;
            maxcount = count[code];
         }
         count[code]=0;   /* for next time */
     }
   
     if(maxcount >= limitnum)  return 1;
     else  return 0;
  }
}     

/*--------------------------------------------------------------------*/

static char get_columnNum_2(index)
int index;
{
    switch (index % 10){
        case 0:
  	    return '0';
	    break;
        case 9:
	    return (char)((int)(((index+1)/10 % 10)+48));
	    break;
        case 8:
	    if (index > 90){
	        return (char)((int)(((index+2)/100 % 10)+48));
	    }else{
		return ' ';
	    }
	    break;
        case 7:
	    if (index > 990){
                return (char)((int)((index+3)/1000+48));
	    }else{
		return ' ';
	    }
	    break;
/*
        default:
  	    return ' ';
	    break;
*/
    }

    return ' ';
}

/*--------------------------------------------------------------------*/

static void	disp_scale_2(display, window, flag, index, charNum)
Display	*display;
Window	window;
int	flag;		/* True: display column num */
int	index;		/* display start index */
int	charNum;
{
	int	code, startcol, j, x, xo, yo = get_yo();
	GC	charGC;
	void	draw_string_2();
	char	get_columnNum_2();

  if (!Result_draw_dummy) {
      startcol = index - Info.dispStartIndex;
  }else{
      startcol = index - send_left;
  }
  xo = LeftMargin + startcol*BoxW;

  if (flag) {
      XFillRectangle(display, window, DrawBackGC, 
                     xo, yo, charNum*BoxW, BoxH);
      if (Kanji) {
         for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
             code = get_columnNum_2(index - Info.dataStartIndex+j);
             XDrawString16(display, window, TextGC, 
                           x+XOffset[code], yo+YOffset[code],
                           &XChar2[code], 1);
         }
      }
      else { 
         for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
             code = get_columnNum_2(index - Info.dataStartIndex+j);
             XDrawString(display, window, TextGC, 
                         x+XOffset[code], yo+YOffset[code],
                         &Char1[code], 1);                            
         }
      }
  }

  yo += BoxH;
  XFillRectangle(display, window, DrawBackGC, 
                 xo, yo, charNum*BoxW, BoxH);
  for(j=0, x=xo; j<charNum; ++j, x += BoxW) { /* for each char */
     if(Info.columnAtrib[index+j]==0) { /* normal column */
        charGC = TextGC;
     }
     else if(Info.columnAtrib[index+j]==FIXED_COLUMN) { /* fixed column */
        charGC = TextGC;
        XFillRectangle(display, window, FixedColumnGC, x, yo, BoxW, BoxH);
     }

     if (((index - Info.dataStartIndex+j) % 10) == 9){
         code = '|';
     }else{
         code = '-';
     }
     draw_string_2(display, window, False, x, yo, code, charGC);
  }
}

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

/* draw only 1 column specified by index(index of array) */

static void	disp_scale_one_2(display, window, index)
Display	*display;
Window	window;
int	index; 
{
	int	col, xo, yo;
	int	code;
	GC	backGC, charGC;
	void	draw_string_2();
	char	get_columnNum_2();

  yo = get_yo();
  col = index - Info.dispStartIndex;
  xo = LeftMargin+col*BoxW;


  XFillRectangle(display, window, DrawBackGC, xo, yo, BoxW, BoxH); 

  code = get_columnNum_2(Info.dispStartIndex-Info.dataStartIndex+col);
  draw_string_2(display, window, False, xo, yo, code, TextGC);

  yo += BoxH;

  if(Info.columnAtrib[Info.dispStartIndex+col]==0) { /* normal column */
      backGC = DrawBackGC;
      charGC = TextGC;
  }
  else if(Info.columnAtrib[Info.dispStartIndex+col]==FIXED_COLUMN) {
      backGC = FixedColumnGC;
      charGC = TextGC;
  }

  XFillRectangle(display, window, backGC, xo, yo, BoxW, BoxH); 

  if (((Info.dispStartIndex - Info.dataStartIndex+col) % 10) == 9){
      code = '|';
  }else{
      code = '-';
  }
  draw_string_2(display, window, False, xo, yo, code, charGC);
}  

#endif

/*--------------------------------------------------------------------*/

/* BOU Graph WO KAKU */

static void	disp_cost_graph_2(display, window, startIndex, charNum)
Display	*display;
Window	window;
int	startIndex;     /* display start index */
int	charNum;
{
  int    startcol,x,xo,yo,xr,i,j,cost,value;
  float  magPlus, magMinus;
  GC  gc;
  extern Widget da2;

  if (Result_draw_dummy){
      startcol = 0;
  }else{
      startcol = startIndex - Info.dispStartIndex;
  }
  xo = LeftMargin+startcol*BoxW;

  if (!Result_draw_dummy){ 
      if(charNum > Info.dataEndIndex - Info.dispStartIndex + 1)
         charNum = Info.dataEndIndex - Info.dispStartIndex + 1;

      if(charNum > PerLine - startcol)
         charNum = PerLine - startcol;
  }

  calc_column_cost(startIndex,startIndex+charNum+1);

  yo = get_yo() + (Info.alignnum+3)*BoxH;
  XFillRectangle(display, window, DrawBackGC,
                 xo, yo, BoxW*charNum, BouMinusMargin+BouPlusMargin); 

  yo += BouPlusMargin;

  magPlus = (float)(BouPlusMargin)/(float)(BouMaxValue);
  magMinus = (float)(BouMinusMargin)/(float)(BouMaxValue);
/*  printf("mag=%f\n",mag); */

  for(i=startIndex, j=0, x=xo+1; j<charNum; ++j, ++i, x += BoxW) {
      if (Result_draw_dummy){
          cost = -Calc_columnCost[i];
      }else{
          cost = -Info.columnCost[i];
      }
  /*    printf("cost=%d\n",cost); */
      if(cost>=0) {
         value = (int)(cost*magPlus+0.5);
/*         printf("value=%d\n",value); */
         if(value>BouPlusMargin) value = BouPlusMargin;

         if(value > (int)((float)(BouPlusMargin * BouMaxRatio)/100.0))  {
            gc = BouMotifGC;
	 }
         else {
            gc = BouPlusGC;
         }
         XFillRectangle(display, window, gc,
                        x, yo-value, BoxW-1, value); 
      }
      else {
         value = (int)(-cost*magMinus-0.5);
/*         printf("value=%d\n",value); */
         if(value>BouMinusMargin) value = BouMinusMargin;
         XFillRectangle(display, window, BouMinusGC,
                        x, yo, BoxW-1, value);
      }
  }

  if (!Result_draw_dummy){ 
    if (Info.dispStartIndex+PerLine-1>Info.dataEndIndex){
        xr = LeftMargin + (Info.dataEndIndex-Info.dispStartIndex+1)*BoxW;
        XFillRectangle(display, window, DrawBackGC, xr, get_yo()+BoxH*2,
                       BoxW*PerLine, (Info.alignnum+1)*BoxH+BouMinusMargin+BouPlusMargin); 
    }
  }
}

/*--------------------------------------------------------------------*/

/* display alignment name */

static void	disp_name_2(display, window)
Display	*display;
Window	window;
{
	int	x, yo, align, code, i, leng;
	void	draw_string_2();

   yo = get_yo();
   XFillRectangle(display, window, DrawBackGC,
                  3, yo, 
                  LeftMargin, Info.rowH);

   yo += 2*BoxH;
   for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
       leng = strlen(Info.alignname[align]);
       for(i=0, x=AnMargin; i<leng; ++i, x += BoxW) {
           code = Info.alignname[align][i];
           draw_string_2(display, window, False, x, yo, code, TextGC);
      }
   }
   XFlush(display);
}

/*--------------------------------------------------------------------*/

/* display filename and editmode */

static void disp_editmode_etc_2(display, window)
Display	*display;
Window	window;
{
	char	*edit_mode;
	char	str1[63], str2[63];
	int	x, yo, code, i, leng;
	void	draw_string_2();

   if (strrchr(FileName,'/')){ 
       sprintf(str1,"File Name:%s",(strrchr(FileName,'/')+1));
   }else{
       sprintf(str1,"File Name:%s",FileName);
   }
   switch (EditMode){
       case VIEW: edit_mode = "View"; break;
       case NORMAL: edit_mode = "Edit(Normal)"; break;
       case CONSTRAINT: edit_mode = "Edit(Constraint)"; break;
       case INSERT: edit_mode = "Amino(Insert)"; break;
       case OVER_WRITE: edit_mode = "Amino(Overwrite)"; break;
       case MOVE_ALIGNMENT: edit_mode = "Move(Alignment)"; break;
       case ALIGNMENT_MANUAL: edit_mode = "Alignment(Manual)"; break;
   }
   sprintf(str2,"Edit Mode:%s",edit_mode);

   yo = 8;
   leng = strlen(str1);
   XFillRectangle(display, window, DrawBackGC,
                  8+32*BoxW, yo, 
                  (int)(40*BoxW), BoxH);

   for(i=0,x=12+32*BoxW; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(display, window, DrawBackGC,
                  8+32*BoxW, yo, 
                  (int)(40*BoxW), BoxH);

   for(i=0,x=12+32*BoxW; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }
}

/*--------------------------------------------------------------------*/

static void	disp_cost_2(display, window, copy)
Display	*display;
Window	window;
Bool copy; /* copy current to previous */
{
	char	str1[31], str2[31];
	int	x, yo, code, i, leng;
	void	draw_string_2();

   if (Result_draw_dummy) return;

   if (copy) strcpy(PreviousCost,CurrentCost);
   
   Info.cost = calcCost(Info.dataStartIndex, Info.dataEndIndex);
   sprintf(CurrentCost,"%d",-Info.cost);

   sprintf(str1,"Current Score  = %s",CurrentCost);
   sprintf(str2,"Previous Score = %s",PreviousCost);

   yo = 8;
   leng = strlen(str1);
   XFillRectangle(display, window, DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW),BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(display, window, DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW), BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }
   XFlush(display);
}

/*--------------------------------------------------------------------*/

#ifdef	DUMMY

static void	disp_cost_result_2(display, window)
Display	*display;
Window	window;
{
	char	str1[31], str2[31], after_cost[31], before_cost[31];
	int	x, yo, code, i, leng, temp;
	void	draw_string_2();

   if (!Result_draw_dummy) return;

   Calc_cost = calcCost_result();
   sprintf(after_cost,"%d",-Calc_cost);
   temp = calcCost(send_left, send_right);
   sprintf(before_cost,"%d",-temp);

   sprintf(str1,"After Calculate  = %s",after_cost);
   sprintf(str2,"Before Calculate = %s",before_cost);

   yo = 24;
   leng = strlen(str1);
   XFillRectangle(display, window, DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW), BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str1[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }

   yo += (int)(1.3*BoxH);
   leng = strlen(str2);
   XFillRectangle(display, window, DrawBackGC,
                  8, yo, 
                  (int)(1.3*leng*BoxW), BoxH);

   for(i=0,x=12; i<leng; ++i, x+=BoxW) {
      code = str2[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }
   XFlush(display);
}

#endif

/*--------------------------------------------------------------------*/

static void	disp_bar_2(display, window)
Display	*display;
Window	window;
{
	char	str[100];
	int	i, leng, code, x, xo, yo,
		red_bar_start,red_bar_end, red_bar_leng;
	void	draw_string_2();

   if (Result_draw_dummy) return;

   xo = WinW - BarMargin;

   XFillRectangle(display, window, DrawBackGC, xo, 4,
                  BarLeng+5, TopMargin-5);

   yo = TopMargin - 60;
   yo += BoxH;
   sprintf(str, "%d",Info.dispStartIndex - Info.dataStartIndex + 1);
   leng = strlen(str);
   for(i=0,x=xo; i<leng; ++i, x+=BoxW) {
      code = str[i];
      draw_string_2(display, window, False, x, yo, code, TextGC);
   }
   /* empty case */
   if(Info.dataEndIndex <= Info.dataStartIndex) return;

   yo += BoxH;
   /* black line means total length */  
   XDrawLine(display, window, TextGC, xo, yo,
             xo+BarMargin-10, yo);
   XDrawLine(display, window, TextGC, xo, yo+1,
             xo+BarMargin-10, yo+1);

   /* red line means displaying area */
   red_bar_start = xo + 
             BarLeng*(Info.dispStartIndex - Info.dataStartIndex)/
                      (Info.dataEndIndex - Info.dataStartIndex);
   red_bar_leng = BarLeng*PerLine/(Info.dataEndIndex - Info.dataStartIndex);

   if(red_bar_leng >BarLeng)
      red_bar_leng = BarLeng;

   red_bar_end = red_bar_start + red_bar_leng;

   XDrawLine(display, window, FixedColumnGC, red_bar_start, yo-1,
             red_bar_end, yo-1);
   XDrawLine(display, window, FixedColumnGC, red_bar_start, yo,
             red_bar_end, yo);
   XDrawLine(display, window, FixedColumnGC, red_bar_start, yo+1,
             red_bar_end, yo+1);
   XDrawLine(display, window, FixedColumnGC, red_bar_start, yo+2,
             red_bar_end, yo+2);
   XFlush(display);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
