/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	constraint.c
		treate constraint data
----------------------------------------------------------------------*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include "aedit.h"

static Bool SET_flag = True;
static int first_click, const_active;


int process_const(now_align, now_index)
int now_align, now_index;
{
    Bool break_flag = False;
    Constraint Const_head_back;
    Constraint_data *p_now;
    Constraint_data *p_old;
    int const_now = -1;
    int c;

    if (Info.codeAlign[now_align][now_index] == GAP_INNER_CODE) return;

    do {
        const_now++;
        if (const_now > Const_no) break;
        p_now = Const_head[const_now].p_first;
        p_old = Const_head[const_now].p_first;
        while (p_now != NULL){
            if (p_now->align == now_align && p_now->index == now_index){
                if (Const_head[const_now].active){
                    Const_head[const_now].active = False;
		    Const_head_back = Const_head[const_now];
		    first_click = CONST_GRAY;
		    for (c=const_now; c<Const_no; c++){
		        Const_head[c] = Const_head[c+1];
		    }
		    if (SET_flag){
			Const_head[Const_no] = Const_head_back;
			SET_flag = False;
		    }else{
			Const_no--;
			Const_head[Const_no].p_last->p_next = 
			    			Const_head_back.p_first;
			Const_head[Const_no].p_last = Const_head_back.p_last;
			Const_head[Const_no].active_no += 
						Const_head_back.active_no;
		    }
                    disp_all_const(Const_no, WhiteGC, 0, 0, 0);
		    process_divide(Const_no, False);
		}else{
                    if (p_now == Const_head[const_now].p_first &&
        	        p_old == Const_head[const_now].p_first){
		        Const_head[const_now].p_first = p_now->p_next;
		        p_old = p_now->p_next;
	    	    }else{
		        p_old->p_next = p_now->p_next;
		    }
		    if (p_now->p_next == NULL){
			Const_head[const_now].p_last = p_old;
		    }
		    Const_head[const_now].active_no--;
		    XtFree(p_now);
		    disp_align_one(now_align, now_index, 1);
		    disp_edited_motif(now_align, now_align, now_index, now_index); 
		    first_click = CONST_WHITE;
		    const_active = const_now;
		    if (Const_head[const_now].active_no == 0){
			Const_no--;
			SET_flag = True;
		    }
		}
		print_list();
                break_flag = True;
            }else{
                p_old = p_now;
                p_now = p_now->p_next;
            }
        if (break_flag) break;
        }
    }while (!break_flag);
    if (!break_flag){
        add_const(now_align, now_index);
	first_click = CONST_COLORLESS;
	print_list();
    }
}


edit_const(now_align, start_index, end_index, select, add)
int now_align, start_index, end_index, add;
Bool select; /* True:one alignnment(=align)  False:other alignment */
{
    Constraint_data *p_now;
    int const_now;

    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    if (start_index<=p_now->index && p_now->index<=end_index){
		if ((select && (p_now->align == now_align)) ||
		    (!select && (p_now->align != now_align))){
		    p_now->index += add;
		}
	    }
 	    p_now = p_now->p_next;
        }
    } 
}


Bool check_const(now_align, now_index)
int now_align, now_index;
{
    Constraint_data *p_now;
    int const_now;

    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    if (p_now->align==now_align && p_now->index==now_index) return True;
 	    p_now = p_now->p_next;
        }
    } 
    return False;
}


Bool check_active(now_align, now_index)
int now_align, now_index;
{
    Constraint_data *p_now;
    int const_now;

    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    if (p_now->align==now_align && p_now->index==now_index && 
                Const_head[const_now].active) return True;
 	    p_now = p_now->p_next;
        }
    } 
    return False;
}


edit_region(start_index, end_index, movement, dir)
int start_index, end_index, movement, dir;
{
    int i, deff, mod;

    deff = mod = dir;
    if (movement*dir>0) deff *= -1;
    if (movement*dir<0) mod *= -1;

    for (i=end_index; i*mod>=start_index*mod; i+=deff){
	Region_divide[i+movement] = Region_divide[i];
	Region_flag[i+movement] = Region_flag[i];
    }
    if (movement*dir>0){
	if (Region_flag[start_index-dir] || 
            (Region_divide[start_index-dir] && Region_flag[start_index])){
	    for (i=start_index; i*dir<(start_index+movement)*dir; i+=dir){
	        Region_flag[i] = True;
	    }
	}else{
	    for (i=start_index; i*dir<(start_index+movement)*dir; i+=dir){
	        Region_flag[i] = False;
	    }
	}
	if (Region_divide[start_index]){
	    for (i=start_index; i*dir<(start_index+movement)*dir; i+=dir){
	        Region_divide[i] = False;
	    }
	}
    }
}


clear_const()
{
    Constraint_data *p_now;
    Constraint_data *p_clear;
    int const_now, i;

    SET_flag = True; 

    for (const_now=0; const_now<=Const_no; const_now++){
        Const_head[const_now].active = False;
        Const_head[const_now].active_no = 0;
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    p_clear = p_now;
 	    p_now = p_now->p_next;
	    XtFree(p_clear);
        }
    } 
    Const_no = -1;

    for (i=0; i<MAX_ALIGN_LENG; i++){
	Region_flag[i] = False;
	Region_divide[i] = False;
    }
    Region_no = 0;

    print_list();
}


process_OK()
{
    Constraint_data *p_now;
    Bool const_column[MAX_ALIGN];
    int save_ActiveIndex, save_ActiveAlign, save_ActiveXo, save_ActiveYo;
 
    if (EditMode != CONSTRAINT) return;
    if (Const_head[Const_no].active_no == 0) return;
    if (Const_no < 0) return;
    if (check_const_column(-1, -1, const_column)){
        popUpWarnDialog("This constraint overlaps at one alignment");
	return;
    }
    if (check_cross()){
        popUpWarnDialog("This constraint crosses previous one");
	return;
    }

    Const_head[Const_no].active = True;
    disp_all_const(Const_no, Gray8GC[CONST_GRAY], 0, 0, 0);
    process_divide(Const_no, True);
    SET_flag = True;

    print_list();
}


add_const(now_align, now_index)
int now_align, now_index;
{
    Constraint_data *p_temp;

    if((p_temp = (Constraint_data *)calloc(1, sizeof(Constraint_data))) == 
       NULL){
        fprintf(stderr, "constraint memory alloc error\n");
    }else{
        if (SET_flag){
	    Const_no++;
            Const_head[Const_no].p_first = p_temp;
            Const_head[Const_no].p_last = p_temp;
            Const_head[Const_no].active_no = 1;
            Const_head[Const_no].active = False;
            Const_head[Const_no].region = False;
            SET_flag = False;
        }else{
 	    Const_head[Const_no].p_last->p_next = p_temp;
            Const_head[Const_no].p_last = p_temp;
            Const_head[Const_no].active_no++;
        }
        Const_head[Const_no].p_last->p_next = NULL;
        Const_head[Const_no].p_last->align = now_align;
        Const_head[Const_no].p_last->index = now_index;
    }

    disp_constraint(now_align, now_index, WhiteGC);
}    
        

disp_all_const(const_now, nowGC, select, align, index)
int const_now, align, index;
int select; /* 0:all  1:one column  2:one alignment  3:one amino*/
GC nowGC;
{
    Constraint_data *p_now;

    p_now = Const_head[const_now].p_first;
    while (p_now != NULL){
	if ((p_now->index)<Info.dispStartIndex || 
            (p_now->index)>(Info.dispStartIndex+PerLine)){ ;
	}else{
	    switch (select){
		case 0:
                    disp_constraint(p_now->align, p_now->index, nowGC);
		    break;
		case 1:
		    if (p_now->index == index){
                        disp_constraint(p_now->align, p_now->index, nowGC);
		    }
		    break;
		case 2:
		    if (p_now->align == align){
                        disp_constraint(p_now->align, p_now->index, nowGC);
		    }
		    break;
		case 3:
		    if (p_now->align == align && p_now->index == index){
                        disp_constraint(p_now->align, p_now->index, nowGC);
		    }
		    break;
		default:
		    break;
	    }
	}
	p_now = p_now->p_next;
    }
}


process_divide(const_now, const_flag)
int const_now;
Bool const_flag;
{
    Constraint_data *p_now;
    int count[MAX_ALIGN_LENG];
    int i, c, right, left;

    if (Const_head[const_now].active_no < Info.alignnum) return;

    for (i=0; i<=MAX_ALIGN_LENG; i++){
	count[i] = 0;
    }

    p_now = Const_head[const_now].p_first;
    while (p_now != NULL){
	count[p_now->index]++;
	p_now = p_now->p_next;
    }
    for (i=0; i<=MAX_ALIGN_LENG; i++){
	if (count[i] == Info.alignnum){
	    switch (const_flag){
		case True:
		    Region_divide[i] = True;
		    Region_flag[i] = False;
		    disp_region_one(i, FixedColumnGC);
		    if (Region_flag[i+1] == True && Region_flag[i-1] == True){
			Region_no++;
		    }
		    break;
		case False:
		    Region_divide[i] = False;
		    disp_region_one(i, DrawBackGC);
		    if (Region_flag[i+1] == True && Region_flag[i-1] == True){
			Region_flag[i] = True;
			if (Region_no>0) Region_no--;
		    	disp_region_one(i, WhiteGC);
			break;
		    }
		    if ((Region_flag[i+1]==True && Region_divide[i-1]==True) ||
		        (Region_flag[i-1]==True && Region_divide[i+1]==True)){
			Region_flag[i] = True;
		    	disp_region_one(i, WhiteGC);
			break;
		    }
		    if (Region_flag[i+1]==True && Region_flag[i-1]==False){
			if (Region_no>0) Region_no--;
    			for (c=i; (c<=Info.dataEndIndex && !Region_divide[c]);
                             c++){ ;
    			}
    			right = c-1;
        		for (c=i+1; c<=right; c++){
	        	    Region_flag[c] = False;
	    		    if (c>=Info.dispStartIndex && 
			        c<(Info.dispStartIndex+PerLine)){
		    		disp_region_one(c, DrawBackGC);
	    		    }
			}
			break;
		    }
		    if (Region_flag[i-1]==True && Region_flag[i+1]==False){
			if (Region_no>0) Region_no--;
    			for (c=i; (c>=Info.dataStartIndex && !Region_divide[c]);
			     c--){ ;
    			}
    		        left = c+1;
        		for (c=i-1; c>=left; c--){
	        	    Region_flag[c] = False;
	    		    if (c>=Info.dispStartIndex && 
			        c<(Info.dispStartIndex+PerLine)){
		    		disp_region_one(c, DrawBackGC);
	    		    }
			}
		    }
		    break;
		default:
		    break;
	    }
	}
    }
}


process_region(newActiveCol)
int newActiveCol;
{
    int i, index, left, right;
    Bool next_flag = False;

    index = newActiveCol + Info.dispStartIndex;

    if (Region_divide[index]) return;

    for (i=index; (i>=Info.dataStartIndex && !Region_divide[i]); i--){ ;
    }
    left = i+1;
    for (i=index; (i<=Info.dataEndIndex && !Region_divide[i]); i++){ ;
    }
    right = i-1;
    if (Region_flag[index]){
	if (Region_no>0) Region_no--;
        for (i=left; i<=right; i++){
	    Region_flag[i] = False;
	    if (i>=Info.dispStartIndex && i<(Info.dispStartIndex+PerLine)){
                disp_region_one(i, BlackGC);
	    }
	}
    }else{
	if (Region_no != 0){
            for (i=left-1; Region_divide[i]; i--){ ;
            }
	    if (Region_flag[i]) next_flag = True;
            for (i=right+1; Region_divide[i]; i++){ ;
            }
	    if (Region_flag[i]) next_flag = True;
	    if (!next_flag) return;
	}
	Region_no++;
        for (i=left; i<=right; i++){
	    Region_flag[i] = True;
	    if (i>=Info.dispStartIndex && i<(Info.dispStartIndex+PerLine)){
                disp_region_one(i, WhiteGC);
	    }
	}
    }    
}


Bool check_const_column(seek_index, const_attribute, const_column)
int seek_index, const_attribute;
Bool *const_column;
{
    Constraint_data *p_now, *p_temp;
    Bool first_flag = True;
    int const_now, align, i, same_align;
    int first_direction, left = -1, right = 1;
    int const_before[MAX_ALIGN][MAX_CONSTRAINT], const_before_now[MAX_ALIGN];

    for (align=0; align<Info.alignnum; align++){
	const_column[align] = False;
	const_before_now[align] = -1;
    }

    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
            if (p_now->index == seek_index){
		switch (const_attribute){
		    case CONST_COLORLESS:
			break;
		    case CONST_WHITE:
                	if (!(Const_head[const_now].active)){
		       	    const_column[p_now->align] = True;
			}
			break;
		    case CONST_GRAY:
                	if (Const_head[const_now].active){
		       	    const_column[p_now->align] = True;
			}
			break;
		}
            }
	    /* check overlap */
	    if (const_attribute == -1 && !(Const_head[const_now].active)){
	        if (const_column[p_now->align] == False){
		    const_column[p_now->align] = True;
		}else{
		    return True;
		}
	    }
            p_now = p_now->p_next;
        }
    }
    return False;
}
    

Bool check_cross()
{
    Constraint_data *p_now, *p_temp;
    Bool first_flag = True;
    int const_now, align, i, same_align;
    int first_direction, left = -1, right = 1;

    /* check cross */
    for (i=0; i<Const_no; i++){
        first_flag = True;
    	p_now = Const_head[Const_no].p_first;
        while (p_now != NULL){
    	    p_temp = Const_head[i].p_first;
            while (p_temp != NULL){
		  if (p_temp->align == p_now->align) same_align = p_temp->index;
            p_temp = p_temp->p_next;
	    }
	    if (first_flag){
	        first_flag = False;
		if ((same_align - p_now->index) > 0) first_direction = right;
		if ((same_align - p_now->index) < 0) first_direction = left;
	    }
	    if (((same_align - p_now->index) * first_direction) < 0) return True;
            p_now = p_now->p_next;
    	}
    }
    return False;
}


not_disp_all_const_data()
{
    Constraint_data *p_now;
    int const_now;

    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    disp_align_one(p_now->align, p_now->index, 1);
	    disp_edited_motif(p_now->align, p_now->align, p_now->index, p_now->index);
 	    p_now = p_now->p_next;
        }
    } 
} 


print_list()
{
    Constraint_data *p_now;
    int const_now;
    int c = 0;

/*    
    for (const_now=0; const_now<=Const_no; const_now++){
        fprintf(stderr, "list no:%d  data no:%d  attribute:%d   position:%d %d\n",
               const_now, Const_head[const_now].active_no, 
               Const_head[const_now].active, ActiveAlign, ActiveIndex);
        p_now = Const_head[const_now].p_first;
        c = 0;
        while (p_now != NULL){
  	    c++;
            fprintf(stderr, "%d %d %d   ",c, p_now->align, p_now->index);
 	    p_now = p_now->p_next;
        }
        fprintf(stderr, "\n");
    } 
    if (Const_no<0) fprintf(stderr, "data none\n");
    fprintf(stderr, "\n");
*/   
} 

/*--------------------------------------------------------------------*/

void	disp_all_const_2(display, window,
			 const_now, nowGC, select, align, index)
Display	*display;
Window	window;
int	const_now, align, index;
int	select;				/* 0:all
					   1:one column 
					   2:one alignment
					   3:one amino */
GC	nowGC;
{
	extern void	disp_constraint_2();
	Constraint_data	*p_now;

    p_now = Const_head[const_now].p_first;
    while (p_now != NULL){
	if ((p_now->index)<Info.dispStartIndex || 
            (p_now->index)>(Info.dispStartIndex+PerLine)){ ;
	}else{
	    switch (select){
		case 0:
                    disp_constraint_2(display, window,
				      p_now->align, p_now->index, nowGC);
		    break;
		case 1:
		    if (p_now->index == index){
                        disp_constraint_2(display, window,
					  p_now->align, p_now->index, nowGC);
		    }
		    break;
		case 2:
		    if (p_now->align == align){
                        disp_constraint_2(display, window,
					  p_now->align, p_now->index, nowGC);
		    }
		    break;
		case 3:
		    if (p_now->align == align && p_now->index == index){
                        disp_constraint_2(display, window,
					  p_now->align, p_now->index, nowGC);
		    }
		    break;
		default:
		    break;
	    }
	}
	p_now = p_now->p_next;
    }
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
