/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   cmd2.c  
**
**   commands which chage alignment itself.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  "aedit.h"


/* Delete the active position's char. return 1 if really modified. */
/* Normal Text Mode */
delActivChar1(dir)
int  dir;
{
   int  i;

   if(ActiveIndex == Info.dataEndIndex+1)  return 0;

   if(Info.columnAtrib[ActiveIndex] == FIXED_COLUMN)  return 0;
 
   delChar(ActiveIndex,dir);

   if(dir==LEFT)  
      disp_align_one(ActiveAlign,Info.dispStartIndex,PerLine);
   else          
      disp_align_one(ActiveAlign,ActiveIndex,PerLine-ActiveCol+1);

   disp_activ();

   return 1;
}


/* delete the active position's char. return 1 if really modified. */
/* Normal Text Mode */
delBeforeChar1(dir)
int  dir;
{
   int  i;

   /* There is no before char */
   if(ActiveIndex==Info.dataStartIndex)  return 0;

   if(Info.columnAtrib[ActiveIndex-1] == FIXED_COLUMN)  return 0;

   delChar(ActiveIndex-1,dir);

   if(dir==LEFT)  
      disp_align_one(ActiveAlign,Info.dispStartIndex,PerLine);
   else          
      disp_align_one(ActiveAlign,ActiveIndex-1,PerLine-ActiveCol+2);

   shiftLeftActiv(1);     /* move active point(cursor) backward */
   return 1;
}



/* Delete the active position's char. return 1 if really modified. */
/* Alignment Editor Mode */
delActivChar2(dir)
int  dir;          /* direction 'gap' insert */
{
   int  i, code;

   if(EditMode==VIEW)   return 0;

   /* cursor is out of string alignment */
   if(ActiveIndex == Info.dataEndIndex+1)  return 0;

   if(Info.columnAtrib[ActiveIndex] == FIXED_COLUMN)  return 0;

   code = Info.codeAlign[ActiveAlign][ActiveIndex];
   if(code == GAP_INNER_CODE) {  
      delChar(ActiveIndex,dir);

      if(dir==LEFT)  
         disp_align_one(ActiveAlign,Info.dispStartIndex,PerLine);
      else          
         disp_align_one(ActiveAlign,ActiveIndex,PerLine-ActiveCol+1);
      disp_activ();
      return 1;
   }
   else if(isAmino(code)) {
       if (EditMode != VIEW){
           return 0;
       }else{
           insertGapOther(ActiveIndex,dir);
           return 1;
       }
   }
   return 0;
}


/* delete the active position's char. return 1 if really modified. */
/* Alignment Editor Mode */
delBeforeChar2(dir)
int  dir;
{
   int  i, code;

   /* There is no before char */
   if(ActiveIndex == Info.dataStartIndex)  return 0;

   if(Info.columnAtrib[ActiveIndex-1] == FIXED_COLUMN)  return 0;

   /* If Amino char, insert Gap other alignment */
   code = Info.codeAlign[ActiveAlign][ActiveIndex-1];
   if(code==GAP_INNER_CODE) { 
      delChar(ActiveIndex-1,dir);
      if(dir==LEFT)  
         disp_align_one(ActiveAlign,Info.dispStartIndex,PerLine);
      else          
         disp_align_one(ActiveAlign,ActiveIndex-1,PerLine-ActiveCol+2);
      shiftLeftActiv(1);     /* move active point(cursor) backward */
      return 1;
   }
   if(isAmino(code)) { 
       insertGapOther(ActiveIndex-1,dir);
       return 1;
   }
}


static delChar(index,dir)
int  index;
int  dir;
{
   int  i, code, type, fix_index;

   if(dir==RIGHT) {  
      get_absorb_fixed_column(dir,Info.dataEndIndex,&type,&fix_index);

      for(i=index;  i<fix_index-1; ++i)  {
         Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i+1];
      }

      /* Insert Gap at the place just befor the first fixed column */
      Info.codeAlign[ActiveAlign][fix_index-1] = GAP_INNER_CODE;
   }
   else {
      get_absorb_fixed_column(dir,Info.dataStartIndex,&type,&fix_index);

      for(i=index; i>fix_index+1; --i)  {
         Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i-1];
      }

      /* Insert Gap at the top of alignments */
      Info.codeAlign[ActiveAlign][fix_index+1] = GAP_INNER_CODE;
   }
}


deleteGapOther(index,dir)
int  index;
int  dir;    /* inser position on array */
{
   int  align,i, type, fix_index, start_align, end_align;
   int  charNum, startcol, endcol, xo, yo, x, code;
   Bool start_align_flag = False, end_align_flag = False;

/* decidion start and end alignment of delete area */
   start_align = 0; end_align = Info.alignnum-1;
   for(align=0; align<Info.alignnum; ++align) {
       if (align == ActiveAlign) start_align_flag = True;
       if (Info.codeAlign[align][index] != GAP_INNER_CODE &&
           align != ActiveAlign){ 
           if (!start_align_flag) start_align = align+1;  
           if (start_align_flag && !end_align_flag){
               end_align = align-1;  
               end_align_flag = True;
           }
       }
   }

   if(dir==RIGHT) {
   get_absorb_fixed_column(dir,Info.dataEndIndex,&type,&fix_index);
   if (fix_index != Info.dataEndIndex+1 && !((end_align - start_align) == Info.alignnum-1)) return;
      
      for(align=0; align<Info.alignnum; ++align) {
         if((align != ActiveAlign) && (align >= start_align) &&
            (align <= end_align)){ 
            for (i = index; i < Info.dataEndIndex; i++){
               Info.codeAlign[align][i] = Info.codeAlign[align][i+1];
            }
            Info.codeAlign[align][Info.dataEndIndex] = GAP_INNER_CODE;
	    edit_const(align, ActiveIndex, Info.dataEndIndex, True, -1);
         }
      }

      if (end_align - start_align == Info.alignnum-1){
          for (i=index; i<Info.dataEndIndex; i++){
	      Info.columnAtrib[i] = Info.columnAtrib[i+1];
	  }
          disp_scale_one(fix_index); disp_scale_one(fix_index-1);
	  if (fix_index != Info.dataEndIndex+1){
              for (i=fix_index-1; i<Info.dataEndIndex; i++){
		  Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i+1];
	      }
	      disp_align_one(ActiveAlign, ActiveIndex, PerLine-(ActiveIndex-Info.dispStartIndex));
	  }
          Info.dataEndIndex--;
          Info.columnAtrib[Info.dataEndIndex] = 0;
	  edit_region(301, ActiveIndex, -1, RIGHT);
	  disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
      }

/****** START OF MODIFY ********/
      yo = get_yo() + 2*BoxH;
      xo = LeftMargin + (index-Info.dispStartIndex+1)*BoxW;
      charNum = PerLine - (index-Info.dispStartIndex+1);

      for(align=0; align<Info.alignnum; ++align,  yo +=BoxH) {
         if((align != ActiveAlign) && (align >= start_align) &&
            (align <= end_align)){ 
              XCopyArea(TheDisplay, TheWindow, TheWindow, WhiteGC, 
                        xo, yo, charNum*BoxW, BoxH, xo-BoxW, yo);
          }
      }

/* draw right-end char */
      if ((Info.dispStartIndex+PerLine-1) <= Info.dataEndIndex){ 
          yo = get_yo() + 2*BoxH;
          x = LeftMargin + (PerLine-1)*BoxW;
          for(align=0; align<Info.alignnum; ++align,  yo +=BoxH) {
             if((align != ActiveAlign) && (align >= start_align) &&
                (align <= end_align)){ 
                  code = Info.codeAlign[align][Info.dispStartIndex+PerLine-1]; 
                  draw_string(True, x, yo, code, AminoCharGC[code]);
              }
          }
	  if (EditMode == CONSTRAINT){
	      disp_one_column_const(Info.dispStartIndex+PerLine-1); 
	  }
      }

      if (((Info.dispStartIndex+PerLine-1) >= Info.dataEndIndex) &&
          (Info.dispStartIndex <= Info.dataEndIndex)){
          if (start_align == 0 && end_align == Info.alignnum-1){
              yo = get_yo() + BoxH*(ActiveAlign+2);
              x = LeftMargin + (Info.dataEndIndex-Info.dispStartIndex+1)*BoxW;
              XFillRectangle(TheDisplay, TheWindow, BlackGC, 
                             x, yo, BoxW, BoxH);
          }else{
              code = GAP_INNER_CODE;
              for (align=start_align; align<=end_align; align++){
                  yo = get_yo() + BoxH*(align+2);
                  x = LeftMargin + (Info.dataEndIndex-Info.dispStartIndex)*BoxW;
                  draw_string(False, x, yo, code, AminoCharGC[code]);
              }
          }
      }  

   }else
   if(dir==LEFT) {
      get_absorb_fixed_column(dir,Info.dataStartIndex,&type,&fix_index);
      if (fix_index != Info.dataStartIndex-1 && !((end_align - start_align) == Info.alignnum-1)) return;

      for(align=0; align<Info.alignnum; ++align) {
         if((align != ActiveAlign) && (align >= start_align) &&
            (align <= end_align)){ 
            for (i = index; i > Info.dataStartIndex; i--){
               Info.columnAtrib[i] = Info.columnAtrib[i-1];
            }
            Info.codeAlign[align][Info.dataStartIndex] = GAP_INNER_CODE;
	    edit_const(align, Info.dataStartIndex, ActiveIndex, True, 1);
         }
      }

      if (end_align - start_align == Info.alignnum-1){
          for (i=index; i>Info.dataStartIndex; i--){
	      Info.columnAtrib[i] = Info.columnAtrib[i-1];
	  }
          disp_scale_one(fix_index); disp_scale_one(fix_index+1);
          if (fix_index != Info.dataStartIndex-1){
              for (i=fix_index+1; i>Info.dataStartIndex; i--){
                  Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i-1];
	      }
	      disp_align_one(ActiveAlign, ActiveIndex, ActiveIndex-Info.dispStartIndex+1);
	  }
          Info.dataStartIndex++;
          Info.columnAtrib[Info.dataStartIndex] = 0;
	  edit_region(301, ActiveIndex, 1, LEFT);
	  disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
      }

/****** START OF MODIFY ********/
      yo = get_yo() + 2*BoxH;
      xo = LeftMargin;
      charNum = index-Info.dispStartIndex;

      for(align=0; align<Info.alignnum; ++align,  yo +=BoxH) {
         if((align != ActiveAlign) && (align >= start_align) &&
            (align <= end_align)){ 
              XCopyArea(TheDisplay, TheWindow, TheWindow, WhiteGC, 
                        xo, yo, charNum*BoxW, BoxH, xo+BoxW, yo);
          }
      }
      
/* draw left-end char */
          yo = get_yo() + 2*BoxH;
          x = LeftMargin;
          for(align=0; align<Info.alignnum; ++align,  yo +=BoxH) {
             if((align != ActiveAlign) && (align >= start_align) &&
                (align <= end_align)){ 
                  code = Info.codeAlign[align][Info.dispStartIndex]; 
                  draw_string(True, x, yo, code, AminoCharGC[code]);
              }
          }
	  if (EditMode == CONSTRAINT){
	      disp_one_column_const(Info.dispStartIndex); 
	  }
   }
}


insertGapOther(index,dir)
int  index;
int  dir;    /* inser position on array */
{
   int  align,i, type, fix_index;
   int  charNum, startcol, endcol, xo, yo;

   if(dir==RIGHT) { /* same as normal text */
      get_absorb_fixed_column(dir,Info.dataEndIndex,&type,&fix_index);

      Info.dataEndIndex++;
 
      for(align=0; align<Info.alignnum; ++align) {
         if(align == ActiveAlign)  { /* myself */
            /* copy the right of the first fixed(or absorb) column */
            for(i=Info.dataEndIndex; i>fix_index; --i)  {
               Info.codeAlign[align][i] = Info.codeAlign[align][i-1];
               /* Copy atribute column also. */
               Info.columnAtrib[i] = Info.columnAtrib[i-1];
            }
            /* insert the gap at the place the first fixed(or absorb) column
             * was exist before.
             */
            Info.codeAlign[align][fix_index] = GAP_INNER_CODE;
            Info.columnAtrib[fix_index] = 0;
         }
         else {
            for(i=Info.dataEndIndex; i>index; --i)  {
               Info.codeAlign[align][i] = Info.codeAlign[align][i-1];
            }
            Info.codeAlign[align][index] = GAP_INNER_CODE;
         }
      }

/****** START OF MODIFY ********/
      disp_bar();
      if(CalcColumnCost) 
          disp_cost_graph(index,PerLine);

      display_ident(index,PerLine);

      /* move the right part of fixed column */    
      yo = get_yo() + 2*BoxH;
      startcol = fix_index - Info.dispStartIndex;
      endcol = PerLine-1;
      if(startcol < PerLine)  {
          disp_scale(False,fix_index,PerLine-startcol);
          disp_scroll_mark();

          xo = LeftMargin+startcol*BoxW;
          charNum = endcol-startcol;
          if(charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) {
/*              printf("charNum=%d at 1 Right\n",charNum); */
              charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;
          }

          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    xo,yo, charNum*BoxW, BoxH*Info.alignnum,
                    xo+BoxW, yo);

          /* draw gap char to ActiveAlign */
          yo = get_yo() + (ActiveAlign+2)*BoxH;
          draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
      }

      /* move the right part of index of ActiveAlign */
      yo = get_yo() + 2*BoxH;
      startcol = index - Info.dispStartIndex;
      endcol = fix_index - Info.dispStartIndex;
      if(endcol >= PerLine)    endcol = PerLine-1;
      charNum = endcol - startcol;
      if(charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1){
          printf("charNum=%d at 4 Right\n",charNum);
          charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;
      }
      xo = LeftMargin+startcol*BoxW;
      for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
          if(align==ActiveAlign) continue;
          
          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    xo,yo, charNum*BoxW, BoxH,
                    xo+BoxW, yo);

          /* draw inserted char */
          draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
      }
/****** END OF MODIFY ********/
      disp_activ();
   }
   else if(dir==LEFT) { 
      get_absorb_fixed_column(dir,Info.dataStartIndex,&type,&fix_index);

      Info.dataStartIndex--;
      for(align=0; align<Info.alignnum; ++align) {
         if(align == ActiveAlign) {  /* myself */
            /* copy the left of the first fixed(or absorb) column */
            for(i=Info.dataStartIndex; i<fix_index; ++i)  {
               Info.codeAlign[align][i] = Info.codeAlign[align][i+1];
               /* Copy atribute column also. */
               Info.columnAtrib[i] = Info.columnAtrib[i+1];
            }
            /* insert the gap at the place the first fixed(or absorb) column
             * was exist before.
             */
             Info.codeAlign[align][fix_index] = GAP_INNER_CODE;
             Info.columnAtrib[fix_index] = 0;
         }
         else {
            for(i=Info.dataStartIndex; i<index; ++i)  {
                Info.codeAlign[align][i] = Info.codeAlign[align][i+1];
            }
            Info.codeAlign[align][index] = GAP_INNER_CODE;
         }
      }
/****** START OF MODIFY ********/
      disp_scroll_mark();
      disp_bar();
      if(CalcColumnCost) 
          disp_cost_graph(Info.dispStartIndex,PerLine);

      display_ident(Info.dispStartIndex,PerLine);

      /* move the leftt part of fixed column */    
      yo = get_yo() + 2*BoxH;
      startcol = fix_index - Info.dispStartIndex;
      if(startcol >= 0)  {
          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    LeftMargin+BoxW,yo, startcol*BoxW, BoxH*Info.alignnum,
                    LeftMargin, yo);

          /* draw gap char of ActiveAlign */
          yo = get_yo() + (ActiveAlign+2)*BoxH;
          xo = LeftMargin + startcol*BoxW;
          draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
      }

      /* move the left part of index of ActiveAlign */
      yo = get_yo() + 2*BoxH;
      startcol = fix_index - Info.dispStartIndex;
      endcol = index - Info.dispStartIndex;
      if(startcol<0)  {
         startcol=0;
      }
      charNum = endcol - startcol;
      for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
          if(align==ActiveAlign)  continue;
          xo = LeftMargin + (startcol+1)*BoxW;

          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    xo,yo, charNum*BoxW, BoxH,
                    xo-BoxW, yo);

          /* draw inserted char */
          xo = LeftMargin + endcol*BoxW;
          draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
      }

/****** END OF MODIFY ********/
      disp_activ();
   }
}   


/* Used for both alignment editor and normal text. */
/* insert ch at ActiveIndex(Global variable) */
insertChar(dir,ch)
int  dir; /* inser direction, LEFT or RIGHT(same as normal text editor) */
int  ch;
{
  int  align,code, i, type, fix_index;
  int  charNum, startcol, endcol, xo, yo;
  Bool over_shift = False;

  if(ch==GAP_INNER_CODE)    code = ch;
  else if(ch==' ')          code = GAP_INNER_CODE;
  else if(ch=='-')          code = GAP_INNER_CODE;
  else if(isupper(ch))      code = ch - 'A';
  else if(islower(ch))      code = ch - 'a';
  else                      code = OTHER_INNER_CODE;

  /* Don't allow this case because this means insert all gap column.
   * (nonsense)
   */
  if(code==GAP_INNER_CODE && ((Info.columnAtrib[ActiveIndex] == FIXED_COLUMN) || Region_divide[ActiveIndex]))  
    return 0;

  if(dir==RIGHT) {
      get_absorb_fixed_column(dir,Info.dataEndIndex,&type,&fix_index);
/*      printf("type=%d,fix_index=%d\n",type,fix_index); */

      if (Info.codeAlign[ActiveAlign][fix_index-1]==GAP_INNER_CODE){
           over_shift = True;
           for (i=fix_index-1; i>ActiveIndex; i--){
               Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i-1];	       
	   }
          if (Region_divide[fix_index]) edit_const(ActiveAlign, ActiveIndex, Info.dataEndIndex, True, -1);
      }else{
          Info.dataEndIndex++;

          for(i=Info.dataEndIndex; i>ActiveIndex; --i)  {
             Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i-1];
             /* Copy atribute column also. */
             Info.columnAtrib[i] = Info.columnAtrib[i-1];
          }

          Info.columnAtrib[ActiveIndex] = 0;
          if (Region_divide[fix_index]){
	      edit_const(ActiveAlign, ActiveIndex, Info.dataEndIndex, False, 1);
              edit_region(301, ActiveIndex,1, RIGHT);
	  }

          /* Insert a gap at the absorb column(or fixed column)
           * of the other alignments.
           */
          for(align=0; align<Info.alignnum; ++align) {
             if(align != ActiveIndex) {  /* other alignment */
                /* copy the right of the first fixed(or absorb) column */
                for(i=Info.dataEndIndex; i>fix_index; --i)  {
                   Info.codeAlign[align][i] = Info.codeAlign[align][i-1];
                }

                /* insert the gap at the place the first fixed(or absorb) column
                 * was exist before.
                 */
                Info.codeAlign[align][fix_index] = GAP_INNER_CODE;
             }
          }
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = code;

/****** START OF MODIFY ********/
      disp_bar();
      if(CalcColumnCost) 
          disp_cost_graph(ActiveIndex,PerLine);

      display_ident(ActiveIndex,PerLine);

  if (!over_shift){
      /* move the right part of fixed column */    
      yo = get_yo() + 2*BoxH;
      startcol = fix_index - Info.dispStartIndex;
      endcol = PerLine-1;
      if(startcol < PerLine)  {
          disp_scale(False,fix_index,PerLine-startcol);
          disp_scroll_mark();

          xo = LeftMargin+startcol*BoxW;
          charNum = endcol-startcol;
          if(charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) {
/*              printf("charNum=%d at 1 Right\n",charNum); */
              charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;
          }

          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    xo,yo, charNum*BoxW, BoxH*Info.alignnum,
                    xo+BoxW, yo);

          /* draw gap char */
          yo = get_yo() + 2*BoxH;
          for(align=0; align<Info.alignnum; ++align, yo += BoxH) {

          draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
          }
          disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
      }
  }

      /* move the right part of ActiveIndex of ActiveAlign */
      startcol = ActiveIndex - Info.dispStartIndex;
      endcol = fix_index - Info.dispStartIndex;
      if(endcol >= PerLine)
         endcol = PerLine-1;
      charNum = endcol - startcol;
      if(charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1){
          fprintf(stderr, "charNum=%d at 4 Right\n",charNum);
          charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;
      }
      if (over_shift) charNum--;
      yo = get_yo() + (ActiveAlign+2)*BoxH;
      xo = LeftMargin+startcol*BoxW;

      XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                xo,yo, charNum*BoxW, BoxH,
                xo+BoxW, yo);

      /* draw inserted char */
      draw_string(True, xo, yo, code, AminoCharGC[code]);
/****** END OF MODIFY ********/
      if (EditMode == INSERT || EditMode == OVER_WRITE){
          disp_activ();
          disp_align_one(ActiveAlign, ActiveIndex+1, 1);
      }
      return 1;     /* return 1 when modified */
  }
/**************************** LEFT DIRECTION ******************************/
  else if(dir==LEFT) {
      if(Info.dataEndIndex+1 == ActiveIndex) return 0; /* cursot at end of string */

      get_absorb_fixed_column(dir,Info.dataStartIndex,&type,&fix_index);
                                            
      if (Info.codeAlign[ActiveAlign][fix_index+1]==GAP_INNER_CODE){
           over_shift = True;
           for (i=fix_index+1; i<ActiveIndex; i++){
               Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i+1];	       
	   }
          if (Region_divide[fix_index]) edit_const(ActiveAlign, Info.dataStartIndex, ActiveIndex, True, 1);
      }else{
          Info.dataStartIndex--;
          for(i=Info.dataStartIndex; i<ActiveIndex; ++i)  {
             Info.codeAlign[ActiveAlign][i] = Info.codeAlign[ActiveAlign][i+1];
             /* Copy atribute column also. */
             Info.columnAtrib[i] = Info.columnAtrib[i+1];
          }
          Info.columnAtrib[ActiveIndex] = 0;
          if (Region_divide[fix_index]){
	      edit_const(ActiveAlign, Info.dataStartIndex, ActiveIndex, False, -1);
              edit_region(301, ActiveIndex, -1, LEFT);
	  }

          for(align=0; align<Info.alignnum; ++align) {
             if(align != ActiveAlign)  {
                /* copy the left of the first fixed(or absorb) column */
                for(i=Info.dataStartIndex; i<fix_index; ++i)  {
                   Info.codeAlign[align][i] = Info.codeAlign[align][i+1];
                }

                /* insert the gap at the place the first fixed(or absorb) column
                 * was exist before.
                 */
                Info.codeAlign[align][fix_index] = GAP_INNER_CODE;
             }
          }
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = code;


/****** START OF MODIFY ********/
      disp_scroll_mark();
      disp_bar();
      if(CalcColumnCost) 
          disp_cost_graph(Info.dispStartIndex,PerLine);

      display_ident(Info.dispStartIndex,PerLine);

  if (!over_shift){
      /* move the leftt part of fixed column */    
      yo = get_yo() + 2*BoxH;
      startcol = fix_index - Info.dispStartIndex;
      if(startcol >= 0)  {
          XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                    LeftMargin+BoxW,yo, startcol*BoxW, BoxH*Info.alignnum,
                    LeftMargin, yo);

          /* draw gap char */
          yo = get_yo() + 2*BoxH;
          xo = LeftMargin + startcol*BoxW;
          for(align=0; align<Info.alignnum; ++align, yo += BoxH) {

              draw_string(True, xo, yo, GAP_INNER_CODE, AminoCharGC[GAP_INNER_CODE]);
          }
      }
      disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
  }
 
      /* move the left part of ActiveIndex of ActiveAlign */

      startcol = fix_index - Info.dispStartIndex;
      endcol = ActiveIndex - Info.dispStartIndex;
      if(startcol<0)  {
         startcol=0;
      }
      charNum = endcol - startcol;

      yo = get_yo() + (ActiveAlign+2)*BoxH;
      xo = LeftMargin + (startcol+1)*BoxW;
      
      if(charNum >= PerLine - startcol) {
          fprintf(stderr, "charNum=%d at 1\n",charNum);
          charNum = PerLine - startcol -1;	
      }
         
      if(charNum > Info.dataEndIndex - Info.dispStartIndex - startcol+1) {
          fprintf(stderr, "charNum=%d at 2\n",charNum);
          charNum = Info.dataEndIndex - Info.dispStartIndex - startcol +1;
      }
      if (over_shift) xo += BoxW;

      XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
                xo,yo, charNum*BoxW, BoxH,
                xo-BoxW, yo);

      /* draw inserted char */
      xo = LeftMargin+endcol*BoxW;
      draw_string(True, xo, yo, code, AminoCharGC[code]);

/****** END OF MODIFY ********/
      disp_scale(True,Info.dispStartIndex,PerLine);
      if (EditMode == INSERT || EditMode == OVER_WRITE){
          disp_activ();
          disp_align_one(ActiveAlign, ActiveIndex-1, 1);
      }

      return 1;     /* return 1 when modified */
   }
}
