/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   cmd2.c  
**
**   commands which chage alignment itself.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <math.h>
#include  "aedit.h"

#if	0
#define	DEBUG
#endif

typedef struct{
    int start[DELETE_STEP];
    int end[DELETE_STEP];
    int num;
    int sum;
} Align_gap;

initInfo()
{
   int  i, align;

   Info.empty = True;
   Info.dataStartIndex = INITIAL_DATA_START_INDEX;
   Info.dispStartIndex = INITIAL_DATA_START_INDEX;
   Info.dataEndIndex = Info.dataStartIndex - 1;
   Info.cost = 0;
   Calc_cost = 0;

   for(i=0; i<MAX_ALIGN_LENG; ++i) {
      Info.columnCost[i]=0;
      Calc_columnCost[i]=0;
      Info.columnAtrib[i]=0;
   }
}


/* return True if modified*/
pasteChar(leng,str)
int   leng;
char  *str;
{
}


void swap_int(a,b)
int *a, *b;
{
    int bak;

    bak = *a;
    *a = *b;
    *b = bak;
}


void get_gap(gap)
Bool *gap;
{
    int align;

    for (align=0; align<Info.alignnum; align++){
        if (Info.codeAlign[align][ActiveIndex] == GAP_INNER_CODE){
	    *gap = True;
	}else{
	    *gap = False;
	}
	gap++;
    }
}


void move_data(start_align, end_align, start_index, end_index, movement)
int start_align, end_align, start_index, end_index, movement;
{
    int align, i;

    if (start_index > end_index) swap_int(&start_index, &end_index);

    for (align=start_align; align<=end_align; align++){
        if (movement > 0){
	    for (i=end_index; i>=start_index; i--) Info.codeAlign[align][i+movement] = Info.codeAlign[align][i];
	}
        if (movement < 0){
	    for (i=start_index; i<=end_index; i++) Info.codeAlign[align][i+movement] = Info.codeAlign[align][i];
	}
        edit_const(align, start_index, end_index, True, movement);
    }
}


void edit_scale_etc(start_index, end_index, movement, dir)
int start_index, end_index, movement, dir;
{
    int i, deff, mod;

    edit_region(start_index, end_index, movement, dir);

    deff = mod = dir;
    if (movement*dir>0) deff *= -1;
    if (movement*dir<0) mod *= -1;
    for (i=end_index; i*mod>=start_index*mod; i+=deff) Info.columnAtrib[i+movement] = Info.columnAtrib[i];
}   


void partial_disp_graph_and_ident(dir, index)
int dir, index;
{
    int start, leng;

    if (dir==RIGHT){
        start = index; leng = Info.dispStartIndex+PerLine-index;
    }else{
        start = Info.dispStartIndex; leng = index-Info.dispStartIndex+1;
    }
    disp_cost_graph(start, leng);
    display_ident(start, leng);
}


void shift_fixedcolumn_right(dir, add, index, fix_index)
int dir, add, index, fix_index;
{
    int i;

    for (i=fix_index; i<Info.dispStartIndex+PerLine+dir*add; i++){
        if (Info.columnAtrib[i] == FIXED_COLUMN){
            disp_scale(False, i, 1);
            disp_scale(False, i-dir*add, 1);
	}
    }
    disp_scroll_mark();
}


void process_insert(start_align, end_align, index, add, dir)
int start_align, end_align, index, add, dir;
{
    int dummy, fix_index, align, end_index, i;
    int *edge_index;
    int mode = 1;  /* 1:slide of one alignment  2:slide + move all alignment  3:move all alignment */

    /* mode decision */
    if (dir == RIGHT) edge_index = &Info.dataEndIndex;
    if (dir == LEFT) edge_index = &Info.dataStartIndex;
    get_absorb_fixed_column(dir, *edge_index, &dummy, &fix_index);
    if ((start_align==0 && end_align==Info.alignnum-1) || 
           ((Info.columnAtrib[index] & FIXED_COLUMN) || Region_divide[index])){
        mode = 3;
    }else{
        for (align=start_align; align<=end_align; align++){
	    if (((int)fabs((double)(fix_index-index)))<add*2) mode = 2;
	    for (i=1; i<=add; i++){
                if (Info.codeAlign[align][fix_index-i*dir] != GAP_INNER_CODE) mode = 2;
            }
        }
    }
    /*fprintf(stderr, "insert mode:%d\n", mode);*/

    /* move data and draw */
    switch (mode){
        case 1:
            /* modify data */
            undisp_edited_motif(start_align, end_align, index, fix_index-dir*(add+1));
            move_data(start_align, end_align, index, fix_index-dir*(add+1), add*dir);
            for (align=start_align; align<=end_align; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
	            Info.codeAlign[align][i] = GAP_INNER_CODE;
		}
	    }
	    /* draw */
            disp_by_XCopyArea(start_align, end_align, index, fix_index-dir*(add+1), add*dir);
            disp_edited_motif(start_align, end_align, index, fix_index-dir);
            for (align=start_align; align<=end_align; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
                    disp_align_one(align, i, 1);
		}
	    }
            break;
        case 2:
            /* modify data */
	    *edge_index += dir*add;
            move_data(0, Info.alignnum-1, fix_index, *edge_index-dir*add, add*dir);
            for (align=0; align<Info.alignnum; align++){ 
	        for (i=fix_index; i*dir<(fix_index+add*dir)*dir; i+=dir){
	            Info.codeAlign[align][i] = GAP_INNER_CODE;
		}
	    }
            edit_scale_etc(fix_index, *edge_index-dir*add, add*dir, dir);
	    for (i=fix_index; i*dir<(fix_index+add*dir)*dir; i+=dir) Info.columnAtrib[i] = 0;
            undisp_edited_motif(start_align, end_align, index, fix_index-dir);
            move_data(start_align, end_align, index, fix_index-dir, add*dir);
            for (align=start_align; align<=end_align; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
	            Info.codeAlign[align][i] = GAP_INNER_CODE;

		}
	    }
	    /* draw */	    
            disp_by_XCopyArea(0, Info.alignnum, fix_index, *edge_index-dir*add, add*dir);
            for (align=0; align<Info.alignnum; align++){ 
	        for (i=fix_index; i*dir<(fix_index+add*dir)*dir; i+=dir){
                    disp_align_one(align, i, 1);
		}
	    }
            disp_by_XCopyArea(start_align, end_align, index, fix_index-dir, add*dir);
            disp_edited_motif(start_align, end_align, index, fix_index+dir*(add-1));
            for (align=start_align; align<=end_align; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
                    disp_align_one(align, i, 1);
		}
	    }
	    if (EditMode == CONSTRAINT){
	        if (dir==RIGHT){
	            disp_region_data(index, Info.dispStartIndex+PerLine-1);
		}else{
	            disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
		}
	    }else{
	        if (dir==RIGHT){
		    shift_fixedcolumn_right(dir, add, index, fix_index);
		}else{
  	            disp_scale(True, Info.dispStartIndex, PerLine);		      
		}
	    }
            break;
        case 3:
            /* modify data */
	    *edge_index += dir*add;
            move_data(0, Info.alignnum-1, index, *edge_index-dir*add, add*dir);
            for (align=0; align<Info.alignnum; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
	            Info.codeAlign[align][i] = GAP_INNER_CODE;
		}
	    }
            edit_scale_etc(index, *edge_index-dir*add, add*dir, dir);
	    for (i=index; i*dir<(index+add*dir)*dir; i+=dir) Info.columnAtrib[i] = 0;
	    /* draw */	    
            disp_by_XCopyArea(0, Info.alignnum, index, *edge_index-dir*add, add*dir);
            for (align=0; align<Info.alignnum; align++){ 
	        for (i=index; i*dir<(index+add*dir)*dir; i+=dir){
                    disp_align_one(align, i, 1);
		}
	    }
	    if (EditMode == CONSTRAINT){
	        if (dir==RIGHT){
	            disp_region_data(index, Info.dispStartIndex+PerLine-1);
		}else{
	            disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
		}
	    }else{
	        if (dir==RIGHT){
		    shift_fixedcolumn_right(dir, add, index, fix_index);
		}else{
  	            disp_scale(True, Info.dispStartIndex, PerLine);		      
		}
	    }
            break;
	default:
	    break;
    }

    if (dir == LEFT){
        disp_scroll_mark();
	for (align=0; align<Info.alignnum; align++) disp_align_one(align, Info.dispStartIndex, 1);
    }
    disp_bar();
    if (CalcColumnCost){
        disp_cost(True);
        partial_disp_graph_and_ident(dir, index);
    }
}


void process_delete_slide(index, add, dir, edge_index)
int index, add, dir;
int *edge_index;
{
    int align;

#ifdef	DEBUG
    (void)printf("process_delete_slide --- index, add, dir, *edge_index = %d %d %d %d\n",
		 index, add, dir, *edge_index);
#endif

#if	1
    if (dir==LEFT && Info.dataStartIndex==Info.dispStartIndex) return;
#endif
    if ((index-dir*add)*dir > (*edge_index)*dir){
        for (align=0; align<Info.alignnum; align++){
                disp_align_one(align, *edge_index+add*dir, -add);
        }
        *edge_index += dir*add;
	return;
    }

    move_data(0, Info.alignnum-1, index-dir*add, *edge_index, add*dir);
    edit_scale_etc(*edge_index, index-dir*add, add*dir, dir);
    *edge_index += dir*add;

    disp_by_XCopyArea(0, Info.alignnum, index-add*dir,
                      Info.dispStartIndex+(PerLine-1)*((dir+1)/2), add*dir);
    for (align=0; align<Info.alignnum; align++){
            disp_align_one(align, Info.dispStartIndex+(PerLine+dir*add)*((dir+1)/2), -add);
    }
    if (EditMode == CONSTRAINT){
        if (dir==RIGHT){
            disp_region_data(index, Info.dispStartIndex+PerLine-1);
	}else{
            disp_region_data(Info.dispStartIndex, Info.dispStartIndex+PerLine-1);
	}
    }else{
        if (dir==RIGHT){
	    shift_fixedcolumn_right(dir, add, index, index);
	}else{
            disp_scale(True, Info.dispStartIndex, PerLine);		      
	}
    }
}


void get_align_gap(align, index, add, dir, align_gap)
int align, index, add, dir;
Align_gap *align_gap;
{
    int i;
    Bool flag = False;

    align_gap->num = 0; align_gap->sum = 0;
    for (i=index; i*dir<(index-add*dir)*dir; i+=dir){
        if (Info.codeAlign[align][i]==GAP_INNER_CODE){
	    if (!flag){
	        flag = True;
		align_gap->start[align_gap->num] = i;
	    }
	}else{
	    if (flag){
	        flag = False;
		align_gap->end[align_gap->num] = i-dir;
		align_gap->num++;
	    }
	}
    }
    if (flag){
        align_gap->end[align_gap->num] = i-dir;
	align_gap->num++;
    }
    
    for (i=0; i<align_gap->num; i++){
        align_gap->sum += ((int)fabs((double)align_gap->end[i]-(double)align_gap->start[i])+1);
    }

#ifdef	DEBUG
    (void)printf("get_align_gap --- align:%d\n", align);
    printf("get_align_gap --- num:%d sum:%d\n", align_gap->num, align_gap->sum);
    for (i=0; i < align_gap->num; i++)
        (void)printf("get_align_gap --- start%d:%d end%d:%d\n",
		     i, align_gap->start[i], i, align_gap->end[i]);
#endif
}


void process_delete_partial(start_align, end_align, index, add, dir, fix_index, edge_index)
int start_align, end_align, index, add, dir, fix_index;
int *edge_index;
{
    int i, align, slide_wid = 0, edge, max_sum = 0, ngflag;
    Bool slide_flag = True, wid_flag = True;
    Align_gap align_gap[MAX_ALIGN];

#ifdef	DEBUG
    (void)printf("process_delete_partial --- start_align, end_align, fix_index = %d %d %d\n",
		 start_align, end_align, fix_index);
    (void)printf("                           index, add, dir, *edge_index = %d %d %d %d\n",
		 index, add, dir, *edge_index);
#endif

    edge = Info.dispStartIndex+(PerLine-1)*((dir+1)/2);
    if (fix_index<edge && dir==RIGHT) edge = fix_index;
    if (fix_index>edge && dir==LEFT) edge = fix_index;
    /* distinguish slide or not */
    for (align=0; align<Info.alignnum; align++){
        if (align<start_align || align>end_align){
	    if (Info.codeAlign[align][fix_index-dir]!=GAP_INNER_CODE){
	        slide_flag = False;
#ifdef	DEBUG
		(void)printf("process_delete_partial --- pass 1\n");
#endif
	    }
	}else{
	    get_align_gap(align, index, add, dir, &align_gap[align]);
	    if (align_gap[align].num==0 && Info.codeAlign[align][fix_index-dir]!=GAP_INNER_CODE){
	        slide_flag = False;
#ifdef	DEBUG
		(void)printf("process_delete_partial --- pass 2\n");
#endif
	    }
	}
    }

    for (align=start_align; align<=end_align; align++){
        if (align_gap[align].num==0) continue;
    /* modify data */
        undisp_edited_motif(align, align, index, fix_index-dir);
        for (i=align_gap[align].num-1; i>=0; i--){
            if ((align_gap[align].end[i]+dir)*dir>(fix_index-dir)*dir) continue;
	    move_data(align, align, align_gap[align].end[i]+dir, fix_index-dir,
                      -((int)fabs((double)align_gap[align].end[i]
                      -(double)align_gap[align].start[i])+1)*dir);
	}
        for (i=fix_index-dir; i*dir>=(fix_index-align_gap[align].sum*dir)*dir; i-=dir){
             Info.codeAlign[align][i] = GAP_INNER_CODE;
        }
    /* draw */
        if (dir==LEFT && !(Info.dataStartIndex==Info.dispStartIndex) && 
            fix_index<Info.dispStartIndex){
#ifdef	DEBUG
	    (void)printf("process_delete_partial --- pass A\n");
#endif
            for (i=align_gap[align].num-1; i>=0; i--){
		if (align_gap[align].end[i]+dir < edge)
			continue;
   	        disp_by_XCopyArea(align, align, align_gap[align].end[i]+dir, edge,
                      -((int)fabs((double)align_gap[align].end[i]
                      -(double)align_gap[align].start[i])+1)*dir);
	    }
            disp_edited_motif(align, align, index, edge);
            for (i=edge; i*dir>(edge-align_gap[align].sum*dir)*dir; i-=dir){
                 disp_align_one(align, i, 1);
            }
        }else{
#ifdef	DEBUG
	    (void)printf("process_delete_partial --- pass B\n");
#endif
            for (i=align_gap[align].num-1; i>=0; i--){
   	        disp_by_XCopyArea(align, align, align_gap[align].end[i]+dir, edge, 
                      -((int)fabs((double)align_gap[align].end[i]-(double)align_gap[align].start[i])+1)*dir);
	    }
            disp_edited_motif(align, align, index, fix_index-dir);
            for (i=edge; i*dir>=(edge-align_gap[align].sum*dir)*dir; i-=dir){
                 disp_align_one(align, i, 1);
            }
        }
    }

#if	1
  if (dir == RIGHT) {
#ifdef	DEBUG
    (void)printf("process_delete_partial --- slide_flag = %d\n", slide_flag);
#endif
/* check fixed column or dataEndIndex + 1 */
        for (slide_wid = 0, i = fix_index - dir;
	     i * dir >= (fix_index + add * dir) * dir;
	     i -=dir) {
            for (ngflag = 0, align = 0; align < Info.alignnum; align++){
		if (Info.codeAlign[align][i] != GAP_INNER_CODE) {
		    ngflag = 1;
		    break;
		}
	    }
	    if (ngflag)
		break;
	    slide_wid++;
	}
	if (slide_wid)
	    process_delete_slide(fix_index - slide_wid * dir, -slide_wid, dir, edge_index);
  }
  else {
#if	0
    /* case of slide */
    if (slide_flag){
        for (i=fix_index-dir; i*dir>=(fix_index+add*dir)*dir; i-=dir){
	    wid_flag = True;
            for (align=0; align<Info.alignnum; align++){
	        if ((align<start_align || align>end_align || align_gap[align].sum==0)
		    && Info.codeAlign[align][i]!=GAP_INNER_CODE) wid_flag = False;
	    }
	    if (wid_flag){
	        slide_wid++;
	    }else{
	        break;
	    }
	}
        for (align=start_align; align<=end_align; align++){
            if (max_sum<align_gap[align].sum) max_sum = align_gap[align].sum;
	}
	if (slide_wid>max_sum) slide_wid = max_sum;
	process_delete_slide(fix_index-slide_wid*dir, -slide_wid, dir, edge_index);
    }
#endif
    removeAllGap();
  }
#endif
}


void process_delete(start_align, end_align, index, add, dir)
int start_align, end_align, index, add, dir;
{
    int dummy, fix_index, align, end_index, i, j, step_count = 0;
    int *edge_index;
    int all_wid, partial_wid;
    int all_start[DELETE_STEP], all_end[DELETE_STEP], all_num = 0;
    int partial_start[DELETE_STEP], partial_end[DELETE_STEP], partial_num = 0;
    int del_mode[MAX_ALIGN_LENG];  /* 0:all amino acid  1:part gap  2:all gap */
    Bool all_flag = False, partial_flag = False;
    Bool all_gap, all_amino;

    if (dir == RIGHT) edge_index = &Info.dataEndIndex;
    if (dir == LEFT) edge_index = &Info.dataStartIndex;
    get_absorb_fixed_column(dir, *edge_index, &dummy, &fix_index);

#if	0
    /* set delete step */
    /* case of all alignment */
    if (start_align==0 && end_align==Info.alignnum-1){
        /* division  all or partial */
        for (i=index; i*dir<(index-add*dir)*dir; i+=dir){
	    all_gap = True, all_amino = True;
            for (align=0; align<Info.alignnum; align++){
	        if (Info.codeAlign[align][i]!=GAP_INNER_CODE) all_gap = False;
	        if (Info.codeAlign[align][i]==GAP_INNER_CODE) all_amino = False;
	    }
	    if (all_gap) del_mode[i] = 2;
	    if (all_amino) del_mode[i] = 0;
	    if (!all_gap && !all_amino) del_mode[i] = 1;
	/* set strat, end, num */
	    switch (del_mode[i]){
	        case 0:
	            if (partial_flag){
		        partial_end[partial_num] = i-dir;
		        partial_flag = False;
		        partial_num++;
		    }
	            if (all_flag){
		        all_end[all_num] = i-dir;
   		        all_flag = False;
		        all_num++;
		    }
		    break;
		case 1:
	            if (all_flag){
		        all_end[all_num] = i-dir;
   		        all_flag = False;
		        all_num++;
		    }
		    if (!partial_flag){
		        partial_start[partial_num] = i;
		        partial_flag = True;
		    }
		    break;
		case 2:
	            if (partial_flag){
		        partial_end[partial_num] = i-dir;
		        partial_flag = False;
		        partial_num++;
		    }
		    if (!all_flag){
		        all_start[all_num] = i;
		        all_flag = True;
		    }
		    break;
	    }
	}
	if (all_flag){
	    all_end[all_num] = i-dir;
	    all_num++;
	}
	if (partial_flag){
	    partial_end[partial_num] = i-dir;
	    partial_num++;
	}
#ifdef	DEBUG
        (void)printf("process_delete --- all_num:%d\n", all_num);
        for (i=0; i<all_num; i++){
            (void)printf("process_delete --- start%d:%d end%d:%d\n",
			 i, all_start[i], i, all_end[i]);
        }
        (void)printf("process_delete --- partial_num:%d\n", partial_num);
        for (i=0; i<partial_num; i++){
            (void)printf("process_delete --- start%d:%d end%d:%d\n",
			 i, partial_start[i], i, partial_end[i]);
        }
#endif
        /* process delete */
	for (i=all_num-1; i>=0;  i--){
	    all_wid = (int)fabs((double)all_end[i]-(double)all_start[i]) + 1;
	    process_delete_slide(all_start[i], -all_wid, dir, edge_index);
	    for (j=partial_num-1; j>=0; j--){
	        if (all_start[i]*dir<partial_start[j]*dir){
	            partial_start[j] -= all_wid*dir;
	            partial_end[j] -= all_wid*dir;
	        }
	    }
	}
    	for (i=partial_num-1; i>=0; i--){
	    partial_wid = (int)fabs((double)partial_end[i]-(double)partial_start[i]) + 1;
	    process_delete_partial(0, Info.alignnum-1, partial_start[i], 
				   -partial_wid, dir, fix_index, edge_index);
	}
    }else{
        process_delete_partial(start_align, end_align, 
			       index, add, dir, fix_index, edge_index);
    }
#endif

    process_delete_partial(start_align, end_align, 
			   index, add, dir, fix_index, edge_index);

    disp_bar();
    if (CalcColumnCost){
        disp_cost(True);
        partial_disp_graph_and_ident(dir, index);
    }
}


removeAllGap()
{
  int  index, align,code, i;
  
  /* DW(); */

  for(index = Info.dataStartIndex; index<=Info.dataEndIndex; ++index) {
     for(align=0; align<Info.alignnum; ++align)  {
        code = Info.codeAlign[align][index];
        if(code != GAP_INNER_CODE)  break;
     }
   
     if(align >= Info.alignnum) { /* this column are all gap */
         /* move column atribute */
         for(i=index;  i<=Info.dataEndIndex; ++i){  
            Info.columnAtrib[i] = Info.columnAtrib[i+1];
	    Region_flag[i] = Region_flag[i+1];
	    Region_divide[i] = Region_divide[i+1];
	 }

         /* and move each alignment */
         for(align=0; align<Info.alignnum; ++align)  {
            for(i=index;  i<=Info.dataEndIndex; ++i)  {
               Info.codeAlign[align][i] = Info.codeAlign[align][i+1];
            }
         }
	edit_const(0, index, Info.dataEndIndex, True, -1);
	edit_const(0, index, Info.dataEndIndex, False, -1);
        Info.dataEndIndex--;
        index--;
     }
  }

  /* adjust Active Position */
  if(ActiveIndex > Info.dataEndIndex)
     ActiveIndex = Info.dataEndIndex;

  if(Info.dispStartIndex > Info.dataEndIndex)
     Info.dispStartIndex = Info.dataEndIndex;

  /* case of empty */
  if(Info.dataEndIndex < Info.dataStartIndex) {
     Info.dispStartIndex = INITIAL_DATA_START_INDEX;
     Info.dataStartIndex = INITIAL_DATA_START_INDEX;
     Info.dataEndIndex = Info.dataStartIndex - 1;
     Info.cost = 0;
     Calc_cost = 0;
     Info.empty = True;
     for(align=0; align<Info.alignnum; ++align)  {
        Info.codeAlign[align][Info.dataStartIndex] = -1;
     }
     ActiveIndex = Info.dispStartIndex;
  }

  fprintf(stderr, "dataStartIndex=%d,dispStartIndex=%d,dataEndIndex=%d\n",
          Info.dataStartIndex, Info.dispStartIndex, Info.dataEndIndex);

  ActiveCol = ActiveIndex - Info.dispStartIndex;
  ActiveXo = LeftMargin + BoxW*ActiveCol;

/*  DW(); */
  disp_align_all(CalcColumnCost,True);
}


skipBlockLeft()
{
   int  i, index, code1, code2;

   /* cursor is out of string */
   if(ActiveIndex == Info.dataEndIndex+1)  return 0;

   /* There is no before char */
   if(ActiveIndex == Info.dataStartIndex)  return 0;

   code1 = Info.codeAlign[ActiveAlign][ActiveIndex];

   if(isAmino(code1)) {  /* move amino block */
      /* search amino block */
      for(index=ActiveIndex; index>=Info.dataStartIndex; --index) {
         if(Info.columnAtrib[index] & FIXED_COLUMN) {
             /* We can't move fixed column. */
             return 0;
         }
         code2 = Info.codeAlign[ActiveAlign][index];
         if(!isAmino(code2))  break;
      }

      /* return when no gap exist at the left of amino block */
      if(isAmino(code2))  return 0; 
       
      /* Is the just right column of the block fixed?. */
      if(Info.columnAtrib[index] & FIXED_COLUMN) {
          /* We can't move fixed column. */
          return 0;
      }
 
      /* Now, the whole block is from index+1 to ActiveIndex. 
       * Copy them left.
       */
      for(i=index; i<ActiveIndex; ++i) {
         Info.codeAlign[ActiveAlign][i] = 
                 Info.codeAlign[ActiveAlign][i+1];
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = GAP_INNER_CODE;
   }
   else if(code1==GAP_INNER_CODE) { /* move gap block */
      /* search gap block */
      for(index=ActiveIndex; index>=Info.dataStartIndex; --index) {
         if(Info.columnAtrib[index] & FIXED_COLUMN) {
             /* We can't move fixed column. */
             return 0;
         }
         code2 = Info.codeAlign[ActiveAlign][index];
         if(isAmino(code2))    break;
      }

      /* return when no amino exist at the left of gap block */
      if(!isAmino(code2))  return 0; 
       
      /* Is the just right column of the block fixed?. */
      if(Info.columnAtrib[index] & FIXED_COLUMN) {
          /* We can't move fixed column. */
          return 0;
      }
 
      /* Now, the whole block is from index+1 to ActiveIndex. 
       * Copy them left.
       */
      for(i=index; i<ActiveIndex; ++i) {
         Info.codeAlign[ActiveAlign][i] = 
                 Info.codeAlign[ActiveAlign][i+1];
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = code2;
   }
   else { /* neither amino nor gap */
      return 0;
   }

   disp_align_one(ActiveAlign,Info.dispStartIndex,ActiveCol+1); 
   shiftLeftActiv(1);  /* move active point(cursor) forward */
   return 1;
}



skipBlockRight()
{
   int  i, index, code1, code2;

   if(ActiveIndex == Info.dataEndIndex+1)  return 0;
   if(ActiveIndex == Info.dataEndIndex)    return 0;

   code1 = Info.codeAlign[ActiveAlign][ActiveIndex];

   if(isAmino(code1)) {  /* move amino block */
      /* search amino block */
      for(index=ActiveIndex; index<=Info.dataEndIndex; ++index) {

         if(Info.columnAtrib[index] & FIXED_COLUMN) {
            /* We can't move fixed column. */
            return 0;
         }
         code2 = Info.codeAlign[ActiveAlign][index];
         if(!isAmino(code2))  break;
      }

      /* return when no gap exist at the right of amino block */
      if(isAmino(code2))  return 0; 


      /* Is the just right column of the block fixed?. */
      if(Info.columnAtrib[index] & FIXED_COLUMN) {
          /* We can't move fixed column. */
          return 0;
      }

      /* Now, the whole block is from ActiveIndex to index+1. 
       * Copy them right.
       */
      for(i=index; i>ActiveIndex; --i) {
         Info.codeAlign[ActiveAlign][i] = 
                 Info.codeAlign[ActiveAlign][i-1];
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = GAP_INNER_CODE;
   }
   else if(code1==GAP_INNER_CODE) { /* move gap block */
      /* search gap block */
      for(index=ActiveIndex; index<=Info.dataEndIndex; ++index) {
         if(Info.columnAtrib[index] & FIXED_COLUMN) {
            /* We can't move fixed column. */
            return 0;
         }

         code2 = Info.codeAlign[ActiveAlign][index];
         if(isAmino(code2))   break;
      }

      /* return when no amino exist at the right of gap block */
      if(!isAmino(code2))  return 0; 
        
      /* Is the just right column of the block fixed?. */
      if(Info.columnAtrib[index] & FIXED_COLUMN) {
          /* We can't move fixed column. */
          return 0;
      }

      /* Now, the whole block is from ActiveIndex to index+1. 
       * Copy them right.
       */
      for(i=index; i>ActiveIndex; --i) {
         Info.codeAlign[ActiveAlign][i] = 
                 Info.codeAlign[ActiveAlign][i-1];
      }
      Info.codeAlign[ActiveAlign][ActiveIndex] = code2;
   }
   else { /* neither amino nor gap */
      return 0;
   }
   disp_align_one(ActiveAlign,ActiveIndex,PerLine-ActiveCol+1); 
   shiftRightActiv(1);    /* move active point(cursor) forward */
   return 1;
}



int get_absorb_fixed_column(dir,endindex,type,index)
int        dir;    /* IN:  search direction, LEFT or RIGHT */
int        endindex; /*IN: search until here */
int        *type;  /* OUT: 0 or FIXED_COLUMN or ABSORB_COLUMN */
int        *index; /* OUT: index of first found index */
{
  int  i;

  *type = 0;
  if(dir==RIGHT) {
     for(i=ActiveIndex;  i <= endindex;  ++i) {
        if(((EditMode==NORMAL || EditMode==INSERT || EditMode==OVER_WRITE) && 
           (Info.columnAtrib[i] & FIXED_COLUMN)) || 
           ((EditMode==CONSTRAINT) && Region_divide[i])) {
           *type = FIXED_COLUMN;
           *index = i;
           return;
        }
        /*else if(EditMode!=VIEW && Info.columnAtrib[i] & ABSORB_COLUMN) {
           *type = ABSORB_COLUMN;
           *index = i;
           return;
        }
        else if(EditMode!=VIEW && Info.columnAtrib[i] != 0) {
           fprintf(stderr, 
            "logic error: illegal column attribute found in get_absorb_fixed_column()\n");
           fprintf(stderr, "index==%d, column value = %d\n",i,Info.columnAtrib[i]);
           exit(1);
        }*/
     }
     *index = i;    /* case of not found */
  }
  else if(dir==LEFT) {
     for(i=ActiveIndex;  i>=endindex;  --i) {
        if(((EditMode==NORMAL || EditMode==INSERT || EditMode==OVER_WRITE) && 
           (Info.columnAtrib[i] & FIXED_COLUMN)) || 
           ((EditMode==CONSTRAINT) && Region_divide[i])) {
           *type = FIXED_COLUMN;
           *index = i;
           return;
        }
        /*else if(EditMode!=VIEW && Info.columnAtrib[i] & ABSORB_COLUMN) {
           *type = ABSORB_COLUMN;
           *index = i;
           return;
        }
        else if(EditMode!=VIEW && Info.columnAtrib[i] != 0) {
           fprintf(stderr, 
            "logic error: illegal column attribute found in get_absorb_fixed_column()\n");
           fprintf(stderr, "index==%d, column value = %d\n",i,Info.columnAtrib[i]);
           exit(1);
        }*/
     }
     *index = i;    /* case of not found */
  }
}


