/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   cmd1.c  
**
**   commands which never chage alignment itself.
**   just move cursor(active point) or screen page.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  "aedit.h"

#define AMINO 1
#define GAP   2

/* move active point to next(previous) amino block */
jumpBlockActiv(dir)
int  dir;
{
  int  i, cc, code, current, flag=0, found=False, move,
       oldActiveIndex, oldActiveXo, oldActiveCol;

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  if(dir==RIGHT)  {  /* forward direction */
     if(ActiveIndex == Info.dataEndIndex+1) return;  /* cursor is out of string */
     if(ActiveIndex == Info.dataEndIndex)   return;  /* there is no right char */

     code = Info.codeAlign[ActiveAlign][ActiveIndex];
     if(code == GAP_INNER_CODE)  {  /* if gap, we start to search from ActiveIndex */
        cc=0;
        current=GAP;
     }
     else {  /* if amino, we start to search from (ActiveIndex+1) */
        cc=1;
        code = Info.codeAlign[ActiveAlign][ActiveIndex+1];
        if(code == GAP_INNER_CODE)    current=GAP;
        else                          current=AMINO;
     }

     found=False;
     for(i=ActiveIndex+cc; i<Info.dataEndIndex+1; ++i) {
        code = Info.codeAlign[ActiveAlign][i];
        if(code == GAP_INNER_CODE && current==AMINO)  {
           found=True;   break;
        }
        else if(isAmino(code) && current==GAP)  {
           found=True;   break;
        }
     }

     /* found or we are now in the rightest amino block */
     if(found==True  ||  (found==False  && current==AMINO)) {
        if(current==GAP)  ActiveIndex = i;
        else              ActiveIndex = i-1;
        ActiveCol = ActiveIndex - Info.dispStartIndex;
        ActiveXo = LeftMargin + BoxW*ActiveCol;
     }

     if(ActiveCol>=PerLine) { /* We must go to the next page */
        Info.dispStartIndex += (ActiveCol/PerLine)*PerLine;
        if(Info.dispStartIndex > Info.dataEndIndex)
           Info.dispStartIndex = Info.dataEndIndex;
        ActiveCol = ActiveIndex - Info.dispStartIndex;
        ActiveXo = LeftMargin + ActiveCol*BoxW;
        flag = 1;
     }
  }
  else if(dir==LEFT)  {  /* backward direction */
     if(ActiveIndex == Info.dataStartIndex)  return;  /* there is no left char */

     if(ActiveIndex == Info.dataEndIndex+1)  /* just move end of string */
        shiftLeftActiv(1);

     code = Info.codeAlign[ActiveAlign][ActiveIndex];
     if(code == GAP_INNER_CODE)  {  /* if gap, we start to search from ActiveIndex */
        cc=0;
        current=GAP;
     }
     else {  /* if amino, we start to search from (ActiveIndex-1) */
        cc=1;
        code = Info.codeAlign[ActiveAlign][ActiveIndex-1];
        if(code == GAP_INNER_CODE)    current=GAP;
        else                          current=AMINO;
     }

     found=False;
     for(i=ActiveIndex-cc; i>=Info.dataStartIndex; --i) {
        code = Info.codeAlign[ActiveAlign][i];
        if(code == GAP_INNER_CODE && current==AMINO)  {
           found=True;   break;
        }
        else if(isAmino(code) && current==GAP)  {
           found=True;   break;
        }
     }

     /* found or we are now in the leftest amino block */
     if(found==True  ||  (found==False  && current==AMINO)) {
        if(current==GAP)  ActiveIndex = i;
        else              ActiveIndex = i+1;
        ActiveCol = ActiveIndex - Info.dispStartIndex;
        ActiveXo = LeftMargin + BoxW*ActiveCol;
     }

     if(ActiveCol<0) { /* We must go to the previous page */
        Info.dispStartIndex -= (-ActiveCol/PerLine + 1)*PerLine;
        if(Info.dispStartIndex < Info.dataStartIndex)
           Info.dispStartIndex = Info.dataStartIndex;
        ActiveCol = ActiveIndex - Info.dispStartIndex;
        ActiveXo = LeftMargin + ActiveCol*BoxW;
        flag = 1;
     }
  }

  if(flag)  disp_align_all(CalcColumnCost,False);
  else
     updateActivPoint(ActiveAlign,oldActiveIndex,
                      oldActiveXo,ActiveYo, oldActiveCol,
                      ActiveAlign,ActiveIndex,
                      ActiveXo,ActiveYo, ActiveCol);
}
		


shiftRightActiv(count)
int  count;
{
  int  i, flag, oldActiveIndex, oldActiveXo, oldActiveCol;

  if(ActiveIndex == Info.dataEndIndex+1)  return;  /* not exist right */

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  flag = 0;   /* set 1 if we need redraw */
  for(i=0; i<count; ++i)  {
      if(ActiveIndex == Info.dataEndIndex+1)   break;  /* not exist right */

      if(ActiveCol+1 < PerLine) {
          ++ActiveCol;
          ++ActiveIndex;
          ActiveXo += BoxW;
      }
      else {  /* scroll to next page */
         Info.dispStartIndex += PerLine;
         ActiveCol=0;
         ++ActiveIndex;
         ActiveXo = LeftMargin;
         flag = 1;
      }
  }

  if(flag)  disp_align_all(CalcColumnCost,False);
  else
     updateActivPoint(ActiveAlign,oldActiveIndex,
                      oldActiveXo,ActiveYo, oldActiveCol,
                      ActiveAlign,ActiveIndex,
                      ActiveXo,ActiveYo, ActiveCol);
}


shiftLeftActiv(count)
int  count;
{
  int i, flag, move, oldActiveIndex, oldActiveXo, o, oldActiveCol;

  if(ActiveIndex == Info.dataStartIndex)  return;  /* not exist left */

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  flag = 0;
  for(i=0; i<count; ++i) {
     if(ActiveIndex == Info.dataStartIndex)  break;    /* not exist left */

     if(ActiveCol-1 >= 0) {
        --ActiveCol;
        --ActiveIndex;
        ActiveXo -= BoxW;
     }
     else {  
        if(Info.dispStartIndex-Info.dataStartIndex >= PerLine)  move=PerLine;
        else     move = Info.dispStartIndex-Info.dataStartIndex;

        Info.dispStartIndex -= move;
        ActiveCol = move-1;
        --ActiveIndex;
        ActiveXo = LeftMargin + ActiveCol*BoxW;
        flag = 1;
     }
  }

  if(flag)  disp_align_all(CalcColumnCost,False);
  else
     updateActivPoint(ActiveAlign,oldActiveIndex,
                      oldActiveXo,ActiveYo, oldActiveCol,
                      ActiveAlign,ActiveIndex,
                      ActiveXo,ActiveYo, ActiveCol);
}



shiftUpActiv()
{
  int oldActiveAlign, oldActiveXo, oldActiveYo, 
      oldActiveCol, oldActiveIndex;

  if(ActiveAlign <= 0 )  return;  /* not exist up */

  oldActiveAlign = ActiveAlign;
  oldActiveXo = ActiveXo;
  oldActiveYo = ActiveYo;
  oldActiveCol = ActiveCol;
  oldActiveIndex = ActiveIndex;

  --ActiveAlign;
  ActiveYo -= BoxH;

  updateActivPoint(oldActiveAlign,oldActiveIndex,
                   oldActiveXo,oldActiveYo, oldActiveCol,
                   ActiveAlign,ActiveIndex,
                   ActiveXo,ActiveYo, ActiveCol);
}


shiftDownActiv()
{
  int oldActiveAlign, oldActiveXo, oldActiveYo, 
      oldActiveCol, oldActiveIndex;

  if(ActiveAlign == Info.alignnum-1)  return;
                                              /* not exist down */
  oldActiveAlign = ActiveAlign;
  oldActiveXo = ActiveXo;
  oldActiveYo = ActiveYo;
  oldActiveCol = ActiveCol;
  oldActiveIndex = ActiveIndex;

  ++ActiveAlign;
  ActiveYo += BoxH;
  updateActivPoint(oldActiveAlign,oldActiveIndex,
                   oldActiveXo,oldActiveYo, oldActiveCol,
                   ActiveAlign,ActiveIndex,
                   ActiveXo,ActiveYo, ActiveCol);
}


/* Move the active position most left in the same page*/
activLeftEdge()
{
  int oldActiveIndex, oldActiveXo, oldActiveCol;

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  ActiveCol=0;
  ActiveIndex = Info.dispStartIndex;
  ActiveXo = LeftMargin;

  updateActivPoint(ActiveAlign,oldActiveIndex,
                   oldActiveXo,ActiveYo, oldActiveCol,
                   ActiveAlign,ActiveIndex,
                   ActiveXo,ActiveYo, ActiveCol);
}



/* Move the active position at the first character */
activFirst()
{
  int oldActiveIndex, oldActiveXo, oldActiveCol, oldDispStartIndex;

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;
  oldDispStartIndex =  Info.dispStartIndex;

  ActiveCol=0;
  ActiveIndex = Info.dataStartIndex;
  ActiveXo = LeftMargin;
  Info.dispStartIndex = Info.dataStartIndex;

  if(oldDispStartIndex != Info.dispStartIndex) { /* We need redraw */
     disp_align_all(CalcColumnCost,False);
  }
  else
     updateActivPoint(ActiveAlign,oldActiveIndex,
                      oldActiveXo,ActiveYo, oldActiveCol,
                      ActiveAlign,ActiveIndex,
                      ActiveXo,ActiveYo, ActiveCol);
}


/* Move the active position most right in the same page*/
activRightEdge()
{
  int oldActiveIndex, oldActiveXo, oldActiveCol;

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  if(lastPage()) {
     ActiveIndex = Info.dataEndIndex+1;
  }
  else { /* there is next page */
     ActiveIndex = Info.dispStartIndex + PerLine-1;
  }

  ActiveCol = ActiveIndex - Info.dispStartIndex;
  ActiveXo = LeftMargin + ActiveCol*BoxW;

  updateActivPoint(ActiveAlign,oldActiveIndex,
                   oldActiveXo,ActiveYo, oldActiveCol,
                   ActiveAlign,ActiveIndex,
                   ActiveXo,ActiveYo, ActiveCol);
}


/* Move the active position at the last character */
activLast()
{
  int flag, oldActiveIndex, oldActiveXo, oldActiveCol, oldDispStartIndex;

  oldActiveIndex = ActiveIndex;
  oldActiveXo = ActiveXo;
  oldActiveCol = ActiveCol;

  flag=0;
  ActiveIndex = Info.dataEndIndex+1;

  if(lastPage()) {
     ActiveCol = ActiveIndex - Info.dispStartIndex;
  }
  else { /* there is next page */
     ActiveCol = PerLine*2/3;
     Info.dispStartIndex =  ActiveIndex - ActiveCol;
     flag=1;
  }

  ActiveXo = LeftMargin + ActiveCol*BoxW;

  if(flag) {
     disp_align_all(CalcColumnCost,False);
  }
  else
     updateActivPoint(ActiveAlign,oldActiveIndex,
                      oldActiveXo,ActiveYo, oldActiveCol,
                      ActiveAlign,ActiveIndex,
                      ActiveXo,ActiveYo, ActiveCol);
}


scrollColumnLeft(count)
int  count;    /* scroll column (char unit) */
{
  int  i,j, startcol, startIndex, xo, yo, x, align, code;

  if(lastPage())    return;

  if(count>=PerLine)  count = PerLine-1;

  if(Info.dispStartIndex+count >= Info.dataEndIndex) {
     count = Info.dataEndIndex - Info.dispStartIndex;
  }
  Info.dispStartIndex += count;

  ActiveCol = ActiveIndex - Info.dispStartIndex;
  if(ActiveCol <0)  {
     ActiveCol = 0;
     ActiveIndex = ActiveCol + Info.dispStartIndex;
  }
  ActiveXo = LeftMargin + ActiveCol*BoxW;

  /* Copy Area */
  yo = get_yo();
  xo = LeftMargin+count*BoxW;
  XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
            xo,yo, (PerLine-count)*BoxW, BoxH*Info.rowH,
            LeftMargin, yo);
  
  /* Draw count char from startcol column  */
  startcol = PerLine-count;
  startIndex =  startcol+Info.dispStartIndex;

  disp_scale(True,startIndex,count);
  disp_scroll_mark();
  disp_bar();
  display_ident(startIndex,count);


  xo = LeftMargin+startcol*BoxW;
  yo = get_yo() + 2*BoxH;
  for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
     for(i=startIndex, j=0, x=xo; j<count; ++j, ++i, x += BoxW) {
         if(i > Info.dataEndIndex) {
             XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                            x,yo,BoxW,BoxH); 
         }
         else {
             code = Info.codeAlign[align][i];
  
             draw_string(True, x, yo, code, AminoCharGC[code]);
         }
     }
  }
  if(CalcColumnCost)
     disp_cost_graph(Info.dispStartIndex,PerLine);
  disp_one_motif();
}



scrollColumnRight(count)
int  count;    /* scroll column (char unit) */
{
  int  i,j, startcol, startIndex, xo, yo, x, align, code;

  if(firstPage())   return;

  if(count>=PerLine)  count = PerLine-1;

  if(Info.dispStartIndex-count < Info.dataStartIndex)  
     count = Info.dispStartIndex - Info.dataStartIndex;

  Info.dispStartIndex -= count;

  ActiveCol = ActiveIndex - Info.dispStartIndex;
  if(ActiveCol >= PerLine)  {
     ActiveCol = PerLine-1;
     ActiveIndex = ActiveCol + Info.dispStartIndex;
  }
  ActiveXo = LeftMargin + ActiveCol*BoxW;

  /* Copy Area */
  yo = get_yo();
  xo = LeftMargin;
  XCopyArea(TheDisplay,TheWindow,TheWindow,WhiteGC,
            xo,yo, (PerLine-count)*BoxW, BoxH*Info.rowH,
            xo+count*BoxW, yo);
  
  /* Draw count char from 0 column  */
  startcol=0;
  startIndex = Info.dispStartIndex;

  disp_scale(True,startIndex,count);
  disp_scroll_mark();
  disp_bar();
  display_ident(startIndex,count);

  xo = LeftMargin+startcol*BoxW;
  yo = get_yo() + 2*BoxH;

  for(align=0; align<Info.alignnum; ++align, yo += BoxH) {
     for(i=startIndex, j=0, x=xo; j<count; ++j, ++i, x += BoxW) {
         code = Info.codeAlign[align][i];

          draw_string(True, x, yo, code, AminoCharGC[code]);
     }

  }
  if(CalcColumnCost)
     disp_cost_graph(Info.dispStartIndex,PerLine);
  disp_one_motif();
}




adjustPageByMouse(ratio)
int  ratio;   /* 0 to 10000 */
{
  int move, oldDispStartIndex;

/*  printf("ratio=%d\n"); */

  oldDispStartIndex =   Info.dispStartIndex;

  Info.dispStartIndex =  Info.dataStartIndex + 
            (Info.dataEndIndex - Info.dataStartIndex)*ratio/10000;

  if(Info.dispStartIndex < Info.dataStartIndex)  
      Info.dispStartIndex = Info.dataStartIndex;
  if(Info.dispStartIndex > Info.dataEndIndex) 
      Info.dispStartIndex = Info.dataEndIndex - 1;

  ActiveCol += (oldDispStartIndex - Info.dispStartIndex);
  if(ActiveCol <0)  {
     ActiveCol = 0;
  }
  if(ActiveCol >= PerLine)  {
     ActiveCol = PerLine-1;
  }
  ActiveXo = LeftMargin + ActiveCol*BoxW;
  ActiveIndex = ActiveCol + Info.dispStartIndex;
  disp_align_all(CalcColumnCost,False);
  disp_one_motif();
}

  
adjustPage()
{
  int move, oldDispStartIndex;

  oldDispStartIndex =   Info.dispStartIndex;

  move = PerLine/2 - ActiveCol;
  
  Info.dispStartIndex -=  move;
  if(Info.dispStartIndex < Info.dataStartIndex)  
      Info.dispStartIndex = Info.dataStartIndex;
  if(Info.dispStartIndex > Info.dataEndIndex) 
      Info.dispStartIndex = Info.dataEndIndex - PerLine/2;

  ActiveCol += (oldDispStartIndex - Info.dispStartIndex);

  ActiveXo = LeftMargin + ActiveCol*BoxW;
  disp_align_all(CalcColumnCost,False);
}


/* erase old position's cursor and draw new cursor */
updateActivPoint(oldActiveAlign,oldActiveIndex,
                 oldActiveXo,oldActiveYo, oldActiveCol,
                 newActiveAlign,newActiveIndex,
                 newActiveXo,newActiveYo, newActiveCol)
int  oldActiveAlign,oldActiveIndex,
     oldActiveXo,oldActiveYo, oldActiveCol,
     newActiveAlign,newActiveIndex,
     newActiveXo,newActiveYo, newActiveCol;
{
   int code;

   /* old activ point MOTONI MODO SU */
   if(oldActiveIndex == Info.dataEndIndex+1) {  /* cursor out of string */
      XFillRectangle(TheDisplay,TheWindow,DrawBackGC,
                     oldActiveXo,oldActiveYo,BoxW,BoxH);
   }
   else {
      code = Info.codeAlign[oldActiveAlign][oldActiveIndex]; 


       draw_string(True, oldActiveXo, oldActiveYo, code, AminoCharGC[code]);
   }

   /* new(current) activ point WO Draw */
   XFillRectangle(TheDisplay,TheWindow,WhiteGC,
                  newActiveXo,newActiveYo,BoxW,BoxH);

   if(newActiveIndex == Info.dataEndIndex+1)  /* cursor out of string */
      ;
   else {

      code = Info.codeAlign[newActiveAlign][newActiveIndex]; 
      draw_string(False, newActiveXo, newActiveYo, code, BlackGC);
   }
   disp_one_motif();
   XFlush(TheDisplay);
}



firstPage()
{
  if(Info.dispStartIndex == Info.dataStartIndex)  
     return 1;
  else
     return 0;
}



lastPage()
{
  if(Info.dataEndIndex >= Info.dispStartIndex+PerLine)  /* there is next page */
     return 0;
  else     
     return 1;
}
