/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*   button.c  
**
**   Handles Button and events.
*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>
#include  <X11/keysym.h>
#include  <math.h>
#include  "aedit.h"

#if	1
#define	PROC_DELETE_BEFORE
#endif

#if	0
#define	DEBUG
#endif

static int mytimer=0;
/*static Bool doubleclick_flag = False;*/
/*static int doubleclick_x, doubleclick_y, doubleclick_button;*/
/*static XtIntervalId doubleclick_timer;*/
static int oldActiveAlign=0, oldActiveIndex=0, oldActiveCol=0;
static int press_align, press_index;
extern XtAppContext  app2;
extern Bool Shift_flag;
void get_selection();


void scrollControlRight(count,id)
int           count;
XtIntervalId *id;
{
  scrollColumnRight(count);
  if (EditMode == CONSTRAINT){
      disp_one_column_const(Info.dispStartIndex);
  }
  mytimer = XtAppAddTimeOut(app2,id==NULL?400:20,scrollControlRight,count);
}  


void scrollControlLeft(count,id)
int  count;   
XtIntervalId *id;
{
  scrollColumnLeft(count);
  if (EditMode == CONSTRAINT){ 
      disp_one_column_const(Info.dispStartIndex+PerLine-1);
  }
  mytimer = XtAppAddTimeOut(app2,id==NULL?400:20,scrollControlLeft,count);
}  


/*void reset_doubleclick_flag()
{
    doubleclick_flag = False;
}*/


/*Boolean distinguish_doubleclick(da, event, new_align, new_index, new_button)
Widget  da;
XButtonEvent *event;
int new_align, new_index, new_button;
{
    if ((doubleclick_flag == True) && (doubleclick_x == new_align) && 
        (doubleclick_y == new_index) && (doubleclick_button == new_button)){
        return True;
    }else{

        doubleclick_flag = True; doubleclick_button = new_button;
        doubleclick_x = new_align; doubleclick_y = new_index;
        doubleclick_timer = XtAppAddTimeOut(app2, 250,
                                            reset_doubleclick_flag, NULL);
        return False;
    }
}*/


processRelease(da,event)
Widget  da;
XButtonEvent *event;
{
    int newActiveAlign, newActiveIndex, newActiveXo, newActiveYo, 
        newActiveCol, rowH, cv, fixIndex, align, start_align, end_align,
        start_index, end_index, add, index, modify = False, dir = RIGHT;
    Bool start_align_flag = False, end_align_flag = False, white_flag, black_flag;

    if(mytimer) {
        XtRemoveTimeOut(mytimer);
        mytimer=0;
    }

    if (EditMode == VIEW) {
	button_release_bscnt(da, event);
	return;
    }
    if (press_index < Info.dispStartIndex || press_index >= Info.dispStartIndex+PerLine) return;
    if (press_align < 0 || press_align > Info.alignnum) return;
    if (oldActiveIndex) undisp_dragging_frame(press_align, press_index, oldActiveAlign, oldActiveIndex);
    oldActiveAlign=0, oldActiveIndex=0, oldActiveCol=0;

    /* New Active Point WO MOTOMERU */
    calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);
    if (newActiveAlign < 0) newActiveAlign = 0;
    if (newActiveAlign >= Info.alignnum) newActiveAlign = Info.alignnum-1;
    if (newActiveCol < 0) newActiveCol = 0;
    if (newActiveCol >= PerLine) newActiveCol = PerLine-1;
    newActiveIndex = newActiveCol + Info.dispStartIndex;
    /*fprintf(stderr, "drag align:%d   release align:%d    ActiveAlign:%d\n", 
              drag_align, newActiveAlign, ActiveAlign);*/

    start_align = press_align; end_align = newActiveAlign;
    if (start_align>end_align) swap_int(&start_align, &end_align);
    start_index = press_index; end_index = newActiveIndex;
    if (start_index>end_index) swap_int(&start_index, &end_index);
    add = end_index-start_index+1;

    switch(event->button){
        case Button1:
            if (press_align == Info.alignnum){
	        ActiveIndex = press_index;
	        start_align = 0;  end_align = Info.alignnum-1;
	    }
            if ((Button_flag[2] && (EditMode!=CONSTRAINT)) || Shift_flag){ /* left direction */            
#ifdef	PROC_DELETE_BEFORE
	        process_insert(start_align, end_align, end_index, add, LEFT);    
#else	PROC_DELETE_BEFORE
	        process_insert(start_align, end_align, start_index, add, RIGHT);    
#endif	PROC_DELETE_BEFORE
	    }else{
	        process_insert(start_align, end_align, start_index, add, RIGHT);    
	    }
            break;
        case Button2:
            if (press_align == Info.alignnum){
	        ActiveIndex = press_index;
	        start_align = 0;  end_align = Info.alignnum-1;
	    }
            if ((Button_flag[2] && (EditMode!=CONSTRAINT)) || Shift_flag){ /* left direction */            
#ifdef	PROC_DELETE_BEFORE
#ifdef	DEBUG
		(void)printf("processRelease --- before process_delete (LEFT)\n");
#endif	DEBUG
	        process_delete(start_align, end_align, end_index, -add, LEFT);    
#else	PROC_DELETE_BEFORE
  	        process_delete(start_align, end_align, start_index, -add, RIGHT);    
#endif	PROC_DELETE_BEFORE
	    }else{
#ifdef	DEBUG
		(void)printf("processRelease --- before process_delete (RIGHT)\n");
#endif
  	        process_delete(start_align, end_align, start_index, -add, RIGHT);    
	    }
            break;
        case Button3:
	    if (EditMode != CONSTRAINT) return;
	    white_flag = black_flag = False;
            if (press_align == Info.alignnum){
	        ActiveIndex = press_index;  ActiveAlign = 0;
	        start_align = 0; end_align = Info.alignnum-1;
	        start_index = end_index = press_index;
	    }
	    /* from black to white */
	    for (index=start_index; index<=end_index; index++){
	        for (align=start_align; align<=end_align; align++){
		    if (check_active(align, index)){
			if (Info.codeAlign[align][index]!=GAP_INNER_CODE) process_const(align, index);
			black_flag = True;
			break;
		    }
		}
	    }
	    if (black_flag) break;
	    /* from white to colorless */
	    for (align=start_align; align<=end_align; align++){
		for (index=start_index; index<=end_index; index++){
		    if (check_const(align, index)){
		        white_flag = True;
			if (Info.codeAlign[align][index]!=GAP_INNER_CODE) process_const(align, index);
		    }
		}
	    }
	    if (white_flag) break;
	    /* from colorless to white */
	    for (align=start_align; align<=end_align; align++){
		for (index=start_index; index<=end_index; index++){
		    if (Info.codeAlign[align][index]!=GAP_INNER_CODE) process_const(align, index);
		}
	    }
            break;
        default:
            break;
    }
    if ((EditMode == INSERT || EditMode == OVER_WRITE) && event->button!=Button3){
        if (press_align == Info.alignnum) {
            ActiveAlign = Info.alignnum-1;
            ActiveCol = ActiveIndex-Info.dispStartIndex;
            ActiveXo = LeftMargin + BoxW*newActiveCol;
            ActiveYo = get_yo() + (Info.alignnum+1)*BoxH;
	}
        disp_constraint(ActiveAlign, ActiveIndex, WhiteGC);
    }
}


processMotion(da,event)
Widget  da;
XButtonEvent *event;
{
    int newActiveAlign, newActiveIndex, newActiveXo, newActiveYo, newActiveCol;
    int right_fix, left_fix, dummy, rowH, align;

    if (EditMode == VIEW) {
	pointer_motion_bscnt(da, event);
	return;
    }
    if (press_align < 0 || press_align >= Info.alignnum) return;
    if (press_index < Info.dispStartIndex || press_index >= Info.dispStartIndex+PerLine) return;
    if (EditMode != CONSTRAINT && Button_flag[2] && !Button_flag[0] && !Button_flag[1]) return;

    calc_active_point(event->x,event->y,&newActiveAlign,&newActiveCol,&rowH);
    if (newActiveCol < 0) newActiveCol = 0;
    if (newActiveCol >= PerLine) newActiveCol = PerLine-1;
    newActiveIndex = newActiveCol + Info.dispStartIndex;
    if (newActiveAlign < 0) newActiveAlign = 0;
    if (newActiveAlign >= Info.alignnum) newActiveAlign = Info.alignnum-1;

    if (newActiveAlign==oldActiveAlign && newActiveIndex==oldActiveIndex) return;
    if (event->button==Button2){
        get_absorb_fixed_column(RIGHT, Info.dataEndIndex, &dummy, &right_fix);
        get_absorb_fixed_column(LEFT, Info.dataStartIndex, &dummy, &left_fix);
        if (newActiveIndex>=right_fix || newActiveIndex<=left_fix) return;
    }

    /*fprintf(stderr, "undisp: %d %d %d %d\n", press_align, press_index, oldActiveAlign, oldActiveIndex);*/
    if (oldActiveIndex) undisp_dragging_frame(press_align, press_index, oldActiveAlign, oldActiveIndex);
    /*fprintf(stderr, "disp: %d %d %d %d\n", press_align, press_index, newActiveAlign, newActiveIndex);*/
    disp_dragging_frame(press_align, press_index, newActiveAlign, newActiveIndex);

    oldActiveAlign = newActiveAlign; oldActiveIndex = newActiveIndex; oldActiveCol =  newActiveCol;
}


processPress(da,event)
Widget  da;
XButtonEvent *event;
{
   int newActiveAlign, newActiveIndex, newActiveXo, newActiveYo, 
       newActiveCol, rowH, cv, fixIndex, align,
       modify = False, dir = RIGHT;
   static int pressAlign, pressIndex;

   /* New Active Point WO MOTOMERU */
   calc_active_point(event->x,event->y,
                     &newActiveAlign,&newActiveCol,&rowH);
   press_align = newActiveAlign;  press_index = newActiveCol+Info.dispStartIndex;
   if ((EditMode == INSERT || EditMode == OVER_WRITE) && 
       event->button!=Button3 && press_align == Info.alignnum){
       disp_align_one(ActiveAlign, ActiveIndex, 1);
   }
/***
      printf("newActiveCol=%d, newActiveAlign=%d\n",
              newActiveCol,newActiveAlign);
***/

   if(event->button == Button1)  {
      if(event->x >= WinW-BarMargin &&
         event->x <= WinW-BarMargin+BarLeng &&
         event->y >= 10    &&
         event->y <= TopMargin ) {
         /* Our Scroll Bar Area */        
         int ratio;
         ratio = 10000*(event->x - (WinW-BarMargin))/
                       (BarMargin-10);
	 erase_base_count();
         adjustPageByMouse(ratio);
	 display_base_count();
      }
      else if(newActiveAlign == -1  &&  -1 == newActiveCol ) {
         /* User push button at < mark */
	  erase_base_count();
          scrollControlRight(1,NULL); 
	  display_base_count();
      }
      else if(newActiveAlign == -1  && PerLine == newActiveCol ) {
         /* User push button at > mark */
	  erase_base_count();
          scrollControlLeft(1,NULL);
	  display_base_count();
      }
      else if(newActiveAlign == -1  &&
         0<=newActiveCol && newActiveCol<PerLine) {

         /* User Specify "Absorb Column" */
         if(EditMode==VIEW)   return;
         if(EditMode == CONSTRAINT)   return;

         fixIndex = Info.dispStartIndex + newActiveCol;

         /* If Absorb Column, we don't allow fix column */
         if(ABSORB_COLUMN  &  Info.columnAtrib[fixIndex])  return;
         /* Toggle */
         cv = FIXED_COLUMN  &  Info.columnAtrib[fixIndex];
         if(cv)  Info.columnAtrib[fixIndex] &= ~FIXED_COLUMN;
         else    Info.columnAtrib[fixIndex] |= FIXED_COLUMN;

         disp_scale_one(fixIndex);  
      }
      else if(0<=newActiveAlign &&  
              0<=newActiveCol && newActiveCol<PerLine) {
         newActiveIndex = Info.dispStartIndex + newActiveCol; 
/*         printf("newActiveIndex=%d\n",newActiveIndex);  */

         if(newActiveIndex <= Info.dataEndIndex+1 &&
            newActiveAlign < Info.alignnum) {
                newActiveYo = rowH + (newActiveAlign+2)*BoxH;
                newActiveXo = LeftMargin + BoxW*newActiveCol;
 
                if (EditMode == INSERT || EditMode == OVER_WRITE){
                    /*updateActivPoint(ActiveAlign,ActiveIndex,
                                     ActiveXo,ActiveYo, ActiveCol,
                                     newActiveAlign,newActiveIndex,
                                     newActiveXo,newActiveYo, newActiveCol);*/
                    disp_align_one(ActiveAlign, ActiveIndex, 1);
		}

	/* append (begin) */
		else if (EditMode == VIEW) {
			button_press_bscnt(da, event);
		}
	/* append (end) */

                ActiveAlign = newActiveAlign;
                ActiveIndex = newActiveIndex;
                ActiveXo = newActiveXo;
                ActiveYo = newActiveYo;
                ActiveCol = newActiveCol;

         }     
      }
   }
   else if(event->button == Button2)  { 
       if (EditMode != VIEW){
           if(0<=newActiveAlign &&  
              0<=newActiveCol && newActiveCol<PerLine) {
               newActiveIndex = Info.dispStartIndex + newActiveCol; 
/*         printf("newActiveIndex=%d\n",newActiveIndex);  */

               if(newActiveIndex <= Info.dataEndIndex+1 &&
                  newActiveAlign < Info.alignnum) {
                   newActiveYo = rowH + (newActiveAlign+2)*BoxH;
                   newActiveXo = LeftMargin + BoxW*newActiveCol;
                   if (EditMode == INSERT || EditMode == OVER_WRITE){
                       /*updateActivPoint(ActiveAlign,ActiveIndex,
                                          ActiveXo,ActiveYo, ActiveCol,
                                          newActiveAlign,newActiveIndex,
                                          newActiveXo,newActiveYo, newActiveCol);*/
                       disp_align_one(ActiveAlign, ActiveIndex, 1);
                   }
                   ActiveAlign = newActiveAlign;
                   ActiveIndex = newActiveIndex;
                   ActiveXo = newActiveXo;
                   ActiveYo = newActiveYo;
                   ActiveCol = newActiveCol;

               }
           }
       }
/*** 
   Copy selection 
   whoGetKeyboard();
      printf("XtGetSelectionValue just called\n"); 
   XtGetSelectionValue(da,XA_PRIMARY,XA_STRING,get_selection,NULL,event->time);
***/
   }
   else if(event->button == Button3)  {
       if (EditMode == CONSTRAINT){
           if(newActiveAlign == -1  && 0<=newActiveCol && 
              newActiveCol<PerLine) {
	       process_region(newActiveCol);  /* Region select */
           }
           if(0<=newActiveAlign &&  
              0<=newActiveCol && newActiveCol<PerLine) {
               newActiveIndex = Info.dispStartIndex + newActiveCol; 
/*         printf("newActiveIndex=%d\n",newActiveIndex);  */

               if(newActiveIndex <= Info.dataEndIndex+1 &&
                  newActiveAlign < Info.alignnum) {
                   newActiveYo = rowH + (newActiveAlign+2)*BoxH;
                   newActiveXo = LeftMargin + BoxW*newActiveCol;
                   ActiveAlign = newActiveAlign;
                   ActiveIndex = newActiveIndex;
                   ActiveXo = newActiveXo;
                   ActiveYo = newActiveYo;
                   ActiveCol = newActiveCol;

               }
           }
       }
/***
      printf("newActiveCol=%d, newActiveAlign=%d\n",
              newActiveCol,newActiveAlign);
***/
   }
}


/* Mouse NO OSARETA ITI KARA New Active Point WO MOTOMERU */
/* return 0 : user push button illegal point */
/* return 1 : success */
calc_active_point(x,y,align,col, rowh)
int  x,y;       	/* (x,y) on the window */
int  *align,*col, *rowh;
{
  int         i;

  if(x<LeftMargin)   /* to maesure *col is -2, -1, 0, 1, 2 */
     *col = -((LeftMargin-x)/BoxW)-1;
  else
     *col = (x - LeftMargin)/BoxW;
    
  *rowh = TopMargin;
  *align = (y - *rowh)/BoxH - 2;
                          /* -2 for lines for displaying column# */
}


void get_selection(da,client_data,selection,type,value,leng,format)
Widget   da;
caddr_t  client_data;
Atom     *selection, *type;
caddr_t  value;
unsigned long *leng;
int      *format;
{
  fprintf(stderr, "get_selection just called. *selection=%d, *type=%d\n",*selection,*type);
  if(*type == XA_STRING) {
     if(pasteChar(*leng,value))  disp_cost();
  }
}



int get_yo()
{
  return TopMargin;
}
