/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*  network_menu.c 
 *  treat network items commands.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <setjmp.h>

#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include	<X11/cursorfont.h>

#include "menu.h"
#include "aedit.h"

#define  START_PORT        1192
#define  END_PORT          4000

extern void cancelCB();
void toggle3();
extern Widget aedit_top, menu_top, result, da, da2;
extern Display *dpy2, *dpy3;
extern MENUITEM network_menu[];
extern MENUITEM network_sub_menu_PIM[];
extern MENUITEM network_sub_menu_UNIX[];
extern int errno;
extern char *sys_errlist[];
extern int UU_s, VV_s, WW_s, PP_s, QQ_s, SS_s, Cut_s;
static int   Sockfd = -1;
static int   NewSockfd = -1;
static int method = 1;
int cut = 95;
int UU_n, VV_n, WW_n = 0, PP_n = 0, QQ_n = 0, SS_n;
int send_left, send_right, new_send_right;
int const_flag[MAX_CONSTRAINT]; /* 0:not  1:send  2:right of send region */
Bool left_flag = False, right_flag = False, UNIX_flag = False;


socketClose()
{
  if(Sockfd != -1)        close(Sockfd);
  if(NewSockfd != -1)     writen(NewSockfd, "@&", 2); close(NewSockfd);
}


Bool process_presend()
{
    Constraint_data *p_now;
    int i, align, const_now;

    left_flag = False; right_flag = False;
    for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
	if (Region_flag[i]) break;
    }
    if (i == Info.dataEndIndex+1) return False;
    if (i != Info.dataStartIndex){
	send_left = i-1;
        left_flag = True;
    }else{
	send_left = i;
    }
    for (i=Info.dataEndIndex; i>=Info.dataStartIndex; i--){
	if (Region_flag[i]) break;
    }
    if (i != Info.dataEndIndex){
	send_right = i+1;
        right_flag = True;
    }else{
	send_right = i;
    }
    Calc_leng = send_right - send_left + 1;
    /*New_calc_leng = Calc_leng;*/

    for (align=0; align<Info.alignnum; align++){
        for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
	    if (Info.codeAlign[align][i] == GAP_INNER_CODE){
		Calc_constraint[align][i] = '_';
	    }else{
		Calc_constraint[align][i] = '`';
	    }
    /*Calc_codeAlign[align][i] = Info.codeAlign[align][i];*/
	}
    }
    for (const_now=0; const_now<=Const_no; const_now++){
        p_now = Const_head[const_now].p_first;
        while (p_now != NULL){
	    const_flag[const_now] = 0;
	    if ((p_now->index >= send_left) && (p_now->index <= send_right)){
		const_flag[const_now] = 1;
	    }
	    if (p_now->index > send_right){
		const_flag[const_now] = 2;
	    }
	    Calc_constraint[p_now->align][p_now->index] = (char)(const_now+97);
	    if ((p_now->index == send_left) && left_flag){
		Calc_constraint[p_now->align][p_now->index] = '`';
	    }
	    if ((p_now->index == send_right) && right_flag){
		Calc_constraint[p_now->align][p_now->index] = '`';
	    }
            p_now = p_now->p_next;
        }
    }
    return True;
}


send_PIMOS()
{
    int i, align, p = 0;
    char sock_buff[MAX_ALIGN_LENG * MAX_ALIGN + 100];

    strncpy(&sock_buff[p], "@!", 2); p += 2;

    strncpy(&sock_buff[p], "@1", 2); p += 2;
    sock_buff[p] = (char)Info.alignnum; p += 1;

    strncpy(&sock_buff[p], "@2", 2); p += 2;
    sock_buff[p] = (char)(Calc_leng/256); p += 1;
    sock_buff[p] = (char)(Calc_leng%256); p += 1;

    for (align=0; align<Info.alignnum; align++){
        strncpy(&sock_buff[p], "@0", 2); p += 2;
	if (left_flag){
            sock_buff[p] = 'O'; p += 1;
	}else{
            sock_buff[p] = Char1[Info.codeAlign[align][send_left]]; p +=1;
	}
	for (i=send_left+1; i<=send_right-1; i++){
            sock_buff[p] = Char1[Info.codeAlign[align][i]]; p +=1;
	}
	if (right_flag){
            sock_buff[p] = 'O'; p += 1;
	}else{
            sock_buff[p] = Char1[Info.codeAlign[align][send_right]]; p +=1;
	}
    }

    for (align=0; align<Info.alignnum; align++){
        strncpy(&sock_buff[p], "@8", 2); p += 2;
        strncpy(&sock_buff[p], &Calc_constraint[align][send_left], Calc_leng);
        p += Calc_leng;
    }

    strncpy(&sock_buff[p], "@#", 2); p += 2;
    sock_buff[p] = (char)method; p += 1;

    strncpy(&sock_buff[p], "@$", 2); p += 2;
    sock_buff[p] = (char)cut; p += 1;

    strncpy(&sock_buff[p], "@%", 2); p += 2;
    sock_buff[p] = (char)UU_n; p += 1;
    sock_buff[p] = (char)VV_n; p += 1;
    sock_buff[p] = (char)WW_n; p += 1;
    sock_buff[p] = (char)PP_n; p += 1;
    sock_buff[p] = (char)QQ_n; p += 1;
    sock_buff[p] = (char)SS_n; p += 1;

    sock_buff[p] = '@'; p += 1;
    sock_buff[p] = '"'; p += 1;
   
    sock_buff[p] = '\0';

    for (i=0; i<p; i++){fprintf(stderr, "%c", sock_buff[i]);}
    fprintf(stderr, "\nsend %dbytes\n", p);
    writen(NewSockfd, sock_buff, p);
}


receive_PIMOS()
{
    int i, j, k, p;
    char sock_buff[MAX_ALIGN_LENG * MAX_ALIGN + 100];

    p = readline(NewSockfd, sock_buff, MAX_ALIGN_LENG * MAX_ALIGN + 100);
    /*for (i=0; i<p; i++){fprintf(stderr, "%c", sock_buff[i]);}*/
    fprintf(stderr, "\nreceive %dbytes\n", p);
    
    New_calc_leng = ((int)sock_buff[4]-48)*1000 + ((int)sock_buff[5]-48)*100 +
                     ((int)sock_buff[6]-48)*10 + ((int)sock_buff[7]-48);
    fprintf(stderr, "result alignment length:%d\n", New_calc_leng);

    for (i=0; i<Info.alignnum; i++){
	for (j=i*(New_calc_leng+2)+10, k=send_left; 
             j<((i+1)*(New_calc_leng+2)+10-2); j++, k++){
	    if (sock_buff[j] == '-'){
    	        Calc_codeAlign[i][k] = (char)26;
            }else{
                Calc_codeAlign[i][k] = (char)((int)sock_buff[j]-65);
	    }
            fprintf(stderr, "%c", sock_buff[j]);
        }
        if (left_flag){
            Calc_codeAlign[i][send_left] = Info.codeAlign[i][send_left];
        }
        if (right_flag){
            Calc_codeAlign[i][send_left+New_calc_leng-1] = 
                                              Info.codeAlign[i][send_right];
        }
   	fprintf(stderr, "\n");
    }

    for (i=0; i<Info.alignnum; i++){
	for (j=(i+Info.alignnum)*(New_calc_leng+2)+10, k=send_left; 
             j<((i+Info.alignnum+1)*(New_calc_leng+2)+10-2); j++, k++){
    	    Calc_constraint[i][k] = sock_buff[j];
    	    fprintf(stderr, "%c", Calc_constraint[i][k]);
        }
    	fprintf(stderr, "\n");
    }
}


net_okCB(w,client_data,call_data)
Widget    w;
caddr_t   client_data, call_data;
{
    Constraint_data *p_now;
    int add, align, i, j, k, count = 'a', direc, direc_num[MAX_ALIGN];
    Bool left_set = False, right_set = False, count_flag = True;

    add = New_calc_leng - Calc_leng;
    Info.dataEndIndex += add;
    if (add >= 0){
        for (i=0; i<Info.alignnum; i++){
	    for (j=Info.dataEndIndex; j>send_right; j--){
	        Info.codeAlign[i][j+add] = Info.codeAlign[i][j];
	    }
        }
        for (j=Info.dataEndIndex; j>send_right; j--){
	    Region_flag[j+add] = Region_flag[j];
	    Region_divide[j+add] = Region_divide[j];
	}
    }else{
        for (i=0; i<Info.alignnum; i++){
/*	    for (j=send_right; j<=Info.dataEndIndex; j++){ */
	    for (j=send_right; j<=Info.dataEndIndex-add; j++){
	        Info.codeAlign[i][j+add] = Info.codeAlign[i][j];
	        Region_flag[j+add] = Region_flag[j];
	        Region_divide[j+add] = Region_divide[j];
	    }
        }
    }
    for (i=0; i<Info.alignnum; i++){
	for (j=send_left; j<(send_left+New_calc_leng); j++){
	    Info.codeAlign[i][j] = Calc_codeAlign[i][j];
        }
    }

    for (i=0; i<=Const_no; i++){
	switch (const_flag[i]){
	    case 0:
		break;
	    case 1:
		k = 0;
        	p_now = Const_head[i].p_first;
    		for (align=0; align<Info.alignnum; align++){
            	    for (j=send_left; j<(send_left+New_calc_leng); j++){
			if (Calc_constraint[align][j] == (char)count){
			    k++;
			    if (k == 1){
				direc = j;
				direc_num[i] = 1;
			    }else{
				if (j == direc){
				    direc_num[i]++;
				}
			    }
		    	    p_now->align = align;
		    	    p_now->index = j;
            	    	    p_now = p_now->p_next;
        		}
        	    }
		}
		if (k == 0){
		    if (left_flag && !left_set){
    		        for (align=0; align<Info.alignnum; align++){
			    k++;
		    	    p_now->align = align;
		            p_now->index = send_left;
            	       	    p_now = p_now->p_next;
        	        }
		        left_set = True;
		    }else{    
		    if (right_flag && !right_set){
    		        for (align=0; align<Info.alignnum; align++){
		            k++;
		    	    p_now->align = align;
		            p_now->index = send_left+New_calc_leng-1;
            	    	    p_now = p_now->p_next;
        	        }
		        right_set = True;
		    }}    
		}    
        	Const_head[i].active_no = k;
		p_now = NULL;
		count++;
		break;
	    case 2:
        	p_now = Const_head[i].p_first;
        	while (p_now != NULL){
		    p_now->index += add;
            	    p_now = p_now->p_next;
        	}
		break;
	    default:
		break;
	}
    }
	
    for (i=send_left+1; i<send_left+New_calc_leng; i++){
	Region_flag[i] = True;
	Region_divide[i] = False;
    }
    if (right_flag){
	Region_flag[send_left+New_calc_leng-1] = False;
	Region_divide[send_left+New_calc_leng-1] = True;
    }
    for (i=0; i<=Const_no; i++){
	if ((const_flag[i]==1) && (direc_num[i]==Info.alignnum)){
	    Region_flag[Const_head[i].p_first->index] = False;
	    Region_divide[Const_head[i].p_first->index] = True;
	}
    }
    Region_no = 0;
    for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
	if (Region_divide[i] || !Region_flag[i]) count_flag = True;
	if (count_flag && Region_flag[i]){
	    count_flag = False;
	    Region_no++;
	}
    }

    XtUnmapWidget(result);

    Result_flag = True;
}


net_cancelCB(w,client_data,call_data)
Widget    w;
caddr_t   client_data, call_data;
{
    XtUnmapWidget(result);}


netCB(w,client_data,cbs)
Widget    w;
caddr_t   client_data;
XmAnyCallbackStruct *cbs;
{
	extern Widget	menu_top, aedit_top;
  static Bool first_flag = True;
  Arg args[10];
  int align, i, result_leng;
	Cursor	cursor1, cursor2;
  
  XtPopdown((Widget)client_data);
  XFlush(XtDisplay((Widget)client_data));

  if (!process_presend()){
      popUpWarnDialog("alignment region is not selected"); 
      return;
  }

	cursor1 = XCreateFontCursor(XtDisplay(menu_top), XC_watch);
	XDefineCursor(XtDisplay(menu_top), XtWindow(menu_top), cursor1);
	XFlush(XtDisplay(menu_top));

	cursor2 = XCreateFontCursor(XtDisplay(aedit_top), XC_watch);
	XDefineCursor(XtDisplay(aedit_top), XtWindow(aedit_top), cursor2);
	XFlush(XtDisplay(aedit_top));

  if (first_flag && !UNIX_flag){
      first_flag = False;
      connect_PIMOS();
  }

  if (UNIX_flag){
      switch(method){
	  case 1:
              tree_base();
	      break;
	  case 2:
              tree_base_ria();
	      break;
	  case 3:
              ria();
	      break;
	  case 4:
	      break;
	  case 5:
	      break;
	  default:
	      break;
      }
      New_calc_leng = new_send_right - send_left + 1;
  }else{
      send_PIMOS();
      receive_PIMOS();
  }

	XUndefineCursor(XtDisplay(menu_top), XtWindow(menu_top));
	XFlush(XtDisplay(menu_top));
	XFreeCursor(XtDisplay(menu_top), cursor1);

	XUndefineCursor(XtDisplay(aedit_top), XtWindow(aedit_top));
	XFlush(XtDisplay(aedit_top));
	XFreeCursor(XtDisplay(aedit_top), cursor2);

  result_leng = New_calc_leng; if (New_calc_leng<12) result_leng = 12;
  XtSetArg(args[0], XmNwidth, (result_leng+2)*BoxW+LeftMargin);
  XtSetArg(args[1], XmNheight,(Info.alignnum+4)*BoxH+TopMargin+BouMinusMargin+BouPlusMargin);
  XtSetValues(da2, args, 2);
  XtRealizeWidget(result);
  XtMapWidget(result);
}


static void param_scaleCB(w,param,call_data)
Widget   w;
int      param;
XmScaleCallbackStruct  *call_data;
{
  if(param==0)              UU_n = call_data->value;
  else if(param==1)     VV_n = call_data->value;
  else if(param==2)     SS_n = call_data->value;
  else if(param==3)     cut = call_data->value;

  /*printf("UU:%d  VV:%d  SS:%d\nUU_n:%d  VV_n:%d  SS_n :%d  Cut:%d\n",
         UU, VV, SS, UU_n, VV_n, SS_n, cut);*/
}


void methodCB(w,client_data,cbs)
Widget    w;
int client_data;
XmAnyCallbackStruct *cbs;
{
    int i;
    static Widget dialog = NULL;
    static Widget scale[4], rc, rc1, rc2, ok, cancel;
    Arg args[10];
    XButtonEvent *ev;
    XmString xms;
    static char *label[] = { "UU ", "VV ", "SS ", "Cut" };
    extern MENUITEM network_sub_menu_PIM[];
    extern MENUITEM network_sub_menu_UNIX[];


    method = client_data;
    if (method > 10){
	UNIX_flag = True;
        method -= 10;
        XtVaSetValues(network_sub_menu_UNIX[method-1].w, XmNset, False, NULL);
    }else{
	UNIX_flag = False;
        XtVaSetValues(network_sub_menu_PIM[method-1].w, XmNset, False, NULL);
    }

    /*printf("alignment method:%d\n", method);*/

    ev = (XButtonEvent *)cbs->event;
    if (!dialog){
        UU_n = UU; VV_n = VV; SS_n = SS;
        if (NA_flag){ UU_n = 30; VV_n = 5; SS_n = 50;}
        XtSetArg(args[0], XmNallowShellResize, True);
        dialog = XtCreatePopupShell("param_dialog", overrideShellWidgetClass,
                                    menu_top, args, 1);

	rc = XmCreateRowColumn(dialog, "param_rc", NULL, 0); XtManageChild(rc);
	rc1 = XmCreateRowColumn(rc, "param_rc1", NULL, 0); XtManageChild(rc1);

	for (i=0; i<4; i++){
	    xms = XmStringCreateLtoR(label[i], XmSTRING_DEFAULT_CHARSET);
	    XtSetArg(args[0], XmNtitleString, xms);
	    XtSetArg(args[1], XmNmaximum, 11);
	    XtSetArg(args[2], XmNminimum, -10);
            if (NA_flag){
                XtSetArg(args[1], XmNmaximum, 51);
                XtSetArg(args[2], XmNminimum, -10);
	    }
	    if (i == 3){
	        XtSetArg(args[1], XmNmaximum, 100);
	        XtSetArg(args[2], XmNminimum, 0);
	    }
	    XtSetArg(args[3], XmNshowValue, True);
	    scale[i] = XtCreateManagedWidget("param_scale", xmScaleWidgetClass, 
					     rc1, args, 4);
	    XtAddCallback(scale[i], XmNdragCallback, param_scaleCB, i);
	    XtAddCallback(scale[i], XmNvalueChangedCallback, param_scaleCB, i);
	    XmStringFree(xms);
	}

	rc2 = XmCreateRowColumn(rc, "param_rc2", NULL, 0); XtManageChild(rc2);
	ok = XmCreatePushButton(rc2, "   OK", NULL, 0); XtManageChild(ok);
	XtAddCallback(ok, XmNactivateCallback, netCB, dialog);
	cancel = XmCreatePushButton(rc2, " Cancel", NULL, 0); XtManageChild(cancel);
	XtAddCallback(cancel, XmNactivateCallback, cancelCB, dialog);
    }

    XtVaSetValues(scale[0], XmNvalue, UU_n, NULL);
    XtVaSetValues(scale[1], XmNvalue, VV_n, NULL);
    XtVaSetValues(scale[2], XmNvalue, SS_n, NULL);
    XtVaSetValues(scale[3], XmNvalue, cut, NULL);

    XtVaSetValues(dialog, XmNx, ev->x_root, XmNy, ev->y_root, NULL);
    XtPopup(dialog, XtGrabNone);
}


connect_PIMOS()
{
  short port;
  int  i, newsockfd, clilen, childpid, length, status;
  struct sockaddr_in  cli_addr, serv_addr;
  struct hostent *hp, *gethostbyaddr(), *gethostbyname();
  char   *hostname, my_hostname[100];

  
  setbuf(stdout,NULL);

  Sockfd = NewSockfd = -1;

  /* Open a TCP socket (an Internet stream socket)  */  
  if((Sockfd=socket(AF_INET,SOCK_STREAM,0))<0) 
     err_dump("server: can't open stream socket");

  /* Bind our local address so that the clients can send to us */
  bzero((char *)&serv_addr, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;

/*  serv_addr.sin_addr.s_addr = htonl(INADDR_ANY); */
  gethostname(my_hostname);
  if((hp = gethostbyname(my_hostname)) == NULL) {
     err_ret("host name %s not exist",my_hostname);
     popUpWarnDialog("host name %s not exist",my_hostname);
     close(Sockfd);
     Sockfd = -1;
     return -1;
  }
  bcopy(hp->h_addr, (char *)&serv_addr.sin_addr, hp->h_length);

  for(port=START_PORT;  port<END_PORT; ++port) {
     serv_addr.sin_port = htons(port);
     
     errno=0;
     if(bind(Sockfd,(struct sockaddr *)&serv_addr, sizeof(serv_addr))<0) {
        fprintf(stderr,"port#=%d, errno = %d\n", port,errno);
        fprintf(stderr,"sys_errlist[] = %s\n", sys_errlist[errno]);
        continue;    /*find next port */
     }
     else 
        break;
  }

  /* display assined port # */
  length = sizeof(serv_addr);
  if(getsockname(Sockfd,(struct sockaddr *)&serv_addr,&length)<0) 
     err_dump("server: getsockname error");

  fprintf(stderr, "We use the socket port#=%d\n", ntohs(serv_addr.sin_port));

  listen(Sockfd,1);

     /* Wait for a connection from a client process.
      * This is an exmaple of a concurrent server.
      */

     fprintf(stderr, "Now, waiting connection request from client process(PIMOS).\n");
     clilen = sizeof(cli_addr);
     newsockfd = accept(Sockfd,(struct sockaddr *)&cli_addr,&clilen);
     if(newsockfd<0) {
        perror("accept failed\n");
        close(Sockfd);
        Sockfd = -1;
        exit(1);
     }
     NewSockfd = newsockfd;

     fprintf(stderr, "server: accept success\n");
     fprintf(stderr, "server: cli_addr.sin_family=%d\n",cli_addr.sin_family);
     fprintf(stderr, "server: cli_addr.sin_addr.s_addr=0x%x\n",cli_addr.sin_addr.s_addr);
     fprintf(stderr, "server: inet_ntoa(cli_addr.sin_addr)=%s\n",
                     inet_ntoa(cli_addr.sin_addr));

     /* get client's hostname */
     hp = gethostbyaddr((char *)&cli_addr.sin_addr,
                         sizeof(struct in_addr), cli_addr.sin_family);
     if(hp)  fprintf(stderr, "server: client's hostname=%s\n",hp->h_name);
     hostname = hp->h_name;

     fprintf(stderr, "server: client's port#=%d\n",ntohs(cli_addr.sin_port));

     close(Sockfd);             /* close original socket */
     Sockfd = -1;

     return NewSockfd;
}


/*
*  Read a line from a descriptor. Read the line one byte at a time,
*  looking for the 34H. We store the newline in the buffer, then
*  follow it with a null(the same as fgets() ).
*  We return the number of characters up to, but not including,
*  the null(the same as strlen() )
*/

int  readline(fd,ptr,maxlen)
int  fd;
char *ptr;
int  maxlen;
{
  int  n, rc;
  char c;

  for(n=1; n<maxlen; n++) {
     if((rc=read(fd,&c,1))==1) {
        *ptr++ = c;
        if(c=='"')  break;
     }
     else if(rc==0) {
        if(n==1)  return 0;
        else      break;
     }
     else
        return -1;
  }
  *ptr=0;
  return n;
}


/*
*  Read "n" bytes from a descriptor.
*  Use in place of read() when fd is a stream socket.
*/
int  readn(fd,ptr,nbytes)
int  fd;
char *ptr;
int  nbytes;
{
  int  nleft, nread;

  nleft = nbytes;
  while(nleft>0) {
     nread = read(fd,ptr,nleft); 
     if(nread<0)   return nread;    /* error, return<0 */
     else if(nread==0)  break;      /* EOF */
 
     nleft -= nread;
     ptr += nread;
  }

  *(ptr++) = '\0';
  return (nbytes-nleft);
}



/*
*  Write "n" bytes to a descriptor.
*  Use in place of write() when fd is a stream socket.
*/
int  writen(fd,ptr,nbytes)
int  fd;
char *ptr;
int  nbytes;
{
  int  nleft, nwritten;

  nleft = nbytes;
  while(nleft>0) {
/*     nwritten = write(fd,ptr,nleft); */
     nwritten = send(fd,ptr,nleft,0);
     if(nwritten<=0)   return nwritten;    /* error */
     nleft -= nwritten;
     ptr += nwritten;
  }

  return (nbytes-nleft);
}


MENUITEM network_sub_menu_PIM[] = {
   { "Tree-based", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)1, NULL, True, True, XmONE_OF_MANY},
   { "Tree-based Best-first Iterative", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)2, NULL, True, False, XmONE_OF_MANY},
   { "Block-based", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)3, NULL, True, False, XmONE_OF_MANY},
   { "Block-based Best-first Iterative", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)4, NULL, True, False, XmONE_OF_MANY},
   { "Best-first Iterative", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)5, NULL, True, False, XmONE_OF_MANY},
   {NULL},
};


MENUITEM network_sub_menu_UNIX[] = {
   { "Tree-based", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)11, NULL, True, True, XmONE_OF_MANY},
   { "Tree-based Round-robin Iterative", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)12, NULL, True, False, XmONE_OF_MANY},
   { "Round-robin Iterative", &xmToggleButtonGadgetClass, NULL, NULL, NULL,
      methodCB, (caddr_t)13, NULL, True, False, XmONE_OF_MANY},
   {NULL},
};


MENUITEM network_menu[] = {

   { "PIM", &xmCascadeButtonWidgetClass, 'P', NULL, NULL,
      NULL, (caddr_t)NULL, network_sub_menu_PIM, True},

   { "UNIX", &xmCascadeButtonWidgetClass, 'U', NULL, NULL,
      NULL, (caddr_t)NULL, network_sub_menu_UNIX, True},

   {NULL},
};


