/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	饤ȡǥ

	ե̾	aep_scantd.c

	ǽ		ƥȡǡΥ

			ޥη׻ϥݡȤƤʤ

			6/28/93

	С	1.0

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<sys/stat.h>
#include	<malloc.h>
#include	<string.h>
#include	<varargs.h>
#include	<ctype.h>
#include	<limits.h>

/*--------------------------------------------------------------------*/

#define	MACRO_INIT_ASZ	1	/* 10 */
#define	MACRO_ADD_ASZ	1	/* 10 */

/*--------------------------------------------------------------------*/

typedef struct TextDataStruct {
	int	areasize;	/* Υ */
	int	datasize;	/* ǡΥ */
	char	*curptr;	/* ƥȡǡΥȡݥ
				   ʥѡ*/
	char	*textdata;	/* ƥȥǡ */

} TextData;

typedef	struct MacroStruct {
	char	*name;	/* ̾ */	
	char	*value;	/*  */
} Macro;

typedef struct MacroDataStruct {
	int	areasize;	/* Υ */
	int	datasize;	/* ǡΥ */
	Macro	*macro;		/* ޥ */
} MacroData;

static TextData	textdata_scan;		/* 󤹤ƥȡǡ
					   */

static int	textdata_linenum;	/* 󤹤륫ȤΥƥ
					   ȡǡϥե
					   ιֹ */

static char	message[BUFSIZ];	/* å */

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/* ƥȡǡΥץʥǡ */

char *open_textdata(filename)
char	*filename;
{
	struct stat	status;
	int		masize;
	MacroData	macrodata;
	TextData	readdata;
	FILE		*fp;
	char		lntext[BUFSIZ];
	void		init_macrodata();
	void		alloc_macrodata();
	void		init_textdata();
	void		alloc_textdata();
	void		read_textdata();
	char		*generate_textdata();
	void		free_textdata();

	/* ƥȡǡΰβʥ󤹤ƥȡǡ */
	if (textdata_scan.textdata != (char *)NULL)
		free_textdata(&textdata_scan);

	/* ꥢåʽĥˤη */
	if (stat(filename, &status)) {
		(void)sprintf(message,
			      "file %s status get error",
			      filename);
		return message;
	}
	if (status.st_size <= 0) {
		(void)sprintf(message,
			      "illegal file size (0) (%s)",
			      filename);
		return message;
	}
	masize = status.st_size;
#ifdef	DEBUG
(void)printf("open_textdata --- masize = %d\n", masize);
#endif

	/* եΥץ */
	if ((fp = fopen(filename, "r")) == (FILE *)NULL) {
		(void)sprintf(message, "file %s open error", filename);
		return message;
	}

	/* ޥǡΰν */
	init_macrodata(&macrodata);

	/* ޥǡΰγ */
	alloc_macrodata(&macrodata, MACRO_INIT_ASZ);

	/* ƥȡǡɤ߹ΰν */
	init_textdata(&readdata);

	/* ƥȡǡɤ߹ΰγ */
	alloc_textdata(&readdata, masize);

	/* ǡե뤫ɤ߹ */
	macrodata.datasize = 0;
	readdata.datasize = 0;
	readdata.curptr = readdata.textdata;
	read_textdata(fp, masize, &macrodata, &readdata);

#ifdef	DEBUG
(void)printf("open_textdata --- readdata (len) = %s (%d)\n",
	     readdata.textdata, strlen(readdata.textdata));
#endif

	/* եΥ */
	(void)fclose(fp);

	/* ƥȡǡΰγ */
	alloc_textdata(&textdata_scan, masize);

	/* ƥȡǡ */
	readdata.datasize = 0;	/* ̤ */
	readdata.curptr = readdata.textdata;
	textdata_scan.datasize = 0;
	textdata_scan.curptr = textdata_scan.textdata;
	(void)strcpy(lntext, "#0");
	if (generate_textdata(
		&readdata, 0, lntext, masize, &textdata_scan)) {
		free_textdata(&readdata);
		return message;
	}

#ifdef	DEBUG
(void)printf("open_textdata --- textdata_scan (len) = %s (%d)\n",
	     textdata_scan.textdata, strlen(textdata_scan.textdata));
#endif

	/* ƥȡǡɤ߹ΰβ */
	free_textdata(&readdata);

	/* ƥȡǡΥǡν */
	textdata_scan.datasize = 0;
	textdata_scan.curptr = textdata_scan.textdata;
	textdata_linenum = 0;

	return (char *)NULL;
}

/* ƥȡǡե뤫ɤ߹ */

static void read_textdata(fp, masize, macrodata, readdata)
FILE		*fp;
MacroData	*macrodata;
TextData	*readdata;
{
	char	ldtext[BUFSIZ], lntext[BUFSIZ];
	int	lnum = 0;
	char	*p;
	int	ldtlen, lntlen, assize;
	char	*msg;
	void	alloc_textdata();
	char	*generate_macrodata();

	readdata->curptr = readdata->textdata;

	while (fgets(ldtext, BUFSIZ, fp) != (char *)NULL) {
		lnum++;
		(void)sprintf(lntext, " #%d", lnum);
		lntlen = strlen(lntext);
		if (readdata->datasize + lntlen >= readdata->areasize)
			alloc_textdata(readdata, lntlen + masize);
		readdata->datasize += lntlen;
		(void)strncpy(readdata->curptr, lntext, lntlen);
		readdata->curptr += lntlen;
		if ((p = strrchr(ldtext, '\n')) != (char *)NULL)
			*p = '\0';
		if ((p = strchr(ldtext, '#')) != (char *)NULL)
			*p = '\0';
		msg = generate_macrodata(macrodata, ldtext);
		if (!strcmp(msg, "Macro Success"))
			continue;
		else if (!strcmp(msg, "Macro Fail"))
			break;
		if ((ldtlen = strlen(ldtext)) > 0) {
			assize = 1 + ldtlen;
			if (readdata->datasize + assize >= readdata->areasize)
				alloc_textdata(readdata, assize + masize);
			readdata->datasize += assize;
			*readdata->curptr = ' ';
			readdata->curptr++;
			(void)strncpy(readdata->curptr, ldtext, ldtlen);
			readdata->curptr += ldtlen;
		}
	}
	*readdata->curptr = '\0';

	readdata->curptr = (char *)NULL;
}

/* ޥǡ */

static char	*generate_macrodata(macrodata, ldtext)
MacroData	*macrodata;
char		*ldtext;
{
	char	*p;

	if ((p = strchr(ldtext, '=')) == (char *)NULL)
		return "Not Macro";
/*
	if (macrodata.datasize + 1 >= macrodata.areasize)
		alloc_macrodata(macrodata, 1 + 10);
*/

	return "Macro Success";
}

/* ƥȡǡ */

static char *generate_textdata(
	readdata, nest, lntext, masize, textdata)
TextData	*readdata;
int		nest;
char		lntext[BUFSIZ];
int		masize;
TextData	*textdata;
{
	int		amode, bmode;
	char		token[BUFSIZ], lvtoken[BUFSIZ], lvlntext[BUFSIZ];
	int		tlen, lvtlen, lntlen, lvlntlen;
	int		assize;
	TextData	textdatabr;
	int		r;
	int		i;
	void		get_texttoken();
	void		init_textdata();
	void		alloc_textdata();

#ifdef	DEBUG
(void)printf("generate_textdata --- nest = %d\n", nest);
(void)printf("generate_textdata --- lntext = %s\n", lntext);
#endif

	for (amode = 0, bmode = 0; ; ) {
		get_texttoken(readdata, token);
#ifdef	DEBUG
(void)printf("generate_textdata --- token = %s\n", token);
#endif
		if (*token == '#') {
			tlen = strlen(token);
			assize = 1 + tlen;
			if (textdata->datasize + assize >= textdata->areasize)
				alloc_textdata(textdata, assize + masize);
			textdata->datasize += assize;
			*textdata->curptr = ' ';
			textdata->curptr++;
			(void)strncpy(textdata->curptr, token, tlen);
			textdata->curptr += tlen;
			*textdata->curptr = '\0';
			(void)strcpy(lntext, token);
			continue;
		}
		if (amode) {
			if (check_datatype(token) != 1) {
			    (void)sprintf(
				message,
				"not integer after * (%s)(line number(%s))",
				token, lntext + 1);
			    return message;
			}
			r = atoi(token);
			if (r <= 0) {
			    (void)sprintf(
				message,
				"not positive integer after * (%s)(line number(%s))",
				token, lntext + 1);
			    return message;
			}
			if (bmode) {
				assize = (1 + textdatabr.datasize) * r;
				if (textdata->datasize + assize >= textdata->areasize)
					alloc_textdata(textdata, assize + masize);
				textdata->datasize += assize;
				for (i = 0; i < r; i++) {
					*textdata->curptr = ' ';
					textdata->curptr++;
					(void)strncpy(textdata->curptr, textdatabr.textdata,
						      textdatabr.datasize);
					textdata->curptr += textdatabr.datasize;
					*textdata->curptr = '\0';
				}
				free_textdata(&textdatabr);
				bmode = 0;
			}
			else {
				if (r > 1) {
					lvtlen = strlen(lvtoken);
					lvlntlen = strlen(lvlntext);
					assize = (1 + lvlntlen) + (1 + lvtlen) * (r - 1);
					if (textdata->datasize + assize >= textdata->areasize)
						alloc_textdata(textdata, assize + masize);
					textdata->datasize += assize;
					*textdata->curptr = ' ';
					textdata->curptr++;
					(void)strncpy(textdata->curptr, lvlntext, lvlntlen);
					textdata->curptr += lvlntlen;
					*textdata->curptr = '\0';
					for (i = 1; i < r; i++) {
						*textdata->curptr = ' ';
						textdata->curptr++;
						(void)strncpy(textdata->curptr, lvtoken,
							      lvtlen);
						textdata->curptr += lvtlen;
						*textdata->curptr = '\0';
					}
				}
			}
			amode = 0;
		}
		else {
			if (!strcmp(token, "*")) {
				amode = 1;
				continue;
			}
			if (bmode) {
				lntlen = strlen(lntext);
				assize = (1 + textdatabr.datasize) + (1 + lntlen);
				if (textdata->datasize + assize >= textdata->areasize)
					alloc_textdata(textdata, assize + masize);
				textdata->datasize += assize;
				*textdata->curptr = ' ';
				textdata->curptr++;
				(void)strncpy(textdata->curptr,
					      textdatabr.textdata,
					      textdatabr.datasize);
				textdata->curptr += textdatabr.datasize;
				*textdata->curptr = ' ';
				textdata->curptr++;
				(void)strncpy(textdata->curptr, lntext, lntlen);
				textdata->curptr += lntlen;
				*textdata->curptr = '\0';
				free_textdata(&textdatabr);
				bmode = 0;
			}
			if (*token == '\0') {
				if (nest != 0) {
				    (void)sprintf(
					message,
					"'(' not closed (line number(%s))",
					lntext + 1);
				    return message;
				}
				break;
			}
			else if (*token == '(') {
				init_textdata(&textdatabr);
				lntlen = strlen(lntext);
				assize = 1 + lntlen;
				alloc_textdata(&textdatabr, assize + masize);
				textdatabr.datasize = assize;
				textdatabr.curptr = textdatabr.textdata;
				*textdatabr.curptr = ' ';
				textdatabr.curptr++;
				(void)strncpy(textdatabr.curptr, lntext,
					      lntlen);
				textdatabr.curptr += lntlen;
				*textdatabr.curptr = '\0';
				if (generate_textdata(
				  readdata, nest + 1, lntext, masize,
				  &textdatabr))
					return message;
#ifdef	DEBUG
(void)printf("generate_textdata --- textdatabr (len) = %s (%d)\n",
	     textdatabr.textdata, strlen(textdatabr.textdata));
(void)printf("generate_textdata --- textdatabr.areasize, textdatabr.datasize = %d %d\n",
	     textdatabr.areasize, textdatabr.datasize);
#endif
				bmode = 1;
			}
			else if (*token == ')') {
				if (nest <= 0) {
				    (void)sprintf(
					message,
					"')' not opened (line number(%s))",
					lntext + 1);
				    return message;
				}
				break;
			}
			else {
				tlen = strlen(token);
				assize = 1 + tlen;
				if (textdata->datasize + assize >= textdata->areasize)
					alloc_textdata(textdata, assize + masize);
				textdata->datasize += assize;
				*textdata->curptr = ' ';
				textdata->curptr++;
				(void)strncpy(textdata->curptr, token, tlen);
				textdata->curptr += tlen;
				*textdata->curptr = '\0';
				(void)strcpy(lvtoken, token);
				(void)strcpy(lvlntext, lntext);
			}
		}
	}

	return (char *)NULL;
}

/*--------------------------------------------------------------------*/

/* ƥȡǡΥ */

/*
	οΥåʡοȥݥ󥿤οӡˤԲǽǤ롣
	äƥץޤǤλԤʤƤϤʤʤ
*/

char *scan_textdata(va_alist)
va_dcl
{
	va_list	ap;
	char	*format;
	int	ptrcnt;
	int	i;
	char	*argptr;
	char	token[BUFSIZ];
	char	*fp;
	int	dtype, stype;
	char	partformat[BUFSIZ];
	char 	*get_partformat();

	va_start(ap);

	format = va_arg(ap, char *);
	ptrcnt = get_textccnt(format, '%');
#ifdef	DEBUG
(void)printf("scan_textdata --- format = %s\n", format);
(void)printf("scan_textdata --- ptrcnt = %d\n", ptrcnt);
#endif

	for (fp = format, i = 0; i < ptrcnt; i++) {
		argptr = va_arg(ap, char *);
		for ( ; ; ) {
			get_texttoken(&textdata_scan, token);
#ifdef	DEBUG
(void)printf("scan_textdata --- token = %s\n", token);
#endif
			if (*token == '\0') {
				(void)sprintf(
					message,
					"data not found (line number(%d))",
					textdata_linenum);
				return message;
			}
			else if (*token == '#') {
				if (sscanf(token + 1, "%d", &textdata_linenum) != 1) {
				    (void)sprintf(
					message,
					"scan error (line number(%d))",
					textdata_linenum);
				    return message;
				}
			}
			else {
				fp = get_partformat(fp, partformat);
#ifdef	DEBUG
(void)printf("scan_textdata --- partformat = %s\n", partformat);
#endif
				dtype = check_datatype(token);
				stype = check_scantype(partformat);
#ifdef	DEBUG
(void)printf("scan_textdata --- dtype, stype = %d %d\n", dtype, stype);
#endif
/*
				if (dtype == 0 || stype == 0 || dtype != stype) {
*/
				if (dtype == 0                    ||
				    stype == 0                    ||
				    (stype != 3 && dtype != stype)  ) {
				    (void)sprintf(
					message,
					"scan type error (%s %s)(line number(%d))",
					token, partformat + 1, textdata_linenum);
				    return message;
				}
				if (sscanf(token, partformat, argptr) != 1) {
				    (void)sprintf(
					message,
					"scan error (data)(line number(%d))",
					textdata_linenum);
				    return message;
				}
				break;
			}
		}
	}

	va_end(ap);

	return (char *)NULL;
}

/*--------------------------------------------------------------------*/

/* ƥȡǡΥʥǡκ */

char *close_textdata()
{
	char	token[BUFSIZ];
	void	get_texttoken();
	void	free_textdata();
	void	init_textdata();

	for ( ; ; ) {
		get_texttoken(&textdata_scan, token);
		if (*token == '\0')
			break;
		else if (*token == '#')
			continue;
		else {
			(void)sprintf(message,
				      "more data exist (line number(%d))",
				      textdata_linenum);
			return message;
		}
	}

	free_textdata(&textdata_scan);

	return (char *)NULL;
}

/*--------------------------------------------------------------------*/

/* ޥǡν */

static void init_macrodata(macrodata)
MacroData	*macrodata;
{
	macrodata->areasize = 0;
	macrodata->datasize = 0;
	macrodata->macro = (Macro *)NULL;
}

/* ޥǡΰγ */

static void alloc_macrodata(macrodata, size)
MacroData	*macrodata;
int		size;
{
	void	exit();

	if (macrodata->macro == (Macro *)NULL) {
		if ((macrodata->macro = (Macro *)calloc((unsigned)size, sizeof(Macro)))
		    == (Macro *)NULL) {
		  (void)fprintf(
		    stderr,
		    "memory alloc error (alloc_macrodata)");
		  exit(1);
		}
		macrodata->areasize = size;
		macrodata->datasize = 0;
	}
	else {
		if ((macrodata->macro
			= (Macro *)realloc((char *)macrodata->macro,
					   (unsigned)(macrodata->areasize + size)
					   * sizeof(Macro)))
		    == (Macro *)NULL) {
		  (void)fprintf(
		    stderr,
		    "memory realloc error (alloc_macrodata)");
		    exit(1);
		}
		macrodata->areasize += size;
	}
}

/* ޥǡΰβ */

static void free_macrodata(macrodata)
MacroData	*macrodata;
{
	int	i;
	void	init_macrodata();

	for (i = 0; i < macrodata->datasize; i++) {
		free((macrodata->macro+i)->name);
		free((macrodata->macro+i)->value);
	}

	free((char *)macrodata->macro);

	init_macrodata(macrodata);
}

/*--------------------------------------------------------------------*/

/* ƥȡǡν */

static void init_textdata(textdata)
TextData	*textdata;
{
	textdata->areasize = 0;
	textdata->datasize = 0;
	textdata->curptr = (char *)NULL;
	textdata->textdata = (char *)NULL;
}

/* ƥȡǡΰγ */

static void alloc_textdata(textdata, size)
TextData	*textdata;
int		size;
{
	int	offset;
	void	exit();

	if (textdata->textdata == (char *)NULL) {
		if ((textdata->textdata = malloc((unsigned)size)) == (char *)NULL) {
		  (void)fprintf(
		    stderr,
		    "memory alloc error (alloc_textdata)");
		  exit(1);
		}
		textdata->areasize = size;
		textdata->datasize = 0;
		*textdata->textdata = '\0';
	}
	else {
		if (textdata->curptr != (char *)NULL) {
			offset = textdata->curptr - textdata->textdata;
		}
		if ((textdata->textdata
			= realloc(textdata->textdata,
				  (unsigned)(textdata->areasize + size)))
		    == (char *)NULL) {
		  (void)fprintf(
		    stderr,
		    "memory realloc error (alloc_textdata)");
		    exit(1);
		}
		textdata->areasize += size;
		if (textdata->curptr != (char *)NULL)
			textdata->curptr = textdata->textdata + offset;
	}
}

/* ƥȡǡΰβ */

static void free_textdata(textdata)
TextData	*textdata;
{
	void	init_textdata();

	free(textdata->textdata);

	init_textdata(textdata);
}

/*--------------------------------------------------------------------*/

/* ƥȡǡȡФ */

static void get_texttoken(textdata, token)
TextData	*textdata;
char		token[BUFSIZ];
{
	while (*textdata->curptr) {
		if (*textdata->curptr == ' ' || *textdata->curptr == '\t') {
			textdata->datasize++;
			*textdata->curptr++;
		}
		else
			break;
	}
		
	if (*textdata->curptr == '\0')
		*token = '\0';
	else if (*textdata->curptr == '*') {
		*token = '*';
		token++;
		*token = '\0';
		textdata->datasize++;
		*textdata->curptr++;
	}
	else if (*textdata->curptr == '(') {
		*token = '(';
		token++;
		*token = '\0';
		textdata->datasize++;
		*textdata->curptr++;
	}
	else if (*textdata->curptr == ')') {
		*token = ')';
		token++;
		*token = '\0';
		textdata->datasize++;
		*textdata->curptr++;
	}
	else {
		while (*textdata->curptr) {
			if (*textdata->curptr == '*' ||
			    *textdata->curptr == '(' ||
			    *textdata->curptr == ')' ||
			    *textdata->curptr == ' ' ||
			    *textdata->curptr == '\t'  ) {
				break;
			}
			else {
				*token = *textdata->curptr;
				textdata->datasize++;
				textdata->curptr++;
				token++;
				*token = '\0';
			}
		}
	}
}

/* ƥȡǡλʸ */

static int get_textccnt(textdata, c)
char	*textdata, c;
{
	int	cnt = 0;

	while (*textdata) {
		if (*textdata == c)
			cnt++;
		textdata++;
	}

	return cnt;
}

/* եޥåΤʬեޥåȤФ */

static char *get_partformat(format, partformat)
char	*format;
char	*partformat;
{
	int	mcnt = 0;
	char	*nmp = (char *)NULL;

#ifdef	DEBUG
(void)printf("get_partformat format --- %u\n", format);
#endif

	while (*format) {
		if (*format == '%')
			mcnt++;
		if (mcnt == 1) {
			*partformat = *format;
			partformat++;
			*partformat = '\0';
			format++;
		}
		else if (mcnt == 2) {
			nmp = format;
			break;
		}
	}

#ifdef	DEBUG
(void)printf("get_partformat nmp --- %u\n", nmp);
#endif

	return nmp;
}

/* ƥȡǡɽǡΥפĴ٤
   ʣΣգ̡̣ưʸˡ */

static int check_datatype(textdata)
char	*textdata;
{
	int	slen;
	int	pcnt;
	int	sflag;
	int	i;
	int	type;

	slen = strlen(textdata);

	if (slen == 0)
		type = 0;
	else if (slen == 1) {
		if (isdigit(*textdata))
			type = 1;
		else
			type = 3;
	}
	else {
		for (pcnt = 0, sflag = 0, i = 0; i < slen; i++) {
			if (isdigit(*textdata))
				;
			else if (*textdata == '.')
				pcnt++;
			else if (*textdata == '-' || *textdata == '+') {
				if (i != 0) {
					sflag = 1;
					break;
				}
			}
			else {
				sflag = 1;
				break;
			}
			textdata++;
		}
		if (sflag)
			type = 3;
		else {
			if (pcnt == 0)
				type = 1;
			else if (pcnt == 1)
				type = 2;
			else
				type = 3;
		}
	}

	return type;
}

/* ƥȡǡɽ󥿥פĴ٤
   ʣΣգ̡̣ưʸˡ */

static int check_scantype(textdata)
char	*textdata;
{
	int	type = 0;

	while (*textdata) {
		if (*textdata == 'd') {
			type = 1;
			break;
		}
		else if (*textdata == 'f' || *textdata == 'e') {
			type = 2;
			break;
		}
		else if (*textdata == 's') {
			type = 3;
			break;
		}
		textdata++;
	}

	return type;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
