/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aep_mval.c
----------------------------------------------------------------------*/

#include	"aedit.h"

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

int	move_align(alansrc, alandst)
int	alansrc, alandst;
{
	extern INFO	Info;
	int		i;
	char		*codealign;
	char		alname[MAX_ALIGN_NAME_LENG+1];
	int		mflag;
#ifdef	CHECK
	void		exit();
#endif

#ifdef	DEBUG
	(void)printf("move_align --- alansrc, alandst = %d %d\n", alansrc, alandst);
#endif

#ifdef	CHECK
	if ((alansrc < 0 || alansrc > Info.alignnum) ||
	    (alandst < 0 || alandst > Info.alignnum)   ) {
		(void)fprintf(stderr,
			      "move_align --- alignnum, alansrc, alandst = %d %d %d\n",
			      Info.alignnum, alansrc, alandst);
		exit(1);
	}
#endif

	if (alansrc + 1 < alandst) {
		(void)strncpy(alname,
			      (char *)(Info.alignname+alansrc),
			      MAX_ALIGN_NAME_LENG + 1);
		codealign = *(Info.codeAlign+alansrc);
		for (i = alansrc; i <= alandst - 2; i++) {
#ifdef	DEBUG
			(void)printf("(1) i = %d\n", i);
#endif
			(void)strncpy((char *)(Info.alignname+i),
				      (char *)(Info.alignname+i+1),
				      MAX_ALIGN_NAME_LENG + 1);
			*(Info.codeAlign+i) = *(Info.codeAlign+i+1);
		}
#ifdef	CHECK
		if (i != alandst - 1) {
		    (void)fprintf(
			stderr,
			"move_align --- alignnum, alansrc, alandst, i = %d %d %d %d\n",
			Info.alignnum, alansrc, alandst, i);
			exit(1);
		}
#endif
		(void)strncpy((char *)(Info.alignname+i),
			      alname,
			      MAX_ALIGN_NAME_LENG + 1);
		*(Info.codeAlign+i) = codealign;
		mflag = 1;
	}
	else if (alansrc > alandst) {
		(void)strncpy(alname,
			      (char *)(Info.alignname+alansrc),
			      MAX_ALIGN_NAME_LENG + 1);
		codealign = *(Info.codeAlign+alansrc);
		for (i = alansrc; i >= alandst + 1; i--) {
#ifdef	DEBUG
			(void)printf("(2) i = %d\n", i);
#endif
			(void)strncpy((char *)(Info.alignname+i),
				      (char *)(Info.alignname+i-1),
				      MAX_ALIGN_NAME_LENG + 1);
			*(Info.codeAlign+i) = *(Info.codeAlign+i-1);
		}
#ifdef	CHECK
		if (i != alandst) {
		    (void)fprintf(
			stderr,
			"move_align --- alignnum, alansrc, alandst, i = %d %d %d %d\n",
			Info.alignnum, alansrc, alandst, i);
			exit(1);
		}
#endif
		(void)strncpy((char *)(Info.alignname+i),
			      alname,
			      MAX_ALIGN_NAME_LENG + 1);
		*(Info.codeAlign+i) = codealign;
		mflag = 1;
	}
	else
		mflag = 0;

	return mflag;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
