/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aep_gltrupg.c
		Genealogical Tree (UPGMA)

----------------------------------------------------------------------*/

#include	"ae_gltree.h"

#include	<stdio.h>
#include	<string.h>
#include	<malloc.h>

/*--------------------------------------------------------------------*/

static IDataAry		dvcalc_index;
static int		dttb_size;
static DtTableElm	*dttb_data = (DtTableElm *)NULL;
static GlTreeElm	**gltr_btm = (GlTreeElm **)NULL;
static DtTbIndexElm	*dttbi_row, *dttbi_column;
static GlTreeElm	*gltree_root = (GlTreeElm *)NULL;

/*--------------------------------------------------------------------*/

#if	0
#define	TEST
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*
  饤ȡǥоݥǡη롣
  饤ȡǥоݥǡη뤿Ԥ
  ˤUPGMAˡʥ饤ΤǥåפΤ륫
ִΥȤʿѵΥˡˤѤ롣
    Υ롼Ȥ˳
*/

GlTreeElm	*get_tree_gltrupg()
{
	extern int		data_exist;
	extern INFO		Info;
#ifndef	TEST
	extern void		set_dttbdata();
#else
	extern void		set_dttbdata_test();
#endif
	extern void		free_gltree_root();
	extern void		alloc_idataary();
	extern void		alloc_idataary();
	extern void		set_dvcalcindex();
	extern void		alloc_dttable();
	extern void		alloc_gltree_btm();
	extern void		set_gltree_btm();
	extern void		alloc_dttbindex();
	extern void		set_dttbindex();
	extern void		set_gltree_posdata();
	extern void		free_idataary();
	extern void		free_dttable();
	extern void		free_gltree_btm();
	extern void		free_dttbindex();
#ifdef	DEBUG
	extern void		output_idataary_gltr();
	extern void		output_dttable_gltr();
	extern void		output_dttbindex_gltr();
	extern void		output_gltree_gltr();
#endif
	GlTreeElm		*create_gltree_gltrupg();

	free_gltree_root(&gltree_root);

#ifndef	TEST
	if (data_exist == 0)
		return (GlTreeElm *)NULL;
#else
	Info.alignnum = 8;
#endif

	alloc_gltree_btm(&Info, &gltr_btm);
	set_gltree_btm(&Info, gltr_btm);

	alloc_dttbindex(&Info, &dttbi_row);
	alloc_dttbindex(&Info, &dttbi_column);
	set_dttbindex(&Info, gltr_btm, dttbi_row, dttbi_column);

	alloc_idataary(&Info, &dvcalc_index);
	set_dvcalcindex(&Info, &dvcalc_index);
#ifdef	DEBUG
	output_idataary_gltr(&dvcalc_index);
#endif

	alloc_dttable(&Info, &dttb_size, &dttb_data);
#ifndef	TEST
	set_dttbdata(&Info, &dvcalc_index, dttb_data);
#else
	set_dttbdata_test(&Info, dttb_data);
#endif

#ifdef	DEBUG
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_row);
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_column);
	output_dttable_gltr(dttb_size, dttb_data);
#endif

	gltree_root = create_gltree_gltrupg(&Info,
					    dttbi_row, dttbi_column,
					    dttb_size, dttb_data);

	set_gltree_posdata(gltree_root);

#ifdef	DEBUG
/*
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_row);
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_column);
	output_dttable_gltr(dttb_size, dttb_data);
*/
	output_gltree_gltr(gltree_root);
#endif

	free_idataary(&dvcalc_index);
	free_dttable(&dttb_data);
	dttb_size = 0;
	free_gltree_btm(&gltr_btm);
	free_dttbindex(&dttbi_row);
	free_dttbindex(&dttbi_column);

	return gltree_root;
}

/*--------------------------------------------------------------------*/

/*
  饤ȡǥоݥǡη롣
    Υ롼Ȥ˳
*/

static GlTreeElm	*create_gltree_gltrupg(info, dttbirow, dttbicolumn,
					       dttbsize, dttbdata)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttbdata;	/* I:Υơ֥롦ǡ */
{
	int		i;
	GlTreeElm	*gltree;
	GlTreeElm	*set_gltree_gltrupg();
#if	0
	extern void	output_dttbindex_gltr();
	extern void	output_dttable_gltr();
	extern void	output_gltree_gltr();
#endif

	for (i = 0; i < info->alignnum - 1; i++) {
#if	0
		(void)printf("================================\n");
		(void)printf("create_gltree_gltrupg --- i = %d\n", i);
		(void)printf("================================\n");
		output_dttbindex_gltr(Info.alignnum - 1, dttbirow);
		output_dttbindex_gltr(Info.alignnum - 1, dttbicolumn);
		output_dttable_gltr(dttbsize, dttbdata);
#endif
		gltree = set_gltree_gltrupg(i + 1, info, dttbirow, dttbicolumn,
					    dttbsize, dttbdata);
#if	0
		output_dttbindex_gltr(Info.alignnum - 1, dttbirow);
		output_dttbindex_gltr(Info.alignnum - 1, dttbicolumn);
		output_dttable_gltr(dttbsize, dttbdata);
		output_gltree_gltr(gltree);
/*
		if (i == 0)
			break;
*/
#endif
	}

	return gltree;
}

/*
  ʬǤ롣
  ʥХʥꡦĥ꡼ˤϥܥȥࡦåפ롣
    ʬ
	  ʺǽλϷΥ롼Ȥ˳ǤȤʤ
*/

static GlTreeElm	*set_gltree_gltrupg(psn, info, dttbirow, dttbicolumn,
					    dttbsize, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int			minan;
	int			column, row;
	int			bsid, dlid;
	float			abdtv;
	GlTreeElm		*gltrelmnew;
	GlTreeElm		*gltrelmbs, *gltrelmdl;
	extern GlTreeElm	*alloc_gltrelm();
	extern void		merge_dttbindex_gltree();
	extern void		merge_dttable_gltree();
	extern void		fatal_error();
	int			get_minimum_dttable_gltrupg();
	void			set_branch_gltrupg();
/*
	void			merge_dttable_gltrupg();
*/

	minan = get_minimum_dttable_gltrupg(dttbsize, dttable);

	row = (dttable+minan)->row;
	column = (dttable+minan)->column;

	if (row < column) {
		bsid = row;
		dlid = column;
	}
	else if (row > column) {
		bsid = column;
		dlid = row;
	}
	else
		fatal_error("set_gltree_gltrupg", "row == column\n");

	abdtv = (dttable+minan)->distance / 2.0;

	gltrelmnew = alloc_gltrelm();
	gltrelmnew->dflag = GLTREE_ELM_BRCH;

	merge_dttbindex_gltree(info, gltrelmnew,
			       bsid, dlid,
			       dttbirow, dttbicolumn,
			       &gltrelmbs, &gltrelmdl);

	set_branch_gltrupg(abdtv, gltrelmbs, gltrelmdl, gltrelmnew);

/*
	merge_dttable_gltrupg(psn, info, minan, bsid, dlid, dttable);
*/
	merge_dttable_gltree(psn, info, minan, bsid, dlid, dttable);

	return gltrelmnew;
}

/*
  ΥǾȤʤΥơ֥Υǥå롣
    ΥǾȤʤΥơ֥Υǥå
*/

static int	get_minimum_dttable_gltrupg(dttbsize, dttable)
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int		i;
	int		sflag;
	float		distance;
	int		an;
#ifdef	CHECK
	extern void	fatal_error();
#endif

	for (sflag = 0, i = 0; i < dttbsize; i++) {
		if ((dttable+i)->eflag < 0)
			continue;
		if (!sflag) {
			distance = (dttable+i)->distance;
			an = i;
			sflag = 1;
		}
		else {
			if ((dttable+i)->distance < distance) {
				distance = (dttable+i)->distance;
				an = i;
			}
		}
	}

#ifdef	CHECK
	if (!sflag)
		fatal_error("get_minimum_dttable_gltrupg", "effective data not found\n");
#endif

	return an;
}

/*
  ʬǤ˳ƥǡꤹ
*/

static void	set_branch_gltrupg(abdtv, gltrelmbs, gltrelmdl, gltrelmnew)
float		abdtv;		/* I:ʬθеΥ */
GlTreeElm	*gltrelmbs;	/* I:ޡ¦η
				     ʷ */
GlTreeElm	*gltrelmdl;	/* I:ޡ¦η
				     ʷ */
GlTreeElm	*gltrelmnew;	/* O:˺ʬ
				     */
{
	float		cdtvbs, cdtvdl;
	float		btmdtvbs, btmdtvdl;
	int		btmflagbs, btmflagdl;
	extern void	fatal_error();

	if (gltrelmbs->dflag == GLTREE_ELM_BTM) {
		cdtvbs = abdtv - gltrelmbs->elmd.btm.abdtv;
		btmdtvbs = cdtvbs;
		btmflagbs = 1;
	}
	else if (gltrelmbs->dflag == GLTREE_ELM_BRCH) {
		cdtvbs = abdtv - gltrelmbs->elmd.brch.abdtv;
		btmdtvbs = MAX(gltrelmbs->elmd.brch.btmdtvleft,
			       gltrelmbs->elmd.brch.btmdtvright)
			 + cdtvbs;
		btmflagbs = 0;
	}
	else
		fatal_error("set_branch_gltrupg", "illegal dflag (base)\n");
	if (gltrelmdl->dflag == GLTREE_ELM_BTM) {
		cdtvdl = abdtv - gltrelmdl->elmd.btm.abdtv;
		btmdtvdl = cdtvdl;
		btmflagdl = 1;
	}
	else if (gltrelmdl->dflag == GLTREE_ELM_BRCH) {
		cdtvdl = abdtv - gltrelmdl->elmd.brch.abdtv;
		btmdtvdl = MAX(gltrelmdl->elmd.brch.btmdtvleft,
			       gltrelmdl->elmd.brch.btmdtvright)
			 + cdtvdl;
		btmflagdl = 0;
	}
	else
		fatal_error("set_branch_gltrupg", "illegal dflag (delete)\n");

	gltrelmnew->elmd.brch.abdtv = abdtv;

	if (btmflagbs && btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
		gltrelmnew->elmd.brch.rldtvright = cdtvdl;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
		gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
		gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
	}
	else if (btmflagbs && !btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
		gltrelmnew->elmd.brch.rldtvright = cdtvbs;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
		gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
		gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
	}
	else if (!btmflagbs && btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
		gltrelmnew->elmd.brch.rldtvright = cdtvdl;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
		gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
		gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
	}
	else if (!btmflagbs && !btmflagdl) {
		if (cdtvbs >= cdtvdl) {
			gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
			gltrelmnew->elmd.brch.rldtvright = cdtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
			gltrelmnew->elmd.brch.rldtvright = cdtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
}

/*--------------------------------------------------------------------*/
#if	0
/*--------------------------------------------------------------------*/

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
ޡ롣
*/

static void	merge_dttable_gltrupg(psn, info, minan, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		minan;		/* I:ΥǾȤʤΥơ֥
				     Υǥå */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	extern void	fatal_error();
	void		merge_dttable_column_gltrupg();
	void		merge_dttable_row_gltrupg();

	(dttable+minan)->eflag = -psn;

	if (dlid == 1)
		merge_dttable_row_gltrupg(psn, info, bsid, dlid, dttable);
	else if (dlid > 1 && dlid < info->alignnum) {
		merge_dttable_row_gltrupg(psn, info, bsid, dlid, dttable);
		merge_dttable_column_gltrupg(psn, info, bsid, dlid, dttable);
	}
	else if (dlid == info->alignnum)
		merge_dttable_column_gltrupg(psn, info, bsid, dlid, dttable);
	else
		fatal_error("merge_dttable_gltrupg", "illegal dlid\n");
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlid˹Ԥбդƥޡ롣
*/

static void	merge_dttable_row_gltrupg(psn, info, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = dlid + 1; i <= info->alignnum; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, dlid, i);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
			(void)fprintf(stderr,
				      "merge_dttable_row_gltrupg --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance = ((dttable+lvsn-1)->distance
					      + (dttable+dlsn-1)->distance)
					     / 2.0;
		(dttable+dlsn-1)->eflag = -psn;
	}
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlidбդƥޡ롣
*/

static void	merge_dttable_column_gltrupg(psn, info, bsid, dlid, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = 1; i < dlid; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, i, dlid);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
		    (void)fprintf(stderr,
				  "merge_dttable_column_gltrupg --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance = ((dttable+lvsn-1)->distance
					      + (dttable+dlsn-1)->distance)
					     / 2.0;
		(dttable+dlsn-1)->eflag = -psn;
	}
}

/*--------------------------------------------------------------------*/
#endif
/*--------------------------------------------------------------------*/

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
