/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aep_gltrnj.c
		Genealogical Tree (NJ)

----------------------------------------------------------------------*/

#include	"ae_gltree.h"

#include	<stdio.h>
#include	<string.h>
#include	<malloc.h>

/*--------------------------------------------------------------------*/

static IDataAry		dvcalc_index;
static int		dttb_size;
static DtTableElm	*dttb_data = (DtTableElm *)NULL;
static GlTreeElm	**gltr_btm = (GlTreeElm **)NULL;
static DtTbIndexElm	*dttbi_row, *dttbi_column;
static GlTreeElm	*gltree_root = (GlTreeElm *)NULL;

/*--------------------------------------------------------------------*/

#if	0
#define	TEST
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*
  饤ȡǥоݥǡη롣
  饤ȡǥоݥǡη뤿Ԥ
  ˤUPGMAˡʥ饤ΤǥåפΤ륫
ִΥȤٷˡˤѤ롣
    Υ롼Ȥ˳
*/

GlTreeElm	*get_tree_gltrnj()
{
	extern int		data_exist;
	extern INFO		Info;
#ifndef	TEST
	extern void		set_dttbdata();
#else
	extern void		set_dttbdata_test();
#endif
	extern void		free_gltree_root();
	extern void		alloc_idataary();
	extern void		alloc_idataary();
	extern void		set_dvcalcindex();
	extern void		alloc_dttable();
	extern void		alloc_gltree_btm();
	extern void		set_gltree_btm();
	extern void		alloc_dttbindex();
	extern void		set_dttbindex();
	extern void		set_gltree_posdata();
	extern void		free_idataary();
	extern void		free_dttable();
	extern void		free_gltree_btm();
	extern void		free_dttbindex();
#ifdef	DEBUG
	extern void		output_idataary_gltr();
	extern void		output_dttable_gltr();
	extern void		output_dttbindex_gltr();
	extern void		output_gltree_gltr();
#endif
	GlTreeElm		*create_gltree_gltrnj();

	free_gltree_root(&gltree_root);

#ifndef	TEST
	if (data_exist == 0)
		return (GlTreeElm *)NULL;
#else
	Info.alignnum = 8;
#endif

	alloc_gltree_btm(&Info, &gltr_btm);
	set_gltree_btm(&Info, gltr_btm);

	alloc_dttbindex(&Info, &dttbi_row);
	alloc_dttbindex(&Info, &dttbi_column);
	set_dttbindex(&Info, gltr_btm, dttbi_row, dttbi_column);

	alloc_idataary(&Info, &dvcalc_index);
	set_dvcalcindex(&Info, &dvcalc_index);
#ifdef	DEBUG
	output_idataary_gltr(&dvcalc_index);
#endif

	alloc_dttable(&Info, &dttb_size, &dttb_data);
#ifndef	TEST
	set_dttbdata(&Info, &dvcalc_index, dttb_data);
#else
	set_dttbdata_test(&Info, dttb_data);
#endif

#ifdef	DEBUG
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_row);
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_column);
	output_dttable_gltr(dttb_size, dttb_data);
#endif

	gltree_root = create_gltree_gltrnj(&Info,
					   dttbi_row, dttbi_column,
					   dttb_size, dttb_data);

	set_gltree_posdata(gltree_root);

#ifdef	DEBUG
/*
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_row);
	output_dttbindex_gltr(Info.alignnum - 1, dttbi_column);
	output_dttable_gltr(dttb_size, dttb_data);
*/
	output_gltree_gltr(gltree_root);
#endif

	free_idataary(&dvcalc_index);
	free_dttable(&dttb_data);
	dttb_size = 0;
	free_gltree_btm(&gltr_btm);
	free_dttbindex(&dttbi_row);
	free_dttbindex(&dttbi_column);

	return gltree_root;
}

/*--------------------------------------------------------------------*/

/*
  饤ȡǥоݥǡη롣
    Υ롼Ȥ˳
*/

static GlTreeElm	*create_gltree_gltrnj(info,
					      dttbirow, dttbicolumn,
					      dttbsize, dttbdata)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttbdata;	/* I:Υơ֥롦ǡ */
{
	int		i;
	GlTreeElm	*gltree;
	void		set_dtv_gltrnj();
	GlTreeElm	*set_gltree_a_gltrnj();
	GlTreeElm	*set_gltree_b_gltrnj();
#if	0
	extern void	output_dttbindex_gltr();
	extern void	output_dttable_gltr();
	extern void	output_gltree_gltr();
#endif

	for (i = 1; i <= info->alignnum - 2; i++) {
		set_dtv_gltrnj(info, info->alignnum - i + 1,
			       dttbirow, dttbicolumn, dttbdata);
#if	0
		(void)printf("===============================\n");
		(void)printf("create_gltree_gltrnj --- i = %d\n", i);
		(void)printf("===============================\n");
		output_dttbindex_gltr(Info.alignnum - 1, dttbirow);
		output_dttbindex_gltr(Info.alignnum - 1, dttbicolumn);
		output_dttable_gltr(dttbsize, dttbdata);
#endif
		gltree = set_gltree_a_gltrnj(i, info, info->alignnum - i + 1,
					     dttbirow, dttbicolumn, dttbsize, dttbdata);
#if	0
		output_dttbindex_gltr(Info.alignnum - 1, dttbirow);
		output_dttbindex_gltr(Info.alignnum - 1, dttbicolumn);
		output_dttable_gltr(dttbsize, dttbdata);
		output_gltree_gltr(gltree);
/*
		if (i == 0)
			break;
*/
#endif
	}

	gltree = set_gltree_b_gltrnj(dttbirow, dttbicolumn, dttbsize, dttbdata);

	return gltree;
}

/*
  뤿ɬפʳƼεΥǡꤹ롣
*/

void	set_dtv_gltrnj(info, dtmrsize,
		       dttbirow, dttbicolumn, dttbdata)
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		dtmrsize;	/* I:ΥΥ */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
DtTableElm	*dttbdata;	/* I:Υơ֥롦ǡ */
{
	int		i, j;
	float		tdtv;	/*  */
	float		idtv;	/* i */
	int		sn;
	extern int	get_dttable_index();
#ifdef	CHECK
	extern void	fatal_error();
#endif

	tdtv = 0.0; 

	for (i = 1; i <= info->alignnum; i++) {
		if (i < info->alignnum) {
			if ((dttbirow+i-1)->gltrelm == (GlTreeElm *)NULL   )
				continue;
		}
		if (i > 1) {
			if ((dttbicolumn+i-2)->gltrelm == (GlTreeElm *)NULL)
				continue;
		}
		idtv = 0.0;
		for (j = 1; j < i; j++) {
			if ((dttbirow+j-1)->gltrelm == (GlTreeElm *)NULL)
				continue;
			sn = get_dttable_index(info->alignnum, j, i);
			idtv += (dttbdata+sn-1)->distance;
		}
		for (j = i + 1; j <= info->alignnum; j++) {
			if ((dttbicolumn+j-2)->gltrelm == (GlTreeElm *)NULL)
				continue;
			sn = get_dttable_index(info->alignnum, i, j);
			idtv += (dttbdata+sn-1)->distance;
		}
		if (i < info->alignnum)
			(dttbirow+i-1)->idtv = idtv;
		if (i > 1)
			(dttbicolumn+i-2)->idtv = idtv;
		tdtv += idtv;
	}

	tdtv /= 2.0;

	for (i = 1; i < info->alignnum; i++) {
		for (j = i + 1; j <= info->alignnum; j++) {
			sn = get_dttable_index(info->alignnum, i, j);
			if ((dttbdata+sn-1)->eflag < 0)
				continue;
			(dttbdata+sn-1)->rcdtv = (2.0 * tdtv
						  - (dttbirow+i-1)->idtv 
						  - (dttbicolumn+j-2)->idtv)
					       / (float)(2 * (dtmrsize - 2))
					       + (dttbdata+sn-1)->distance / 2.0;
#ifdef	CHECK
if ((dttbdata+sn-1)->rcdtv <= 0.0) {
	(void)printf("set_dtv_gltrnj --- (dttbdata+sn-1)->rcdtv <= 0.0\n");
	(void)printf("i, j = %d %d\n", i, j);
	(void)printf("sn = %d\n", sn);
	(void)printf("tdtv = %f\n", tdtv);
	(void)printf("2 * tdtv = %f\n", 2 * tdtv);
	(void)printf("(dttbirow+i-1)->idtv = %f\n",
		     (dttbirow+i-1)->idtv);
	(void)printf("(dttbicolumn+j-2)->idtv = %f\n",
		     (dttbicolumn+j-2)->idtv);
	(void)printf("(float)(2 * (dtmrsize - 2)) = %f\n",
		     (float)(2 * (dtmrsize - 2)));
	(void)printf("(dttbdata+sn-1)->distance / 2.0 = %f\n",
		     (dttbdata+sn-1)->distance / 2.0);
	(void)fprintf(stderr,
		      "set_dtv_gltrnj --- (dttbdata+sn-1)->rcdtv <= 0.0\n");
/*
	fatal_error("set_dtv_gltrnj", "(dttbdata+sn-1)->rcdtv <= 0.0\n");
*/
}
#endif
		}
	}
}

/*
  ʬǤʺǽʳΰޤǤνˡ
  ʥХʥꡦĥ꡼ˤϥܥȥࡦåפ롣
    ʬ
  ͡ǤޤǤμºݤεΥ
*/

static GlTreeElm	*set_gltree_a_gltrnj(psn, info, dtmrsize,
					     dttbirow, dttbicolumn,
					     dttbsize, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		dtmrsize;	/* I:ΥΥ */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int			minan;
	int			column, row;
	float			rldtvrow, rldtvcolumn;
	float			rldtvbs, rldtvdl;
	int			bsid, dlid;
	GlTreeElm		*gltrelmnew;
	GlTreeElm		*gltrelmbs, *gltrelmdl;
	extern GlTreeElm	*alloc_gltrelm();
	extern void		merge_dttbindex_gltree();
	extern void		merge_dttable_gltree();
	extern void		fatal_error();
	int			get_minimum_dttable_gltrnj();
	void			set_branch_gltrnj();

	minan = get_minimum_dttable_gltrnj(dttbsize, dttable);

	row = (dttable+minan)->row;
	column = (dttable+minan)->column;

	rldtvrow = ((float)(dtmrsize - 2) * (dttable+minan)->distance
		   + (dttbirow+row-1)->idtv 
		   - (dttbicolumn+column-2)->idtv)
		/ (float)(2 * (dtmrsize - 2));
	rldtvcolumn = ((float)(dtmrsize - 2) * (dttable+minan)->distance
		      + (dttbicolumn+column-2)->idtv
		      - (dttbirow+row-1)->idtv)
		   / (float)(2 * (dtmrsize - 2));

	if (row < column) {
		bsid = row;
		dlid = column;
		rldtvbs = rldtvrow;
		rldtvdl = rldtvcolumn;
	}
	else if (row > column) {
		bsid = column;
		dlid = row;
		rldtvbs = rldtvcolumn;
		rldtvdl = rldtvrow;
	}
	else
		fatal_error("set_gltree_gltrnj", "row == column\n");

	gltrelmnew = alloc_gltrelm();
	gltrelmnew->dflag = GLTREE_ELM_BRCH;

	merge_dttbindex_gltree(info, gltrelmnew,
			       bsid, dlid, dttbirow, dttbicolumn,
			       &gltrelmbs, &gltrelmdl);

	set_branch_gltrnj(rldtvbs, rldtvdl, gltrelmbs, gltrelmdl, gltrelmnew);

	merge_dttable_gltree(psn, info, minan, bsid, dlid, dttable);

	return gltrelmnew;
}

/*
  ʬǤʺǽʳνˡ
    ʬǡʷΥ롼Ȥ˳ǡ
*/

static GlTreeElm	*set_gltree_b_gltrnj(dttbirow, dttbicolumn,
					     dttbsize, dttable)
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int			minan;
	int			column, row;
	GlTreeElm		*gltrelmbs, *gltrelmdl;
	GlTreeElm		*gltrelmnew;
	float			dtvbs, dtvdl;
	float			diffbs, diffdl;
	float			dtv0, dtv1, dtv2;
	float			rldtvbs, rldtvdl;	/* ʬʸ
							   ˤǤ
							   ľǤ
							   Ǥμºݤε
							   Υ */
	extern void		fatal_error();
	extern GlTreeElm	*alloc_gltrelm();
	int			get_minimum_dttable_gltrnj();
	void			set_branch_gltrnj();

	minan = get_minimum_dttable_gltrnj(dttbsize, dttable);

	row = (dttable+minan)->row;
	column = (dttable+minan)->column;

	gltrelmbs = (dttbirow+row-1)->gltrelm;
	gltrelmdl = (dttbicolumn+column-2)->gltrelm;

	if (gltrelmbs->dflag == GLTREE_ELM_BTM)
		dtvbs = 0.0;
	else if (gltrelmbs->dflag == GLTREE_ELM_BRCH)
		dtvbs = gltrelmbs->elmd.brch.rlrldtvavrg;
	else
		fatal_error("set_gltree_b_gltrnj", "illegal dflag (base)\n");
	if (gltrelmdl->dflag == GLTREE_ELM_BTM)
		dtvdl = 0.0;
	else if (gltrelmdl->dflag == GLTREE_ELM_BRCH)
		dtvdl = gltrelmdl->elmd.brch.rlrldtvavrg;
	else
		fatal_error("set_gltree_b_gltrnj", "illegal dflag (delete)\n");
#if	1
	dtv0 = (dttable+minan)->distance;
	dtv1 =  dtv0 / 2.0;
	diffbs = dtv1 - dtvbs;
	diffdl = dtv1 - dtvdl;
	if (diffbs >= 0.0 && diffdl >= 0.0) {
		rldtvbs = dtv1;
		rldtvdl = dtv1;
	}
	else if (diffbs < 0.0 && diffdl >= 0.0) {
		rldtvbs = dtvbs;
		rldtvdl = dtv0 - dtvbs;
	}
	else if (diffbs >= 0.0 && diffdl < 0.0) {
		rldtvbs = dtv0 - dtvdl;
		rldtvdl = dtvdl;
	}
	else {
		dtv2 = ((dttable+minan)->distance - dtvbs - dtvdl) / 2.0;
		rldtvbs = dtvbs + dtv2;
		rldtvdl = dtvdl + dtv2;
	}
#else
	dtv = ((dttable+minan)->distance - dtvbs - dtvdl) / 2.0;
	rldtvbs = dtvbs + dtv;
	rldtvdl = dtvdl + dtv;
#endif

	gltrelmnew = alloc_gltrelm();
	gltrelmnew->dflag = GLTREE_ELM_BRCH;

	set_branch_gltrnj(rldtvbs, rldtvdl, gltrelmbs, gltrelmdl, gltrelmnew);

	return gltrelmnew;
}

/*
  ΥǾȤʤΥơ֥Υǥå롣
    ΥǾȤʤΥơ֥Υǥå
*/

static int	get_minimum_dttable_gltrnj(dttbsize, dttable)
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int		i;
	int		sflag;
	float		rcdtv;
	int		an;
#ifdef	CHECK
	extern void	fatal_error();
#endif

	for (sflag = 0, i = 0; i < dttbsize; i++) {
		if ((dttable+i)->eflag < 0)
			continue;
		if (!sflag) {
			rcdtv = (dttable+i)->rcdtv;
			an = i;
			sflag = 1;
		}
		else {
			if ((dttable+i)->rcdtv < rcdtv) {
				rcdtv = (dttable+i)->rcdtv;
				an = i;
			}
		}
	}

#ifdef	CHECK
	if (!sflag)
		fatal_error("get_minimum_dttable_gltrnj", "effective data not found\n");
#endif

	return an;
}

/*
  ʬǤ˳ƥǡꤹ
*/

static void	set_branch_gltrnj(rldtvbs, rldtvdl,
				    gltrelmbs, gltrelmdl, gltrelmnew)
float		rldtvbs;	/* I:ʬʸߡˤǤޡ
				     ¦ľˤǤޤǤμºݤε
				     Υ */
float		rldtvdl;	/* I:ʬʸߡˤǤޡ
				     ¦ľˤǤޤǤμºݤε
				     Υ */
GlTreeElm	*gltrelmbs;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmdl;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmnew;	/* O:˺ʬ
				     */
{
	float		cdtvbs, cdtvdl;		/* ߤǤľ
						   ǤޤǤ³Υ */
	float		abdtvbs, abdtvdl;	/* ʷκǲ
						   ˤеΥ */
	float		abdtvdiff;
	float		btmdtvbs, btmdtvdl;	/* κǲ
						   ޤǤεΥκ
						   ľ */
	float		btmdtvlbs, btmdtvldl;	/* κǲ
						   ޤǤεΥκ
						   ʸߡ */
	int		btmflagbs, btmflagdl;	/* κǲ
						   ե饰 */
	extern void	fatal_error();
	void		move_adtree_gltrnj();

	if (gltrelmbs->dflag == GLTREE_ELM_BTM) {
		cdtvbs = rldtvbs;
		if (cdtvbs < 0.0)
			fatal_error("set_branch_gltrnj", "cdtvbs < 0.0\n");

		abdtvbs = gltrelmbs->elmd.btm.abdtv + cdtvbs;
		btmdtvbs = cdtvbs;
		btmflagbs = 1;
	}
	else if (gltrelmbs->dflag == GLTREE_ELM_BRCH) {
		cdtvbs = rldtvbs - gltrelmbs->elmd.brch.rlrldtvavrg;
		if (cdtvbs < 0.0) {
(void)printf("cdtvbs < 0.0\n");
			cdtvbs = 0.0;
			rldtvbs = gltrelmbs->elmd.brch.rlrldtvavrg;
		}

		abdtvbs = gltrelmbs->elmd.brch.abdtv + cdtvbs;
		btmdtvlbs = MAX(gltrelmbs->elmd.brch.btmdtvleft,
				gltrelmbs->elmd.brch.btmdtvright);
		btmdtvbs = btmdtvlbs + cdtvbs;
		btmflagbs = 0;
	}
	else
		fatal_error("set_branch_gltrnj", "illegal dflag (base)\n");
	if (gltrelmdl->dflag == GLTREE_ELM_BTM) {
		cdtvdl = rldtvdl;
		if (cdtvdl < 0.0)
			fatal_error("set_branch_gltrnj", "cdtvdl < 0.0\n");

		abdtvdl = gltrelmdl->elmd.btm.abdtv + cdtvdl;
		btmdtvdl = cdtvdl;
		btmflagdl = 1;
	}
	else if (gltrelmdl->dflag == GLTREE_ELM_BRCH) {
		cdtvdl = rldtvdl - gltrelmdl->elmd.brch.rlrldtvavrg;
		if (cdtvdl < 0.0) {
(void)printf("cdtvdl < 0.0\n");
			cdtvdl = 0.0;
			rldtvdl = gltrelmdl->elmd.brch.rlrldtvavrg;
		}

		abdtvdl = gltrelmdl->elmd.brch.abdtv + cdtvdl;
		btmdtvldl = MAX(gltrelmdl->elmd.brch.btmdtvleft,
				gltrelmdl->elmd.brch.btmdtvright);
		btmdtvdl = btmdtvldl + cdtvdl;
		btmflagdl = 0;
	}
	else
		fatal_error("set_branch_gltrnj", "illegal dflag (delete)\n");

	gltrelmnew->elmd.brch.rlrldtvavrg = (rldtvbs +rldtvdl) / 2.0;

	if (abdtvbs < abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvdl;
		abdtvdiff = abdtvdl - abdtvbs;
		move_adtree_gltrnj(gltrelmbs, abdtvdiff);
	}
	else if (abdtvbs > abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvbs;
		abdtvdiff = abdtvbs - abdtvdl;
		move_adtree_gltrnj(gltrelmdl, abdtvdiff);
	}
	else
		gltrelmnew->elmd.brch.abdtv = abdtvbs;

	if (btmflagbs && btmflagdl) {
		if (cdtvbs <= cdtvdl) {
			gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
			gltrelmnew->elmd.brch.rldtvright = cdtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
			gltrelmnew->elmd.brch.rldtvright = cdtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
	else if (btmflagbs && !btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
		gltrelmnew->elmd.brch.rldtvright = cdtvbs;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
		gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
		gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
	}
	else if (!btmflagbs && btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
		gltrelmnew->elmd.brch.rldtvright = cdtvdl;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
		gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
		gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
	}
	else if (!btmflagbs && !btmflagdl) {
		if (btmdtvlbs <= btmdtvldl) {
			gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
			gltrelmnew->elmd.brch.rldtvright = cdtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
			gltrelmnew->elmd.brch.rldtvright = cdtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
}

#if	0

/*
  ʬǤ˳ƥǡꤹʺǾ
*/

static void	set_branch_t_gltrnj(rldtvbs, rldtvdl,
				  gltrelmbs, gltrelmdl, gltrelmnew)
float		rldtvbs;	/* I:ʬǤΥޡ¦η
				     ǤޤǤμºݤεΥ */
float		rldtvdl;	/* I:ʬǤΥޡ¦η
				     ǤޤǤμºݤεΥ */
GlTreeElm	*gltrelmbs;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmdl;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmnew;	/* O:˺ʬ
				     */
{
	float		abdtvbs, abdtvdl, abdtvdiff;
	float		btmdtvbs, btmdtvdl;
	float		btmdtvlbs, btmdtvldl;
	int		btmflagbs, btmflagdl;
	extern void	fatal_error();
	void		move_adtree_gltrnj();

	if (gltrelmbs->dflag == GLTREE_ELM_BTM) {
		abdtvbs = gltrelmbs->elmd.btm.abdtv + rldtvbs;
		btmdtvbs = rldtvbs;
		btmflagbs = 1;
	}
	else if (gltrelmbs->dflag == GLTREE_ELM_BRCH) {
		abdtvbs = gltrelmbs->elmd.brch.abdtv + rldtvbs;
		btmdtvlbs = MAX(gltrelmbs->elmd.brch.btmdtvleft,
				gltrelmbs->elmd.brch.btmdtvright);
		btmdtvbs = btmdtvlbs + rldtvbs;
		btmflagbs = 0;
	}
	else
		fatal_error("set_branch_t_gltrnj", "illegal dflag (base)\n");
	if (gltrelmdl->dflag == GLTREE_ELM_BTM) {
		abdtvdl = gltrelmdl->elmd.btm.abdtv + rldtvdl;
		btmdtvdl = rldtvdl;
		btmflagdl = 1;
	}
	else if (gltrelmdl->dflag == GLTREE_ELM_BRCH) {
		abdtvdl = gltrelmdl->elmd.brch.abdtv + rldtvdl;
		btmdtvldl = MAX(gltrelmdl->elmd.brch.btmdtvleft,
				gltrelmdl->elmd.brch.btmdtvright);
		btmdtvdl = btmdtvldl + rldtvdl;
		btmflagdl = 0;
	}
	else
		fatal_error("set_branch_t_gltrnj", "illegal dflag (delete)\n");

	if (abdtvbs < abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvdl;
		abdtvdiff = abdtvdl - abdtvbs;
		move_adtree_gltrnj(gltrelmbs, abdtvdiff);
	}
	else if (abdtvbs > abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvbs;
		abdtvdiff = abdtvbs - abdtvdl;
		move_adtree_gltrnj(gltrelmdl, abdtvdiff);
	}
	else
		gltrelmnew->elmd.brch.abdtv = abdtvbs;

	if (btmflagbs && btmflagdl) {
		if (rldtvbs <= rldtvdl) {
			gltrelmnew->elmd.brch.rldtvleft = rldtvbs;
			gltrelmnew->elmd.brch.rldtvright = rldtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = rldtvdl;
			gltrelmnew->elmd.brch.rldtvright = rldtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
	else if (btmflagbs && !btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = rldtvdl;
		gltrelmnew->elmd.brch.rldtvright = rldtvbs;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
		gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
		gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
	}
	else if (!btmflagbs && btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = rldtvbs;
		gltrelmnew->elmd.brch.rldtvright = rldtvdl;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
		gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
		gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
	}
	else if (!btmflagbs && !btmflagdl) {
		if (btmdtvlbs <= btmdtvldl) {
			gltrelmnew->elmd.brch.rldtvleft = rldtvbs;
			gltrelmnew->elmd.brch.rldtvright = rldtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = rldtvdl;
			gltrelmnew->elmd.brch.rldtvright = rldtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
}

#endif

/*
  ǰʲηꤵ줿Υư
  κǲеΥʵΥˤ򹹿
  ȥåץ˺ƵŪ˸ƤФʤư롣
*/

void	move_adtree_gltrnj(gltree, distance)
GlTreeElm	*gltree;	/* I: */
float		distance;	/* I:ưΥ */
{
	void		move_adtree_gltrnj();
	extern void	fatal_error();

	if (gltree != (GlTreeElm *)NULL) {
		if (gltree->dflag == GLTREE_ELM_BTM)
			gltree->elmd.btm.abdtv += distance;
		else if (gltree->dflag == GLTREE_ELM_BRCH) {
			gltree->elmd.brch.abdtv += distance;
			move_adtree_gltrnj((GlTreeElm *)gltree->elmd.brch.left,
					    distance);
			move_adtree_gltrnj((GlTreeElm *)gltree->elmd.brch.right,
					    distance);
		}
		else
			fatal_error("move_adtree_gltrnj", "illegal dflag (right)\n");
	}
	else
		fatal_error("move_adtree_gltrnj", "gltree == (GlTreeElm *)NULL\n");
}

/*--------------------------------------------------------------------*/
#if	1
/*--------------------------------------------------------------------*/

/* ޤǤεΥ */

/*
  ʬǤʺǽʳΰޤǤνˡ
  ʥХʥꡦĥ꡼ˤϥܥȥࡦåפ롣
    ʬ
*/

static GlTreeElm	*set_gltree_a_gltrnj_2(psn, info, dtmrsize,
					       dttbirow, dttbicolumn,
					       dttbsize, dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		dtmrsize;	/* I:ΥΥ */
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int			minan;
	int			column, row;
	float			cdtvrow, cdtvcolumn;
	float			cdtvbs, cdtvdl;
	int			bsid, dlid;
	GlTreeElm		*gltrelmnew;
	GlTreeElm		*gltrelmbs, *gltrelmdl;
	extern GlTreeElm	*alloc_gltrelm();
	extern void		merge_dttbindex_gltree();
	int			get_minimum_dttable_gltrnj();
	void			set_branch_gltrnj_2();
	void			merge_dttable_gltrnj_2();
	void			exit();

	minan = get_minimum_dttable_gltrnj(dttbsize, dttable);

	row = (dttable+minan)->row;
	column = (dttable+minan)->column;

	cdtvrow = ((float)(dtmrsize - 2) * (dttable+minan)->distance
		   + (dttbirow+row-1)->idtv 
		   - (dttbicolumn+column-2)->idtv)
		/ (float)(2 * (dtmrsize - 2));
	cdtvcolumn = ((float)(dtmrsize - 2) * (dttable+minan)->distance
		      + (dttbicolumn+column-2)->idtv
		      - (dttbirow+row-1)->idtv)
		   / (float)(2 * (dtmrsize - 2));

	if (cdtvrow < 0.0) {
		cdtvrow = 0.0;
#ifdef	DEBUG
		(void)printf("set_gltree_a_gltrnj_2 --- cdtvrow < 0.0\n");
		(void)printf("minan = %d\n", minan);
		(void)printf("row, column = %d %d\n", row, column);
		(void)printf("dtmrsize = %d\n", dtmrsize);
		(void)printf("(dttable+minan)->distance = %f\n",
			     (dttable+minan)->distance);
		(void)printf("(dttbirow+row-1)->idtv = %f\n",
			     (dttbirow+row-1)->idtv);
		(void)printf("(dttbicolumn+column-2)->idtv = %f\n",
			     (dttbicolumn+column-2)->idtv);
#endif
		(void)fprintf(stderr, "set_gltree_a_gltrnj_2 --- cdtvrow < 0.0\n");
	}
	if (cdtvcolumn < 0.0) {
		cdtvcolumn = 0.0;
#ifdef	DEBUG
		(void)printf("set_gltree_a_gltrnj_2 --- cdtvcolumn < 0.0\n");
		(void)printf("minan = %d\n", minan);
		(void)printf("row, column = %d %d\n", row, column);
		(void)printf("dtmrsize = %d\n", dtmrsize);
		(void)printf("(dttable+minan)->distance = %f\n",
			     (dttable+minan)->distance);
		(void)printf("(dttbirow+row-1)->idtv = %f\n",
			     (dttbirow+row-1)->idtv);
		(void)printf("(dttbicolumn+column-2)->idtv = %f\n",
			     (dttbicolumn+column-2)->idtv);
#endif
		(void)fprintf(stderr, "set_gltree_a_gltrnj_2 --- cdtvcolumn < 0.0\n");
	}

	if (row < column) {
		bsid = row;
		dlid = column;
		cdtvbs = cdtvrow;
		cdtvdl = cdtvcolumn;
	}
	else if (row > column) {
		bsid = column;
		dlid = row;
		cdtvbs = cdtvcolumn;
		cdtvdl = cdtvrow;
	}
	else {
		(void)fprintf(stderr, "set_gltree_gltrnj --- row == column\n");
		exit(1);
	}

	gltrelmnew = alloc_gltrelm();
	gltrelmnew->dflag = GLTREE_ELM_BRCH;

	merge_dttbindex_gltree(info, gltrelmnew,
			       bsid, dlid, dttbirow, dttbicolumn,
			       &gltrelmbs, &gltrelmdl);

	set_branch_gltrnj_2(cdtvbs, cdtvdl, gltrelmbs, gltrelmdl, gltrelmnew);

	merge_dttable_gltrnj_2(psn, info, minan, bsid, dlid, cdtvbs,
			       dttable);

	return gltrelmnew;
}

/*
  ʬǤʺǽʳνˡ
    ʬǡʷΥ롼Ȥ˳ǡ
*/

static GlTreeElm	*set_gltree_b_gltrnj_2(dttbirow, dttbicolumn,
					       dttbsize, dttable)
DtTbIndexElm	*dttbirow;	/* I:Υơ֥롦ǥåʹԡ */
DtTbIndexElm	*dttbicolumn;	/* I:Υơ֥롦ǥå */
int		dttbsize;	/* I:Υơ֥롦 */
DtTableElm	*dttable;	/* I:Υơ֥ */
{
	int			minan;
	int			column, row;
	GlTreeElm		*gltrelmnew;
	float			cdtv;
	int			get_minimum_dttable_gltrnj();
	extern GlTreeElm	*alloc_gltrelm();
	void			set_branch_gltrnj_2();

	minan = get_minimum_dttable_gltrnj(dttbsize, dttable);

	row = (dttable+minan)->row;
	column = (dttable+minan)->column;

	gltrelmnew = alloc_gltrelm();
	gltrelmnew->dflag = GLTREE_ELM_BRCH;

	cdtv = (dttable+minan)->distance / 2.0;
	set_branch_gltrnj_2(cdtv, cdtv,
			    (dttbirow+row-1)->gltrelm, (dttbicolumn+column-2)->gltrelm,
			    gltrelmnew);

	return gltrelmnew;
}

/*
  ʬǤ˳ƥǡꤹ
*/

static void	set_branch_gltrnj_2(cdtvbs, cdtvdl,
				    gltrelmbs, gltrelmdl, gltrelmnew)
float		cdtvbs;		/* I:ʬǤΥޡ¦η
				     ǤޤǤ³Υ */
float		cdtvdl;		/* I:ʬǤΥޡ¦η
				     ǤޤǤ³Υ */
GlTreeElm	*gltrelmbs;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmdl;	/* I/O:ޡ¦η
				       ʷ */
GlTreeElm	*gltrelmnew;	/* O:˺ʬ
				     */
{
	float		abdtvbs, abdtvdl, abdtvdiff;
	float		btmdtvbs, btmdtvdl;
	float		btmdtvlbs, btmdtvldl;
	int		btmflagbs, btmflagdl;
	extern void	fatal_error();
	void		move_adtree_gltrnj();
	void		exit();

	if (gltrelmbs->dflag == GLTREE_ELM_BTM) {
		abdtvbs = gltrelmbs->elmd.btm.abdtv + cdtvbs;
		btmdtvbs = cdtvbs;
		btmflagbs = 1;
	}
	else if (gltrelmbs->dflag == GLTREE_ELM_BRCH) {
		abdtvbs = gltrelmbs->elmd.brch.abdtv + cdtvbs;
		btmdtvlbs = MAX(gltrelmbs->elmd.brch.btmdtvleft,
				gltrelmbs->elmd.brch.btmdtvright);
		btmdtvbs = btmdtvlbs + cdtvbs;
		btmflagbs = 0;
	}
	else
		fatal_error("set_branch_gltrnj_2", "illegal dflag (base)\n");
	if (gltrelmdl->dflag == GLTREE_ELM_BTM) {
		abdtvdl = gltrelmdl->elmd.btm.abdtv + cdtvdl;
		btmdtvdl = cdtvdl;
		btmflagdl = 1;
	}
	else if (gltrelmdl->dflag == GLTREE_ELM_BRCH) {
		abdtvdl = gltrelmdl->elmd.brch.abdtv + cdtvdl;
		btmdtvldl = MAX(gltrelmdl->elmd.brch.btmdtvleft,
				gltrelmdl->elmd.brch.btmdtvright);
		btmdtvdl = btmdtvldl + cdtvdl;
		btmflagdl = 0;
	}
	else
		fatal_error("set_branch_gltrnj_2", "illegal dflag (delete)\n");

	if (abdtvbs < abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvdl;
		abdtvdiff = abdtvdl - abdtvbs;
		move_adtree_gltrnj(gltrelmbs, abdtvdiff);
	}
	else if (abdtvbs > abdtvdl) {
		gltrelmnew->elmd.brch.abdtv = abdtvbs;
		abdtvdiff = abdtvbs - abdtvdl;
		move_adtree_gltrnj(gltrelmdl, abdtvdiff);
	}
	else
		gltrelmnew->elmd.brch.abdtv = abdtvbs;

	if (btmflagbs && btmflagdl) {
		if (cdtvbs <= cdtvdl) {
			gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
			gltrelmnew->elmd.brch.rldtvright = cdtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
			gltrelmnew->elmd.brch.rldtvright = cdtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
	else if (btmflagbs && !btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
		gltrelmnew->elmd.brch.rldtvright = cdtvbs;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
		gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
		gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
	}
	else if (!btmflagbs && btmflagdl) {
		gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
		gltrelmnew->elmd.brch.rldtvright = cdtvdl;
		gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
		gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
		gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
		gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
	}
	else if (!btmflagbs && !btmflagdl) {
		if (btmdtvlbs <= btmdtvldl) {
			gltrelmnew->elmd.brch.rldtvleft = cdtvbs;
			gltrelmnew->elmd.brch.rldtvright = cdtvdl;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvbs;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvdl;
			gltrelmnew->elmd.brch.left = (char *)gltrelmbs;
			gltrelmnew->elmd.brch.right = (char *)gltrelmdl;
		}
		else {
			gltrelmnew->elmd.brch.rldtvleft = cdtvdl;
			gltrelmnew->elmd.brch.rldtvright = cdtvbs;
			gltrelmnew->elmd.brch.btmdtvleft = btmdtvdl;
			gltrelmnew->elmd.brch.btmdtvright = btmdtvbs;
			gltrelmnew->elmd.brch.left = (char *)gltrelmdl;
			gltrelmnew->elmd.brch.right = (char *)gltrelmbs;
		}
	}
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
ޡ롣
*/

static void	merge_dttable_gltrnj_2(psn, info,
				       minan, bsid, dlid, cdtvbs,
				       dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		minan;		/* I:ΥǾȤʤΥơ֥
				     Υǥå */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
float		cdtvbs;		/* I:ޡ¦ηޤǤεΥ */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	extern void	fatal_error();
	void		merge_dttable_column_gltrnj_2();
	void		merge_dttable_row_gltrnj_2();

	(dttable+minan)->eflag = -psn;
	(dttable+minan)->distance = 0.0;
	(dttable+minan)->rcdtv = 0.0;

	if (dlid == 1)
		merge_dttable_row_gltrnj_2(psn, info, bsid, dlid, cdtvbs, dttable);
	else if (dlid > 1 && dlid < info->alignnum) {
		merge_dttable_row_gltrnj_2(psn, info, bsid, dlid, cdtvbs, dttable);
		merge_dttable_column_gltrnj_2(psn, info, bsid, dlid, cdtvbs, dttable);
	}
	else if (dlid == info->alignnum)
		merge_dttable_column_gltrnj_2(psn, info, bsid, dlid, cdtvbs, dttable);
	else
		fatal_error("merge_dttable_gltrnj_2", "illegal dlid\n");
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlid˹Ԥбդƥޡ롣
*/

static void	merge_dttable_row_gltrnj_2(psn,
					   info, bsid, dlid, cdtvbs,
					   dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
float		cdtvbs;		/* I:ޡ¦ηޤǤεΥ */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = dlid + 1; i <= info->alignnum; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, dlid, i);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
			(void)fprintf(stderr,
				      "merge_dttable_row_gltrnj_2 --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance -= cdtvbs;
		(dttable+dlsn-1)->eflag = -psn;
		(dttable+dlsn-1)->distance = 0.0;
		(dttable+dlsn-1)->rcdtv = 0.0;
	}
}

/*
  Υơ֥롦ǥåĤΣɣĤ˳Υơ֥Υǡ
dlidбդƥޡ롣
*/

static void	merge_dttable_column_gltrnj_2(psn,
					      info, bsid, dlid, cdtvbs,
					      dttable)
int		psn;		/* I:ץֹ */
INFO		*info;		/* I:饤ȡǥоݥǡ
				      */
int		bsid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1dlid
				     ʥޡ̤򥻥åȤ¦Σɣġ
				     */
int		dlid;		/* I:ޡ¦εΥơ֥롦
				     ǥåΣɣġʡ1bsid
				     ʥޡ˺¦Σɣġ
				     */
float		cdtvbs;		/* I:ޡ¦ηޤǤεΥ */
DtTableElm	*dttable;	/* I/O:Υơ֥ */
{
	int		i;
	int		dlsn, lvsn;
	int		c, r;
	extern int	get_dttable_index();
	extern void	adjust_twoint_ascend();

	for (i = 1; i < dlid; i++) {
		if (i == bsid)
			continue;
		dlsn = get_dttable_index(info->alignnum, i, dlid);
		if ((dttable+dlsn-1)->eflag < 0)
			continue;
		adjust_twoint_ascend(i, bsid, &r, &c);
		lvsn = get_dttable_index(info->alignnum, r, c);
#ifdef	CHECK
		if ((dttable+lvsn-1)->eflag < 0) {
		    (void)fprintf(stderr,
				  "merge_dttable_column_gltrnj_2 --- illegal lvsn eflag\n");
		}
#endif
		(dttable+lvsn-1)->distance -= cdtvbs;
		(dttable+dlsn-1)->eflag = -psn;
		(dttable+dlsn-1)->distance = 0.0;
		(dttable+dlsn-1)->rcdtv = 0.0;
	}
}

/*--------------------------------------------------------------------*/
#endif
/*--------------------------------------------------------------------*/

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
