/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aeg_stemfinder.c

----------------------------------------------------------------------*/

#include	<signal.h>

#include	<Xm/PushBG.h>

#include	"aedit.h"
#include	"menu.h"

/*--------------------------------------------------------------------*/

#define	DEBUG

/*--------------------------------------------------------------------*/

#define	PROGRAMNAME_STEMFINDER	"ste"
#define	FILENAME_STEMFINDER	"stemfinder.aed"

/*--------------------------------------------------------------------*/

static void	stemfinder_dummy_proc();

MENUITEM	stemfinder_submenu[] = {{"Start", &xmPushButtonGadgetClass,
					 'S', NULL, NULL,
					 stemfinder_dummy_proc, (caddr_t)NULL,
					 NULL, True},
					{NULL}
				       };

static int	stemfinder_flag = 0;

/*--------------------------------------------------------------------*/

static void	stemfinder_dummy_proc()
{
	extern INFO	Info;
	extern int	errno;
	int		cpid;
	extern void	fatal_error();
	void		save_stemfinder_file();
	void		stemfinder_flag_proc();

#ifdef	DEBUG
	(void)printf("stemfinder_dummy_proc --- in\n");
	(void)printf("stemfinder_dummy_proc --- Info.alignnum = %d\n", Info.alignnum);
	(void)printf("stemfinder_dummy_proc --- Info.empty = %d\n", Info.empty);
	(void)printf("stemfinder_dummy_proc --- stemfinder_flag = %d\n", stemfinder_flag);
#endif

	if (Info.empty)
		return;

	if (stemfinder_flag)
		return;

	/* parent (start) */

	save_stemfinder_file(FILENAME_STEMFINDER);

	stemfinder_flag = 1;

	if (signal(SIGCHLD, stemfinder_flag_proc) == (void (*)())-1)
		fatal_error("stemfinder_dummy_proc",
			    "signal failed (errno = %d)\n",
			    errno);

	/* parent (end) */

	if ((cpid = fork()) > 0) {
	}
	else if (cpid == 0) {
		/* child (start) */
		if (execl(PROGRAMNAME_STEMFINDER,
			  PROGRAMNAME_STEMFINDER,
			  FILENAME_STEMFINDER,
			  (char *)0)
			== -1) {
			fatal_error("stemfinder_dummy_proc",
				    "execl failed (errno = %d)\n",
				    errno);
		}
		/* child (end) */
	}
	else
		fatal_error("stemfinder_dummy_proc",
			    "fork failed (errno = %d)\n",
			    errno);
}

/*--------------------------------------------------------------------*/

static void save_stemfinder_file(filename)
char	*filename;
{
	FILE		*fp;
	extern void	fatal_error();
	extern void	writeSeq();

#ifdef	DEBUG
	(void)printf("save_stemfinder_file --- in\n");
#endif

	if ((fp = fopen(filename, "w")) == NULL)
		fatal_error("save_stemfinder_file",
			    "fopen failed (filename = %s)\n",
			    filename);

	writeSeq(fp);

	if (fclose(fp) == -1)
		fatal_error("save_stemfinder_file",
			    "fclose failed (filename = %s)\n",
			    filename);
}

/*--------------------------------------------------------------------*/

static void
stemfinder_flag_proc()
{
	extern int	errno;
	extern void	fatal_error();

#ifdef	DEBUG
	(void)printf("stemfinder_flag_proc --- in\n");
#endif

	stemfinder_flag = 0;

/*
	if (signal(SIGCHLD, stemfinder_flag_proc) == (void (*)())-1)
		fatal_error("stemfinder_flag_proc",
			    "signal failed (errno = %d)\n",
			    errno);
*/
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
