/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_mval.c
----------------------------------------------------------------------*/

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/Intrinsic.h>

#include	"aedit.h"

/*--------------------------------------------------------------------*/

#define	COLOR_BS	"skyblue"
#define	COLOR_MV	"yellow"

/*--------------------------------------------------------------------*/

static int		proc_mode = 0;

static int		alan_src, alan_dst;
static int		x_src, y_src, x_dst, y_dst;
static unsigned int	width_src, height_src, width_dst, height_dst;

static GC		gc_src, gc_dst;

static Pixel		pixel_src, pixel_dst;

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	SLEEP
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void	button_press_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern int	data_exist;
	extern Widget	da;
	extern GC	DrawBackGC;
	int		x, y;
	unsigned int	width, height;
	int		get_align();
	extern Pixel	mycolor_use();
	void		display_alname_mval();

	if (!data_exist)
		return;

	if (get_align(event->x, event->y,
		      &alan_src, &x, &y, &width, &height) &&
	    alan_src < Info.alignnum                        ) {
		alan_dst = alan_src;
		x_src = x_dst = x;
		y_src = y_dst = y;
		width_src = width_dst = width;
		height_src = height_dst = height;

		gc_src = XCreateGC(XtDisplay(da), XtWindow(da), 0, 0);
		pixel_src = mycolor_use(XtDisplay(da), COLOR_BS);
		XSetForeground(XtDisplay(da), gc_src, pixel_src);
		gc_dst = XCreateGC(XtDisplay(da), XtWindow(da), 0, 0);
		pixel_dst = mycolor_use(XtDisplay(da), COLOR_MV);
		XSetForeground(XtDisplay(da), gc_dst, pixel_dst);

		XFillRectangle(XtDisplay(da), XtWindow(da), gc_src,
			       x_src, y_src, width_src, height_src);
		display_alname_mval(alan_src);
		XDrawRectangle(XtDisplay(da), XtWindow(da), gc_dst,
			       x_dst, y_dst, width_dst, height_dst);
		XFlush(XtDisplay(da));

		proc_mode = 1;

	}
}

/*ARGSUSED*/
void	pointer_motion_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern Widget	da;
	extern GC	DrawBackGC;
	int		alan;
	int		x, y;
	unsigned int	width, height;

	if (!proc_mode)
		return;

	if (get_align(event->x, event->y,
		      &alan, &x, &y, &width, &height) &&
	    alan != alan_dst                            ) {
		XDrawRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
			       x_dst, y_dst, width_dst, height_dst);
		alan_dst = alan;
		x_dst = x;
		y_dst = y;
		width_dst = width;
		height_dst = height;
		XDrawRectangle(XtDisplay(da), XtWindow(da), gc_dst,
			       x_dst, y_dst, width_dst, height_dst);
		XFlush(XtDisplay(da));
	}
}

/*ARGSUSED*/
void	button_release_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern Widget	da;
	extern GC	DrawBackGC;
	int		idmy1, idmy2;
	unsigned int	uidmy1, uidmy2;
	extern int	move_align();
	void		display_mval();
	void		display_alname_mval();

	if (!proc_mode)
		return;

	XDrawRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       x_dst, y_dst, width_dst, height_dst);
	XFillRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       x_src, y_src, width_src, height_src);
	display_alname_mval(alan_src);
	XFlush(XtDisplay(da));

	XFreeGC(XtDisplay(da), gc_src);
	XFreeGC(XtDisplay(da), gc_dst);

	proc_mode = 0;

	if (get_align(event->x, event->y,
		      &alan_dst, &idmy1, &idmy2, &uidmy1, &uidmy2))  {
		if (move_align(alan_src, alan_dst)) {
#ifdef	DEBUG
			(void)printf("button_release_mval --- move\n");
#endif
			display_mval(alan_src, alan_dst);
		}
	}
}

/*--------------------------------------------------------------------*/

static int	get_align(ex, ey, alan, x, y, width, height)
int		ex, ey;
int		*alan;
int		*x, *y;
unsigned int	*width, *height;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin, BoxH;
	int		flag;
	int		bx, by;

	bx = 3;
	by = TopMargin + 2 * BoxH;

	if (ex >= bx && ex <= bx + LeftMargin - BoxW / 2     &&
	    ey >= by && ey <= by + (Info.alignnum + 1) * BoxH  ) {
		*alan = (ey - by) / BoxH;
		if (*alan > Info.alignnum)
			*alan = Info.alignnum;
		flag = 1;
		*x = bx;
		*y = by + *alan * BoxH;
		*width = LeftMargin - BoxW / 2;
		*height = BoxH;
	}
	else
		flag = 0;

	return flag;
}

/*--------------------------------------------------------------------*/

void display_alname_mval(alan)
int	alan;
{
	extern INFO	Info;
	extern int	AnMargin;
	extern int	BoxW;
	extern Widget	da;
	extern GC	TextGC;
	int		len;
	int		code;
	int		x, y;
	int		i;
	extern void	draw_string_2();

	len = strlen((char *)(Info.alignname+alan));

	y = TopMargin + 2 * BoxH + alan * BoxH;

	for(x = AnMargin, i = 0; i < len; x += BoxW, i++) {
		code = *((char *)(Info.alignname+alan)+i);
		draw_string_2(XtDisplay(da), XtWindow(da), False, x, y, code, TextGC);
	}
}

/*--------------------------------------------------------------------*/

void	display_mval(alansrc, alandst)
int	alansrc, alandst;
{
	extern Widget	da;
	int		i;
	extern void	display_one_alignment();
	extern void	erase_one_alignment();
#ifdef	CHECK
	void		exit();
#endif

#ifdef	DEBUG
	(void)printf("display_mval --- alansrc, alandst = %d %d\n", alansrc, alandst);
#endif


	if (alansrc + 1 < alandst) {
		erase_one_alignment(XtDisplay(da), XtWindow(da), alansrc);
#ifdef	SLEEP
sleep(1);
#endif
		for (i = alansrc; i <= alandst - 2; i++) {
			erase_one_alignment(XtDisplay(da), XtWindow(da), i + 1);
#ifdef	SLEEP
sleep(1);
#endif
			display_one_alignment(XtDisplay(da), XtWindow(da), i);
#ifdef	SLEEP
sleep(1);
#endif
#ifdef	DEBUG
			(void)printf("(1) i = %d\n", i);
#endif
		}
#ifdef	CHECK
		if (i != alandst - 1) {
		    (void)fprintf(
			stderr,
			"display_mval --- alansrc, alandst, i = %d %d %d\n",
			alansrc, alandst, i);
			exit(1);
		}
#endif
		display_one_alignment(XtDisplay(da), XtWindow(da), i);
#ifdef	SLEEP
sleep(1);
#endif
	}
	else if (alansrc > alandst) {
		erase_one_alignment(XtDisplay(da), XtWindow(da), alansrc);
#ifdef	SLEEP
sleep(1);
#endif
		for (i = alansrc; i >= alandst + 1; i--) {
#ifdef	DEBUG
			(void)printf("(2) i = %d\n", i);
#endif
			erase_one_alignment(XtDisplay(da), XtWindow(da), i - 1);
#ifdef	SLEEP
sleep(1);
#endif
			display_one_alignment(XtDisplay(da), XtWindow(da), i);
#ifdef	SLEEP
sleep(1);
#endif
		}
#ifdef	CHECK
		if (i != alandst) {
		    (void)fprintf(
			stderr,
			"display_mval --- alansrc, alandst, i = %d %d %d\n",
			alansrc, alandst, i);
			exit(1);
		}
#endif
		display_one_alignment(XtDisplay(da), XtWindow(da), i);
#ifdef	SLEEP
sleep(1);
#endif
	}
	else {
	    (void)fprintf(
		stderr,
		"display_mval --- alansrc, alandst, i = %d %d %d\n",
		alansrc, alandst, i);
		exit(1);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
