/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aeg_gltrupg.c
		Genealogical Tree (UPGMA)

----------------------------------------------------------------------*/

#include	<string.h>

#include	<X11/Intrinsic.h>
#include	<Xm/Form.h>
#include	<Xm/PushB.h>
#include	<Xm/DrawingA.h>

#include	"ae_gltree.h"

/*--------------------------------------------------------------------*/

static int		aps_exist_gltrupg = 0;
static Widget		aps_gltrupg;
static Dimension	aps_width_gltrupg, aps_height_gltrupg;

static Widget		fm_gltrupg;
static Widget		pb_ec_gltrupg, pb_er_gltrupg;
static Dimension	da_width_gltrupg, da_height_gltrupg;

static GlTreeElm	*root_gltrupg = (GlTreeElm *)NULL;

static GC		gc_scale_gltrupg, gc_tree_gltrupg;

static float		scale_x_gltrupg, scale_y_gltrupg;

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ΥɥʤΣˡ
  ɥȤߤ롣
*/

void	create_window_gltrupg_1(argc, argv)
int	*argc;		/* I/O:ץΰθĿ */
char	*argv[];	/* I/O:ץΰʸؤΥݥ
			    */
{
	extern XtAppContext	apc_gltrupg;
	extern Display		*dsp_gltrupg;
	extern Widget		da_gltrupg;
	Arg			args[10];
		
#ifdef	DEBUG
(void)printf("create_window_gltrupg_1 --- in\n");
#endif

	apc_gltrupg = XtCreateApplicationContext();

	dsp_gltrupg = XtOpenDisplay(apc_gltrupg, NULL, "aps_gltrupg", "aps_gltrupg",
				    NULL, 0, argc, argv);

	XtSetArg(args[0], XmNx, APS_X_GLTREE);
	XtSetArg(args[1], XmNy, APS_Y_GLTREE);
	XtSetArg(args[2], XmNwidth, APS_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, APS_HEIGHT_GLTREE);
	XtSetArg(args[4], XmNallowShellResize, True);
	XtSetArg(args[5], XmNminWidth, APS_MINWIDTH_GLTREE);
	XtSetArg(args[6], XmNminHeight, APS_MINHEIGHT_GLTREE);
/*
	XtSetArg(args[7], XmNmappedWhenManaged,  False);
*/
	aps_gltrupg = XtAppCreateShell("UPGMA", "aps_gltrupg",
				       applicationShellWidgetClass, dsp_gltrupg,
				       args, 7);

#ifdef	DEBUG
(void)printf("create_window_gltrupg_1 --- out\n");
#endif
}

/*
  ɽ뤿ΥɥʤΣˡ
  ɥΥƥ롣
*/

void	create_window_gltrupg_2()
{
	Arg	args[10];
	void	gltrupg_exchange_cb();
	void	gltrupg_erase_cb();

#ifdef	DEBUG
(void)printf("create_window_gltrupg_2 --- in\n");
#endif

	fm_gltrupg = XmCreateForm(aps_gltrupg, "fm_gltrupg", NULL, 0);
	XtManageChild(fm_gltrupg);

	XtSetArg(args[0], XmNx, 0);
	XtSetArg(args[1], XmNy, 0);
	XtSetArg(args[2], XmNwidth, PB_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, PB_HEIGHT_GLTREE);
	pb_ec_gltrupg = XmCreatePushButton(fm_gltrupg, "Exchange", args, 4); 
	XtManageChild(pb_ec_gltrupg); 
	XtAddCallback(pb_ec_gltrupg, XmNactivateCallback, gltrupg_exchange_cb, NULL);

	XtSetArg(args[0], XmNx, PB_WIDTH_GLTREE + 10);
	XtSetArg(args[1], XmNy, 0);
	XtSetArg(args[2], XmNwidth, PB_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, PB_HEIGHT_GLTREE);
	pb_er_gltrupg = XmCreatePushButton(fm_gltrupg, "Erase", args, 4); 
	XtManageChild(pb_er_gltrupg); 
	XtAddCallback(pb_er_gltrupg, XmNactivateCallback, gltrupg_erase_cb, NULL);

	XtSetArg(args[0], XmNtopAttachment, XmATTACH_WIDGET);
	XtSetArg(args[1], XmNtopWidget, pb_er_gltrupg);
	XtSetArg(args[2], XmNtopOffset, 0);
	XtSetArg(args[3], XmNbottomAttachment, XmATTACH_WIDGET);
	XtSetArg(args[4], XmNbottomOffset, 0);
	XtSetArg(args[5], XmNleftAttachment, XmATTACH_WIDGET);
	XtSetArg(args[6], XmNleftOffset, 0);
	XtSetArg(args[7], XmNrightAttachment, XmATTACH_WIDGET);
	XtSetArg(args[8], XmNrightOffset, 0);
/*
	XtSetArg(args[3], XmNwidth, DA_WIDTH_GLTREE);
	XtSetArg(args[4], XmNheight, DA_HEIGHT_GLTREE);
*/
	da_gltrupg = XmCreateDrawingArea(fm_gltrupg, "da_gltrupg", args, 9);
	XtManageChild(da_gltrupg); 

#ifdef	DEBUG
(void)printf("create_window_gltrupg_2 --- out\n");
#endif
}

/*--------------------------------------------------------------------*/

/*
  Exchangeܥ򤵤줿˸ƤФ륳Хåؿ
  饤ȡǥоݥǡΥ饤Ƚν¤Ӵ
뤳Ȥǧ뤿Υɽ롣
*/

/*ARGSUSED*/
static void	gltrupg_exchange_cb(w, client_data, call_data)
Widget	w;		/* ̤ѡʥåȡ */
caddr_t	client_data;	/* ̤ѡʥ饤ȡǡ */
caddr_t	call_data;	/* ̤ѡʥ롦ǡ */
{
	extern int	popUpConfirmDialog();
	void		confirm_gltrupg_exchange_cb();

#ifdef	DEBUG
(void)printf("gltrupg_exchange_cb --- in\n");
#endif

	(void)popUpConfirmDialog(confirm_gltrupg_exchange_cb, NULL, True,
				 "Are you sure you want to exchange ?");
}

/*
  饤ȡǥоݥǡΥ饤Ƚν¤Ӵ
뤳Ȥǧ뤿Υˤơܥ򤵤줿˸
Ф륳Хåؿ
  OKܥ򤵤줿饤ȡǥоݥǡΥ饤
ν¤Ӵ롣
  Cancelܥ򤵤줿¤Ӵʤ
*/

/*ARGSUSED*/
static void confirm_gltrupg_exchange_cb(wd, d1, call_data)
Widget			wd;		/* ̤ѡʥåȡ */
caddr_t			d1;		/* ̤ѡʥ饤ȡǡ
					    */
XmAnyCallbackStruct	*call_data;	/* I:롦ǡ */
{
	extern void	display_aedit_win_2();
	extern void	exchange_align_gltree();

#ifdef	DEBUG
	(void)printf("confirm_gltrupg_exchange_cb --- in\n");
#endif

	if(call_data->reason == XmCR_OK) {
		exchange_align_gltree(root_gltrupg);
		display_aedit_win_2();
	}
}

/*
  Eraseܥ򤵤줿˸ƤФ륳Хåؿ
  ɽ뤿ΥɥõԲĻ֤ˡˤ롣
*/

/*ARGSUSED*/
static void	gltrupg_erase_cb(w, client_data, call_data)
Widget	w;		/* ̤ѡʥåȡ */
caddr_t	client_data;	/* ̤ѡʥ饤ȡǡ */
caddr_t	call_data;	/* ̤ѡʥ롦ǡ */
{
#ifdef	DEBUG
(void)printf("gltrupg_erase_cb --- in\n");
#endif

	root_gltrupg = (GlTreeElm *)NULL;

	XtUnmapWidget(aps_gltrupg);
}

/*
  ɽ뤿ΥɥõԲĻ֤ˡˤ롣
*/

void	reset_gltrupg()
{
#ifdef	DEBUG
(void)printf("reset_gltrupg --- in\n");
#endif

	if (aps_exist_gltrupg) {
		root_gltrupg = (GlTreeElm *)NULL;
		XtUnmapWidget(aps_gltrupg);
	}
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ΥɥɽʲĻ֤ˡˤ롣
*/

void	display_window_gltrupg()
{
	extern Widget		da_gltrupg;
	Arg			args[10];
	extern GlTreeElm	*get_tree_gltrupg();

#ifdef	DEBUG
(void)printf("display_window_gltrupg --- in\n");
#endif

	if (!aps_exist_gltrupg) {
#ifdef	DEBUG
(void)printf("display_window_gltrupg --- realize\n");
#endif
		XtRealizeWidget(aps_gltrupg);
		aps_exist_gltrupg = 1;
	}

	XtSetArg(args[0], XmNwidth, &aps_width_gltrupg);
	XtSetArg(args[1], XmNheight, &aps_height_gltrupg);
	XtGetValues(aps_gltrupg, args, 2);
#ifdef	DEBUG
(void)printf("aps_width, aps_height = %d %d\n",
	     aps_width_gltrupg, aps_height_gltrupg);
#endif
	XtSetArg(args[0], XmNwidth, aps_width_gltrupg);
	XtSetArg(args[1], XmNheight, aps_height_gltrupg - PB_HEIGHT_GLTREE);
	XtSetValues(da_gltrupg, args, 2);

	XtMapWidget(aps_gltrupg);

	root_gltrupg = get_tree_gltrupg();
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿Υɥ˥饤ȡǥоݥǡη
ɽ椹롣
  ɽ뤿ΥɥΥɥ󥰡ꥢExpose٥
ȯʤɤ˸ƤФ롣
*/

void display_proc_gltrupg()
{
	extern Widget	da_gltrupg;
	extern GC	DrawBackGC;
	Arg		args[10];
	char		value[BUFSIZ];
	char		*p;
	int		len;
	int		av;
	int		scalelength;
	float		fdmy1, fdmy2;
	void		set_dspparam();
	void		display_scale();
	void		display_gltree();
	void		reset_dspparam();

#if	0
	if (root_gltrupg == (GlTreeElm *)NULL) {
		root_gltrupg = get_tree_gltrupg();
		if (root_gltrupg == (GlTreeElm *)NULL)
			return;
	}

	if (!XtIsRealized(aps_gltrupg)) {
#ifdef	DEBUG
(void)printf("display_tree --- not realized\n");
#endif
		return;
	}
#endif

	if (root_gltrupg == (GlTreeElm *)NULL)
		return;

	(void)sprintf(value, "%f", root_gltrupg->elmd.brch.abdtv);
	if ((p = strchr(value, '.')) == (char *)NULL) {
		(void)fprintf(stderr,
			      "display_proc_gltrupg --- strchr return value NULL\n");
	}
	*p = '\0';
	len = strlen(value);
	av = power(10, len - 1);
	scalelength = ((int)root_gltrupg->elmd.brch.abdtv / av + 1) * av;
	if (scalelength < 10)
		scalelength = 10;

	XtSetArg(args[0], XmNwidth, &da_width_gltrupg);
	XtSetArg(args[1], XmNheight, &da_height_gltrupg);
	XtGetValues(da_gltrupg, args, 2);

	set_dspparam(0.0, (float)scalelength,
		     root_gltrupg->elmd.brch.treemin - 1.0,
		     root_gltrupg->elmd.brch.treemax,
		     da_width_gltrupg, da_height_gltrupg);

	XFillRectangle(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), DrawBackGC,
		       0, 0, da_width_gltrupg, da_height_gltrupg);

	display_scale(scalelength);

	display_gltree(root_gltrupg, &fdmy1, &fdmy2);

	XFlush(XtDisplay(da_gltrupg));

	reset_dspparam();
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ѥ᡼򥻥åȤ롣
*/

static void	set_dspparam(xmin, xmax, ymin, ymax, dawidth, daheight)
float		xmin, xmax, ymin, ymax;	/* I:κɸǡ
					     κǾ͡
					     κǾ͡ */
Dimension	dawidth, daheight;	/* I:ɥ󥰡ꥢ
					     ⤵ */
{
	extern Widget	da_gltrupg;
	extern int	MaxAlignName;
	extern int	BoxW, BoxH;
	Pixel		pixel_scale, pixel_tree;
	Pixel		mycolor_use();

#ifdef	DEBUG
	(void)printf("set_dspparam --- xmin, xmax, ymin, ymax = %f %f %f %f\n",
		     xmin, xmax, ymin, ymax);
	(void)printf("set_dspparam --- BoxW, BoxH = %d %d\n", BoxW, BoxH);
#endif

	gc_scale_gltrupg = XCreateGC(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), 0, 0);
	gc_tree_gltrupg = XCreateGC(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), 0, 0);
	pixel_scale = mycolor_use(XtDisplay(da_gltrupg), COLOR_SCALE_GLTREE);
	pixel_tree = mycolor_use(XtDisplay(da_gltrupg), COLOR_TREE_GLTRUPG);
	XSetForeground(XtDisplay(da_gltrupg), gc_scale_gltrupg, pixel_scale);
	XSetLineAttributes(XtDisplay(da_gltrupg), gc_scale_gltrupg,
			   LINEWIDTH_SCALE_GLTREE, LineSolid, CapButt, JoinRound);
	XSetForeground(XtDisplay(da_gltrupg), gc_tree_gltrupg, pixel_tree);
	XSetLineAttributes(XtDisplay(da_gltrupg), gc_tree_gltrupg,
			   LINEWIDTH_TREE_GLTREE, LineSolid, CapButt, JoinRound);

	scale_x_gltrupg = ((float)dawidth * (1.0 - MRGRATIO_X_GLTREE * 2.0)
			   - MaxAlignName * BoxW)
			 / (xmax - xmin);
	scale_y_gltrupg = ((float)daheight * (1.0 - MRGRATIO_Y_GLTREE * 2.0)
			   - BoxH)
			 / (ymax - ymin);

#ifdef	DEBUG
	(void)printf("display_tree --- dawidth, daheight = %d %d\n",
		     dawidth, daheight);
	(void)printf("display_tree --- scale_x_gltrupg, scale_y_gltrupg = %f %f\n",
		     scale_x_gltrupg, scale_y_gltrupg);
#endif
}

/*
  ɸɺɸϤǥХɸϤѴ롣
    ǥХɸϤǤΣɸ
*/

static int	map_wctodc_x(wc)
float	wc;	/* I:ɺɸϤǤΣɸ */
{
	extern int	MaxAlignName;
	int		dc;

	dc = (int)((float)da_width_gltrupg * (1.0 - MRGRATIO_X_GLTREE)
		   - MaxAlignName * (float)BoxW
		   - wc * scale_x_gltrupg + 0.5);

	return dc;
}

/*
  ɸɺɸϤǥХɸϤѴ롣
    ǥХɸϤǤΣɸ
*/

static int	map_wctodc_y(wc)
float	wc;	/* I:ɺɸϤǤΣɸ */
{
	int	dc;

	dc = (int)(
		(float)da_height_gltrupg * MRGRATIO_Y_GLTREE
		+ BoxH
		+ wc * scale_y_gltrupg
		+ 0.5
	     );

	return dc;
}

/*
  ɽ뤿ѥ᡼ꥻåȤ롣
*/

static void	reset_dspparam()
{
	extern Display	*dsp_gltrupg;

	XFreeGC(dsp_gltrupg, gc_scale_gltrupg);
	XFreeGC(dsp_gltrupg, gc_tree_gltrupg);
}

/*--------------------------------------------------------------------*/

/*
  ɽ롣
  Ȥ롣
*/

static void	display_scale(scalelength)
int	scalelength;	/* I:Ĺ
			     10, 20, ... 100, 200, ... 1000, 2000, ...
			     */
{
	extern Widget	da_gltrupg;
	extern GC	TextGC;
	int		bxmin, bxmax, by, mx;
	char		value[BUFSIZ];
	int		len, av, dcnt, mcnt;
	float		itv;
	int		i;
	int		map_wctodc_x();
	int		map_wctodc_y();

#ifdef	DEBUG
	(void)printf("scalelength = %d\n", scalelength);
#endif

	bxmin = map_wctodc_x(0.0);
	bxmax = map_wctodc_x((float)scalelength);
	by = map_wctodc_y(0.0);

	XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_scale_gltrupg,
		  bxmin, by, bxmax, by);

	(void)sprintf(value, "%d", scalelength);
	len = strlen(value);
	av = power(10, len - 1);
	dcnt = scalelength / av;
	if (dcnt <= SCALE_DIVIDE_PARAM_GLTREE) {
		av = av / 10 * dcnt;
		dcnt = 10;
	}
	mcnt = dcnt + 1;
	itv = (float)scalelength / (float)(dcnt); 
	for (i = 0; i < mcnt; i++) {
		mx = map_wctodc_x(itv * (float)i);
		XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_scale_gltrupg,
			  mx, by, mx, by + BoxH / 2);
		if (dcnt == 10 && (i % 2) == 1)
			continue;
		(void)sprintf(value, "%d", av * i);
		XDrawString(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), TextGC,
			    mx - BoxW / ADJFONT_PARAM_GLTREE_1,
			    by - BoxH / ADJFONT_PARAM_GLTREE_1,
			    value, strlen(value));
	}
}

/*
  ɽ롣
  ȥåס˺ƵŪ˸ƤФʤɽ롣
*/

static void display_gltree(gltree, cx, cy)
GlTreeElm	*gltree;	/* I: */
float		*cx, *cy;	/* O:ǤΣɸ
				     ʥɺɸϡ */
{
	extern Widget	da_gltrupg;
	extern GC	TextGC;
	float		nx, ny;
	float		diff;
	int		dcx, dcy, dnx, dny;
	char		value[BUFSIZ];
	extern void	display_alname_gltree();
	int		map_wctodc_x();
	int		map_wctodc_y();
#ifdef	CHECK
	void		exit();

	if (gltree == (GlTreeElm *)NULL) {
		(void)fprintf(stderr, "display_gltree --- illegal gltree\n");
		exit(1);
	}
#endif

	if (gltree->dflag == GLTREE_ELM_BTM) {
		*cx = 0.0;
		*cy = gltree->elmd.btm.posad;
#if	0
	(void)printf("*cx, *cy (btm) = %f %f\n", *cx, *cy);
#endif
		dcx = map_wctodc_x(*cx);
		dcy = map_wctodc_y(*cy);
		display_alname_gltree(da_gltrupg, gltree->elmd.btm.alname,
				      dcx + BoxW / ADJFONT_PARAM_GLTREE_2,
				      dcy - BoxH / ADJFONT_PARAM_GLTREE_2);
	} 
	else if (gltree->dflag == GLTREE_ELM_BRCH) {
		*cx = gltree->elmd.brch.abdtv;
		*cy = gltree->elmd.brch.posad;
#if	0
	(void)printf("*cx, *cy (brch) = %f %f\n", *cx, *cy);
#endif
		dcx = map_wctodc_x(*cx);
		dcy = map_wctodc_y(*cy);
		display_gltree((GlTreeElm *)gltree->elmd.brch.left, &nx, &ny);
#if	0
	(void)printf("nx, ny (left) = %f %f\n", nx, ny);
#endif
		dnx = map_wctodc_x(nx);
		dny = map_wctodc_y(ny);
		XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_tree_gltrupg,
			  dnx, dny, dcx, dny);
		XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_tree_gltrupg,
			  dcx, dny, dcx, dcy);
		if ((diff = *cx - nx) > 0.0) {
			(void)sprintf(value, "%.1f", diff);
			XDrawString(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), TextGC,
				    dcx + BoxW / ADJFONT_PARAM_GLTREE_1,
				    dny - BoxH / ADJFONT_PARAM_GLTREE_1,
				    value, strlen(value));
		}
		display_gltree((GlTreeElm *)gltree->elmd.brch.right, &nx, &ny);
#if	0
	(void)printf("nx, ny (right) = %f %f\n", nx, ny);
#endif
		dnx = map_wctodc_x(nx);
		dny = map_wctodc_y(ny);
		XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_tree_gltrupg,
			  dnx, dny, dcx, dny);
		XDrawLine(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), gc_tree_gltrupg,
			  dcx, dny, dcx, dcy);
		if ((diff = *cx - nx) > 0.0) {
			(void)sprintf(value, "%.1f", diff);
			XDrawString(XtDisplay(da_gltrupg), XtWindow(da_gltrupg), TextGC,
				    dcx + BoxW / ADJFONT_PARAM_GLTREE_1,
				    dny - BoxH / ADJFONT_PARAM_GLTREE_1,
				    value, strlen(value));
		}
	}
	else {
		(void)fprintf(stderr,
			      "display_gltree --- illegal dflag\n");
		exit(1);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
