/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	aeg_gltrnj.c
		Genealogical Tree (NJ)

----------------------------------------------------------------------*/

#include	<string.h>

#include	<X11/Intrinsic.h>
#include	<Xm/Form.h>
#include	<Xm/PushB.h>
#include	<Xm/DrawingA.h>

#include	"ae_gltree.h"

/*--------------------------------------------------------------------*/

static int		aps_exist_gltrnj = 0;
static Widget		aps_gltrnj;
static Dimension	aps_width_gltrnj, aps_height_gltrnj;

static Widget		fm_gltrnj;
static Widget		pb_ec_gltrnj, pb_er_gltrnj;
static Dimension	da_width_gltrnj, da_height_gltrnj;

static GlTreeElm	*root_gltrnj = (GlTreeElm *)NULL;

static GC		gc_scale_gltrnj, gc_tree_gltrnj;

static float		scale_x_gltrnj, scale_y_gltrnj;

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ΥɥʤΣˡ
  ɥȤߤ롣
*/

void	create_window_gltrnj_1(argc, argv)
int	*argc;		/* I/O:ץΰθĿ */
char	*argv[];	/* I/O:ץΰʸؤΥݥ
			    */
{
	extern XtAppContext	apc_gltrnj;
	extern Display		*dsp_gltrnj;
	extern Widget		da_gltrnj;
	Arg			args[10];
		
#ifdef	DEBUG
(void)printf("create_window_gltrnj_1 --- in\n");
#endif

	apc_gltrnj = XtCreateApplicationContext();

	dsp_gltrnj = XtOpenDisplay(apc_gltrnj, NULL, "aps_gltrnj", "aps_gltrnj",
				   NULL, 0, argc, argv);

	XtSetArg(args[0], XmNx, APS_X_GLTREE);
	XtSetArg(args[1], XmNy, APS_Y_GLTREE);
	XtSetArg(args[2], XmNwidth, APS_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, APS_HEIGHT_GLTREE);
	XtSetArg(args[4], XmNallowShellResize, True);
	XtSetArg(args[5], XmNminWidth, APS_MINWIDTH_GLTREE);
	XtSetArg(args[6], XmNminHeight, APS_MINHEIGHT_GLTREE);
/*
	XtSetArg(args[7], XmNmappedWhenManaged,  False);
*/
	aps_gltrnj = XtAppCreateShell("NJ", "aps_gltrnj",
				      applicationShellWidgetClass, dsp_gltrnj,
				      args, 7);

#ifdef	DEBUG
(void)printf("create_window_gltrnj_1 --- out\n");
#endif
}

/*
  ɽ뤿ΥɥʤΣˡ
  ɥΥƥ롣
*/

void	create_window_gltrnj_2()
{
	Arg	args[10];
	void	gltrnj_exchange_cb();
	void	gltrnj_erase_cb();

#ifdef	DEBUG
(void)printf("create_window_gltrnj_2 --- in\n");
#endif

	fm_gltrnj = XmCreateForm(aps_gltrnj, "fm_gltrnj", NULL, 0);
	XtManageChild(fm_gltrnj);

	XtSetArg(args[0], XmNx, 0);
	XtSetArg(args[1], XmNy, 0);
	XtSetArg(args[2], XmNwidth, PB_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, PB_HEIGHT_GLTREE);
	pb_ec_gltrnj = XmCreatePushButton(fm_gltrnj, "Exchange", args, 4); 
	XtManageChild(pb_ec_gltrnj); 
	XtAddCallback(pb_ec_gltrnj, XmNactivateCallback, gltrnj_exchange_cb, NULL);

	XtSetArg(args[0], XmNx, PB_WIDTH_GLTREE + 10);
	XtSetArg(args[1], XmNy, 0);
	XtSetArg(args[2], XmNwidth, PB_WIDTH_GLTREE);
	XtSetArg(args[3], XmNheight, PB_HEIGHT_GLTREE);
	pb_er_gltrnj = XmCreatePushButton(fm_gltrnj, "Erase", args, 4); 
	XtManageChild(pb_er_gltrnj); 
	XtAddCallback(pb_er_gltrnj, XmNactivateCallback, gltrnj_erase_cb, NULL);

	XtSetArg(args[0], XmNtopAttachment, XmATTACH_WIDGET);
	XtSetArg(args[1], XmNtopWidget, pb_er_gltrnj);
	XtSetArg(args[2], XmNtopOffset, 0);
	XtSetArg(args[3], XmNbottomAttachment, XmATTACH_WIDGET);
	XtSetArg(args[4], XmNbottomOffset, 0);
	XtSetArg(args[5], XmNleftAttachment, XmATTACH_WIDGET);
	XtSetArg(args[6], XmNleftOffset, 0);
	XtSetArg(args[7], XmNrightAttachment, XmATTACH_WIDGET);
	XtSetArg(args[8], XmNrightOffset, 0);
/*
	XtSetArg(args[3], XmNwidth, DA_WIDTH_GLTREE);
	XtSetArg(args[4], XmNheight, DA_HEIGHT_GLTREE);
*/
	da_gltrnj = XmCreateDrawingArea(fm_gltrnj, "da_gltrnj", args, 9);
	XtManageChild(da_gltrnj); 

#ifdef	DEBUG
(void)printf("create_window_gltrnj_2 --- out\n");
#endif
}

/*--------------------------------------------------------------------*/

/*
  Exchangeܥ򤵤줿˸ƤФ륳Хåؿ
  饤ȡǥоݥǡΥ饤Ƚν¤Ӵ
뤳Ȥǧ뤿Υɽ롣
*/

/*ARGSUSED*/
static void	gltrnj_exchange_cb(w, client_data, call_data)
Widget	w;		/* ̤ѡʥåȡ */
caddr_t	client_data;	/* ̤ѡʥ饤ȡǡ */
caddr_t	call_data;	/* ̤ѡʥ롦ǡ */
{
	extern int	popUpConfirmDialog();
	void		confirm_gltrnj_exchange_cb();

#ifdef	DEBUG
(void)printf("gltrnj_exchange_cb --- in\n");
#endif

	(void)popUpConfirmDialog(confirm_gltrnj_exchange_cb, NULL, True,
				 "Are you sure you want to exchange ?");
}

/*
  饤ȡǥоݥǡΥ饤Ƚν¤Ӵ
뤳Ȥǧ뤿Υˤơܥ򤵤줿˸
Ф륳Хåؿ
  OKܥ򤵤줿饤ȡǥоݥǡΥ饤
ν¤Ӵ롣
  Cancelܥ򤵤줿¤Ӵʤ
*/

/*ARGSUSED*/
static void confirm_gltrnj_exchange_cb(wd, d1, call_data)
Widget			wd;		/* ̤ѡʥåȡ */
caddr_t			d1;		/* ̤ѡʥ饤ȡǡ
					    */
XmAnyCallbackStruct	*call_data;	/* I:롦ǡ */
{
	extern void	display_aedit_win_2();
	extern void	exchange_align_gltree();

#ifdef	DEBUG
	(void)printf("confirm_gltrnj_exchange_cb --- in\n");
#endif

	if(call_data->reason == XmCR_OK) {
		exchange_align_gltree(root_gltrnj);
		display_aedit_win_2();
	}
}

/*
  Eraseܥ򤵤줿˸ƤФ륳Хåؿ
  ɽ뤿ΥɥõԲĻ֤ˡˤ롣
*/

/*ARGSUSED*/
static void	gltrnj_erase_cb(w, client_data, call_data)
Widget	w;		/* ̤ѡʥåȡ */
caddr_t	client_data;	/* ̤ѡʥ饤ȡǡ */
caddr_t	call_data;	/* ̤ѡʥ롦ǡ */
{
#ifdef	DEBUG
(void)printf("gltrnj_erase_cb --- in\n");
#endif

	root_gltrnj = (GlTreeElm *)NULL;

	XtUnmapWidget(aps_gltrnj);
}

/*
  ɽ뤿ΥɥõԲĻ֤ˡˤ롣
*/

void	reset_gltrnj()
{
#ifdef	DEBUG
(void)printf("reset_gltrnj --- in\n");
#endif

	if (aps_exist_gltrnj) {
		root_gltrnj = (GlTreeElm *)NULL;
		XtUnmapWidget(aps_gltrnj);
	}
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ΥɥɽʲĻ֤ˡˤ롣
*/

void	display_window_gltrnj()
{
	extern Widget		da_gltrnj;
	Arg			args[10];
	extern GlTreeElm	*get_tree_gltrnj();

#ifdef	DEBUG
(void)printf("display_window_gltrnj --- in\n");
#endif

	if (!aps_exist_gltrnj) {
#ifdef	DEBUG
(void)printf("display_window_gltrnj --- realize\n");
#endif
		XtRealizeWidget(aps_gltrnj);
		aps_exist_gltrnj = 1;
	}

	XtSetArg(args[0], XmNwidth, &aps_width_gltrnj);
	XtSetArg(args[1], XmNheight, &aps_height_gltrnj);
	XtGetValues(aps_gltrnj, args, 2);
#ifdef	DEBUG
(void)printf("display_window_gltrnj --- aps_width_gltrnj, aps_height_gltrnj = %d %d\n",
	     aps_width_gltrnj, aps_height_gltrnj);
#endif
	XtSetArg(args[0], XmNwidth, aps_width_gltrnj);
	XtSetArg(args[1], XmNheight, aps_height_gltrnj - PB_HEIGHT_GLTREE);
	XtSetValues(da_gltrnj, args, 2);

	XtMapWidget(aps_gltrnj);

	root_gltrnj = get_tree_gltrnj();

#ifdef	DEBUG
(void)printf("display_window_gltrnj --- out\n");
#endif
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿Υɥ˥饤ȡǥоݥǡη
ɽ椹롣
  ɽ뤿ΥɥΥɥ󥰡ꥢExpose٥
ȯʤɤ˸ƤФ롣
*/

void display_proc_gltrnj()
{
	extern Widget	da_gltrnj;
	extern GC	DrawBackGC;
	Arg		args[10];
	char		value[BUFSIZ];
	char		*p;
	int		len;
	int		av;
	int		scalelength;
	float		fdmy1, fdmy2;
	void		set_dspparam();
	void		display_scale();
	void		display_gltree();
	void		reset_dspparam();

#ifdef	DEBUG
(void)printf("display_proc_gltrnj --- in\n");
#endif

#if	0
	if (root_gltrnj == (GlTreeElm *)NULL) {
		root_gltrnj = get_tree_gltrnj();
		if (root_gltrnj == (GlTreeElm *)NULL)
			return;
	}

	if (!XtIsRealized(aps_gltrnj)) {
#ifdef	DEBUG
(void)printf("display_proc_gltrnj --- not realized\n");
#endif
		return;
	}
#endif

	if (root_gltrnj == (GlTreeElm *)NULL)
		return;

	(void)sprintf(value, "%f", root_gltrnj->elmd.brch.abdtv);
	if ((p = strchr(value, '.')) == (char *)NULL) {
		(void)fprintf(stderr,
			      "display_proc_gltrnj --- strchr return value NULL\n");
	}
	*p = '\0';
	len = strlen(value);
	av = power(10, len - 1);
	scalelength = ((int)root_gltrnj->elmd.brch.abdtv / av + 1) * av;
	if (scalelength < 10)
		scalelength = 10;

	XtSetArg(args[0], XmNwidth, &da_width_gltrnj);
	XtSetArg(args[1], XmNheight, &da_height_gltrnj);
	XtGetValues(da_gltrnj, args, 2);

	set_dspparam(0.0, (float)scalelength,
		     root_gltrnj->elmd.brch.treemin - 1.0,
		     root_gltrnj->elmd.brch.treemax,
		     da_width_gltrnj, da_height_gltrnj);

	XFillRectangle(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), DrawBackGC,
		       0, 0, da_width_gltrnj, da_height_gltrnj);

	display_scale(scalelength);

	display_gltree(root_gltrnj, &fdmy1, &fdmy2);

	XFlush(XtDisplay(da_gltrnj));

	reset_dspparam();
}

/*--------------------------------------------------------------------*/

/*
  ɽ뤿ѥ᡼򥻥åȤ롣
*/

static void	set_dspparam(xmin, xmax, ymin, ymax, dawidth, daheight)
float		xmin, xmax, ymin, ymax;	/* I:κɸǡ
					     κǾ͡
					     κǾ͡ */
Dimension	dawidth, daheight;	/* I:ɥ󥰡ꥢ
					     ⤵ */
{
	extern Widget	da_gltrnj;
	extern int	MaxAlignName;
	extern int	BoxW, BoxH;
	Pixel		pixel_scale, pixel_tree;
	Pixel		mycolor_use();

#ifdef	DEBUG
	(void)printf("set_dspparam --- xmin, xmax, ymin, ymax = %f %f %f %f\n",
		     xmin, xmax, ymin, ymax);
	(void)printf("set_dspparam --- BoxW, BoxH = %d %d\n", BoxW, BoxH);
#endif

	gc_scale_gltrnj = XCreateGC(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), 0, 0);
	gc_tree_gltrnj = XCreateGC(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), 0, 0);
	pixel_scale = mycolor_use(XtDisplay(da_gltrnj), COLOR_SCALE_GLTREE);
	pixel_tree = mycolor_use(XtDisplay(da_gltrnj), COLOR_TREE_GLTRNJ);
	XSetForeground(XtDisplay(da_gltrnj), gc_scale_gltrnj, pixel_scale);
	XSetLineAttributes(XtDisplay(da_gltrnj), gc_scale_gltrnj,
			   LINEWIDTH_SCALE_GLTREE, LineSolid, CapButt, JoinRound);
	XSetForeground(XtDisplay(da_gltrnj), gc_tree_gltrnj, pixel_tree);
	XSetLineAttributes(XtDisplay(da_gltrnj), gc_tree_gltrnj,
			   LINEWIDTH_TREE_GLTREE, LineSolid, CapButt, JoinRound);

	scale_x_gltrnj = ((float)dawidth * (1.0 - MRGRATIO_X_GLTREE * 2.0)
			  - MaxAlignName * BoxW)
			 / (xmax - xmin);
	scale_y_gltrnj = ((float)daheight * (1.0 - MRGRATIO_Y_GLTREE * 2.0)
			  - BoxH)
			 / (ymax - ymin);

#ifdef	DEBUG
	(void)printf("set_dspparam --- dawidth, daheight = %d %d\n",
		     dawidth, daheight);
	(void)printf("set_dspparam --- scale_x_gltrnj, scale_y_gltrnj = %f %f\n",
		     scale_x_gltrnj, scale_y_gltrnj);
#endif
}

/*
  ɸɺɸϤǥХɸϤѴ롣
    ǥХɸϤǤΣɸ
*/

static int	map_wctodc_x(wc)
float	wc;	/* I:ɺɸϤǤΣɸ */
{
	extern int	MaxAlignName;
	int		dc;

	dc = (int)((float)da_width_gltrnj * (1.0 - MRGRATIO_X_GLTREE)
		   - MaxAlignName * (float)BoxW
		   - wc * scale_x_gltrnj + 0.5);

	return dc;
}

/*
  ɸɺɸϤǥХɸϤѴ롣
    ǥХɸϤǤΣɸ
*/

static int	map_wctodc_y(wc)
float	wc;	/* I:ɺɸϤǤΣɸ */
{
	int	dc;

	dc = (int)(
		(float)da_height_gltrnj * MRGRATIO_Y_GLTREE
		+ BoxH
		+ wc * scale_y_gltrnj
		+ 0.5
	     );

	return dc;
}

/*
  ɽ뤿ѥ᡼ꥻåȤ롣
*/

static void	reset_dspparam()
{
	extern Display	*dsp_gltrnj;

	XFreeGC(dsp_gltrnj, gc_scale_gltrnj);
	XFreeGC(dsp_gltrnj, gc_tree_gltrnj);
}

/*--------------------------------------------------------------------*/

/*
  ɽ롣
  Ȥ롣
*/

static void	display_scale(scalelength)
int	scalelength;	/* I:Ĺ
			     10, 20, ... 100, 200, ... 1000, 2000, ...
			     */
{
	extern Widget	da_gltrnj;
	extern GC	TextGC;
	int		bxmin, bxmax, by, mx;
	char		value[BUFSIZ];
	int		len, av, dcnt, mcnt;
	float		itv;
	int		i;
	int		map_wctodc_x();
	int		map_wctodc_y();

#ifdef	DEBUG
	(void)printf("scalelength = %d\n", scalelength);
#endif

	bxmin = map_wctodc_x(0.0);
	bxmax = map_wctodc_x((float)scalelength);
	by = map_wctodc_y(0.0);

	XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_scale_gltrnj,
		  bxmin, by, bxmax, by);

	(void)sprintf(value, "%d", scalelength);
	len = strlen(value);
	av = power(10, len - 1);
	dcnt = scalelength / av;
	if (dcnt <= SCALE_DIVIDE_PARAM_GLTREE) {
		av = av / 10 * dcnt;
		dcnt = 10;
	}
	mcnt = dcnt + 1;
	itv = (float)scalelength / (float)(dcnt); 
	for (i = 0; i < mcnt; i++) {
		mx = map_wctodc_x(itv * (float)i);
		XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_scale_gltrnj,
			  mx, by, mx, by + BoxH / 2);
		if (dcnt == 10 && (i % 2) == 1)
			continue;
		(void)sprintf(value, "%d", av * i);
		XDrawString(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), TextGC,
			    mx - BoxW / ADJFONT_PARAM_GLTREE_1,
			    by - BoxH / ADJFONT_PARAM_GLTREE_1,
			    value, strlen(value));
	}
}

/*
  ɽ롣
  ȥåס˺ƵŪ˸ƤФʤɽ롣
*/

static void display_gltree(gltree, cx, cy)
GlTreeElm	*gltree;	/* I: */
float		*cx, *cy;	/* O:ǤΣɸ
				     ʥɺɸϡ */
{
	extern Widget	da_gltrnj;
	extern GC	TextGC;
	float		nx, ny;
	float		diff;
	int		dcx, dcy, dnx, dny;
	char		value[BUFSIZ];
	extern void	display_alname_gltree();
	int		map_wctodc_x();
	int		map_wctodc_y();
#ifdef	CHECK
	void		exit();

	if (gltree == (GlTreeElm *)NULL) {
		(void)fprintf(stderr, "display_gltree --- illegal gltree\n");
		exit(1);
	}
#endif

	if (gltree->dflag == GLTREE_ELM_BTM) {
		*cx = gltree->elmd.btm.abdtv;
		*cy = gltree->elmd.btm.posad;
#if	0
	(void)printf("*cx, *cy (btm) = %f %f\n", *cx, *cy);
#endif
		dcx = map_wctodc_x(*cx);
		dcy = map_wctodc_y(*cy);
		display_alname_gltree(da_gltrnj, gltree->elmd.btm.alname,
				      dcx + BoxW / ADJFONT_PARAM_GLTREE_2,
				      dcy - BoxH / ADJFONT_PARAM_GLTREE_2);
	} 
	else if (gltree->dflag == GLTREE_ELM_BRCH) {
		*cx = gltree->elmd.brch.abdtv;
		*cy = gltree->elmd.brch.posad;
#if	0
	(void)printf("*cx, *cy (brch) = %f %f\n", *cx, *cy);
#endif
		dcx = map_wctodc_x(*cx);
		dcy = map_wctodc_y(*cy);
		display_gltree((GlTreeElm *)gltree->elmd.brch.left, &nx, &ny);
#if	0
	(void)printf("nx, ny (left) = %f %f\n", nx, ny);
#endif
		dnx = map_wctodc_x(nx);
		dny = map_wctodc_y(ny);
		XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_tree_gltrnj,
			  dnx, dny, dcx, dny);
		XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_tree_gltrnj,
			  dcx, dny, dcx, dcy);
		if ((diff = *cx - nx) > 0.0) {
			(void)sprintf(value, "%.1f", diff);
			XDrawString(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), TextGC,
				    dcx + BoxW / ADJFONT_PARAM_GLTREE_1,
				    dny - BoxH / ADJFONT_PARAM_GLTREE_1,
				    value, strlen(value));
		}
		display_gltree((GlTreeElm *)gltree->elmd.brch.right, &nx, &ny);
#if	0
	(void)printf("nx, ny (right) = %f %f\n", nx, ny);
#endif
		dnx = map_wctodc_x(nx);
		dny = map_wctodc_y(ny);
		XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_tree_gltrnj,
			  dnx, dny, dcx, dny);
		XDrawLine(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), gc_tree_gltrnj,
			  dcx, dny, dcx, dcy);
		if ((diff = *cx - nx) > 0.0) {
			(void)sprintf(value, "%.1f", diff);
			XDrawString(XtDisplay(da_gltrnj), XtWindow(da_gltrnj), TextGC,
				    dcx + BoxW / ADJFONT_PARAM_GLTREE_1,
				    dny - BoxH / ADJFONT_PARAM_GLTREE_1,
				    value, strlen(value));
		}
	}
	else {
		(void)fprintf(stderr,
			      "display_gltree --- illegal dflag\n");
		exit(1);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
