/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_almn.c
----------------------------------------------------------------------*/

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/Intrinsic.h>

#include	"aedit.h"
#include	"ae_almn.h"

/*--------------------------------------------------------------------*/

static int	proc_mode_b1 = 0, proc_mode_b3 = 0;

static int	alindex_bs = -1, column_bs = -1;
static int	alindex_mv_l = -1;

static AlMnInputDataMgr	almnidm;

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void	button_press_almn(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern int	data_exist;
	extern INFO	Info;
	extern Widget	da;
	int		alindex, column;

	if (!data_exist)
		return;

	if (!proc_mode_b1 && event->button == Button1) {
	    if (get_active_point(&Info, event->x, event->y,
				 &alindex, &column)) {
		alindex_bs = alindex;
		column_bs = column;
		alindex_mv_l = alindex;
		proc_mode_b1 = 1;
	    }
	}
	else if (!proc_mode_b3 && event->button == Button3) {
#ifdef	DEBUG
	(void)printf("button_press_almn --- button3\n");
#endif
	    if (get_active_point(&Info, event->x, event->y,
				 &alindex, &column)) {
		alindex_bs = alindex;
		column_bs = column;
		proc_mode_b3 = 1;
	    }
	}
}

/*ARGSUSED*/
void	pointer_motion_almn(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern INFO	Info;
	int		alindex, column;
	extern void	undisp_dragging_frame_2();
	extern void	disp_dragging_frame_2();

	if (proc_mode_b1) {
	    if (get_active_point(&Info, event->x, event->y,
				 &alindex, &column)) {
		if (column == column_bs) {
		    undisp_dragging_frame_2(XtDisplay(da), XtWindow(da),
					    alindex_bs, column_bs,
					    alindex_mv_l, column_bs);
		    disp_dragging_frame_2(XtDisplay(da), XtWindow(da),
					  alindex_bs, column_bs,
					  alindex, column_bs);
		    alindex_mv_l = alindex;
		}
	    }
	}
	else if (proc_mode_b3) {
	}
}

/*ARGSUSED*/
void	button_release_almn(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern INFO	Info;
	extern Widget	da;
	int		alindex, column;
	AlMnInputData	*almnid;
	extern int	*alloc_intarray();
	extern void	undisp_dragging_frame_2();
	extern int	check_ovl_almnidm();
	extern int	check_alarea_almnidm();
	extern void	set_retain_almnidm();
	extern void	calc_shiftdis_almnidm();
	extern void	shift_basearray_almnidm();
	extern void	free_almnidm();
	extern void	init_almnidm();
	AlMnInputData	*search_almnidm();
	AlMnInputData	*add_almnidm();
	void		update_target_almnidm();
	void		display_target_column();
	void		redisplay_basearray_almnidm();
#ifdef	DEBUG
	extern void	output_almnidm();
#endif

	if (proc_mode_b1) {
	    undisp_dragging_frame_2(XtDisplay(da), XtWindow(da),
				    alindex_bs, column_bs,
				    alindex_mv_l, column_bs);
	    if (get_active_point(&Info, event->x, event->y,
				 &alindex, &column)) {
		if (column == column_bs) {
		    if (search_almnidm(&almnidm, column_bs) == (AlMnInputData *)NULL) {
			if (almnidm.lecount == 0)
			    almnidm.pfcount = Info.alignnum;
			    almnidm.pflag = alloc_intarray(almnidm.pfcount);
			(void)add_almnidm(&almnidm, column_bs);
			almnidm.lecount++;
		    }
		    if (alindex_bs <= alindex)
			update_target_almnidm(&almnidm,
					      alindex_bs, alindex, column_bs, 0);
		    else
			update_target_almnidm(&almnidm,
					      alindex, alindex_bs, column_bs, 0);
		}
	    }
	    alindex_bs = -1;
	    column_bs = -1;
	    alindex_mv_l = -1;
	    proc_mode_b1 = 0;
	}
	else if (proc_mode_b3) {
	    if (get_active_point(&Info, event->x, event->y,
				 &alindex, &column)) {
		if (alindex == alindex_bs && column == column_bs) {
		    if ((almnid = search_almnidm(&almnidm, column_bs))
			!= (AlMnInputData *)NULL) {
			if (*(almnid->pflag+alindex_bs)) {
#if	0
			    output_almnidm(&almnidm);
#endif
			    if (!check_ovl_almnidm(&almnidm)) {
#ifdef	DEBUG
				printf("pass check overlap\n");
#endif
				almnidm.bscolumn = column_bs;
				calc_shiftdis_almnidm(&almnidm);
			        if (!check_alarea_almnidm(&almnidm)) {
				    display_target_column(almnid);
				    set_retain_almnidm(&almnidm);
				    shift_basearray_almnidm(&almnidm);
				    redisplay_basearray_almnidm(&almnidm);
				    free_almnidm(&almnidm);
				    init_almnidm(&almnidm);
				    alindex_bs = -1;
				    column_bs = -1;
				    alindex_mv_l = -1;
				}
				else {
#ifdef	DEBUG
				    printf("not pass check align area\n");
#endif
				    popUpWarnDialog("Not enough alignment area");
				}
			    }
			    else {
#ifdef	DEBUG
				printf("not pass check overlap\n");
#endif
				popUpWarnDialog("This data overlaps at one alignment");
			    }
			}
		    }
		}
	    }
	    proc_mode_b3 = 0;
	}
}

/*--------------------------------------------------------------------*/

void	display_target_column(almnid)
AlMnInputData	*almnid;
{
	int		i;
	extern void	display_one_base_t2();

	for (i = 0; i < almnid->pfcount; i++) {
		if (*(almnid->pflag+i))
		    display_one_base_t2(XtDisplay(da), XtWindow(da), Gray8GC[2],
					i, almnid->column);
	}
}

/*--------------------------------------------------------------------*/

void	update_target_almnidm(almnidm,
			      alindex1, alindex2, column, bsflag)
AlMnInputDataMgr	*almnidm;
int			alindex1, alindex2, column, bsflag;
{
	void	update_target_almnid();

	update_target_almnid(almnidm->root, almnidm->pfcount,
			     alindex1, alindex2, column, bsflag);
}

void	update_target_almnid(almnid, pfcount,
			     alindex1, alindex2, column, bsflag)
AlMnInputData	*almnid;
unsigned int	pfcount;
int		alindex1, alindex2, column, bsflag;
{
	extern Widget	da;
	int		i;
	extern void	display_one_base_t1();
	extern void	display_one_base_t2();
	void		exit();

	if (almnid != (AlMnInputData *)NULL) {
	    if (column == almnid->column) {
		for (i = alindex1; i <= alindex2; i++) {
		    /* ̵ */
		    if (*(almnid->pflag+i)) {
			    display_one_base_t1(
				XtDisplay(da), XtWindow(da),
				i, almnid->column);
			*(almnid->pflag+i) = 0;
		    }
		    /* ͭ */
		    else {
			/* base */
			if (bsflag) {
			    *(almnid->pflag+i) = 2;
			    display_one_base_t2(
				XtDisplay(da), XtWindow(da), Gray8GC[0],
				i, almnid->column);
			}
			/* ¾ */
			else {
			    *(almnid->pflag+i) = 1;
			    display_one_base_t2(
				XtDisplay(da), XtWindow(da), WhiteGC,
				i, almnid->column);
			}
		    }
		}
	    }
	    else
		update_target_almnid((AlMnInputData *)almnid->next, pfcount,
				     alindex1, alindex2, column, bsflag);
	}
	else {
		(void)fprintf(stderr, "update_target_almnid --- data not found\n");
		exit(1);
	}
}

/*--------------------------------------------------------------------*/

void	display_target_almnidm()
{
	void	display_target_almnid();

	display_target_almnid(almnidm.root, almnidm.bscolumn);
}

static void	display_target_almnid(almnid, bscolumn)
AlMnInputData	*almnid;
int		bscolumn;
{
	extern Widget	da;
	extern GC	Gray8GC[8], WhiteGC;
	int		i;
	extern void	display_one_base_t2();

	if (almnid != (AlMnInputData *)NULL) {
		for (i = 0; i < almnid->pfcount; i++) {
			if (!*(almnid->pflag+i))
				continue;
			if (almnid->column == bscolumn)
				display_one_base_t2(
					XtDisplay(da), XtWindow(da), Gray8GC[0],
					i, almnid->column);
			else
				display_one_base_t2(
					XtDisplay(da), XtWindow(da), WhiteGC,
					i, almnid->column);
		}
		display_target_almnid((AlMnInputData *)almnid->next, bscolumn);
	}
}

/*--------------------------------------------------------------------*/

void	erase_target_almnidm()
{
	void	erase_target_almnid();

	erase_target_almnid(almnidm.root);
}

static void	erase_target_almnid(almnid)
AlMnInputData	*almnid;
{
	extern Widget	da;
	int		i;
	extern void	display_one_base_t1();

	if (almnid != (AlMnInputData *)NULL) {
		for (i = 0; i < almnid->pfcount; i++) {
			if (!*(almnid->pflag+i))
				continue;
			display_one_base_t1(XtDisplay(da), XtWindow(da),
					    i, almnid->column);
		}
		erase_target_almnid((AlMnInputData *)almnid->next);
	}
}

/*--------------------------------------------------------------------*/

void	redisplay_basearray_almnidm(almnidm)
AlMnInputDataMgr	*almnidm;
{
	extern Widget	da;
	int		i;
	extern void	erase_one_basearray();
	extern void	display_one_basearray();

	for (i = 0; i < almnidm->pfcount; i++) {
		erase_one_basearray(XtDisplay(da), XtWindow(da), i);
		display_one_basearray(XtDisplay(da), XtWindow(da), i);
	}
}

void	reset_alignment_manual()
{
	extern void	free_almnidm();
	extern void	init_almnidm();
	void		erase_target_almnid();

	erase_target_almnid(almnidm.root);
	free_almnidm(&almnidm);
	init_almnidm(&almnidm);
	proc_mode_b1 = 0;
	proc_mode_b3 = 0;
	alindex_bs = -1;
	column_bs = -1;
	alindex_mv_l = -1;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
