/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aedit.h     
----------------------------------------------------------------------*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/Intrinsic.h>
#include  <stdio.h>
#include  <ctype.h>

#define   MAXCODE         30      /* Amino code and - # etc (inner code) */
#define   MAX_BUFF_LENG   1500    /* max length of buffer */
#define   MAX_ALIGN_NAME_LENG  30
#define   MAX_ALIGN_LENG  1500  
#define   MAX_ALIGN       128
#define   MAX_CONSTRAINT  100
#define   FONT_PAD        2

#define   GAP_INNER_CODE     26    /* Num. of alphabet(26) */
#define   OTHER_INNER_CODE   27   

#define   INITIAL_DATA_START_INDEX  301 
#define   DRAG_FRAME_RATIO 4
#define   DELETE_STEP      63

#ifndef TRUE 
#define   TRUE   1
#define   FALSE  0
#endif

/* for EditMode */
#define	VIEW			0 
#define	NORMAL			1 
#define	CONSTRAINT		2
#define	INSERT			3   
#define	OVER_WRITE		4
#define	MOVE_ALIGNMENT		5
#define	ALIGNMENT_MANUAL	6

/* gap insert direction **** DON'T CHANGE!! *****/
#define   RIGHT  1
#define   LEFT   -1


/**
#define  CHAR   1
#define  BACK   2
**/

/* amino text case */
#define UPPER   0
#define LOWER   1


/* column atrribute */
#define  FIXED_COLUMN   1  /* This column's members must not be cahnged */
#define  ABSORB_COLUMN  2  /* This column absorb gaps */
 
#define  isAmino(a)   (((a)>=0  &&  (a)<=25) ? (TRUE):(FALSE) )  /* a is inner code */

/* mouse */
#define DOUBLECLICK_INTERVAL  200  /* msec */
#define INSERT_GAP_INTERVAL  2  /* msec */
#define DELETE_GAP_INTERVAL  2  /* msec */

/* constraint */
#define CONST_COLORLESS  0
#define CONST_WHITE      1
#define CONST_GRAY       2

/* motif_search */

#if	1
#define	MOTIF_SEARCH_NEW
#endif

#define  MAX_BUFF_MOTIF 511
#define  MAX_NUM_PATTERN 255

typedef struct {
   int   empty;                    /* data is not exist */
   int   dataStartIndex;
   int   dispStartIndex;
   int   dataEndIndex;
   char  columnAtrib[MAX_ALIGN_LENG];   /* column attribute */
   int   rowH;       /* pixel unit */
   int   columnCost[MAX_ALIGN_LENG];   
   int   columnCostMax;
   int   columnCostMin;
   int   cost;            /* alignment's  total cost */
   int   startPos[MAX_ALIGN], endPos[MAX_ALIGN];  /* Out gap start/end position */
   int   firstP[MAX_ALIGN][MAX_ALIGN];
   int   outGapP[MAX_ALIGN];
   int   alignnum;
   char  alignname[MAX_ALIGN][MAX_ALIGN_NAME_LENG+1]; /* alignment name */
   char  *codeAlign[MAX_ALIGN];    /* inner code */
} INFO;

typedef struct Constraint_tag {
    struct Constraint_tag *p_next;
    int align;
    int index;
} Constraint_data;

typedef struct {
    Constraint_data *p_first;
    Constraint_data *p_last;
    int active_no;
    Bool active;
    Bool region;
} Constraint;


typedef struct Segment_tag{
    struct Segment_tag *p_next_seg;	/* ΥȤؤΥݥ */
    char amino[MAX_NUM_PATTERN];	/* ߥλΥѥ */
    Bool forbidden;			/* §ե饰 */
    Bool others;			/* ե饰 */
    int min;				/* ϰϤβ͡ʽ301 */
    int max;				/* ϰϤξ */
    int	repeat;				/* ֤ */
    int index;				/* դƬΥǥå */
}Segment;

typedef struct Motif_tag{
    struct Motif_tag *p_next;		/* ΥդؤΥݥ */
    char title[MAX_BUFF_MOTIF];		/* ̾ */
    char pattern[MAX_BUFF_MOTIF];	/* ֡ѥ */
#ifdef	MOTIF_SEARCH_NEW
    Bool alrpflag[MAX_ALIGN];		/* 饤ȹѥ
					   ե饰ʳ) */
#else
    Bool forbidden_align[MAX_ALIGN];	/* §ե饰ʳ) */
#endif
    int segment_count;			/* ȿ */
    Segment *p_next_seg;		/* ȤؤΥݥ */
}Motif;


extern XColor back_color, fixed_column_color,  text_color,
              bou_plus_color, bou_minus_color, bou_motif_color,
              amino_color[];
extern short aminoCharWorB[];


extern XFontStruct  *FontStruct;
extern Window       TheWindow;
extern GC           DrawBackGC, TextGC, BigTextGC, MiddleTextGC, FixedColumnGC,
                    BlinkGC, FrameGC,
                    WhiteGC, BlackGC, 
                    Gray8GC[8], Red8GC[8], 
                    BouPlusGC, BouMinusGC, BouMotifGC,
                    CodeGC[MAXCODE], 
                    AminoCharGC[MAXCODE];
extern Pixmap       ThePixmap; 

extern int  WinW, WinH;   /* window width and height */

extern int  MaxAlignName; /* max length of alignment name
                           * used for calculate LeftMargin
                           */
extern int  BoxW, BoxH;   /* current fonts */
extern int  PerLine, RowH;  

/* for active point */
extern int  ActiveXo,ActiveYo, ActiveIndex, ActiveAlign, ActiveCol;
extern int  EditMode;     /* Edit Mode (Insert or Delete) */

/* margins of string display window */
extern int   LeftMargin, RightMargin, TopMargin, BottomMargin;

/* Alignment Name Margin, Determine Position of Display
 * of Alignment name.
 */
extern int  AnMargin;

extern int  BarMargin;
extern int  BarLeng;

extern int  BouMinusMargin, BouPlusMargin;     /* BOU Graph margin */
extern int  BouMaxValue;       
extern int  BouMaxRatio;

extern int   YobiN;   /* Yobi Gyou */

extern int   QuitFlag;

extern char  FileName[100];

extern INFO  Info;

extern char  CurrentCost[], PreviousCost[];

extern int   UU, VV;   /* amino vs innergap,  gap cost u + kv */
extern int   WW;       /* innergap vs innergap */
extern int   PP;       /* outgap vs innergap */
extern int   QQ;       /* outgap vs outgap */
extern int   SS;       /* amino vs outgap */
extern int   UUVV;

extern int   ReverseFlag;   /* TRUE if align strings backwards */


extern int   IdenticalRatio;  /* 0 to 100 % */

extern int   CalcColumnCost;  /* if true, calc each column cost every time,
                               * if false, calc only when refresh.
                               */

extern int   AminoTextCase;

extern  short   Dmatrix[26][26];    
extern  short   Nmatrix[26][26];    
extern  short   Triple[26];         

char       *malloc();

/* These are defined in Xcommon's files */
extern  Display        *TheDisplay;
extern  int            TheScreen;
extern  Window         TheRoot;
extern  Colormap       TheColormap;
extern  int            TheDepth;
extern unsigned long   TheBlackPixel;  /*  System "Black" color */
extern unsigned long   TheWhitePixel;  /*  System "White" color */


extern char Char1[];
extern XChar2b XChar2[];

/* Kanji mode or not */
extern int  Kanji;

/* each char's offset */
extern int XOffset[128], YOffset[128];

/* data for constraint and network */
extern int Const_no;
extern int Region_no;
extern int Calc_leng;
extern int New_calc_leng;
extern Bool Result_flag;
extern Bool NA_flag;
extern Bool Result_draw;
extern Bool Button_flag[3];
extern Bool Region_divide[MAX_ALIGN_LENG];
extern Bool Region_flag[MAX_ALIGN_LENG];
extern int Calc_columnCost[MAX_ALIGN_LENG];
extern char Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
extern char Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
extern Constraint Const_head[MAX_CONSTRAINT];

/* motif search */
extern Motif *Motif_root;

Widget XtAppInitialize();
Widget XtVaCreateManagedWidget();

extern int   Calc_columnCost[MAX_ALIGN_LENG];   
extern int   Calc_columnCostMax;
extern int   Calc_columnCostMin;
extern int   Calc_cost;            /* alignment's  total cost */
extern int   Calc_startPos[MAX_ALIGN], Calc_endPos[MAX_ALIGN];  /* Out gap start/end position */
extern int   Calc_firstP[MAX_ALIGN][MAX_ALIGN];
extern int   Calc_outGapP[MAX_ALIGN];

/*--------------------------------------------------------------------*/

/* append (begin) */

#define	TMPAEDFILE_ASD_PROC_NONE	0
#define	TMPAEDFILE_ASD_PROC_SAVE	1
#define	TMPAEDFILE_ASD_PROC_RESTORE	2	/* ---> unused by alarm(0) */

extern char	*tmpaedfile_msd_name;
extern char	*tmpaedfile_asd_name;
extern int	tmpaedfile_asd_interval;
extern int	tmpaedfile_asd_interval_remain;
extern int	tmpaedfile_asd_proc;

/* append (end) */

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
