/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: token.h,v 2.1 91/06/18 22:02:43 dick Exp $
*/

/*
	Token interface.
	Since the definition of a token has been a continual source of
	problems, it is now defined as an Abstract Data Type. To allow
	stronger type checking, there is a special version for use by lint.
*/

#ifndef	TOKEN

#ifdef	lint				/* lint version */

struct cccc {
	int cccc;
};

typedef struct cccc *TOKENlint;
#define	TOKEN		TOKENlint
#define	TOKEN2int(c)	((int)(c))
#define	int2TOKEN(i)	((TOKENlint)(i))

#else					/* production version */

#define	TOKEN		char
#define	TOKEN2int(c)	((c)&0377)
#define	int2TOKEN(i)	(i)
#define	TOKEN_EQ(t1,t2)	(TOKEN2int(t1) == TOKEN2int(t2))

#endif	/* lint */

#endif	/* TOKEN */

/* Macros for the composition of tokens */
#define	NORM(ch)	int2TOKEN(ch&0377)
#define	CTRL(ch)	int2TOKEN(ch&0037)
#define	META(ch)	int2TOKEN(ch|0200)
#define	MTCT(ch)	int2TOKEN((ch&0037)|0200)
#define	NOTOKEN		int2TOKEN(0)
